/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds;

import com.sybase.util.ds.Utils;
import com.sybase.util.ds.interfaces.InterfacesException;
import com.sybase.util.ds.interfaces.Service;
import com.sybase.util.ds.interfaces.SyInterfacesDriver;
import com.sybase.util.ds.interfaces.SyInterfacesEntry;
import com.sybase.util.ds.ldap.LDAPException;
import com.sybase.util.ds.ldap.LibctlDriver;
import com.sybase.util.ds.ldap.SyLDAPServer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class DirectoryServiceHelper {
    private SyInterfacesDriver _interfacesDriver = null;
    private LibctlDriver _libtclDriver = null;

    public DirectoryServiceHelper() {
    }

    public DirectoryServiceHelper(boolean bl, boolean bl2) throws Exception, InterfacesException, LDAPException {
        this.init(bl, bl2);
    }

    public void init(boolean bl, boolean bl2) throws Exception {
        if (bl) {
            this.initInterfacesDriver();
        }
        if (bl2) {
            this.initLibtclDriver();
        }
    }

    public void initInterfacesDriver() throws Exception {
        this._interfacesDriver = new SyInterfacesDriver();
        this._interfacesDriver.open();
    }

    public void initInterfacesDriver(String string) throws Exception {
        this._interfacesDriver = new SyInterfacesDriver(string);
        this._interfacesDriver.open(string);
    }

    public void initLibtclDriver() throws FileNotFoundException, IOException, LDAPException {
        this._libtclDriver = new LibctlDriver();
    }

    public SyInterfacesDriver getInterfacesDriver(Boolean bl) throws Exception {
        if (this._interfacesDriver == null || bl.booleanValue()) {
            this.initInterfacesDriver();
        }
        return this._interfacesDriver;
    }

    public LibctlDriver getLibctlDriver() throws FileNotFoundException, IOException, LDAPException {
        if (this._libtclDriver == null) {
            this.initLibtclDriver();
        }
        return this._libtclDriver;
    }

    public String[] doesServerEntryExistInInterfaces(String string) {
        Vector vector = this._interfacesDriver.getEntries();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                SyInterfacesEntry syInterfacesEntry = (SyInterfacesEntry)vector.elementAt(i);
                if (!syInterfacesEntry.getName().trim().equals(string.trim())) continue;
                return new String[]{syInterfacesEntry.getHost(), syInterfacesEntry.getPort()};
            }
        }
        return null;
    }

    public void addEntryToInterfaces(String string, String string2, String string3) throws Exception {
        this._interfacesDriver.setSaveOnChange(true);
        if (Utils.OS_WINDOWS) {
            this._interfacesDriver.setValue(string, new Service(0, "NLWNSCK," + string2 + "," + string3));
            this._interfacesDriver.setValue(string, new Service(1, "NLWNSCK," + string2 + "," + string3));
        } else {
            this._interfacesDriver.setValue(string, new Service(0, "tcp ether " + string2 + " " + string3));
            this._interfacesDriver.setValue(string, new Service(1, "tcp ether " + string2 + " " + string3));
        }
        this._interfacesDriver.setSaveOnChange(false);
    }

    public Enumeration getEntriesFromInterfacesFile() {
        return this._interfacesDriver.getASEServers().elements();
    }

    public Enumeration getEntriesFromLDAP(Integer n) {
        Vector vector = new Vector();
        if (this._libtclDriver == null) {
            return vector.elements();
        }
        Vector vector2 = this._libtclDriver.getLDAPServers();
        for (int i = 0; i < vector2.size(); ++i) {
            SyLDAPServer syLDAPServer = (SyLDAPServer)vector2.elementAt(i);
            try {
                if (!syLDAPServer.connectLDAP(n)) continue;
                syLDAPServer.initASEEntries();
                vector.addAll(syLDAPServer.getASEServers());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector.elements();
    }
}

