/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.interfaces;

import com.sybase.util.ds.interfaces.InterfacesBaseParser;
import com.sybase.util.ds.interfaces.InterfacesException;
import com.sybase.util.ds.interfaces.Service;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class IniFileParser
extends InterfacesBaseParser {
    private String _fileName;

    protected boolean probe(URL uRL) throws Exception, InterfacesException {
        InputStream inputStream = uRL.openStream();
        this._fileName = uRL.getFile();
        return this.probe(inputStream);
    }

    protected boolean probe(String string) throws Exception, InterfacesException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this._fileName = string;
        return this.probe(fileInputStream);
    }

    protected boolean probe(InputStream inputStream) throws Exception, InterfacesException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        bufferedReader.mark(1);
        if (-1 == bufferedReader.read()) {
            bufferedReader.close();
            InterfacesException interfacesException = new InterfacesException("ERR_EMPTY_FILE", "MSG_INTERFACES", this._fileName);
            throw interfacesException;
        }
        bufferedReader.reset();
        Enumeration enumeration = this.nextSubject(bufferedReader);
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.isAttributes(string)) continue;
            bufferedReader.close();
            return false;
        }
        bufferedReader.close();
        return enumeration != null;
    }

    protected boolean createFile(String string) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
            dataOutputStream.writeBytes(";INI File: " + string + System.getProperty("line.separator"));
            dataOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    protected boolean isAttributes(String string) {
        return string != null && string.length() > 0 && (string = string.trim()).indexOf("=") != -1 && !string.startsWith(";") && this.startsWith(string, cTypesSet);
    }

    protected Service getService(String string) {
        int n = string.indexOf("=");
        String string2 = string.substring(0, n);
        if (!(string2 = this.removeWhiteSpaceCharacters(string2)).equalsIgnoreCase("master") && !string2.equalsIgnoreCase("query")) {
            return null;
        }
        String string3 = string.substring(n + 1, string.length());
        if ((string3 = this.removeWhiteSpaceCharacters(string3)).length() == 0 || string2.length() == 0) {
            return null;
        }
        if (string3.toLowerCase().startsWith("tcpether")) {
            string3 = "TCP" + string3.substring(8);
        }
        return new Service(string2, string3);
    }

    protected boolean isCommentLine(String string) {
        return this.isBlankLine(string) ? false : string.startsWith(";");
    }

    protected boolean isSubject(String string) {
        if (string != null && !this.isCommentLine(string) && string.length() > 0) {
            return string.startsWith("[");
        }
        return false;
    }

    protected String refineSubject(String string) {
        return string.startsWith("[") && string.endsWith("]") ? string : "[" + string + "]";
    }

    protected boolean startsWith(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.toLowerCase().startsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isTLIStyle(String string) {
        return false;
    }

    protected boolean TLI2TCP(String string, String[] stringArray) {
        return false;
    }

    protected boolean TCP2TLI(String string, String[] stringArray) {
        return false;
    }

    private String removeWhiteSpaceCharacters(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t ");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + stringTokenizer.nextToken().trim();
        }
        return string2;
    }
}

