/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.interfaces;

import com.sybase.util.ds.Utils;

public class Service {
    public static final int MASTER_TYPE = 0;
    public static final int QUERY_TYPE = 1;
    public static final String MASTER = "master";
    public static final String QUERY = "query";
    public static final String SSL_FILTER = "ssl";
    private int _type;
    private String _value;
    private String _protocol;
    private String _host;
    private String _port;
    private String _filter;

    public Service(String string, String string2) {
        if (string != null) {
            this.initType(string);
            this._value = string2;
            this._init();
        }
    }

    public Service(int n, String string) {
        this._type = n;
        this._value = string;
        this._init();
    }

    public Service(String string, String string2, String string3, String string4) {
        if (string != null) {
            this.initType(string);
            this._protocol = string2;
            this._host = string3;
            this._port = string4;
            this.getValue();
        }
    }

    public Service(int n, String string, String string2, String string3) {
        this._type = n;
        this._protocol = string;
        this._host = string2;
        this._port = string3;
        this.getValue();
    }

    private void _init() {
        if (this._value == null) {
            return;
        }
        String[] stringArray = this._value.split("[,\\s]");
        if (stringArray.length > 0) {
            this._protocol = stringArray[0];
        }
        if (!this.hasPort()) {
            return;
        }
        String string = Utils.OS_WINDOWS ? "," : " ";
        for (int i = stringArray.length - 1; i > 0; --i) {
            try {
                Integer.parseInt(stringArray[i]);
                this._port = stringArray[i];
                if (i > 1) {
                    this._host = stringArray[i - 1];
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int j = 0; j < i - 1; ++j) {
                        stringBuffer.append(stringArray[j]);
                        stringBuffer.append(string);
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
                if (i + 1 > stringArray.length - 1) continue;
                this._filter = stringArray[i + 1];
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void initType(String string) {
        if (string.toLowerCase().endsWith(MASTER)) {
            this._type = 0;
        } else if (string.toLowerCase().endsWith(QUERY)) {
            this._type = 1;
        }
    }

    public String getType() {
        if (this._type == 0) {
            return MASTER;
        }
        if (this._type == 1) {
            return QUERY;
        }
        return null;
    }

    public String getValue() {
        if (!this.hasPort()) {
            return this._value;
        }
        String string = Utils.OS_WINDOWS ? "," : " ";
        String string2 = this._protocol + string + this._host + string + this._port;
        if (this._filter != null && this._filter.trim().length() > 0) {
            string2 = string2 + string + this._filter;
        }
        return string2;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public boolean hasPort() {
        return this._protocol != null && (this._protocol.toUpperCase().indexOf("TCP") >= 0 || this._protocol.toUpperCase().indexOf("NLWNSCK") >= 0);
    }

    public String getPort() {
        return this._port;
    }

    public void setPort(String string) {
        this._port = string;
    }

    public String getHost() {
        return this._host;
    }

    public String getFilter() {
        return this._filter;
    }

    public void setFilter(String string) {
        this._filter = string;
    }

    public boolean isSSL() {
        return this._filter != null && this._filter.equalsIgnoreCase(SSL_FILTER);
    }

    public String toString() {
        if (this._type == 0) {
            return "master=" + this._value;
        }
        if (this._type == 1) {
            return "query=" + this._value;
        }
        return null;
    }

    public boolean isType(String string) {
        return this.getType().equals(string.toLowerCase());
    }
}

