/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.interfaces;

import com.sybase.util.ds.Utils;
import com.sybase.util.ds.interfaces.IniFileParser;
import com.sybase.util.ds.interfaces.InterfacesBaseParser;
import com.sybase.util.ds.interfaces.InterfacesException;
import com.sybase.util.ds.interfaces.InterfacesFileParser;
import com.sybase.util.ds.interfaces.InterfacesLocator;
import com.sybase.util.ds.interfaces.Service;
import com.sybase.util.ds.interfaces.SyInterfacesEntry;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class SyInterfacesDriverBase {
    protected Vector _lines;
    protected Vector _subjects;
    protected Vector _services;
    protected String _fileName;
    protected boolean _saveOnChange = false;
    protected InterfacesBaseParser _interfacesParser;
    protected long _nextLine = 0L;
    protected InterfacesLocator _interfacesLocator;

    public SyInterfacesDriverBase() {
    }

    public SyInterfacesDriverBase(String string) throws Exception, InterfacesException {
        this(string, false);
    }

    public SyInterfacesDriverBase(String string, boolean bl) throws Exception, InterfacesException {
        this._saveOnChange = bl;
        this._fileName = string;
        try {
            URL uRL = new URL(string);
            this._interfacesParser = new IniFileParser();
            if (!this._interfacesParser.probe(uRL)) {
                this._interfacesParser = new InterfacesFileParser();
                if (!this._interfacesParser.probe(uRL)) {
                    this._fileName = null;
                    InterfacesException interfacesException = new InterfacesException("ERR_FORMAT_ERROR", "MSG_INTERFACES", uRL.getFile());
                    throw interfacesException;
                }
            }
            this.loadFile(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            if (!new File(string).exists()) {
                this._fileName = null;
                InterfacesException interfacesException = new InterfacesException("ERR_FILE_NOT_FOUND", "MSG_INTERFACES", string);
                throw interfacesException;
            }
            this._interfacesParser = new IniFileParser();
            if (!this._interfacesParser.probe(string)) {
                this._interfacesParser = new InterfacesFileParser();
                if (!this._interfacesParser.probe(string)) {
                    this._fileName = null;
                    InterfacesException interfacesException = new InterfacesException("ERR_FORMAT_ERROR", "MSG_INTERFACES", string);
                    throw interfacesException;
                }
            }
            this.loadFile();
        }
        this.parseLines();
    }

    protected void load(String string) throws Exception, InterfacesException {
        this._saveOnChange = false;
        this._fileName = string;
        try {
            URL uRL = new URL(string);
            this._interfacesParser = new IniFileParser();
            if (!this._interfacesParser.probe(uRL)) {
                this._interfacesParser = new InterfacesFileParser();
                if (!this._interfacesParser.probe(uRL)) {
                    this._fileName = null;
                    InterfacesException interfacesException = new InterfacesException("ERR_FORMAT_ERROR", "MSG_INTERFACES", uRL.getFile());
                    throw interfacesException;
                }
            }
            this.loadFile(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            if (!new File(string).exists()) {
                this._fileName = null;
                InterfacesException interfacesException = new InterfacesException("ERR_FILE_NOT_FOUND", "MSG_INTERFACES", string);
                throw interfacesException;
            }
            this._interfacesParser = new IniFileParser();
            if (!this._interfacesParser.probe(string)) {
                this._interfacesParser = new InterfacesFileParser();
                if (!this._interfacesParser.probe(string)) {
                    this._fileName = null;
                    InterfacesException interfacesException = new InterfacesException("ERR_FORMAT_ERROR", "MSG_INTERFACES", string);
                    throw interfacesException;
                }
            }
            this.loadFile();
        }
        this.parseLines();
    }

    public void loadFile(URL uRL) throws IOException {
        this._lines = new Vector();
        this._subjects = new Vector();
        this._services = new Vector();
        InputStream inputStream = uRL.openStream();
        this.loadFile(inputStream);
    }

    public void loadFile() throws IOException {
        this._lines = new Vector();
        this._subjects = new Vector();
        this._services = new Vector();
        this.loadFile(new FileInputStream(this._fileName));
    }

    public void loadFile(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = "";
        while ((string = bufferedReader.readLine()) != null) {
            this._lines.addElement(string);
        }
        bufferedReader.close();
    }

    protected boolean createFile() {
        return this._interfacesParser.createFile(this._fileName);
    }

    protected void parseLines() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < this._lines.size(); ++i) {
            Object object;
            string = (String)this._lines.elementAt(i);
            if (this._interfacesParser.isBlankLine(string) || this._interfacesParser.isCommentLine(string)) continue;
            if (this.isSubject(string)) {
                object = this._interfacesParser.getSubject(string);
                string2 = object[0];
                string3 = object[1];
                string4 = object[2];
                continue;
            }
            if (!this.isAssignment(string)) continue;
            object = string.trim();
            this.addAttributes(string2, (String)object);
        }
    }

    protected boolean addAttributes(String string, String string2) {
        Service service = this._interfacesParser.getService(string2);
        if (service != null) {
            return this.addValue(string, service, false);
        }
        return false;
    }

    public boolean setValue(String string, Service service) throws Exception {
        boolean bl = this.addValue(string, service, true);
        if (this._saveOnChange) {
            this.saveFile();
        }
        return bl;
    }

    protected boolean addValue(String string, Service service, boolean bl) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (!this._subjects.contains(string)) {
            this._subjects.addElement(string);
            this._services.addElement(new Vector());
        }
        int n = this._subjects.indexOf(string);
        Vector vector = (Vector)this._services.elementAt(n);
        boolean bl2 = false;
        for (int i = 0; i < vector.size(); ++i) {
            Service service2 = (Service)vector.get(i);
            if (!service2.toString().equals(service.toString())) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            vector.addElement(service);
        }
        if (bl) {
            this.setLine(string, service);
        }
        return true;
    }

    protected boolean isSubject(String string) {
        return this._interfacesParser.isSubject(string);
    }

    protected void setLine(String string, Service service) {
        int n;
        int n2;
        int n3 = this.findSubjectLine(string);
        if (n3 == -1) {
            String string2 = this.refineSubject(string);
            this.addSubjectLine(string2);
            n3 = this._lines.size() - 1;
        }
        if ((n2 = this.findAssignmentBetween(service, n3, n = this.endOfSubject(n3))) == -1) {
            if (Utils.OS_WINDOWS) {
                this._lines.insertElementAt(service.getType() + "=" + service.getValue(), n);
            } else {
                this._lines.insertElementAt("\t" + service.getType() + " " + service.getValue(), n);
            }
        } else if (Utils.OS_WINDOWS) {
            this._lines.setElementAt(service.getType() + "=" + service.getValue(), n2);
        } else {
            this._lines.setElementAt("\t" + service.getType() + " " + service.getValue(), n2);
        }
    }

    protected String refineSubject(String string) {
        return this._interfacesParser.refineSubject(string);
    }

    protected int findAssignmentLine(String string, String string2) {
        int n = this.findSubjectLine(string);
        int n2 = this.endOfSubject(n);
        return this.findAssignmentBetween(string2, n, n2);
    }

    protected int findAssignmentBetween(String string, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!((String)this._lines.elementAt(i)).trim().startsWith(string)) continue;
            return i;
        }
        return -1;
    }

    private int findAssignmentBetween(Service service, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            String string = ((String)this._lines.elementAt(i)).trim();
            boolean bl = service.hasPort();
            if ((!string.startsWith(service.getType()) || !bl || string.indexOf(service.getHost()) == -1 || string.indexOf(service.getPort()) == -1) && (bl || string.indexOf(service.getValue()) == -1)) continue;
            return i;
        }
        return -1;
    }

    protected void addSubjectLine(String string) {
        this._lines.addElement("");
        this._lines.addElement(this.refineSubject(string));
    }

    protected int findSubjectLine(String string) {
        String string2 = this.refineSubject(string);
        for (int i = 0; i < this._lines.size(); ++i) {
            String string3 = (String)this._lines.elementAt(i);
            if (!string2.equals(string3)) continue;
            return i;
        }
        return -1;
    }

    protected int endOfSubject(int n) {
        int n2 = n + 1;
        if (n >= this._lines.size()) {
            return this._lines.size();
        }
        for (int i = n + 1; i < this._lines.size(); ++i) {
            if (this.isAssignment((String)this._lines.elementAt(i))) {
                n2 = i + 1;
            }
            if (!this.isSubject((String)this._lines.elementAt(i))) continue;
            return n2;
        }
        return n2;
    }

    protected boolean isAssignment(String string) {
        return this._interfacesParser.isAttributes(string);
    }

    public Vector getLines() {
        return (Vector)this._lines.clone();
    }

    public List getServices(String string) {
        int n = this._subjects.indexOf(string);
        if (n != -1) {
            Vector vector = (Vector)this._services.elementAt(n);
            return vector;
        }
        return null;
    }

    public String[] getSubjects() {
        Object[] objectArray = new String[this._subjects.size()];
        this._subjects.copyInto(objectArray);
        return objectArray;
    }

    public void deleteSubject(String string) throws Exception {
        int n = this._subjects.indexOf(string);
        if (n == -1) {
            return;
        }
        this._services.removeElementAt(n);
        this._subjects.removeElementAt(n);
        int n2 = this.findSubjectLine(string);
        int n3 = this.endOfSubject(n2);
        for (int i = n2; i < n3; ++i) {
            this._lines.removeElementAt(n2);
        }
        if (this._saveOnChange) {
            this.saveFile();
        }
    }

    public void saveFile() throws Exception {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this._fileName)));
        for (int i = 0; i < this._lines.size(); ++i) {
            dataOutputStream.writeBytes((String)this._lines.elementAt(i) + System.getProperty("line.separator"));
        }
        dataOutputStream.close();
    }

    protected void finalize() {
    }

    public static SyInterfacesEntry getServer(String string, String string2) {
        return null;
    }

    public Enumeration forService(String string) {
        return null;
    }

    public String getAttribute(String string) {
        return null;
    }
}

