/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ldap;

import com.sybase.util.ds.ldap.LDAPException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class LDAPConfigFileParser {
    private String _fileName;
    private static final String[] LDAP_STRINGS = new String[]{"ldap:", "LDAP:", "dc", "DC", "cn", "CN"};

    protected boolean probe(URL uRL) throws IOException, LDAPException {
        InputStream inputStream = uRL.openStream();
        this._fileName = uRL.getFile();
        return this.probe(inputStream);
    }

    protected boolean probe(String string) throws IOException, LDAPException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this._fileName = string;
        return this.probe(fileInputStream);
    }

    protected boolean probe(InputStream inputStream) throws IOException, LDAPException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        bufferedReader.mark(1);
        if (-1 == bufferedReader.read()) {
            bufferedReader.close();
            throw new LDAPException("ERR_EMPTY_FILE", "MSG_LDAP_CONFIG", this._fileName);
        }
        bufferedReader.reset();
        Enumeration enumeration = this.nextSubject(bufferedReader);
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.isAttributes(string)) continue;
            bufferedReader.close();
            return false;
        }
        bufferedReader.close();
        return true;
    }

    protected Enumeration nextSubject(BufferedReader bufferedReader) throws IOException {
        Vector<String> vector = new Vector<String>();
        String string = bufferedReader.readLine();
        if (string == null) {
            return null;
        }
        string = string.trim();
        while (!this.isaSubject(string)) {
            string = bufferedReader.readLine();
            if (string != null) continue;
            if (string == null) {
                return null;
            }
            string = string.trim();
        }
        boolean bl = false;
        while (!bl) {
            if (!this.isEndOfSubject(string)) {
                if (!this.isBlankLine(string) && !this.isCommentLine(string)) {
                    vector.addElement(string);
                }
            } else {
                bl = true;
            }
            if ((string = bufferedReader.readLine()) == null) continue;
            string = string.trim();
        }
        return !vector.isEmpty() ? vector.elements() : null;
    }

    protected boolean isAttributes(String string) {
        if (string != null && string.length() > 0) {
            return (string.startsWith("LDAP") || string.startsWith("ldap")) && this.hasIt(string);
        }
        return false;
    }

    protected boolean isBlankLine(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().length() == 0;
    }

    protected boolean isCommentLine(String string) {
        boolean bl = false;
        if (string != null) {
            if (string.startsWith("#")) {
                bl = true;
            } else if (string.startsWith(";")) {
                bl = true;
            }
        }
        return this.isBlankLine(string) ? false : bl;
    }

    protected boolean isaSubject(String string) {
        return string != null && !this.isCommentLine(string) && string.length() > 0 && this.isAttributes(string);
    }

    protected boolean isEndOfSubject(String string) {
        if (string == null) {
            return true;
        }
        if (this.isBlankLine(string)) {
            return true;
        }
        if (this.isCommentLine(string)) {
            return true;
        }
        return !this.startsWith(string, LDAP_STRINGS);
    }

    protected boolean startsWith(String string, String[] stringArray) {
        return this.isAttributes(string);
    }

    protected boolean hasIt(String string) {
        if (string != null && string.length() > 0) {
            for (int i = 0; i < LDAP_STRINGS.length; ++i) {
                if (string.indexOf(LDAP_STRINGS[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }
}

