/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ldap;

import com.sybase.util.ds.Utils;
import com.sybase.util.ds.interfaces.Service;
import com.sybase.util.ds.interfaces.SyInterfacesEntry;
import com.sybase.util.ds.ldap.SyASEServer;
import com.sybase.util.ds.ldap.SyServer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class SyLDAPServer
extends SyServer {
    public static final String DEFAULT_LDAP_PORT = "389";
    private String _rootEntry;
    private Hashtable _lookup = new Hashtable();
    private final String INITCTX = "com.sun.jndi.ldap.LdapCtxFactory";
    private final String MY_FILTER = "(1.3.6.1.4.1.897.4.2.2=*)";
    private final String SYBASE_SERVER_NAME = "sybaseServername";
    private final String SYBASE_ADDRESS = "sybaseAddress";
    private NamingEnumeration results = null;
    private byte status = (byte)-1;

    public SyLDAPServer(String string, String string2, String string3, String string4, String string5, String string6) {
        this._serverName = string;
        this._hostName = string2;
        this._portNumber = string3 != null ? string3 : DEFAULT_LDAP_PORT;
        this._rootEntry = string4;
        this._userName = string5;
        this._passwd = string6;
    }

    public SyLDAPServer(String string, String string2, String string3, String string4) {
        this._serverName = string;
        this._hostName = string2;
        this._portNumber = string3 != null ? string3 : DEFAULT_LDAP_PORT;
        this._rootEntry = string4;
    }

    public String getHost() {
        return this._hostName;
    }

    public String getPort() {
        return this._portNumber;
    }

    public String getUserName() {
        return this._userName;
    }

    public String getPassword() {
        return this._passwd;
    }

    public String getRootEntry() {
        return this._rootEntry;
    }

    public String getServerName() {
        return this._serverName;
    }

    public void connectLDAP() {
        try {
            this.results = null;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            if (this._portNumber == null || this._portNumber.length() == 0) {
                this._portNumber = DEFAULT_LDAP_PORT;
            }
            hashtable.put("java.naming.provider.url", "ldap://" + Utils.getHostAndPort(this._hostName, this._portNumber));
            if (this._userName != null) {
                hashtable.put("user", this._userName);
            }
            if (this._passwd != null) {
                hashtable.put("password", this._passwd);
            }
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            this.results = initialDirContext.search(this._rootEntry, "(1.3.6.1.4.1.897.4.2.2=*)", searchControls);
            this.status = 1;
        }
        catch (NamingException namingException) {
            this.status = 0;
        }
    }

    public boolean connectLDAP(int n) {
        long l = n * 1000;
        Thread thread = new Thread(){

            public void run() {
                SyLDAPServer.this.connectLDAP();
            }
        };
        thread.start();
        long l2 = 0L;
        while (l2 < l && this.status == -1) {
            try {
                Thread.sleep(3000L);
                l2 += 3000L;
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.status == 1;
    }

    public void initASEEntries() throws NamingException {
        while (this.results != null && this.results.hasMore()) {
            Attribute attribute;
            SearchResult searchResult = (SearchResult)this.results.next();
            String string = "";
            Attributes attributes = searchResult.getAttributes();
            Attribute attribute2 = attributes.get("sybaseServername");
            if (attribute2 == null && (attribute2 = attributes.get("sybaseServername".toLowerCase())) == null) continue;
            if (attribute2.size() > 0) {
                string = (String)attribute2.get(0);
            }
            if ((attribute = attributes.get("sybaseAddress")) == null && (attribute = attributes.get("sybaseAddress".toLowerCase())) == null) continue;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            while (namingEnumeration.hasMoreElements()) {
                String[] stringArray = this.retrieveASEProperties((String)namingEnumeration.nextElement());
                if (stringArray != null) {
                    if (stringArray[0] == null || stringArray[1] == null || stringArray[2] == null) continue;
                    string5 = stringArray[0];
                    string2 = stringArray[1];
                    string3 = stringArray[2];
                    string4 = stringArray[3];
                }
                if (string5.length() <= 0 || string.length() <= 0 || string2.length() <= 0 || string3.length() <= 0) continue;
                SyInterfacesEntry syInterfacesEntry = new SyInterfacesEntry(string);
                StringBuffer stringBuffer = new StringBuffer(string5);
                stringBuffer.append("," + string2 + "," + string3);
                if (string4 != null && string4.length() > 0) {
                    stringBuffer.append("," + string4);
                }
                String string6 = stringBuffer.toString();
                Service service = new Service(1, string6);
                syInterfacesEntry.addService(service);
                SyASEServer syASEServer = new SyASEServer(syInterfacesEntry);
                if (this.containsASEServerName(string)) {
                    this._lookup.put(string + " [" + Utils.getHostAndPort(string2, string3) + "]", syASEServer);
                    continue;
                }
                this._lookup.put(string, syASEServer);
            }
        }
    }

    private String[] retrieveASEProperties(String string) {
        String[] stringArray = new String[4];
        int n = string.indexOf("#");
        if (n <= 0) {
            return stringArray;
        }
        stringArray[0] = string.substring(0, n);
        int n2 = string.lastIndexOf(35);
        if (n2 > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n2 + 1));
            int n3 = stringTokenizer.countTokens();
            if (n3 < 2) {
                return stringArray;
            }
            int n4 = 1;
            while (stringTokenizer.hasMoreTokens() && n4 < 4) {
                stringArray[n4++] = stringTokenizer.nextToken().trim();
            }
        }
        return stringArray;
    }

    public Enumeration getKeys() {
        return this._lookup.keys();
    }

    public String[] getASEServerNames() {
        Vector vector = new Vector();
        Object[] objectArray = this._lookup.keys();
        while (objectArray.hasMoreElements()) {
            vector.addElement(objectArray.nextElement());
        }
        if (vector.size() > 0) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public Enumeration getElements() {
        return this._lookup.elements();
    }

    public Vector getASEServers() {
        Vector<SyASEServer> vector = new Vector<SyASEServer>();
        Enumeration enumeration = this._lookup.elements();
        while (enumeration.hasMoreElements()) {
            SyASEServer syASEServer = (SyASEServer)enumeration.nextElement();
            vector.addElement(syASEServer);
        }
        return vector;
    }

    public synchronized boolean contains(SyASEServer syASEServer) {
        if (syASEServer != null) {
            return this._lookup.contains(syASEServer);
        }
        return false;
    }

    public synchronized boolean containsASEServerName(String string) {
        if (string != null) {
            return this._lookup.containsKey(string);
        }
        return false;
    }

    public SyASEServer getASEServer(String string) {
        return (SyASEServer)this._lookup.get(string);
    }

    public String toString() {
        Enumeration enumeration = this.getElements();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public Hashtable getLookup() {
        return this._lookup;
    }
}

