/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ui;

import com.sybase.asa.ASABaseGridBagPanel;
import com.sybase.asa.ASAButton;
import com.sybase.asa.ASAComboBox;
import com.sybase.asa.ASAGOConstants;
import com.sybase.asa.ASALabel;
import com.sybase.asa.ASAListCheckEvent;
import com.sybase.asa.ASAMultiCheckList;
import com.sybase.asa.ASAScrollPane;
import com.sybase.asa.ASATextUserData;
import com.sybase.util.ds.uaf.DiscoveryFilter;
import com.sybase.util.ds.ui.BasePanel;
import com.sybase.util.ds.ui.EditFilterDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DiscoveryFiltersPage
extends BasePanel
implements ListSelectionListener {
    public ASALabel infoLabel;
    public ASALabel infoLabel1;
    public ASAComboBox andOrComboBox;
    public ASALabel infoLabel2;
    public ASABaseGridBagPanel infoPanel;
    public ASAMultiCheckList filtersMultiCheckList;
    public ASAButton addButton;
    public ASAButton removeButton;
    public ASAButton editButton;
    public ASAButton enableAllButton;
    public ASAButton disableAllButton;
    private String _filtersString;
    private String _filterId;

    public DiscoveryFiltersPage(JDialog jDialog, String string) {
        super(jDialog);
        this._filterId = string;
        this.createGUI();
    }

    private void createGUI() {
        this.infoLabel = new ASALabel(_res.get("FILTERING_INFO"));
        this.infoLabel1 = new ASALabel(_res.get("FILTERING_INFO1"));
        this.infoLabel2 = new ASALabel(_res.get("FILTERING_INFO2"));
        this.andOrComboBox = new ASAComboBox(new Object[]{new ASATextUserData(_res.get("ALL"), (Object)"ALL"), new ASATextUserData(_res.get("ANY"), (Object)"ANY")});
        String string = _res.get("TARGET");
        String string2 = _res.get("CONDITION");
        Vector<String> vector = new Vector<String>();
        vector.add(string);
        vector.add(string2);
        this.filtersMultiCheckList = new ASAMultiCheckList(vector);
        this.addButton = new ASAButton(_res.get("ADD"));
        this.removeButton = new ASAButton(_res.get("REMOVE"));
        this.editButton = new ASAButton(_res.get("EDIT"));
        this.enableAllButton = new ASAButton(_res.get("ENABLE_ALL"));
        this.disableAllButton = new ASAButton(_res.get("DISABLE_ALL"));
        int n = 0;
        this.infoPanel = new ASABaseGridBagPanel(ASAGOConstants.INSETS_NONE);
        this.infoPanel.add((Component)this.infoLabel1, 0, 0, 1, 1, 0.0, 0.0, 17, 0, ASAGOConstants.INSETS, 0, 0);
        this.infoPanel.add((Component)this.andOrComboBox, 1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0);
        this.infoPanel.add((Component)this.infoLabel2, 2, 0, 1, 1, 0.0, 0.0, 17, 0, ASAGOConstants.INSETS, 0, 0);
        this.add((Component)this.infoLabel, 0, n, 2, 1, 0.0, 0.0, 17, 0, ASAGOConstants.INSETS, 0, 0);
        this.add((Component)this.infoPanel, 0, n, 2, 1, 0.0, 0.0, 17, 0, ASAGOConstants.INSETS, 0, 0);
        ASAScrollPane aSAScrollPane = this.filtersMultiCheckList.getScrollPane();
        aSAScrollPane.setPreferredSize(new Dimension(400, 200));
        this.add((Component)aSAScrollPane, 0, ++n, 1, 5, 1.0, 1.0, 17, 1, ASAGOConstants.INSETS, 0, 0);
        this.add((Component)this.addButton, 1, n, 1, 1, 0.0, 0.0, 12, 2, ASAGOConstants.INSETS, 0, 0);
        this.add((Component)this.removeButton, 1, ++n, 1, 1, 0.0, 0.0, 12, 2, ASAGOConstants.INSETS, 0, 0);
        this.add((Component)this.editButton, 1, ++n, 1, 1, 0.0, 0.0, 12, 2, ASAGOConstants.INSETS, 0, 0);
        this.add((Component)this.enableAllButton, 1, ++n, 1, 1, 0.0, 0.0, 12, 2, ASAGOConstants.INSETS, 0, 0);
        this.add((Component)this.disableAllButton, 1, ++n, 1, 1, 0.0, 0.0, 12, 2, ASAGOConstants.INSETS, 0, 0);
    }

    public void init() {
        this.filtersMultiCheckList.getSelectionModel().removeListSelectionListener(this);
        boolean bl = DiscoveryFilter.isMatchingAllFilters(this._filterId);
        String string = bl ? "ALL" : "ANY";
        this.andOrComboBox.setSelectedItem(_res.get(string));
        List list = DiscoveryFilter.getDiscoveryFilters(this._filterId);
        this._filtersString = String.valueOf(bl);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DiscoveryFilter discoveryFilter = (DiscoveryFilter)iterator.next();
            this.filtersMultiCheckList.addRow(discoveryFilter.enabled, new Object[]{discoveryFilter, discoveryFilter.getCondition()});
            this._filtersString = this._filtersString + discoveryFilter.getText();
        }
        this.filtersMultiCheckList.setInitialColumnWidths();
        this.enableComponents();
        this.filtersMultiCheckList.getSelectionModel().addListSelectionListener(this);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableComponents();
    }

    public void handleValueChanged(ASAListCheckEvent aSAListCheckEvent) {
        this.enableComponents();
    }

    public boolean handleMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1 && this.editFilter()) {
            this.enableComponents();
            return true;
        }
        return false;
    }

    public void handleActionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addButton) {
            EditFilterDialog editFilterDialog = new EditFilterDialog(this, null, false, this._filterId);
            DiscoveryFilter discoveryFilter = editFilterDialog.create();
            if (discoveryFilter != null) {
                this.filtersMultiCheckList.addRow(discoveryFilter.enabled, new Object[]{discoveryFilter, discoveryFilter.getCondition()});
            }
        } else if (object == this.removeButton) {
            int[] nArray = this.filtersMultiCheckList.getSelectedRows();
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.filtersMultiCheckList.removeRow(nArray[i]);
            }
        } else if (object == this.editButton) {
            this.editFilter();
        } else if (object == this.enableAllButton) {
            this.filtersMultiCheckList.checkAllRows();
        } else if (object == this.disableAllButton) {
            this.filtersMultiCheckList.uncheckAllRows();
        }
        this.enableComponents();
    }

    private boolean editFilter() {
        int n = this.filtersMultiCheckList.getSelectedRow();
        if (n < 0) {
            return false;
        }
        Object[] objectArray = this.filtersMultiCheckList.getRowAsArray(n);
        EditFilterDialog editFilterDialog = new EditFilterDialog(this, (DiscoveryFilter)objectArray[0], true, this._filterId);
        DiscoveryFilter discoveryFilter = editFilterDialog.create();
        if (discoveryFilter != null) {
            this.filtersMultiCheckList.setRow(n, discoveryFilter.enabled, new Object[]{discoveryFilter, discoveryFilter.getCondition()});
            return true;
        }
        return false;
    }

    public List getFilters() {
        ArrayList<DiscoveryFilter> arrayList = new ArrayList<DiscoveryFilter>();
        for (int i = 0; i < this.filtersMultiCheckList.getRowCount(); ++i) {
            Object[] objectArray = this.filtersMultiCheckList.getRowAsArray(i);
            DiscoveryFilter discoveryFilter = (DiscoveryFilter)objectArray[0];
            discoveryFilter.enabled = this.filtersMultiCheckList.isRowChecked(i);
            arrayList.add(discoveryFilter);
        }
        return arrayList;
    }

    private boolean isMatchingAll() {
        String string = (String)this.andOrComboBox.getSelectedUserData();
        return string.equals("ALL");
    }

    public void saveFilters() {
        DiscoveryFilter.saveDiscoveryFilters(this._filterId, this.isMatchingAll(), this.getFilters());
    }

    public boolean getEnableSave() {
        String string = String.valueOf(this.isMatchingAll());
        Iterator iterator = this.getFilters().iterator();
        while (iterator.hasNext()) {
            string = string + ((DiscoveryFilter)iterator.next()).getText();
        }
        return !string.equals(this._filtersString);
    }

    public void enableComponents() {
        int n = this.filtersMultiCheckList.getSelectedRowCount();
        boolean bl = n > 0;
        this.editButton.setEnabled(bl);
        this.removeButton.setEnabled(bl);
        int n2 = this.filtersMultiCheckList.getCheckedRowCount();
        this.disableAllButton.setEnabled(n2 > 0);
        this.enableAllButton.setEnabled(n2 < this.filtersMultiCheckList.getRowCount());
        boolean bl2 = n2 > 1;
        this.infoLabel.setVisible(!bl2);
        this.infoPanel.setVisible(bl2);
    }
}

