/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ui;

import com.sybase.asa.ASACheckBox;
import com.sybase.asa.ASAComboBox;
import com.sybase.asa.ASAGOConstants;
import com.sybase.asa.ASAMaskedTextField;
import com.sybase.asa.ASASpinBox;
import com.sybase.asa.ASATextField;
import com.sybase.asa.ASATextUserData;
import com.sybase.util.ds.uaf.DiscoveryFilter;
import com.sybase.util.ds.uaf.Subject;
import com.sybase.util.ds.uaf.Verb;
import com.sybase.util.ds.ui.BasePanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.swing.Box;

public class EditFilterPage
extends BasePanel {
    public ASACheckBox enableCheckBox;
    public ASAComboBox subjectComboBox;
    public ASAComboBox verbComboBox;
    public ASATextField nounTextField;
    public ASASpinBox portSpinBox;
    public ASASpinBox timeSpinBox;
    public ASAComboBox statusComboBox;
    public ASAComboBox timeComboBox;
    public ASAComboBox releaseComboBox;
    public ASAMaskedTextField dateMaskedTextField;
    private String _filterId;

    public EditFilterPage(boolean bl, String string) {
        this._filterId = string;
        this.createGUI();
    }

    private void createGUI() {
        this.enableCheckBox = new ASACheckBox(_res.get("ENABLE_THIS_FILTER"));
        Object[] objectArray = Subject.getSubjects(this._filterId);
        Arrays.sort(objectArray);
        this.subjectComboBox = new ASAComboBox(objectArray);
        this.verbComboBox = new ASAComboBox();
        this.nounTextField = new ASATextField();
        this.portSpinBox = new ASASpinBox(5000, 1, 999999);
        this.timeSpinBox = new ASASpinBox(3, 1, 999);
        this.statusComboBox = new ASAComboBox();
        this.timeComboBox = new ASAComboBox();
        this.releaseComboBox = new ASAComboBox();
        this.dateMaskedTextField = new ASAMaskedTextField("##/##/##");
        ASATextUserData aSATextUserData = new ASATextUserData(_res.get("STOPPED"), (Object)"STOPPED");
        ASATextUserData aSATextUserData2 = new ASATextUserData(_res.get("RUNNING"), (Object)"RUNNING");
        this.statusComboBox.addItem((Object)aSATextUserData2);
        this.statusComboBox.addItem((Object)aSATextUserData);
        ASATextUserData aSATextUserData3 = new ASATextUserData(_res.get("YEARS"), (Object)"YEARS");
        ASATextUserData aSATextUserData4 = new ASATextUserData(_res.get("MONTHS"), (Object)"MONTHS");
        ASATextUserData aSATextUserData5 = new ASATextUserData(_res.get("WEEKS"), (Object)"WEEKS");
        ASATextUserData aSATextUserData6 = new ASATextUserData(_res.get("DAYS"), (Object)"DAYS");
        this.timeComboBox.addItem((Object)aSATextUserData6);
        this.timeComboBox.addItem((Object)aSATextUserData5);
        this.timeComboBox.addItem((Object)aSATextUserData4);
        this.timeComboBox.addItem((Object)aSATextUserData3);
        this.timeComboBox.setSelectedIndex(2);
        ASATextUserData aSATextUserData7 = new ASATextUserData(_res.get("PRODUCTION"), (Object)"PRODUCTION");
        ASATextUserData aSATextUserData8 = new ASATextUserData(_res.get("BETA"), (Object)"BETA");
        ASATextUserData aSATextUserData9 = new ASATextUserData(_res.get("ALPHA"), (Object)"ALPHA");
        this.releaseComboBox.addItem((Object)aSATextUserData9);
        this.releaseComboBox.addItem((Object)aSATextUserData8);
        this.releaseComboBox.addItem((Object)aSATextUserData7);
        this.add((Component)this.enableCheckBox, 0, 0, 1, 1, 0.0, 0.0, 17, 0, ASAGOConstants.INSETS, 0, 0);
        this.add((Component)this.subjectComboBox, 0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0);
        this.add((Component)this.verbComboBox, 1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0);
        this.add((Component)this.nounTextField, 2, 1, 1, 1, 1.0, 0.0, 17, 2, ASAGOConstants.INSETS, 0, 0);
        this.add((Component)this.dateMaskedTextField, 2, 1, 1, 1, 1.0, 0.0, 17, 2, ASAGOConstants.INSETS, 0, 0);
        this.add((Component)this.portSpinBox, 2, 1, 1, 1, 0.0, 0.0, 17, 0, ASAGOConstants.INSETS, 0, 0);
        this.add((Component)this.timeSpinBox, 2, 1, 1, 1, 0.0, 0.0, 17, 0, ASAGOConstants.INSETS, 0, 0);
        this.add((Component)this.statusComboBox, 3, 1, 1, 1, 0.0, 0.0, 17, 0, ASAGOConstants.INSETS, 0, 0);
        this.add((Component)this.timeComboBox, 3, 1, 1, 1, 0.0, 0.0, 17, 0, ASAGOConstants.INSETS, 0, 0);
        this.add((Component)this.releaseComboBox, 3, 1, 1, 1, 0.0, 0.0, 17, 0, ASAGOConstants.INSETS, 0, 0);
        this.add(Box.createGlue(), 0, 2, 0, 1, 1.0, 1.0, 10, 1, ASAGOConstants.INSETS_NONE, 0, 0);
    }

    public void init(DiscoveryFilter discoveryFilter) {
        DiscoveryFilter discoveryFilter2 = discoveryFilter == null ? new DiscoveryFilter() : discoveryFilter;
        this.enableCheckBox.setSelected(discoveryFilter2.enabled);
        this.subjectComboBox.setSelectedItem(discoveryFilter2.subject.toString());
        this.loadVerbs(discoveryFilter2.subject);
        this.verbComboBox.setSelectedItem(discoveryFilter2.verb.toString());
        this.loadNoun(discoveryFilter2);
    }

    private void loadVerbs(Subject subject) {
        Object object = this.verbComboBox.getSelectedItem();
        this.verbComboBox.removeAllItems();
        Verb[] verbArray = subject.getVerbs();
        for (int i = 0; i < verbArray.length; ++i) {
            this.verbComboBox.addItem((Object)verbArray[i]);
        }
        if (object != null) {
            this.verbComboBox.setSelectedItem(object.toString());
        }
    }

    private void loadNoun(DiscoveryFilter discoveryFilter) {
        if (discoveryFilter.subject.type.equals("N")) {
            this.nounTextField.setVisible(false);
            this.dateMaskedTextField.setVisible(false);
            this.portSpinBox.setVisible(true);
            this.timeSpinBox.setVisible(false);
            this.statusComboBox.setVisible(false);
            this.timeComboBox.setVisible(false);
            this.releaseComboBox.setVisible(false);
            this.setNounSpinBoxValue(this.portSpinBox, discoveryFilter.noun, 5000);
        } else if (discoveryFilter.subject.type.equals("S")) {
            this.portSpinBox.setVisible(false);
            this.timeSpinBox.setVisible(false);
            if (discoveryFilter.subject.name.equals("getReleaseType") || discoveryFilter.subject.name.equals("getStatus")) {
                ASAComboBox aSAComboBox;
                this.nounTextField.setVisible(false);
                this.dateMaskedTextField.setVisible(false);
                this.timeComboBox.setVisible(false);
                if (discoveryFilter.subject.name.equals("getReleaseType")) {
                    this.statusComboBox.setVisible(false);
                    this.releaseComboBox.setVisible(true);
                    aSAComboBox = this.releaseComboBox;
                } else {
                    this.statusComboBox.setVisible(true);
                    this.releaseComboBox.setVisible(false);
                    aSAComboBox = this.statusComboBox;
                }
                if (discoveryFilter.noun != null) {
                    aSAComboBox.setSelectedItem(_res.get(discoveryFilter.noun));
                }
            } else {
                this.nounTextField.setVisible(true);
                this.dateMaskedTextField.setVisible(false);
                this.statusComboBox.setVisible(false);
                this.timeComboBox.setVisible(false);
                this.releaseComboBox.setVisible(false);
                this.setNounTextFieldValue(discoveryFilter.noun);
            }
        } else if (discoveryFilter.subject.type.equals("D")) {
            if (discoveryFilter.verb.name.equals("IS_IN_THE_LAST") || discoveryFilter.verb.name.equals("IS_NOT_IN_THE_LAST")) {
                this.nounTextField.setVisible(false);
                this.dateMaskedTextField.setVisible(false);
                this.portSpinBox.setVisible(false);
                this.timeSpinBox.setVisible(true);
                this.statusComboBox.setVisible(false);
                this.timeComboBox.setVisible(true);
                this.releaseComboBox.setVisible(false);
                if (discoveryFilter.noun != null) {
                    String[] stringArray = discoveryFilter.noun.split(":");
                    String string = stringArray[0];
                    String string2 = stringArray[1];
                    this.setNounSpinBoxValue(this.timeSpinBox, string, 3);
                    this.timeComboBox.setSelectedItem(_res.get(string2));
                }
            } else {
                this.dateMaskedTextField.setVisible(true);
                this.nounTextField.setVisible(false);
                this.portSpinBox.setVisible(false);
                this.timeSpinBox.setVisible(false);
                this.statusComboBox.setVisible(false);
                this.timeComboBox.setVisible(false);
                this.releaseComboBox.setVisible(false);
                if (discoveryFilter.noun != null && !discoveryFilter.noun.endsWith(" ")) {
                    this.dateMaskedTextField.setText(discoveryFilter.noun);
                } else {
                    Date date = new Date();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yy");
                    this.dateMaskedTextField.setText(simpleDateFormat.format(date));
                }
            }
        }
    }

    private void setNounTextFieldValue(String string) {
        if (string == null) {
            this.nounTextField.setText("");
        } else {
            this.nounTextField.setText(string);
        }
    }

    private void setNounSpinBoxValue(ASASpinBox aSASpinBox, String string, int n) {
        try {
            aSASpinBox.setValue(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            aSASpinBox.setValue(n);
        }
    }

    public void handleActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.subjectComboBox) {
            Subject subject = this.getSubject();
            this.loadVerbs(subject);
            DiscoveryFilter discoveryFilter = this.getFilter();
            discoveryFilter.noun = null;
            this.loadNoun(discoveryFilter);
        } else if (actionEvent.getSource() == this.verbComboBox) {
            Subject subject = this.getSubject();
            if (subject.type.equals("D")) {
                DiscoveryFilter discoveryFilter = this.getFilter();
                this.loadNoun(discoveryFilter);
            }
        }
    }

    public Subject getSubject() {
        return (Subject)this.subjectComboBox.getSelectedItem();
    }

    public Verb getVerb() {
        return (Verb)this.verbComboBox.getSelectedItem();
    }

    public String getNoun() {
        Subject subject = this.getSubject();
        String string = "";
        if (subject.type.equals("S")) {
            string = subject.name.equals("getReleaseType") ? (String)this.releaseComboBox.getSelectedUserData() : (subject.name.equals("getStatus") ? (String)this.statusComboBox.getSelectedUserData() : this.nounTextField.getText());
        } else if (subject.type.equals("N")) {
            string = String.valueOf(this.portSpinBox.getValue());
        } else if (subject.type.equals("D")) {
            Verb verb = this.getVerb();
            if (verb.name.equals("IS_IN_THE_LAST") || verb.name.equals("IS_NOT_IN_THE_LAST")) {
                String string2 = (String)this.timeComboBox.getSelectedUserData();
                string = String.valueOf(this.timeSpinBox.getValue()) + ":" + string2;
            } else {
                string = this.dateMaskedTextField.getText();
            }
        }
        return string;
    }

    public DiscoveryFilter getFilter() {
        return new DiscoveryFilter(this.enableCheckBox.isSelected(), this.getSubject(), this.getVerb(), this.getNoun());
    }
}

