/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ui;

import com.sybase.asa.ASASpinBoxChangeEvent;
import com.sybase.asa.ASASpinBoxChangeListener;
import com.sybase.util.ds.ui.BaseDialog;
import com.sybase.util.ds.ui.GeneralPage;
import com.sybase.util.ds.ui.LDAPPage;
import com.sybase.util.ds.ui.ServerDiscoveryPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SettingsDialog
extends BaseDialog
implements ChangeListener,
MouseListener,
ASASpinBoxChangeListener {
    private JTabbedPane _tabbedPane = null;
    private ServerDiscoveryPage _serverDiscoveryPage = null;
    private LDAPPage _ldapPage = null;
    private GeneralPage _generalPage = null;
    private List _retcodes = new ArrayList();
    private String _filterId;

    public SettingsDialog(JDialog jDialog) {
        super(jDialog);
        this._filterId = "ASE";
    }

    public SettingsDialog(JDialog jDialog, String string) {
        super(jDialog);
        this._filterId = string;
    }

    public List create() {
        this._retcodes.clear();
        this.setVisible(this.createGUI());
        this.destroyUI();
        return this._retcodes;
    }

    void destroyUI() {
        this._serverDiscoveryPage = null;
        this._tabbedPane = null;
        super.destroyUI();
    }

    private boolean createGUI() {
        this._tabbedPane = new JTabbedPane();
        if (this._filterId.equals("ASE")) {
            this._generalPage = new GeneralPage();
            this._generalPage.init(this, this);
            this._generalPage.enableComponents();
            this._tabbedPane.addTab(_res.get("GENERAL"), (Component)((Object)this._generalPage));
            this._ldapPage = new LDAPPage();
            this._ldapPage.init(this, this);
            this._ldapPage.enableComponents();
            this._tabbedPane.addTab(_res.get("LDAP"), (Component)((Object)this._ldapPage));
        }
        this._serverDiscoveryPage = new ServerDiscoveryPage(this._filterId);
        this._serverDiscoveryPage.init(this);
        this._serverDiscoveryPage.setParentDialog(this);
        this._serverDiscoveryPage.enableComponents();
        this._serverDiscoveryPage.serversList.addMouseListener(this);
        this._tabbedPane.addTab(_res.get("SERVER_DISCOVERY"), (Component)((Object)this._serverDiscoveryPage));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._tabbedPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)this._tabbedPane, "Center");
        super.createUI(jPanel, _res.get("SETTINGS_TITLE"));
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this._serverDiscoveryPage.handleMouseClicked(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this._serverDiscoveryPage != null && object == this._serverDiscoveryPage.addButton || object == this._serverDiscoveryPage.editButton || object == this._serverDiscoveryPage.removeButton || object == this._serverDiscoveryPage.upButton || object == this._serverDiscoveryPage.downButton || object == this._serverDiscoveryPage.filtersButton || object == this._serverDiscoveryPage.discoveryCheckBox) {
            this._serverDiscoveryPage.handleActionPerformed(actionEvent);
        } else if (this._ldapPage != null && object == this._ldapPage.ldapCheckBox) {
            this._ldapPage.handleActionPerformed();
        } else if (this._generalPage != null && object == this._generalPage.loginTimeoutCheckBox) {
            this._generalPage.handleActionPerformed();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (this._ldapPage != null && object == this._ldapPage.timeoutSlider) {
            this._ldapPage.handleStateChanged();
        }
    }

    public void valueChanged(ASASpinBoxChangeEvent aSASpinBoxChangeEvent) {
        Object object = aSASpinBoxChangeEvent.getSource();
        if (object == this._generalPage.loginTimeoutSpinBox) {
            this._generalPage.handleValueChanged(aSASpinBoxChangeEvent);
        }
    }

    void handleOK() {
        boolean bl = this.saveSettings();
        if (bl) {
            this.setVisible(false);
        }
    }

    private boolean saveSettings() {
        this._retcodes.clear();
        boolean bl = this._serverDiscoveryPage != null && this._serverDiscoveryPage.getEnableSave();
        boolean bl2 = false;
        if (bl) {
            bl2 = this._serverDiscoveryPage.saveSettings();
        }
        this._retcodes.add(new Boolean(bl2));
        boolean bl3 = this._ldapPage != null && this._ldapPage.getEnableSave();
        boolean bl4 = false;
        if (bl3) {
            bl4 = this._ldapPage.saveSettings();
        }
        this._retcodes.add(new Boolean(bl4));
        boolean bl5 = this._generalPage != null;
        boolean bl6 = false;
        if (bl5) {
            bl6 = this._generalPage.saveSettings();
        }
        this._retcodes.add(new Boolean(bl6));
        boolean bl7 = bl && !bl2 || bl3 && !bl4 || bl5 && !bl6;
        return !bl7;
    }

    void handleCancel() {
        this._retcodes.clear();
        this.setVisible(false);
    }
}

