/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rma.callback;

import com.sybase.rma.callback.HeartbeatServerImpl;
import com.sybase.rma.callback.StatusServerImpl;
import com.sybase.rma.callback.TriggerServerImpl;
import com.sybase.ua.AgentInfo;
import com.sybase.ua.rma.logging.RmaLogger;
import com.sybase.ua.rma.plugin.RmaAgentPlugin;
import com.sybase.ua.services.Agent;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class RmiServiceInit {
    private Registry registry;
    private String port;
    private String host;
    private static String rmiAddress;
    private String DEFAULTPORT = "9999";
    public static RmaLogger _log;

    public void Start(RmaAgentPlugin plugin) throws Exception {
        if (Agent.getInstance().isStarted()) {
            AgentInfo agentInfo = Agent.getInstance().getAgentInfo();
            this.host = agentInfo.getHost();
            this.port = agentInfo.getRMIPort();
            _log.info("RmiServiceInit.Start.m1", (Object)this.host, (Object)this.port);
        }
        if (this.port == null || this.port.length() == 0) {
            this.port = this.DEFAULTPORT;
        } else {
            this.registry = LocateRegistry.getRegistry(new Integer(this.port));
            _log.info("RmiServiceInit.Start.m2", (Object)this.port);
        }
        if (this.registry == null) {
            LocateRegistry.createRegistry(new Integer(this.port));
            _log.info("RmiServiceInit.Start.m3", (Object)this.port);
        }
        if (this.host == null || this.host.length() == 0) {
            InetAddress localhostAddr = InetAddress.getLocalHost();
            this.host = localhostAddr.getCanonicalHostName();
        }
        RmiServiceInit.setRmiAddress("rmi://" + this.host + ":" + this.port + "/");
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            StatusServerImpl statusServer = new StatusServerImpl(plugin);
            String rmiAddress = "rmi://" + this.host + ":" + this.port + "/StatusService";
            _log.info(rmiAddress);
            Naming.rebind(rmiAddress, statusServer);
            _log.info(_log.getString("RmiServiceInit.Start.rebind", (Object)rmiAddress));
            TriggerServerImpl triggerServer = new TriggerServerImpl(plugin);
            String rmiTriggerAddress = "rmi://" + this.host + ":" + this.port + "/TriggerService";
            _log.info(rmiTriggerAddress);
            Naming.rebind(rmiTriggerAddress, triggerServer);
            _log.info(_log.getString("RmiServiceInit.Start.rebind", (Object)rmiTriggerAddress));
            HeartbeatServerImpl heartbeatServer = new HeartbeatServerImpl(plugin);
            String rmiHeartbeatAddress = "rmi://" + this.host + ":" + this.port + "/HeartbeatService";
            _log.info(rmiHeartbeatAddress);
            Naming.rebind(rmiHeartbeatAddress, heartbeatServer);
            _log.info(_log.getString("RmiServiceInit.Start.rebind", (Object)rmiHeartbeatAddress));
        }
        catch (Exception e) {
            _log.error((Object)_log.getString("RmiServiceInit.Start.m4"), (Throwable)e);
        }
    }

    public static String getRmiAddress() {
        return rmiAddress;
    }

    public static void setRmiAddress(String rmiAddressParam) {
        rmiAddress = rmiAddressParam;
    }

    static {
        _log = (RmaLogger)RmaLogger.getLogger((String)"com.sybase.ua.rma.rmi.RmiServiceInit");
    }
}

