/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rma.callback;

import com.sybase.rma.callback.RMSMonitorListener;
import com.sybase.rma.callback.StatusServer;
import com.sybase.ua.rma.logging.RmaLogger;
import com.sybase.ua.rma.plugin.EntityInfo;
import com.sybase.ua.rma.plugin.RmaAgentPlugin;
import com.sybase.ua.rma.plugin.RmaComponent;
import com.sybase.ua.rma.plugin.RmaEntity;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Hashtable;

public class StatusServerImpl
extends UnicastRemoteObject
implements StatusServer {
    RmaAgentPlugin _plugin;
    public static RmaLogger _log = (RmaLogger)RmaLogger.getLogger((String)"com.sybase.ua.rma.rmi.StatusServerImpl");
    private Hashtable notifyTable = new Hashtable();

    public StatusServerImpl(RmaAgentPlugin plugin) throws RemoteException {
        this._plugin = plugin;
    }

    @Override
    public void registerStatusMonitor(RMSMonitorListener sm) throws RemoteException {
        _log.debug(_log.getString("StatusServerImpl.registerStatusMonitor.m0"));
        ArrayList serverNames = this.getAllServerName();
        while (!serverNames.isEmpty()) {
            String servername = serverNames.remove(0).toString();
            try {
                RmaEntity entity = (RmaEntity)this._plugin.getEntity(servername);
                if (entity == null) {
                    _log.error((Object)_log.getString("StatusServerImpl.registerStatusMonitor.m1", (Object)servername));
                    throw new Exception(_log.getString("StatusServerImpl.registerStatusMonitor.m1", (Object)servername));
                }
                if (entity instanceof RmaComponent) {
                    _log.info(_log.getString("StatusServerImpl.registerStatusMonitor.RmaComponent", (Object)sm.toString()));
                    ((RmaComponent)entity).registerMonitoring(sm);
                    continue;
                }
                _log.error((Object)_log.getString("StatusServerImpl.registerStatusMonitor.m2", (Object)servername));
                throw new Exception(_log.getString("StatusServerImpl.registerStatusMonitor.m2", (Object)servername));
            }
            catch (Exception ex) {
                _log.error((Object)_log.getString("StatusServerImpl.registerStatusMonitor.m3", (Object)servername));
                throw new RemoteException(ex.getMessage());
            }
        }
    }

    @Override
    public void cancelStatusMonitor(RMSMonitorListener sm) throws RemoteException {
        _log.debug(_log.getString("StatusServerImpl.cancelStatusMonitor.m0"));
        ArrayList serverNames = this.getAllServerName();
        while (!serverNames.isEmpty()) {
            String servername = serverNames.remove(0).toString();
            try {
                RmaEntity entity;
                if (this.notifyTable.contains(sm)) {
                    this.notifyTable.remove(sm);
                }
                if (!((entity = (RmaEntity)this._plugin.getEntity(servername)) instanceof RmaComponent)) continue;
                _log.info(_log.getString("StatusServerImpl.cancelStatusMonitor.RmaComponent", (Object)sm.toString()));
                ((RmaComponent)entity).cancelregisterMonitoring(sm);
            }
            catch (Exception ex) {
                _log.error((Object)_log.getString("StatusServerImpl.cancelStatusMonitor.m1", (Object)servername));
                throw new RemoteException(ex.getMessage());
            }
        }
    }

    public ArrayList getAllServerName() throws RemoteException {
        ArrayList<String> serverNames = new ArrayList<String>();
        try {
            EntityInfo[] entityInfos = this._plugin.get_configHandler().getEntities();
            if (entityInfos == null) {
                _log.debug(_log.getString("StatusServerImpl.getAllServerName.noEntity"));
                return serverNames;
            }
            String name = "";
            for (int ido = 0; ido < entityInfos.length; ++ido) {
                name = entityInfos[ido].getName();
                serverNames.add(name);
            }
        }
        catch (Exception e) {
            _log.error((Object)_log.getString("StatusServerImpl.getAllServerName.failure "), (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
        return serverNames;
    }
}

