/*
** Confidential property of Sybase, Inc.
** (c) Copyright Sybase, Inc. 1985 to 1991.
** All rights reserved
*/

/*
** generic/script/%M%:		%I%	%G%	%U%
**
** This prepares a SQL Server database to have primary data and optionally
** replicate data.
*/

/* Drop the table, if it exists. */
if exists (select name
		from sysobjects
		where name = 'rs_lastcommit' and type = 'U')
begin
	drop table rs_lastcommit
end
go

/* 
** Create the table.
** We pad each row to be greater than a half page but less than one page
** to avoid lock contention.
*/

create table rs_lastcommit
	(
	origin		int,
	origin_qid	binary(36),
	secondary_qid	binary(36),
	origin_time	datetime,
	dest_commit_time	datetime,
	pad1		binary(255),
	pad2		binary(255),
	pad3		binary(255),
	pad4		binary(255),
	pad5		binary(4),
	pad6		binary(4),
	pad7		binary(4),
	pad8		binary(4)
	)
go
create unique clustered index rs_lastcommit_idx on rs_lastcommit(origin)
go
if exists (select name
                from sysobjects
                where name = 'rs_threads' and type = 'U')
begin
        drop table rs_threads
end
go
 
/*
** Create the table.
** We pad each row to be greater than a half page but less than one page
** to avoid lock contention.
*/
 
create table rs_threads
        (
        id              int,
        seq             int,
        pad1            char(255),
        pad2            char(255),
        pad3            char(255),
        pad4            char(255),
        )
go
create unique clustered index rs_threads_idx on rs_threads(id)
go
 

grant select on rs_threads to public
go

/* Drop the procedure to update the table. */
if exists (select name
		from sysobjects
		where name = 'rs_update_lastcommit' and type = 'P')
begin
	drop procedure rs_update_lastcommit
end
go
/* Create the procedure to update the table. */
create procedure rs_update_lastcommit
	@origin		int,
	@origin_qid	binary(36),
	@secondary_qid	binary(36),
	@origin_time	datetime
as
	update rs_lastcommit
		set origin_qid = @origin_qid, secondary_qid = @secondary_qid,
			origin_time = @origin_time,
			dest_commit_time = getdate()
		where origin = @origin
	if (@@rowcount = 0)
	begin
		insert rs_lastcommit (origin, origin_qid, secondary_qid,
				origin_time, dest_commit_time,
				pad1, pad2, pad3, pad4, pad5, pad6, pad7, pad8)
			values (@origin, @origin_qid, @secondary_qid,
				@origin_time, getdate(),
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00)
	end
go

/* Drop the procedure to get the last commit. */
if exists (select name
		from sysobjects
		where name = 'rs_get_lastcommit' and type = 'P')
begin
	drop procedure rs_get_lastcommit
end
go

/* Create the procedure to get the last commit for all origins. */
create procedure rs_get_lastcommit
as
	select origin, origin_qid, secondary_qid
		from rs_lastcommit
go
/* Drop the procedure to update the table. */
if exists (select name
                from sysobjects
                where name = 'rs_update_threads' and type = 'P')
begin
        drop procedure rs_update_threads
end
go
/* Create the procedure to update the table. */
create procedure rs_update_threads
        @rs_id          int,
        @rs_seq         int
as
        update rs_threads set seq = @rs_seq where id = @rs_id
go
grant execute on rs_update_threads to public
go
/* Drop the procedure to update the table. */
if exists (select name
                from sysobjects
                where name = 'rs_initialize_threads' and type = 'P')
begin
        drop procedure rs_initialize_threads
end
go
/* Create the procedure to update the table. */
create procedure rs_initialize_threads
        @rs_id          int
as
	delete from rs_threads where id = @rs_id
	insert into rs_threads values (@rs_id, 0, "", "", "", "")
go
grant execute on rs_initialize_threads to public

go
/* Drop the procedure to mark the log. */
if exists (select name
		from sysobjects
		where name = 'rs_marker' and type = 'P')
begin
	drop procedure rs_marker
end
go

/* Create the procedure which marks the log when a subscription is created. */

create procedure rs_marker 
	@rs_api varchar(255)
as
	/* Setup the bit that reflects a SQL Server replicated object. */
	declare	@rep_constant	smallint
	select @rep_constant = -32768

	/* First make sure that this procedure is marked as replicated! */
	if not exists (select sysstat
			from sysobjects
			where name = 'rs_marker'
				and type = 'P'
				and sysstat & @rep_constant != 0)
	begin
		print "Have your DBO execute 'sp_setreplicate' on the procedure 'rs_marker'"
		return(1)
	end

	/*
	** There is nothing else to do in this procedure. It's execution
	** should have been logged into the transaction log and picked up
	** by the SQL Server LTM.
	*/
go



/* Drop the procedure to check replicate status */
if exists (select name
		from sysobjects
		where name = 'rs_check_repl_stat' and type = 'P')
begin
	drop procedure rs_check_repl_stat
end
go

/* Create the procedure which checks replicate status */
create procedure rs_check_repl_stat 
	@rs_repl_name varchar(255)
as
	declare @current_status smallint
	select @current_status = sysstat
		from sysobjects
		where id=object_id(@rs_repl_name)
	if (@current_status & -32768) = -32768
		select 1
	else
		select 0

go

if exists (select name from sysobjects
                where name = 'rs_ticket' and type = 'P')
begin
        drop proc rs_ticket
end
go

/*
** Name: rs_ticket
**   Form rs_ticket parameter in canonical format and call
**        rs_marker "rs_ticket 'rs_ticket_param'"
**
** Parameter
**   head1: the first header. Default is "ticket"
**   head2: the second header. Default is null.
**   head3: the third header. Default is null.
**   head4: the last header. Default is null.
**
** rs_ticket parameter Canonical Form
**   rs_ticket_param ::= <section> | <rs_ticket_param>;<section>
**   section         ::= <tagxxx>=<value>
**   tag             ::= V | H | PDB | EXEC | B | DIST | DSI | RDB | ...
**   Version value   ::= integer
**   Header value    ::= string of varchar(10)
**   DB value        ::= database name
**   Byte value      ::= integer
**   Time value      ::= hh:mm:ss.ddd
**
** Note:
**   1. Don't mark rs_ticket for replication.
**   2. Headers must be 10 character or less.
**   3. For more than 4 headers, passing something like
**        "four;H5=five;H6=six..."
**   4. Don't pass too many headers. rs_ticket_param must be less 255.
**   5. Don't put any single or double quotation mark in header.
**   6. Keep header simple to avoid confusing Repserver parser.
*/
create procedure rs_ticket
@head1 varchar(10) = "ticket",
@head2 varchar(10) = null,
@head3 varchar(10) = null,
@head4 varchar(50) = null
as
begin
set nocount on

declare @cmd	varchar(255),
	@c_time	datetime

select @cmd = "V=1;H1=" + @head1
if @head2 != null select @cmd = @cmd + ";H2=" + @head2
if @head3 != null select @cmd = @cmd + ";H3=" + @head3
if @head4 != null select @cmd = @cmd + ";H4=" + @head4

-- @cmd = "rs_ticket 'V=1;H1=ticket;PDB(name)=hh:mm:ss.ddd'"
select @c_time = getdate()
select @cmd = "rs_ticket '" + @cmd + ";PDB(" + db_name() + ")="
	    + convert(varchar(8),@c_time,8) + "." + right("00"
	    + convert(varchar(3),datepart(ms,@c_time)),3) + "'"

-- print "exec rs_marker %1!", @cmd
exec rs_marker @cmd
end
go


grant execute on rs_ticket to public
go

if exists (select name from sysobjects
                where name = 'rs_ticket_report' and type = 'P')
begin
        drop proc rs_ticket_report
end
go

/*
** Name: rs_ticket_report
**   Append PDB timestamp to rs_ticket_param.
**   DSI calls rs_ticket_report if DSI_RS_TICKET_REPORT in on.
**
** Parameter
**   rs_ticket_param: rs_ticket parameter in canonical form.
**
** rs_ticket_param Canonical Form
**   rs_ticket_param ::= <section> | <rs_ticket_param>;<section>
**   section         ::= <tagxxx>=<value>
**   tag             ::= V | H | PDB | EXEC | B | DIST | DSI | RDB | ...
**   Version value   ::= integer
**   Header value    ::= string of varchar(10)
**   DB value        ::= database name
**   Byte value      ::= integer
**   Time value      ::= hh:mm:ss.ddd
**
** Note:
**   1. Don't mark rs_ticket_report for replication.
**   2. DSI calls rs_ticket_report iff DSI_RS_TICKET_REPORT in on.
**   3. This is an example stored procedure that demonstrates how to
**      add RDB timestamp to rs_ticket_param.
**   4. One should customize this function for parsing and inserting
**      timestamp to tables.
*/
create procedure rs_ticket_report
@rs_ticket_param varchar(255)
as
begin
set nocount on

declare @n_param varchar(255),
	@c_time	 datetime

-- @n_param = "@rs_ticket_param;RDB(name)=hh:mm:ss.ddd"
select @c_time = getdate()
select @n_param = @rs_ticket_param + ";RDB(" + db_name() + ")="
		+ convert(varchar(8), @c_time, 8) + "." + right("00"
		+ convert(varchar(3),datepart(ms,@c_time)) ,3)

-- print @n_param
end
go

grant execute on rs_ticket_report to public
go

/*
** Set the replicate status on the rs_marker procedure.
*/

dbcc settrunc("ltm","valid")
go

sp_setreplicate rs_marker, true
go
