/*
** Confidential property of Sybase, Inc.
** (c) Copyright Sybase, Inc. 1985 to 1991.
** All rights reserved
*/

/*
** generic/script/%M%:		%I%	%G%	%U%
**
** This prepares a SQL Server to receive replicated data.
*/

/* Drop the table, if it exists. */
if exists (select name
		from sysobjects
		where name = 'rs_lastcommit' and type = 'U')
begin
	drop table rs_lastcommit
end
go

/* 
** Create the table.
** We pad each row to be greater than a half page but less than one page
** to avoid lock contention.
*/

create table rs_lastcommit
	(
	origin		int,
	origin_qid	binary(36),
	secondary_qid	binary(36),
	origin_time	datetime,
	dest_commit_time	datetime,
	pad1		binary(255),
	pad2		binary(255),
	pad3		binary(255),
	pad4		binary(255),
	pad5		binary(4),
	pad6		binary(4),
	pad7		binary(4),
	pad8		binary(4)
	)
go
create unique clustered index rs_lastcommit_idx on rs_lastcommit(origin)
go

if exists (select name
                from sysobjects
                where name = 'rs_threads' and type = 'U')
begin
        drop table rs_threads
end
go
 
/*
** Create the table.
** We pad each row to be greater than a half page but less than one page
** to avoid lock contention.
*/
 
create table rs_threads
        (
        id          	int,
        seq      	int,
        pad1            char(255),
        pad2            char(255),
        pad3            char(255),
        pad4            char(255),
        )
go
create unique clustered index rs_threads_idx on rs_threads(id)
go

grant select on rs_threads to public
go

/* Drop the procedure to update the table. */
if exists (select name
		from sysobjects
		where name = 'rs_update_lastcommit' and type = 'P')
begin
	drop procedure rs_update_lastcommit
end
go
/* Create the procedure to update the table. */
create procedure rs_update_lastcommit
	@origin		int,
	@origin_qid	binary(36),
	@secondary_qid	binary(36),
	@origin_time	datetime
as
	update rs_lastcommit
		set origin_qid = @origin_qid, secondary_qid = @secondary_qid,
			origin_time = @origin_time,
			dest_commit_time = getdate()
		where origin = @origin
	if (@@rowcount = 0)
	begin
		insert rs_lastcommit (origin, origin_qid, secondary_qid,
				origin_time, dest_commit_time,
				pad1, pad2, pad3, pad4, pad5, pad6, pad7, pad8)
			values (@origin, @origin_qid, @secondary_qid,
				@origin_time, getdate(),
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00)
	end
go

/* Drop the procedure to get the last commit. */
if exists (select name
		from sysobjects
		where name = 'rs_get_lastcommit' and type = 'P')
begin
	drop procedure rs_get_lastcommit
end
go

/* Create the procedure to get the last commit for all origins. */
create procedure rs_get_lastcommit
as
	select origin, origin_qid, secondary_qid
		from rs_lastcommit
go

/* Drop the procedure to update the table. */
if exists (select name
                from sysobjects
                where name = 'rs_update_threads' and type = 'P')
begin
        drop procedure rs_update_threads
end
go
/* Create the procedure to update the table. */
create procedure rs_update_threads
        @rs_id         	int,
	@rs_seq		int
as
	update rs_threads set seq = @rs_seq where id = @rs_id
	if (@@rowcount = 0)
	begin
		insert into rs_threads 
			(id, seq, pad1, pad2, pad3, pad4)
			values(@rs_id, @rs_seq, "", "", "", "")
	end
go

grant all on rs_update_threads to public
go
/* Drop the procedure to update the table. */
if exists (select name
                from sysobjects
                where name = 'rs_get_thread_seq' and type = 'P')
begin
        drop procedure rs_get_thread_seq
end
go
/* Create the procedure to update the table. */
create procedure rs_get_thread_seq
        @rs_id             int
as
	select seq from rs_threads where id = @rs_id 
go

grant all on rs_get_thread_seq to public
go

/* Drop the procedure to update the table. */
if exists (select name
                from sysobjects
                where name = 'rs_initialize_threads' and type = 'P')
begin
        drop procedure rs_initialize_threads
end
go
/* Create the procedure to update the table. */
create procedure rs_initialize_threads
        @rs_id          int
as
	delete from rs_threads where id = @rs_id
	insert into rs_threads values (@rs_id, 0, 0x0, 0x0, 0x0, 0x0)
go
grant all on rs_initialize_threads to public

/* Drop the procedure to mark the log. */
if exists (select name
		from sysobjects
		where name = 'rs_marker' and type = 'P')
begin
	drop procedure rs_marker
end
go

