/*
** Confidential property of Sybase, Inc.
** (c) Copyright Sybase, Inc. 1985 to 1991.
** All rights reserved
*/

/*
** generic/script/%M%:		%I%	%G%	%U%
**
** This prepares a SQL Server to receive replicated data.
*/

/* Drop the table, if it exists. */
if exists (select name
		from sysobjects
		where name = 'rs_lastcommit' and type = 'U')
begin
	drop table rs_lastcommit
end
go

/* 
** Create the table.
** We pad each row to be greater than a half page but less than one page
** to avoid lock contention.
*/

create table rs_lastcommit
	(
	origin		int,
	origin_qid	binary(36),
	secondary_qid	binary(36),
	origin_time	datetime,
	dest_commit_time	datetime,
	pad1		binary(255),
	pad2		binary(255),
	pad3		binary(255),
	pad4		binary(255),
	pad5		binary(4),
	pad6		binary(4),
	pad7		binary(4),
	pad8		binary(4)
	)
go
create unique clustered index rs_lastcommit_idx on rs_lastcommit(origin)
go

if exists (select name
                from sysobjects
                where name = 'rs_threads' and type = 'U')
begin
        drop table rs_threads
end
go
 
/*
** Create the table.
** We pad each row to be greater than a half page but less than one page
** to avoid lock contention.
*/
 
create table rs_threads
        (
        id          	int,
        seq      	int,
        pad1            char(255),
        pad2            char(255),
        pad3            char(255),
        pad4            char(255),
        )
go
create unique clustered index rs_threads_idx on rs_threads(id)
go

grant select on rs_threads to public
go

/* Drop the procedure to update the table. */
if exists (select name
		from sysobjects
		where name = 'rs_update_lastcommit' and type = 'P')
begin
	drop procedure rs_update_lastcommit
end
go
/* Create the procedure to update the table. */
create procedure rs_update_lastcommit
	@origin		int,
	@origin_qid	binary(36),
	@secondary_qid	binary(36),
	@origin_time	datetime
as
	update rs_lastcommit
		set origin_qid = @origin_qid, secondary_qid = @secondary_qid,
			origin_time = @origin_time,
			dest_commit_time = getdate()
		where origin = @origin
	if (@@rowcount = 0)
	begin
		insert rs_lastcommit (origin, origin_qid, secondary_qid,
				origin_time, dest_commit_time,
				pad1, pad2, pad3, pad4, pad5, pad6, pad7, pad8)
			values (@origin, @origin_qid, @secondary_qid,
				@origin_time, getdate(),
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00)
	end
go

/* Drop the procedure to get the last commit. */
if exists (select name
		from sysobjects
		where name = 'rs_get_lastcommit' and type = 'P')
begin
	drop procedure rs_get_lastcommit
end
go

/* Create the procedure to get the last commit for all origins. */
create procedure rs_get_lastcommit
as
	select origin, origin_qid, secondary_qid
		from rs_lastcommit
go

/* Drop the procedure to update the table. */
if exists (select name
                from sysobjects
                where name = 'rs_update_threads' and type = 'P')
begin
        drop procedure rs_update_threads
end
go
/* Create the procedure to update the table. */
create procedure rs_update_threads
        @rs_id         	int,
	@rs_seq		int
as
	update rs_threads set seq = @rs_seq where id = @rs_id
	if (@@rowcount = 0)
	begin
		insert into rs_threads 
			(id, seq, pad1, pad2, pad3, pad4)
			values(@rs_id, @rs_seq, "", "", "", "")
	end
go

grant all on rs_update_threads to public
go
/* Drop the procedure to update the table. */
if exists (select name
                from sysobjects
                where name = 'rs_get_thread_seq' and type = 'P')
begin
        drop procedure rs_get_thread_seq
end
go
/* Create the procedure to update the table. */
create procedure rs_get_thread_seq
        @rs_id             int
as
	select seq from rs_threads where id = @rs_id 
go

grant all on rs_get_thread_seq to public
go

/* Drop the procedure to update the table. */
if exists (select name
                from sysobjects
                where name = 'rs_initialize_threads' and type = 'P')
begin
        drop procedure rs_initialize_threads
end
go
/* Create the procedure to update the table. */
create procedure rs_initialize_threads
        @rs_id          int
as
	delete from rs_threads where id = @rs_id
	insert into rs_threads values (@rs_id, 0, 0x0, 0x0, 0x0, 0x0)
go
grant all on rs_initialize_threads to public

/* Drop the procedure to mark the log. */
if exists (select name
		from sysobjects
		where name = 'rs_marker' and type = 'P')
begin
	drop procedure rs_marker
end
go

/* Drop the table, if it exists. */
if exists (select name
		from sysobjects
		where name = 'rs_ticket_history' and type = 'U')
begin
	drop table rs_ticket_history
end
go

create table rs_ticket_history (
	cnt		numeric(8,0) identity,
	h1		varchar(10),
	h2		varchar(10),
	h3		varchar(10),
	h4		varchar(50),
	pdb		varchar(30),
	prs		varchar(30),
	rrs		varchar(30),
	rdb		varchar(30),
	pdb_t		datetime,
	exec_t		datetime,
	dist_t		datetime,
	rsi_t		datetime,
	dsi_t		datetime,
	rdb_t		datetime	default getdate(),
	exec_b		int,
	rsi_b		int,
	dsi_tnx		int,
	dsi_cmd		int,
	ticket		varchar(1024))
go
create unique clustered index rs_ticket_idx on rs_ticket_history(cnt)
go
grant all on rs_ticket_history to public
go


if exists (select name from sysobjects
                where name = 'rs_ticket_report' and type = 'P')
begin
        drop proc rs_ticket_report
end
go

/*
** Name: rs_ticket_report
**   Append PDB timestamp to rs_ticket_param.
**   Repserver rs_ticket_report function string can be modified
**	to call this stored proceudre to process ticket.
**
** Parameter
**   rs_ticket_param: rs_ticket parameter in canonical form.
**
** rs_ticket parameter Canonical Form:
**   rs_ticket_param ::= <stamp> | <rs_ticket_param>;<stamp>
**   stamp           ::= <tag>=<value> | <tag>(info)=<value>
**   tag             ::= V | H | PDB | EXEC | B | DIST | DSI | RDB | ...
**   info            ::= Spid | PDB name
**   value           ::= integer | string | mm/dd/yy hh:mm:ss.ddd
**
** rs_ticket tag:
**   V:     Version number.
**   Hx:    Headers for identifying one or one set of tickets.
**   PDB:   Time stamp when ticket passing PDB.
**   EXEC:  Time stamps when ticket passing EXEC module.
**   DIST:  Time stamps when ticket passing DIST module.
**   RSI:   Time stamps when ticket passing RSI module.
**   DSI:   Time stamps when ticket passing DSI module.
**   RDB:   Time stamps when ticket passing RDB.
**   B:     Total bytes EXEC received from RepAgent.
**   RSI_B: Total bytes RSI sent to downstream Repserver.
**   DSI_T: Total transaction DSI sent to RDB.
**   DSI_C: Total commands DSI sent to RDB.
**   PRS:   Primary Repserver name.
**   RRS:   Replicate Repserver name.
**
** Note:
**   1. Don't mark rs_ticket_report for replication.
**   2. DSI will call rs_ticket_report iff DSI_RS_TICKET_REPORT in on.
**   3. This is an example stored procedure that demonstrates how to
**      add RDB timestamp to rs_ticket_param.
**   4. One should customize this function for parsing and inserting
**      timestamp to a table.
*/
create procedure rs_ticket_report
@rs_ticket_param varchar(255)
as
begin
set nocount on

declare @n_param varchar(255),
	@c_time	 datetime

-- @n_param = "@rs_ticket_param;RDB(name)=mm/dd/yy hh:mm:ss.ddd"
select @c_time = getdate()
select @n_param = @rs_ticket_param + ";RDB(" + db_name() + ")="
		+ convert(varchar(8),@c_time, 1) + " "
		+ convert(varchar(8), @c_time, 8) + "." + right("00"
		+ convert(varchar(3),datepart(ms,@c_time)) ,3)

-- print @new_cmd
end
go

grant execute on rs_ticket_report to public
go

