/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.jdbc;

import com.sybase.jdbc42.jdbc.ErrorMessage;
import com.sybase.jdbc42.jdbc.SybProperty;
import com.sybase.jdbc42.jdbc.SybUrlManager;
import com.sybase.jdbc42.jdbc.SybUrlProviderImplBase;
import com.sybase.jdbc42.utils.Debug;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class SybJndiProvider
extends SybUrlProviderImplBase {
    private static final String[] SERVER_ATTRIBUTES = new String[]{"1.3.6.1.4.1.897.4.2.5", "1.3.6.1.4.1.897.4.2.15", "1.3.6.1.4.1.897.4.2.9", "1.3.6.1.4.1.897.4.2.10", "1.3.6.1.4.1.897.4.2.11", "1.3.6.1.4.1.897.4.2.16", "1.3.6.1.4.1.897.4.2.17", "1.3.6.1.4.1.897.4.2.18", "sybaseAddress", "sybaseHAservername", "sybaseJconnectProtocol", "sybaseJconnectProperty", "sybaseDatabaseName", "sybaseResourceManagerName", "sybaseResourceManagerType", "sybaseJdbcDataSourceInterface"};
    private static final int ADDRESS = 0;
    private static final int HASERVER = 1;
    private static final int PROTOCOL = 2;
    private static final int PROPERTY = 3;
    private static final int DBNAME = 4;
    private static final int RMNAME = 5;
    private static final int RMTYPE = 6;
    private static final int DATASOURCE = 7;
    private static final String[][] ATTRIBUTE_TABLE = new String[][]{{"1.3.6.1.4.1.897.4.2.5", "sybaseAddress"}, {"1.3.6.1.4.1.897.4.2.15", "sybaseHAservername"}, {"1.3.6.1.4.1.897.4.2.9", "sybaseJconnectProtocol"}, {"1.3.6.1.4.1.897.4.2.10", "sybaseJconnectProperty"}, {"1.3.6.1.4.1.897.4.2.11", "sybaseDatabaseName"}, {"1.3.6.1.4.1.897.4.2.16", "sybaseResourceManagerName"}, {"1.3.6.1.4.1.897.4.2.17", "sybaseResourceManagerType"}, {"1.3.6.1.4.1.897.4.2.18", "sybaseJdbcDataSourceInterface"}};
    private static final String SYBASE_ADDRESS_PREFIX = "TCP#1#";
    private static final char SYBASE_ADDRESS_DELIMITER = ' ';
    private static final String PLACEHOLDER = "placeholder";
    private static final char HOSTPORT_DELIMITER = ':';

    public SybJndiProvider() {
        this._hostportList = new Vector();
        this._secondaryHostportList = new Vector();
    }

    public SybJndiProvider(DirContext dirContext, Name name, SybProperty sybProperty) throws SQLException, NamingException {
        this();
        this._sybProps = sybProperty;
        this.processAttrs(dirContext.getNameInNamespace(), dirContext.getAttributes(name, SERVER_ATTRIBUTES), dirContext);
    }

    @Override
    public void init(String string, String string2, Properties properties, SybProperty sybProperty) throws SQLException {
        this._sybProps = sybProperty;
        try {
            InitialDirContext initialDirContext = new InitialDirContext(properties);
            this.processAttrs(string2, initialDirContext.getAttributes(string2, SERVER_ATTRIBUTES), initialDirContext);
        }
        catch (NamingException namingException) {
            ErrorMessage.raiseError("JZ013", string2, namingException.toString(), namingException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processAttrs(String string, Attributes attributes, DirContext dirContext) throws SQLException {
        String string2 = null;
        String string3 = string;
        try {
            NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
            block24: while (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
                String string4;
                Attribute attribute = namingEnumeration.next();
                NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
                String string5 = attribute.getID();
                switch (this.mapAttribute(string5)) {
                    case 0: {
                        this.populateAddressList(this._hostportList, attribute);
                        continue block24;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        string2 = namingEnumeration2.nextElement().toString();
                        continue block24;
                    }
                    case 3: {
                        while (namingEnumeration2.hasMoreElements()) {
                            string4 = namingEnumeration2.nextElement().toString();
                            this._sybProps.parsePropertyString(string4);
                        }
                        continue block24;
                    }
                    case 4: {
                        this._dbName = namingEnumeration2.nextElement().toString();
                        continue block24;
                    }
                    case 5: {
                        string4 = namingEnumeration2.nextElement().toString();
                        try {
                            this._sybProps.setConnProperty("RMNAME", string4, true, true);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        this._rmName = this._sybProps.getString(42);
                        continue block24;
                    }
                    case 6: {
                        this._rmType = Integer.parseInt(namingEnumeration2.nextElement().toString());
                        continue block24;
                    }
                    case 7: {
                        this._dataSourceInterface = namingEnumeration2.nextElement().toString();
                        continue block24;
                    }
                    default: {
                        continue block24;
                    }
                }
                while (namingEnumeration2.hasMoreElements()) {
                    Attributes attributes2;
                    block30: {
                        string4 = namingEnumeration2.nextElement().toString();
                        attributes2 = null;
                        try {
                            string3 = string4;
                            URI uRI = null;
                            try {
                                uRI = new URI(null, string4, null);
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                // empty catch block
                            }
                            if (uRI != null) {
                                attributes2 = dirContext.getAttributes(uRI.toString(), SERVER_ATTRIBUTES);
                            }
                        }
                        catch (NamingException namingException) {
                            Object object;
                            NameParser nameParser = null;
                            try {
                                nameParser = dirContext.getNameParser(string);
                                Name name = nameParser.parse(string);
                                name.remove(name.size() - 1);
                                object = nameParser.parse(string4);
                                this.removeDups((Name)object, name);
                                name.addAll((Name)object);
                                try {
                                    string3 = name.toString();
                                    attributes2 = dirContext.getAttributes(name, SERVER_ATTRIBUTES);
                                }
                                catch (NamingException namingException2) {
                                    attributes2 = dirContext.getAttributes(name.toString(), SERVER_ATTRIBUTES);
                                }
                            }
                            catch (Exception exception) {
                                object = dirContext.getNameInNamespace();
                                if (nameParser == null) break block30;
                                Name name = nameParser.parse((String)object);
                                Name name2 = nameParser.parse(string4);
                                this.removeDups(name2, name);
                                try {
                                    string3 = name2.toString();
                                    attributes2 = dirContext.getAttributes(name2, SERVER_ATTRIBUTES);
                                }
                                catch (NamingException namingException3) {
                                    attributes2 = dirContext.getAttributes(name2.toString(), SERVER_ATTRIBUTES);
                                }
                            }
                        }
                    }
                    if (attributes2 == null) continue;
                    if (attributes2.get("1.3.6.1.4.1.897.4.2.5") != null) {
                        this.populateAddressList(this._secondaryHostportList, attributes2.get("1.3.6.1.4.1.897.4.2.5"));
                        continue;
                    }
                    this.populateAddressList(this._secondaryHostportList, attributes2.get("sybaseAddress"));
                }
            }
        }
        catch (NamingException namingException) {
            ErrorMessage.raiseError("JZ013", string3, namingException.toString(), namingException);
        }
        if (string2 == null) {
            string2 = "Tds";
        }
        this._protocol = SybUrlManager.loadProtocol(string2);
    }

    private void removeDups(Name name, Name name2) throws InvalidNameException {
        block0: for (int i = name.size() - 1; i >= 0; --i) {
            String string = name.get(i);
            for (int j = 0; j < name2.size(); ++j) {
                if (!string.equals(name2.get(j))) continue;
                Debug.println(this, "ignoring duplicate DN part: " + string);
                name.remove(i);
                continue block0;
            }
        }
    }

    private void populateAddressList(Vector<String> vector, Attribute attribute) throws NamingException {
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        while (namingEnumeration.hasMoreElements()) {
            String string = namingEnumeration.nextElement().toString();
            if (!string.startsWith(SYBASE_ADDRESS_PREFIX) || string.indexOf(32) == -1) continue;
            vector.addElement(string.substring(SYBASE_ADDRESS_PREFIX.length()).replace(' ', ':'));
        }
    }

    private int mapAttribute(String string) {
        for (int i = 0; i < ATTRIBUTE_TABLE.length; ++i) {
            if (!string.equals(ATTRIBUTE_TABLE[i][0]) && !string.equalsIgnoreCase(ATTRIBUTE_TABLE[i][1])) continue;
            return i;
        }
        return -1;
    }
}

