/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.jdbc.ErrorMessage;
import com.sybase.jdbc42.tds.DataFormat;
import com.sybase.jdbc42.tds.RowDataFormat2;
import com.sybase.jdbc42.tds.RowFormat2Token;
import com.sybase.jdbc42.tds.RowFormatToken;
import com.sybase.jdbc42.tds.Tds;
import com.sybase.jdbc42.tds.TdsInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

public class AltFormatToken
extends RowFormat2Token {
    private static final String LABEL_SUM = "Sum";
    private static final String LABEL_AVG = "Avg";
    private static final String LABEL_CNT = "Count";
    private static final String LABEL_COUNTBG = "Count_Big";
    private static final String LABEL_MIN = "Min";
    private static final String LABEL_MAX = "Max";
    protected int _totalLen;
    protected int _id;
    protected Vector<OperatorInfo> _operators;
    protected int _noByColumns;
    protected Vector<Integer> _byColumns;

    public AltFormatToken(TdsInputStream tdsInputStream) throws IOException, SQLException {
        int n;
        this._totalLen = tdsInputStream.readShort();
        this._id = tdsInputStream.readShort();
        this._numColumns = this._numUserColumns = tdsInputStream.readUnsignedByte();
        this._operators = new Vector();
        for (n = 0; n < this._numUserColumns; ++n) {
            OperatorInfo operatorInfo = new OperatorInfo(tdsInputStream);
            this._operators.addElement(operatorInfo);
        }
        this._byColumns = new Vector();
        this._noByColumns = tdsInputStream.readUnsignedByte();
        for (n = 0; n < this._noByColumns; ++n) {
            this._byColumns.addElement(new Integer(tdsInputStream.readUnsignedByte()));
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this._numUserColumns;
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        OperatorInfo operatorInfo = (OperatorInfo)this.getDataFormat(this.mapColumn(n));
        RowFormatToken rowFormatToken = this._tpc.getFormat();
        return ((Tds)rowFormatToken._tpc._protocol).getColumnTypeName(operatorInfo.getDataType(), operatorInfo.getUserType(), this.getCatalogName(n));
    }

    public int getId() {
        return this._id;
    }

    public void addFormat(DataFormat dataFormat) {
    }

    public int getLength() {
        return 0;
    }

    public int getFormatCount() {
        return this._numUserColumns;
    }

    @Override
    public DataFormat getDataFormat(int n) {
        return this._operators.elementAt(n);
    }

    private String getOperatorTypeString(int n) {
        String string;
        switch (n) {
            case 79: {
                string = LABEL_AVG;
                break;
            }
            case 75: {
                string = LABEL_CNT;
                break;
            }
            case 82: {
                string = LABEL_MAX;
                break;
            }
            case 81: {
                string = LABEL_MIN;
                break;
            }
            case 77: {
                string = LABEL_SUM;
                break;
            }
            case 97: {
                string = LABEL_COUNTBG;
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(500);
        int n2 = this.mapColumn(n);
        String string = ((OperatorInfo)this.getDataFormat(n2)).getOpType();
        String string2 = "";
        DataFormat dataFormat = this.getFieldFormat(n, true);
        string2 = dataFormat instanceof RowDataFormat2 ? ((RowDataFormat2)dataFormat).getLabelName() : dataFormat.getName();
        stringBuffer.append(string).append("(").append(string2).append(")");
        return stringBuffer.toString();
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        return "";
    }

    @Override
    protected int mapColumn(int n) throws SQLException {
        if (n > this._numUserColumns || n < 1) {
            ErrorMessage.raiseError("JZ008", "" + n);
        }
        return --n;
    }

    public DataFormat getFieldFormat(int n, boolean bl) throws SQLException {
        int n2 = bl ? this.mapColumn(n) : n;
        int n3 = ((OperatorInfo)this.getDataFormat(n2)).getOpColNo();
        RowFormatToken rowFormatToken = this._tpc.getFormat();
        DataFormat dataFormat = rowFormatToken.getDataFormat(rowFormatToken.mapColumn(n3));
        return dataFormat;
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        DataFormat dataFormat = this.getFieldFormat(n, true);
        if (dataFormat instanceof RowDataFormat2) {
            return ((RowDataFormat2)dataFormat).getCatalogName();
        }
        return "";
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        return this.getFieldFormat(n, true).getName();
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        DataFormat dataFormat = this.getFieldFormat(n, true);
        if (dataFormat instanceof RowDataFormat2) {
            return ((RowDataFormat2)dataFormat).getSchemaName();
        }
        return "";
    }

    @Override
    public String getTableName(int n) throws SQLException {
        DataFormat dataFormat = this.getFieldFormat(n, true);
        if (dataFormat instanceof RowDataFormat2) {
            return ((RowDataFormat2)dataFormat).getTableName();
        }
        return "";
    }

    @Override
    protected String getLabel(int n) throws SQLException {
        DataFormat dataFormat = this.getFieldFormat(n, true);
        if (dataFormat instanceof RowDataFormat2) {
            return ((RowDataFormat2)dataFormat).getLabelName();
        }
        return dataFormat.getName();
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        return 0;
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        return false;
    }

    private class OperatorInfo
    extends DataFormat {
        private int _opType;
        private int _opColNo;

        protected OperatorInfo(TdsInputStream tdsInputStream) throws IOException {
            this._opType = tdsInputStream.readUnsignedByte();
            this._opColNo = tdsInputStream.readUnsignedByte();
            this._usertype = tdsInputStream.readInt();
            this._datatype = tdsInputStream.readUnsignedByte();
            switch (this._datatype) {
                case 48: 
                case 50: {
                    this._length = 1;
                    break;
                }
                case 52: 
                case 65: {
                    this._length = 2;
                    break;
                }
                case 49: 
                case 51: 
                case 56: 
                case 58: 
                case 59: 
                case 66: 
                case 122: {
                    this._length = 4;
                    break;
                }
                case 60: 
                case 61: 
                case 62: 
                case 191: {
                    this._length = 8;
                    break;
                }
                case 67: {
                    this._length = 8;
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 47: 
                case 68: 
                case 103: 
                case 104: 
                case 109: 
                case 110: 
                case 111: 
                case 123: 
                case 147: {
                    this._length = tdsInputStream.readUnsignedByte();
                    break;
                }
                case 106: 
                case 108: {
                    this._length = tdsInputStream.readUnsignedByte();
                    this._precision = tdsInputStream.readUnsignedByte();
                    this._scale = tdsInputStream.readUnsignedByte();
                    break;
                }
                case 175: 
                case 225: {
                    this._length = tdsInputStream.readInt();
                    break;
                }
                case 31: 
                case 255: {
                    break;
                }
            }
            this._localeLen = tdsInputStream.readUnsignedByte();
            if (this._localeLen != 0) {
                this._locale = tdsInputStream.readString(this._localeLen);
            }
        }

        public String getOpType() {
            return AltFormatToken.this.getOperatorTypeString(this._opType);
        }

        public int getOpColNo() {
            return this._opColNo;
        }
    }
}

