/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.jdbc.Convert;
import com.sybase.jdbc42.jdbc.ErrorMessage;
import com.sybase.jdbc42.tds.CachedTdsReal;
import com.sybase.jdbc42.tds.TdsDataObject;
import com.sybase.jdbc42.tds.TdsProtocolContext;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class TdsReal
extends TdsDataObject {
    double _value;
    byte[] _valueAsBytes = null;

    public TdsReal(TdsProtocolContext tdsProtocolContext) throws IOException {
        super(tdsProtocolContext);
    }

    @Override
    public TdsDataObject createCachedCopy() throws IOException, SQLException {
        return new CachedTdsReal(this);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.doRead();
        BigDecimal bigDecimal = null;
        if (!this._isNull) {
            bigDecimal = new BigDecimal(this._value);
        }
        bigDecimal = Convert.setScale(bigDecimal, n);
        return bigDecimal;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        this.doRead();
        return 0.0 != this._value;
    }

    @Override
    public byte getByte() throws SQLException {
        this.doRead();
        Convert.checkByteOflo(new Double(this._value).longValue());
        return (byte)this._value;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        this.doReadAsBytes();
        return this._valueAsBytes;
    }

    @Override
    public double getDouble() throws SQLException {
        this.doRead();
        return this._value;
    }

    @Override
    public float getFloat() throws SQLException {
        this.doRead();
        return (float)this._value;
    }

    @Override
    public int getInt() throws SQLException {
        this.doRead();
        Convert.checkIntOflo(new Double(this._value).longValue());
        return (int)this._value;
    }

    @Override
    public long getLong() throws SQLException {
        this.doRead();
        Convert.checkLongOflo(this._value);
        return (long)this._value;
    }

    @Override
    public short getShort() throws SQLException {
        this.doRead();
        Convert.checkShortOflo(new Double(this._value).longValue());
        return (short)this._value;
    }

    @Override
    public Object getObject() throws SQLException {
        this.doRead();
        Number number = null;
        if (!this._isNull) {
            switch (this._dataLength) {
                case 4: {
                    number = new Float(this._value);
                    break;
                }
                case 8: {
                    number = new Double(this._value);
                }
            }
        }
        return number;
    }

    @Override
    public String getString() throws SQLException {
        this.doRead();
        String string = null;
        if (!this._isNull) {
            string = String.valueOf(this._value);
        }
        return string;
    }

    @Override
    public void cache() throws IOException {
        this.beginRead();
    }

    @Override
    public void clear() throws IOException {
        if (this._state == 0) {
            this.getSize();
            this.skip(this._dataLength);
        }
        this.initialize();
    }

    @Override
    protected void beginRead() throws IOException {
        this.startRead();
        switch (this._state) {
            case 1: {
                if (this._isNull) {
                    this._value = 0.0;
                } else {
                    switch (this._dataFmt._datatype) {
                        case 59: {
                            this._value = this.readFloat();
                            break;
                        }
                        case 62: {
                            this._value = this.readDouble();
                            break;
                        }
                        case 109: {
                            this._value = this.readFLTN();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseIOException("JZ0TC");
                        }
                    }
                }
                this._state = 3;
                break;
            }
            case 4: {
                if (this._isNull) {
                    this._value = 0.0;
                } else {
                    try {
                        switch (this._dataFmt._datatype) {
                            case 59: {
                                this._value = Float.intBitsToFloat((int)Convert.bufToLong(this._valueAsBytes));
                                break;
                            }
                            case 62: {
                                this._value = Double.longBitsToDouble(Convert.bufToLong(this._valueAsBytes));
                                break;
                            }
                            case 109: {
                                if (this._valueAsBytes.length == 0) {
                                    this._value = 0.0;
                                    break;
                                }
                                this._value = Convert.bufToDouble(this._valueAsBytes);
                                break;
                            }
                            default: {
                                ErrorMessage.raiseIOException("JZ0TC");
                                break;
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        ErrorMessage.raiseIOException("JZ0TC", sQLException.getMessage(), sQLException.getCause());
                    }
                }
                this._state = 3;
                break;
            }
        }
    }

    @Override
    protected void beginReadAsBytes() throws IOException {
        this.startRead();
        switch (this._state) {
            case 1: {
                if (this._isNull) {
                    this._value = 0.0;
                } else {
                    switch (this._dataFmt._datatype) {
                        case 59: {
                            this._valueAsBytes = this.readBytesForAllTypes(4);
                            break;
                        }
                        case 62: {
                            this._valueAsBytes = this.readBytesForAllTypes(8);
                            break;
                        }
                        case 109: {
                            this._valueAsBytes = this.readFLTNAsBytes();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseIOException("JZ0TC");
                        }
                    }
                }
                this._state = 4;
            }
        }
    }

    @Override
    public NClob getInitializedNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLWarning getWarning() throws SQLException {
        return super.getWarning();
    }

    @Override
    public void clearWarning() throws SQLException {
        super.clearWarning();
    }
}

