/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.ReplyPacket;
import com.sap.db.jdbc.packet.RequestPacket;
import com.sap.db.rte.comm.JdbcCommunication;
import java.sql.SQLException;
import java.util.Iterator;

class InternalStatementSapDB
extends StatementSapDB {
    InternalStatementSapDB(ConnectionSapDB connection) throws SQLException {
        super(connection, 1003, 1007, 1);
    }

    int executeUpdateOnAllSessions(String sql, boolean handleTransaction, boolean isWriteOperation) throws SQLException {
        JdbcCommunication primarySession;
        this.m_Session = primarySession = this.connection.m_sessionPool.getPrimarySession();
        if (handleTransaction) {
            this.connection.m_transaction.handleTransaction(this.connection, this.m_Session, isWriteOperation);
        }
        boolean isQuery = this.execute(sql, false, 1003, 1007, this.m_Session);
        Iterator iter = this.connection.getSessionPool().getSessions();
        while (iter.hasNext()) {
            this.m_Session = (JdbcCommunication)iter.next();
            if (!this.m_Session.isConnected() || this.m_Session == primarySession) continue;
            if (handleTransaction) {
                this.connection.m_transaction.handleTransaction(this.connection, this.m_Session, isWriteOperation);
            }
            isQuery = this.execute(sql, false, 1003, 1007, this.m_Session);
        }
        if (isQuery) {
            throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.resultset");
        }
        if (this.hasRowCount) {
            return this.rowsAffected;
        }
        return 0;
    }

    ReplyPacket sendCommand(RequestPacket requestPacket, String sqlCmd, int gcFlags, boolean parseAgain, JdbcCommunication session) throws SQLException {
        requestPacket.initDbsCommandThrowSQLExc(this.connection.m_transaction.m_autocommit, sqlCmd, this.resultSetType, this.resultSetHoldability, this.connection.getStatementContext());
        ReplyPacket replyPacket = this.connection.execute(requestPacket, this, gcFlags, session, false);
        return replyPacket;
    }

    public boolean execute(String sql, JdbcCommunication session, boolean handleTransaction, boolean isWriteTrans) throws SQLException {
        boolean isQuery = false;
        if (handleTransaction) {
            this.connection.m_transaction.handleTransaction(this.connection, session, isWriteTrans);
        }
        return this.execute(sql, isQuery, this.resultSetType, this.resultSetConcurrency, session);
    }
}

