/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.translators.DBTechTranslator;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ResultSetMetaDataSapDB
extends WrapperDummy
implements ResultSetMetaData {
    private DBTechTranslator[] colInfo;
    private String tablename = "";

    ResultSetMetaDataSapDB(DBTechTranslator[] infos, String tabname) {
        this.colInfo = infos;
        this.tablename = tabname;
    }

    public DBTechTranslator findColInfo(int columnIndex) throws SQLException {
        DBTechTranslator info;
        try {
            info = this.colInfo[columnIndex - 1];
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            throw SQLExceptionSapDB.generateSQLException("error.invalidcolumnindex", Integer.toString(columnIndex));
        }
        return info;
    }

    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    public String getColumnClassName(int column) throws SQLException {
        return this.findColInfo(column).getColumnClassName();
    }

    public int getColumnCount() throws SQLException {
        return this.colInfo.length;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        return this.findColInfo(column).getColumnDisplaySize();
    }

    public String getColumnLabel(int column) throws SQLException {
        return this.findColInfo(column).getColumnLabel();
    }

    public String getColumnName(int column) throws SQLException {
        return this.findColInfo(column).getColumnName();
    }

    public int getColumnType(int column) throws SQLException {
        return this.findColInfo(column).getColumnType();
    }

    public String getColumnTypeName(int column) throws SQLException {
        return this.findColInfo(column).getColumnTypeName();
    }

    public int getPrecision(int column) throws SQLException {
        return this.findColInfo(column).getPrecision();
    }

    public int getScale(int column) throws SQLException {
        return this.findColInfo(column).getScale();
    }

    public String getSchemaName(int column) throws SQLException {
        return this.findColInfo(column).getSchemaName();
    }

    public String getTableName(int column) throws SQLException {
        String erg = this.findColInfo(column).getTableName();
        return erg.equals("") ? this.tablename : erg;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        return this.findColInfo(column).isAutoIncrement();
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        return this.findColInfo(column).isCaseSensitive();
    }

    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    public int isNullable(int column) throws SQLException {
        return this.findColInfo(column).isNullable();
    }

    public boolean isReadOnly(int column) throws SQLException {
        return this.findColInfo(column).isReadOnly();
    }

    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    public boolean isSigned(int column) throws SQLException {
        return this.findColInfo(column).isSigned();
    }

    public boolean isWritable(int column) throws SQLException {
        return this.findColInfo(column).isWritable();
    }
}

