/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.packet.ReplyPacket;
import com.sap.db.jdbc.packet.RequestPacket;
import com.sap.db.rte.comm.JdbcCommunication;
import com.sap.db.util.Tracer;
import java.sql.SQLException;
import java.util.Iterator;

public class Transaction {
    public static final int transactionStateNone = 0;
    public static final int transactionStateReadTransaction = 1;
    public static final int transactionStateWriteTransaction = 2;
    public static final int transactionStateDistributedTransaction = 3;
    static final String[] transactionStateString = new String[]{"None", "ReadTransaction", "WriteTransaction", "DistributedTransaction"};
    boolean debug = false;
    private int m_transactionState;
    private SessionPool m_sessionPool;
    boolean m_autocommit;
    int m_numberOfSessionsInvolved;
    private byte[] m_transactionID;
    private Tracer m_tracer;

    public void setAutocommit(boolean autocommit) {
        this.m_autocommit = autocommit;
    }

    public Transaction(SessionPool sessionPool, Tracer tracer) {
        this.m_sessionPool = sessionPool;
        this.m_tracer = tracer;
        this.m_numberOfSessionsInvolved = 0;
        this.m_transactionID = null;
        this.m_autocommit = true;
        this.m_transactionState = 0;
    }

    public void clear(ConnectionSapDB conn) {
        this.m_transactionState = 0;
        Iterator iter = this.m_sessionPool.getSessions();
        while (iter.hasNext()) {
            JdbcCommunication session = (JdbcCommunication)iter.next();
            session.leaveTransaction();
        }
        if (this.m_tracer.isDistributionTraceOn() && this.m_transactionState >= 0) {
            this.m_tracer.println("DISTRIBUTION: Close  Tx [" + (this.m_transactionID != null ? Tracer.Hex2String(this.m_transactionID) : "null") + "]");
            this.m_tracer.dumpConnectionState(this.m_sessionPool, conn, null);
        }
        this.m_numberOfSessionsInvolved = 0;
        this.m_transactionID = null;
    }

    public boolean isXATransaction() {
        return this.m_transactionState >= 3;
    }

    public boolean isWriteTransaction() {
        return this.m_transactionState >= 2;
    }

    public boolean isReadTransactionOrNothing() {
        return this.m_transactionState <= 1;
    }

    public boolean isInTransaction() {
        return this.m_transactionState >= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDistributedTransaction(ConnectionSapDB conn) throws SQLException {
        ConnectionSapDB connectionSapDB = conn;
        synchronized (connectionSapDB) {
            if (!this.isXATransaction()) {
                JdbcCommunication session = this.m_sessionPool.getSessionForTransactionHandling();
                RequestPacket req = conn.getRequestPacket(session);
                req.initStartDistributedTransaction(conn.getStatementContext());
                ReplyPacket repl = conn.execute(req, false, true, this, 1, session, true);
                this.m_transactionID = repl.getTransactionID();
                this.m_transactionState = 3;
                session.joinDistributedTransaction();
                if (this.m_tracer.isDistributionTraceOn()) {
                    this.m_tracer.println("DISTRIBUTION: Start Distributed Tx [" + (this.m_transactionID != null ? Tracer.Hex2String(this.m_transactionID) : "null") + "] on session " + session.getLocation().getAsShortString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinDistributedTransaction(JdbcCommunication session, ConnectionSapDB conn) throws SQLException {
        ConnectionSapDB connectionSapDB = conn;
        synchronized (connectionSapDB) {
            if (!session.isPartOfDistributedTransaction()) {
                RequestPacket req = conn.getRequestPacket(session);
                req.initJoinDistributedTransaction(this.m_transactionID, conn.getStatementContext());
                conn.execute(req, false, true, this, 1, session, true);
                session.joinDistributedTransaction();
                if (this.m_tracer.isDistributionTraceOn()) {
                    this.m_tracer.println("DISTRIBUTION: Join Distributed Tx [" + (this.m_transactionID != null ? Tracer.Hex2String(this.m_transactionID) : "null") + "] on session " + session.getLocation().getAsShortString());
                }
            }
        }
    }

    public static boolean isWriteOperation(int functionCode) {
        switch (functionCode) {
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public boolean setTransactionState(int functionCode, JdbcCommunication session, boolean isDDLCommitted, ConnectionSapDB conn) {
        int newState;
        boolean implicitCommit = false;
        switch (functionCode) {
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                newState = 2;
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 18: {
                newState = 0;
                break;
            }
            case 22: 
            case 23: {
                return false;
            }
            case 1: {
                if (isDDLCommitted) {
                    newState = 0;
                    this.clear(conn);
                    implicitCommit = true;
                    break;
                }
                newState = 2;
                break;
            }
            default: {
                newState = 1;
            }
        }
        this.setTransactionState(newState, session);
        return implicitCommit;
    }

    public void setTransactionState(int newState, JdbcCommunication session) {
        if (this.m_transactionState < 1 && (newState == 1 || newState == 2)) {
            this.m_sessionPool.setPrimarySession(session);
        }
        this.m_transactionState = newState;
        if (this.m_tracer.isDistributionTraceOn()) {
            this.m_tracer.println("DISTRIBUTION: Change Tx [" + (this.m_transactionID != null ? Tracer.Hex2String(this.m_transactionID) : "null") + "] state to " + transactionStateString[this.m_transactionState] + " on session " + session.getLocation().getAsShortString());
        }
    }

    public int getTransactionState() {
        return this.m_transactionState;
    }

    public boolean isDistributedTransaction() {
        return this.m_numberOfSessionsInvolved > 1;
    }

    private synchronized void addSessionToTransaction(JdbcCommunication session) {
        if (!session.isPartOfTransaction()) {
            session.joinTransaction();
            ++this.m_numberOfSessionsInvolved;
        }
    }

    public synchronized void handleTransaction(ConnectionSapDB conn, JdbcCommunication session, boolean isWriteOperation) throws SQLException {
        this.addSessionToTransaction(session);
        if (this.m_transactionState == 0) {
            this.m_sessionPool.setPrimarySession(session);
        }
        if (this.isXATransaction()) {
            if (!session.isPartOfDistributedTransaction()) {
                this.joinDistributedTransaction(session, conn);
            }
        } else if (this.m_numberOfSessionsInvolved > 1) {
            switch (this.m_transactionState) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    this.startDistributedTransaction(conn);
                    this.joinDistributedTransaction(session, conn);
                }
            }
        }
    }
}

