/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.jdbc.packet.RequestPacket;
import com.sap.db.util.MemIndirection;
import com.sap.db.util.StructuredMem;
import java.sql.SQLException;

public class OptionsPart
extends MemIndirection {
    protected StructuredMem originalMem;
    protected RequestPacket requestPacket;
    protected int argCount = 0;
    protected int extent = 0;
    int m_currentOffset = 0;
    int m_currentArg = 0;

    OptionsPart(StructuredMem rawMem, RequestPacket requestPacket) {
        super(rawMem);
        this.originalMem = rawMem.getPointer(0);
        this.requestPacket = requestPacket;
    }

    public OptionsPart(StructuredMem rawMem, int argCnt) {
        super(rawMem);
        this.originalMem = rawMem.getPointer(0);
        this.requestPacket = null;
        this.argCount = argCnt;
    }

    public void close() {
        int argCountOffs = -14;
        this.originalMem.putInt2(this.argCount, argCountOffs);
        this.requestPacket.closePart(this.extent, this.argCount);
    }

    public void addBoolOption(int option, boolean optionValue) {
        this.originalMem.putInt1(option, this.extent);
        this.originalMem.putInt1(28, this.extent + 1);
        this.originalMem.putInt1(optionValue ? 1 : 0, this.extent + 2);
        ++this.argCount;
        this.extent += 3;
    }

    public void addIntOption(int option, int optionValue) {
        this.originalMem.putInt1(option, this.extent);
        this.originalMem.putInt1(3, this.extent + 1);
        this.originalMem.putInt4(optionValue, this.extent + 2);
        ++this.argCount;
        this.extent += 6;
    }

    public void addLongOption(int option, long optionValue) {
        this.originalMem.putInt1(option, this.extent);
        this.originalMem.putInt1(4, this.extent + 1);
        this.originalMem.putInt8(optionValue, this.extent + 2);
        ++this.argCount;
        this.extent += 10;
    }

    public void addStringOption(int option, String optionValue) throws SQLException {
        this.originalMem.putInt1(option, this.extent);
        this.originalMem.putInt1(29, this.extent + 1);
        this.originalMem.putInt2(optionValue.length(), this.extent + 2);
        this.extent += 4;
        this.extent += this.originalMem.putString(optionValue, this.extent);
        ++this.argCount;
    }

    public void addBinaryOption(int option, byte[] optionValue) throws SQLException {
        this.originalMem.putInt1(option, this.extent);
        this.originalMem.putInt1(33, this.extent + 1);
        this.originalMem.putInt2(optionValue.length, this.extent + 2);
        this.extent += 4;
        this.extent += this.originalMem.putBytes(optionValue, this.extent);
        ++this.argCount;
    }

    public boolean findOption(int option) {
        boolean rc;
        this.m_currentOffset = 0;
        this.m_currentArg = 1;
        do {
            if (this.getOptionName() != option) continue;
            return true;
        } while (rc = this.nextOption());
        return rc;
    }

    public boolean nextOption() {
        if (this.m_currentArg >= this.argCount) {
            return false;
        }
        switch (this.getOptionType()) {
            case 28: {
                this.m_currentOffset += 3;
                break;
            }
            case 3: {
                this.m_currentOffset += 6;
                break;
            }
            case 4: {
                this.m_currentOffset += 10;
                break;
            }
            case 29: 
            case 33: {
                int len = this.originalMem.getInt2(this.m_currentOffset + 2);
                this.m_currentOffset += 4;
                this.m_currentOffset += len;
                break;
            }
            case 7: {
                this.m_currentOffset += 8;
                break;
            }
            default: {
                return false;
            }
        }
        ++this.m_currentArg;
        return this.m_currentArg < this.argCount;
    }

    public int getOptionName() {
        return this.originalMem.getInt1(this.m_currentOffset);
    }

    public int getOptionType() {
        return this.originalMem.getInt1(this.m_currentOffset + 1);
    }

    public String getOptionTypeString() {
        switch (this.getOptionType()) {
            case 28: {
                return "BOOL";
            }
            case 3: {
                return "INT";
            }
            case 4: {
                return "BIGINT";
            }
            case 29: {
                return "STRING";
            }
            case 33: {
                return "BSTRING";
            }
            case 7: {
                return "DOUBLE";
            }
        }
        return "UNKNOWN";
    }

    public int getOptionIntValue() {
        return this.originalMem.getInt4(this.m_currentOffset + 2);
    }

    public long getOptionLongValue() {
        return this.originalMem.getInt8(this.m_currentOffset + 2);
    }

    public boolean getOptionBoolValue() {
        return this.originalMem.getInt1(this.m_currentOffset + 2) > 0;
    }

    public double getOptionDoubleValue() {
        byte[] buffer = this.mem.getBytes(this.m_currentOffset + 2, 8);
        double value = Double.longBitsToDouble((long)buffer[0] & 0xFFL | (long)buffer[1] << 8 & 0xFF00L | (long)buffer[2] << 16 & 0xFF0000L | (long)buffer[3] << 24 & 0xFF000000L | (long)buffer[4] << 32 & 0xFF00000000L | (long)buffer[5] << 40 & 0xFF0000000000L | (long)buffer[6] << 48 & 0xFF000000000000L | (long)buffer[7] << 56 & 0xFF00000000000000L);
        return value;
    }

    public String getOptionStringValue() {
        int len = this.originalMem.getInt2(this.m_currentOffset + 2);
        return this.originalMem.getString(this.m_currentOffset + 4, len);
    }

    public byte[] getOptionBinaryValue() {
        int len = this.originalMem.getInt2(this.m_currentOffset + 2);
        return this.originalMem.getBytes(this.m_currentOffset + 4, len);
    }

    public Object getOptionValue() {
        switch (this.getOptionType()) {
            case 28: {
                return new Boolean(this.getOptionBoolValue());
            }
            case 3: {
                return new Integer(this.getOptionIntValue());
            }
            case 29: {
                return this.getOptionStringValue();
            }
            case 7: {
                return new Double(this.getOptionDoubleValue());
            }
            case 33: {
                return this.getOptionBinaryValue();
            }
        }
        return null;
    }
}

