/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.trace;

import com.sap.db.jdbc.trace.TraceEventListener;
import com.sap.db.util.TraceConfiguration;
import com.sap.db.util.Tracer;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;

public class TraceControl {
    private TraceConfiguration traceSettings;
    public Tracer tracer;
    private boolean isTraceOn = false;
    private HashSet TraceEventListeners = new HashSet();

    public TraceControl() {
        this.tracer = new Tracer(this);
        this.traceSettings = new TraceConfiguration();
        this.tracer.setTraceFileName(this.traceSettings.getTraceFolder() + File.separator + this.traceSettings.getTraceFileName());
        this.tracer.setMaxTraceSize(this.traceSettings.getTraceSize());
        this.tracer.setStopOnError(this.traceSettings.getStopOnError());
        this.tracer.setTraceLevel(this.traceSettings.getTraceLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTraceEventListener(WeakReference listener) {
        HashSet hashSet = this.TraceEventListeners;
        synchronized (hashSet) {
            this.TraceEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTraceEventListener(WeakReference listener) {
        HashSet hashSet = this.TraceEventListeners;
        synchronized (hashSet) {
            this.TraceEventListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void switchTraceOn() {
        if (!this.isTraceOn) {
            this.traceSettings.setTraceOn(true);
            this.isTraceOn = true;
            this.tracer.open();
            HashSet hashSet = this.TraceEventListeners;
            synchronized (hashSet) {
                Iterator it = this.TraceEventListeners.iterator();
                while (it.hasNext()) {
                    TraceEventListener tel = (TraceEventListener)((WeakReference)it.next()).get();
                    if (tel != null) {
                        tel.traceOn();
                        continue;
                    }
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void switchTraceOff() {
        if (this.isTraceOn) {
            this.traceSettings.setTraceOn(false);
            this.isTraceOn = false;
            this.tracer.close();
            HashSet hashSet = this.TraceEventListeners;
            synchronized (hashSet) {
                Iterator it = this.TraceEventListeners.iterator();
                while (it.hasNext()) {
                    TraceEventListener tel = (TraceEventListener)((WeakReference)it.next()).get();
                    if (tel != null) {
                        tel.traceOff();
                        continue;
                    }
                    it.remove();
                }
            }
        }
    }

    public HashSet getTraceEventListeners() {
        return this.TraceEventListeners;
    }

    public synchronized void checkTraceSettings() {
        if (this.traceSettings.hasTraceSettingsChanged()) {
            this.traceSettings.loadTraceSettings();
            boolean forcereopen = this.tracer.setTraceFileName(this.traceSettings.getTraceFolder() + File.separator + this.traceSettings.getTraceFileName());
            forcereopen |= this.tracer.setMaxTraceSize(this.traceSettings.getTraceSize());
            this.tracer.setStopOnError(this.traceSettings.getStopOnError());
            this.tracer.setTraceLevel(this.traceSettings.getTraceLevel());
            if (this.traceSettings.isTraceOn()) {
                if (forcereopen) {
                    this.switchTraceOff();
                }
                this.switchTraceOn();
            } else {
                this.switchTraceOff();
            }
        }
    }

    public synchronized void refreshTraceSettings() {
        if (this.traceSettings.isTraceOn()) {
            this.switchTraceOn();
        } else {
            this.switchTraceOff();
        }
    }

    public boolean isTraceOn() {
        return this.isTraceOn;
    }

    public int getHandleCount() {
        return this.TraceEventListeners.size();
    }
}

