/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.ABAPStreamTranslator;
import com.sap.db.util.StructuredBytes;
import com.sap.db.util.StructuredMem;
import java.io.PrintStream;

public class ABAPStreamDescriptor {
    protected ABAPStreamTranslator translator;
    protected StructuredBytes descriptor;
    protected StructuredMem descriptorMark;
    protected int rowSize;

    public ABAPStreamDescriptor(ABAPStreamTranslator translator) {
        this.translator = translator;
        this.descriptor = new StructuredBytes(translator.physicalLength - 1);
        this.descriptorMark = null;
        this.rowSize = 0;
    }

    public void clearColumns() {
        this.descriptor.putInt2(0, 10);
        this.descriptor.putInt2(0, 8);
    }

    public void addColumn(int inout, int abaptype, int abaptypelength, int dec, int length, int offset) {
        int columnCount = this.descriptor.getInt2(10);
        if (this.descriptor.size() < 20 + (columnCount + 1) * 8) {
            this.expandDescriptor(20 + (columnCount + 1) * 8);
        }
        this.descriptor.putInt2(columnCount + 1, 10);
        this.rowSize = this.descriptor.getInt2(8);
        this.rowSize = Math.max(this.rowSize, abaptypelength + offset);
        this.descriptor.putInt2(this.rowSize, 8);
        this.descriptor.putInt1(inout, 20 + 8 * columnCount + 0);
        this.descriptor.putInt1(abaptype, 20 + 8 * columnCount + 1);
        this.descriptor.putInt2(dec, 20 + 8 * columnCount + 2);
        this.descriptor.putInt2(abaptypelength, 20 + 8 * columnCount + 4);
        this.descriptor.putInt2(offset, 20 + 8 * columnCount + 6);
    }

    private void expandDescriptor(int descriptorlength) {
        byte[] oldba = this.descriptor.bytes();
        byte[] newba = new byte[descriptorlength];
        System.arraycopy(oldba, 0, newba, 0, oldba.length);
        this.descriptor = new StructuredBytes(newba);
    }

    public void updateIndex(int index) {
        this.descriptorMark.putInt4(index, 16);
    }

    public int putDescriptor(DataPart mem, int bufpos) {
        int erg = mem.putBytes(this.descriptor.bytes(), bufpos);
        this.descriptorMark = mem.getPointer(bufpos);
        return erg;
    }

    public void traceOn(PrintStream ps) {
        ps.println("DESCRIPTOR");
        ps.println("  ROW SIZE       : " + this.descriptor.getInt2(8));
        int colcount = this.descriptor.getInt2(10);
        ps.println("  COLUMN COUNT   : " + colcount);
        ps.println("  ROW COUNT      : " + this.descriptor.getInt4(12));
        ps.println("  TAB ID         : " + this.descriptor.getInt4(16));
        for (int i = 0; i < colcount; ++i) {
            byte io = this.descriptor.getInt1(i * 8 + 20 + 0);
            byte abaptype = this.descriptor.getInt1(i * 8 + 20 + 1);
            int length = this.descriptor.getInt2(i * 8 + 20 + 4);
            int dec = this.descriptor.getInt2(i * 8 + 20 + 2);
            int offset = this.descriptor.getInt2(i * 8 + 20 + 6);
            ps.println("    COLDESC[" + (i + 1) + "]");
            ps.println("      INOUT   : " + ABAPStreamDescriptor.inout(io));
            ps.println("      TYPE    : " + ABAPStreamDescriptor.type(abaptype) + " (" + abaptype + ")");
            ps.println("      LENGTH  : " + length);
            ps.println("      PREC    : " + dec);
            ps.println("      OFFSET  : " + offset);
        }
    }

    private static String type(int t) {
        switch (t) {
            case 0: {
                return "BOOL";
            }
            case 14: {
                return "CHAR";
            }
            case 10: {
                return "DOUBLE";
            }
            case 9: {
                return "FLOAT";
            }
            case 1: {
                return "INT1";
            }
            case 3: {
                return "INT2";
            }
            case 5: {
                return "INT4";
            }
            case 7: {
                return "INT8";
            }
            case 17: {
                return "WYDE";
            }
        }
        return "Unknown type (" + t + ")";
    }

    private static String inout(int inout) {
        switch (inout) {
            case 0: {
                return "IN";
            }
            case 1: {
                return "OUT";
            }
            case 2: {
                return "IN/OUT";
            }
        }
        return "???";
    }
}

