/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.jdbc.translators.StringTranslator;
import com.sap.db.util.StringUtil;
import java.sql.SQLException;

public class AlphanumTranslator
extends StringTranslator {
    private static final int ALPHANUM_LENGTH_MASK = 127;
    private static final int ALPHANUM_PURELY_NUMERIC = 128;
    private static final String ZEROS_127 = "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";

    public AlphanumTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        String result = null;
        if (!this.isNull(controller, mem)) {
            int datalen;
            int alphalen;
            result = "";
            byte[] alphanumBytes = mem.getBytes(this.bufpos_output, this.logicalLength - 1);
            int flags = alphanumBytes[0];
            if (flags < 0) {
                flags += 256;
            }
            String value = StringUtil.getStringFromCesu8(alphanumBytes, 1, alphanumBytes.length - 1);
            if ((flags & 0x80) > 0 && (alphalen = flags & 0x7F) > (datalen = value.length())) {
                int zerolen = alphalen < datalen ? 0 : alphalen - datalen;
                result = ZEROS_127.substring(0, zerolen);
            }
            result = result + value;
        }
        return result;
    }
}

