/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.ABAPStreamTranslator;
import com.sap.db.jdbc.translators.AbstractABAPStreamPutval;
import com.sap.db.jdbc.translators.InputStreamFilter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class AsciiABAPStreamPutval
extends AbstractABAPStreamPutval {
    private InputStream stream;
    private boolean isUnicodeConnection;

    public AsciiABAPStreamPutval(ABAPStreamTranslator translator, byte[] bs, boolean isUnicodeConnection) {
        this(translator, new ByteArrayInputStream(bs), -1L, isUnicodeConnection);
    }

    public AsciiABAPStreamPutval(ABAPStreamTranslator translator, InputStream stream, long length, boolean isUnicodeConnection) {
        super(translator);
        this.isUnicodeConnection = isUnicodeConnection;
        this.stream = length >= 0L ? new InputStreamFilter(stream, length) : stream;
        this.clearColumns();
        this.addColumn(0, 14, 1, 0, 1, 0);
    }

    public void transferStream(DataPart dataPart) throws SQLException {
        boolean streamExhausted = dataPart.fillWithOMSStream(this.stream, this.isUnicodeConnection);
        if (streamExhausted) {
            try {
                this.stream.close();
            }
            catch (IOException ioex) {
                throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", ioex.getMessage());
            }
            this.stream = null;
        }
    }

    public boolean atEnd() {
        return this.stream == null;
    }
}

