/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.DBTechTranslator;
import com.sap.db.jdbc.translators.DateTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public class DayDateTranslator
extends DateTranslator {
    public DayDateTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public DayDateTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out) {
        this(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, false, false);
    }

    public Date getDate(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        int day;
        int month;
        int year;
        if (this.isNull(controller, mem)) {
            return null;
        }
        int dtday = mem.getInt4(this.bufpos_output);
        if (dtday == 0) {
            year = 0;
            month = 0;
            day = 0;
        } else {
            int ja;
            int julian;
            if ((julian = --dtday + 1721424) >= 2299161) {
                int jalpha = (int)(((double)(julian - 1867216) - 0.25) / 36524.25);
                ja = julian + 1 + jalpha - (int)(0.25 * (double)jalpha);
            } else {
                ja = julian;
            }
            int jb = ja + 1524;
            int jc = (int)(6680.0 + ((double)(jb - 2439870) - 122.1) / 365.25);
            int jd = (int)((double)(365 * jc) + 0.25 * (double)jc);
            int je = (int)((double)(jb - jd) / 30.6001);
            day = jb - jd - (int)(30.6001 * (double)je);
            month = je - 1;
            if (month > 12) {
                month -= 12;
            }
            year = jc - 4715;
            if (month > 2) {
                --year;
            }
            if (year <= 0) {
                --year;
            }
        }
        if (cal == null) {
            return new Date(year - 1900, month - 1, day);
        }
        cal.clear();
        cal.set(year, month - 1, day, 0, 0, 0);
        return DBTechTranslator.CalendarUtil.getDateFromCalendar(cal);
    }

    public Object transDateForInput(Date val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        cal.setTime(val);
        TimeZone tz = cal.getTimeZone();
        long timeInMillis = cal.getTimeInMillis();
        int offset = tz.getOffset(timeInMillis);
        long ts = (timeInMillis + 62135769600000L + (long)offset) / 86400000L + 1L;
        byte[] value = new byte[5];
        value[0] = 63;
        dataFormat.putInt4(value, (int)ts, 1);
        return value;
    }

    public Timestamp getTimestamp(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Date dateValue = this.getDate(controller, mem, cal);
        if (dateValue == null) {
            return null;
        }
        return new Timestamp(dateValue.getTime());
    }

    public int getPrecision() {
        return 10;
    }

    public int getColumnDisplaySize() {
        return 10;
    }
}

