/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.InputStreamFilter;
import com.sap.db.util.JoinStream;
import com.sap.db.util.StructuredMem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class Putval {
    public static final int STATE_EXECUTE = 1;
    public static final int STATE_WRITELOB = 2;
    private byte[] m_LOBLocatorID = null;
    protected int m_state = 1;
    private byte[] sourceBytes;
    protected StructuredMem descriptorMark;
    private InputStream stream;
    protected StructuredMem requestedData = null;
    protected int requestedLen;
    private int bufpos;
    private boolean needsUpdate;
    protected int m_dataType = 1;

    Putval(byte[] stream, int bufpos, StructuredMem adescriptorMark, int dataType) {
        this(stream, bufpos, dataType);
        this.descriptorMark = adescriptorMark;
    }

    Putval(InputStream stream, long length, int bufpos, int dataType) {
        this.stream = length >= 0L ? new InputStreamFilter(stream, length) : stream;
        this.bufpos = bufpos;
        this.m_dataType = dataType;
    }

    Putval(byte[] bytes, int bufpos, int dataType) {
        this.stream = new ByteArrayInputStream(bytes);
        this.sourceBytes = bytes;
        this.bufpos = bufpos;
        this.m_dataType = dataType;
    }

    public Object cloneForBatch() {
        if (this.sourceBytes == null) {
            return this;
        }
        return new Putval(this.sourceBytes, this.bufpos, this.descriptorMark, this.m_dataType);
    }

    protected Putval(int bufpos, int dataType) {
        this.bufpos = bufpos;
        this.stream = null;
        this.m_dataType = dataType;
    }

    public boolean atEnd() {
        return this.stream == null;
    }

    private byte[] newDescriptor() {
        byte[] result;
        if (this.m_state == 1 || this.m_LOBLocatorID == null) {
            result = new byte[10];
            switch (this.m_dataType) {
                case 1: {
                    result[0] = 27;
                    break;
                }
                case 2: {
                    result[0] = 25;
                    break;
                }
                case 3: {
                    result[0] = 26;
                }
            }
        } else {
            result = new byte[21];
            System.arraycopy(this.m_LOBLocatorID, 0, result, 0, 8);
        }
        return result;
    }

    public int putDescriptor(DataPart mem, int pos) {
        byte[] descriptor = this.newDescriptor();
        this.descriptorMark = mem.putDescriptor(pos, descriptor);
        return this.descriptorMark == null ? -1 : descriptor.length;
    }

    public void markErrorStream() {
        this.descriptorMark.putInt1(8, 27);
        this.descriptorMark.putInt4(0, 32);
        this.descriptorMark.putInt4(0, 36);
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.stream = null;
    }

    protected void transferStream(DataPart dataPart) throws SQLException {
        if (this.atEnd()) {
            dataPart.markEmptyStream(this.descriptorMark);
        } else {
            boolean streamExhausted = dataPart.fillWithStream(this.stream, this.descriptorMark, this, this.m_state == 1);
            if (streamExhausted) {
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.stream = null;
            }
        }
    }

    public void transferStream(DataPart dataPart, int streamIndex) throws SQLException {
        this.transferStream(dataPart);
    }

    public String toString() {
        return "<Putval " + this.stream + ">";
    }

    public void markAsLast(DataPart dataPart) {
    }

    public void markRequestedChunk(StructuredMem requestedData, int requestedLen) {
        this.requestedData = requestedData;
        this.requestedLen = requestedLen;
    }

    public void reset() {
        if (this.requestedData != null) {
            byte[] data = this.requestedData.getBytes(0, this.requestedLen);
            ByteArrayInputStream firstChunk = new ByteArrayInputStream(data);
            this.stream = this.stream == null ? firstChunk : new JoinStream(new InputStream[]{firstChunk, this.stream});
            this.requestedData = null;
        }
    }

    public final int getBufpos() {
        return this.bufpos;
    }

    public void setNeedsDescriptorUpdate() {
        this.needsUpdate = true;
    }

    public boolean isDescriptorUpdated() {
        return !this.needsUpdate;
    }

    public void setLOBLocatorID(byte[] locatorID) {
        this.m_LOBLocatorID = locatorID;
        this.needsUpdate = false;
    }

    public void setState(int state) {
        this.m_state = state;
    }
}

