/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext;

import com.sap.db.jdbcext.StatementEventListenerHelper;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class ConnectionListenerBag {
    protected Set connectionlisteners = new HashSet();
    protected Set stmtlisteners = new HashSet();

    ConnectionListenerBag() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendCloseEvent(PooledConnection pc) {
        ConnectionEvent connectionEvent = new ConnectionEvent(pc);
        Set set = this.connectionlisteners;
        synchronized (set) {
            Iterator iterator = this.connectionlisteners.iterator();
            while (iterator.hasNext()) {
                ConnectionEventListener cl = (ConnectionEventListener)iterator.next();
                cl.connectionClosed(connectionEvent);
            }
        }
    }

    public synchronized void sendCloseEvent(PooledConnection pc, PreparedStatement ps) {
        StatementEventListenerHelper.sendCloseEvent(this.stmtlisteners, pc, ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendErrorEvent(PooledConnection pc, SQLException sqlEx) {
        ConnectionEvent event = new ConnectionEvent(pc, sqlEx);
        Set set = this.connectionlisteners;
        synchronized (set) {
            int list_sz = this.connectionlisteners.size();
            Iterator iterator = this.connectionlisteners.iterator();
            while (iterator.hasNext()) {
                ConnectionEventListener cl = (ConnectionEventListener)iterator.next();
                cl.connectionErrorOccurred(event);
            }
        }
    }

    public synchronized void sendErrorEvent(PooledConnection pc, PreparedStatement ps, SQLException sqlEx) {
        StatementEventListenerHelper.sendErrorEvent(this.stmtlisteners, pc, ps, sqlEx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        if (listener == null) {
            return;
        }
        Set set = this.connectionlisteners;
        synchronized (set) {
            this.connectionlisteners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        if (listener == null) {
            return;
        }
        Set set = this.connectionlisteners;
        synchronized (set) {
            this.connectionlisteners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatementEventListener(StatementEventListener listener) {
        if (listener == null) {
            return;
        }
        Set set = this.stmtlisteners;
        synchronized (set) {
            this.stmtlisteners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatementEventListener(StatementEventListener listener) {
        if (listener == null) {
            return;
        }
        Set set = this.stmtlisteners;
        synchronized (set) {
            this.stmtlisteners.remove(listener);
        }
    }
}

