/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbcext.AbstractRowSetSAP;
import com.sap.db.jdbcext.translators.RowSetTranslator;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;

public class JDBCRowSetSAP
extends AbstractRowSetSAP
implements RowSet {
    private Connection conn = null;
    private CallableStatement ps = null;
    private ResultSet rs = null;

    public JDBCRowSetSAP() throws SQLException {
        this.initParams();
    }

    public boolean absolute(int i) throws SQLException {
        this.checkState();
        boolean flag = this.rs.absolute(i);
        this.notifyCursorMoved();
        return flag;
    }

    public void afterLast() throws SQLException {
        this.checkState();
        this.rs.afterLast();
        this.notifyCursorMoved();
    }

    public void beforeFirst() throws SQLException {
        this.checkState();
        this.rs.beforeFirst();
        this.notifyCursorMoved();
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkState();
        this.rs.cancelRowUpdates();
        this.notifyRowChanged();
    }

    void checkState() throws SQLException {
        if (this.conn == null || this.ps == null || this.rs == null) {
            throw SQLExceptionSapDB.generateSQLException("error.objectisclosed", this);
        }
    }

    public void clearWarnings() throws SQLException {
        this.checkState();
        this.rs.clearWarnings();
    }

    public void close() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.ps != null) {
            this.ps.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }

    private Connection connect() throws SQLException {
        if (this.getDataSourceName() != null) {
            try {
                InitialContext initialcontext = new InitialContext();
                DataSource datasource = (DataSource)initialcontext.lookup(this.getDataSourceName());
                return datasource.getConnection(this.getUsername(), this.getPassword());
            }
            catch (NamingException _ex) {
                throw SQLExceptionSapDB.generateSQLException("error.connection.JNDILookup");
            }
        }
        if (this.getUrl() != null) {
            return DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
        }
        return null;
    }

    public void deleteRow() throws SQLException {
        this.checkState();
        this.rs.deleteRow();
        this.notifyRowChanged();
    }

    public void execute() throws SQLException {
        try {
            this.conn = this.connect();
            this.conn.setTransactionIsolation(this.getTransactionIsolation());
            this.conn.setTypeMap(this.getTypeMap());
            this.ps = this.conn.prepareCall(this.getCommand());
            this.ps.setEscapeProcessing(this.getEscapeProcessing());
            this.ps.setMaxFieldSize(this.getMaxFieldSize());
            this.ps.setMaxRows(this.getMaxRows());
            this.ps.setQueryTimeout(this.getQueryTimeout());
            Iterator iterator = this.params.iterator();
            while (iterator.hasNext()) {
                ((RowSetTranslator)iterator.next()).setValue(this.ps);
            }
            this.rs = this.ps.executeQuery();
            this.notifyRowSetChanged();
        }
        catch (SQLException sqlexc) {
            if (this.ps != null) {
                this.ps.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
            throw sqlexc;
        }
    }

    public int findColumn(String s) throws SQLException {
        this.checkState();
        return this.rs.findColumn(s);
    }

    public boolean first() throws SQLException {
        this.checkState();
        boolean flag = this.rs.first();
        this.notifyCursorMoved();
        return flag;
    }

    public Array getArray(int i) throws SQLException {
        this.checkState();
        return this.rs.getArray(i);
    }

    public Array getArray(String s) throws SQLException {
        this.checkState();
        return this.rs.getArray(s);
    }

    public InputStream getAsciiStream(int i) throws SQLException {
        this.checkState();
        return this.rs.getAsciiStream(i);
    }

    public InputStream getAsciiStream(String s) throws SQLException {
        this.checkState();
        return this.rs.getAsciiStream(s);
    }

    public BigDecimal getBigDecimal(int i) throws SQLException {
        this.checkState();
        return this.rs.getBigDecimal(i);
    }

    public BigDecimal getBigDecimal(int i, int j) throws SQLException {
        this.checkState();
        return this.rs.getBigDecimal(i, j);
    }

    public BigDecimal getBigDecimal(String s) throws SQLException {
        return this.getBigDecimal(s);
    }

    public BigDecimal getBigDecimal(String s, int i) throws SQLException {
        this.checkState();
        return this.rs.getBigDecimal(s, i);
    }

    public InputStream getBinaryStream(int i) throws SQLException {
        this.checkState();
        return this.rs.getBinaryStream(i);
    }

    public InputStream getBinaryStream(String s) throws SQLException {
        this.checkState();
        return this.rs.getBinaryStream(s);
    }

    public Blob getBlob(int i) throws SQLException {
        this.checkState();
        return this.rs.getBlob(i);
    }

    public Blob getBlob(String s) throws SQLException {
        this.checkState();
        return this.rs.getBlob(s);
    }

    public boolean getBoolean(int i) throws SQLException {
        this.checkState();
        return this.rs.getBoolean(i);
    }

    public boolean getBoolean(String s) throws SQLException {
        this.checkState();
        return this.rs.getBoolean(s);
    }

    public byte getByte(int i) throws SQLException {
        this.checkState();
        return this.rs.getByte(i);
    }

    public byte getByte(String s) throws SQLException {
        this.checkState();
        return this.rs.getByte(s);
    }

    public byte[] getBytes(int i) throws SQLException {
        this.checkState();
        return this.rs.getBytes(i);
    }

    public byte[] getBytes(String s) throws SQLException {
        this.checkState();
        return this.rs.getBytes(s);
    }

    public Reader getCharacterStream(int i) throws SQLException {
        this.checkState();
        return this.rs.getCharacterStream(i);
    }

    public Reader getCharacterStream(String s) throws SQLException {
        this.checkState();
        return this.rs.getCharacterStream(s);
    }

    public Clob getClob(int i) throws SQLException {
        this.checkState();
        return this.rs.getClob(i);
    }

    public Clob getClob(String s) throws SQLException {
        this.checkState();
        return this.rs.getClob(s);
    }

    public int getConcurrency() throws SQLException {
        this.checkState();
        return this.rs.getConcurrency();
    }

    public String getCursorName() throws SQLException {
        this.checkState();
        return this.rs.getCursorName();
    }

    public Date getDate(int i) throws SQLException {
        this.checkState();
        return this.rs.getDate(i);
    }

    public Date getDate(int i, Calendar calendar) throws SQLException {
        this.checkState();
        return this.rs.getDate(i, calendar);
    }

    public Date getDate(String s) throws SQLException {
        this.checkState();
        return this.rs.getDate(s);
    }

    public Date getDate(String s, Calendar calendar) throws SQLException {
        this.checkState();
        return this.rs.getDate(s, calendar);
    }

    public double getDouble(int i) throws SQLException {
        this.checkState();
        return this.rs.getDouble(i);
    }

    public double getDouble(String s) throws SQLException {
        this.checkState();
        return this.rs.getDouble(s);
    }

    public int getFetchDirection() throws SQLException {
        this.checkState();
        return this.rs.getFetchDirection();
    }

    public float getFloat(int i) throws SQLException {
        this.checkState();
        return this.rs.getFloat(i);
    }

    public float getFloat(String s) throws SQLException {
        this.checkState();
        return this.rs.getFloat(s);
    }

    public int getInt(int i) throws SQLException {
        this.checkState();
        return this.rs.getInt(i);
    }

    public int getInt(String s) throws SQLException {
        this.checkState();
        return this.rs.getInt(s);
    }

    public long getLong(int i) throws SQLException {
        this.checkState();
        return this.rs.getLong(i);
    }

    public long getLong(String s) throws SQLException {
        this.checkState();
        return this.rs.getLong(s);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkState();
        return this.rs.getMetaData();
    }

    public Object getObject(int i) throws SQLException {
        this.checkState();
        return this.rs.getObject(i);
    }

    public Object getObject(int i, Map map) throws SQLException {
        this.checkState();
        return this.rs.getObject(i, map);
    }

    public Object getObject(String s) throws SQLException {
        this.checkState();
        return this.rs.getObject(s);
    }

    public Object getObject(String s, Map map) throws SQLException {
        this.checkState();
        return this.rs.getObject(s, map);
    }

    public Ref getRef(int i) throws SQLException {
        this.checkState();
        return this.rs.getRef(i);
    }

    public Ref getRef(String s) throws SQLException {
        this.checkState();
        return this.rs.getRef(s);
    }

    public int getRow() throws SQLException {
        this.checkState();
        return this.rs.getRow();
    }

    public short getShort(int i) throws SQLException {
        this.checkState();
        return this.rs.getShort(i);
    }

    public short getShort(String s) throws SQLException {
        this.checkState();
        return this.rs.getShort(s);
    }

    public Statement getStatement() throws SQLException {
        this.checkState();
        return this.rs.getStatement();
    }

    public String getString(int i) throws SQLException {
        this.checkState();
        return this.rs.getString(i);
    }

    public String getString(String s) throws SQLException {
        this.checkState();
        return this.rs.getString(s);
    }

    public Time getTime(int i) throws SQLException {
        this.checkState();
        return this.rs.getTime(i);
    }

    public Time getTime(int i, Calendar calendar) throws SQLException {
        this.checkState();
        return this.rs.getTime(i, calendar);
    }

    public Time getTime(String s) throws SQLException {
        this.checkState();
        return this.rs.getTime(s);
    }

    public Time getTime(String s, Calendar calendar) throws SQLException {
        this.checkState();
        return this.rs.getTime(s, calendar);
    }

    public Timestamp getTimestamp(int i) throws SQLException {
        this.checkState();
        return this.rs.getTimestamp(i);
    }

    public Timestamp getTimestamp(int i, Calendar calendar) throws SQLException {
        this.checkState();
        return this.rs.getTimestamp(i, calendar);
    }

    public Timestamp getTimestamp(String s) throws SQLException {
        this.checkState();
        return this.rs.getTimestamp(s);
    }

    public Timestamp getTimestamp(String s, Calendar calendar) throws SQLException {
        this.checkState();
        return this.rs.getTimestamp(s, calendar);
    }

    public int getType() throws SQLException {
        this.checkState();
        return this.rs.getType();
    }

    public InputStream getUnicodeStream(int i) throws SQLException {
        this.checkState();
        return this.rs.getUnicodeStream(i);
    }

    public InputStream getUnicodeStream(String s) throws SQLException {
        this.checkState();
        return this.rs.getUnicodeStream(s);
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkState();
        return this.rs.getWarnings();
    }

    public void insertRow() throws SQLException {
        this.checkState();
        this.rs.insertRow();
        this.notifyRowChanged();
    }

    public boolean isAfterLast() throws SQLException {
        this.checkState();
        return this.rs.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        this.checkState();
        return this.rs.isBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        this.checkState();
        return this.rs.isFirst();
    }

    public boolean isLast() throws SQLException {
        this.checkState();
        return this.rs.isLast();
    }

    public boolean last() throws SQLException {
        this.checkState();
        boolean flag = this.rs.last();
        this.notifyCursorMoved();
        return flag;
    }

    public void moveToCurrentRow() throws SQLException {
        this.checkState();
        this.rs.moveToCurrentRow();
    }

    public void moveToInsertRow() throws SQLException {
        this.checkState();
        this.rs.moveToInsertRow();
    }

    public boolean next() throws SQLException {
        this.checkState();
        boolean flag = this.rs.next();
        this.notifyCursorMoved();
        return flag;
    }

    public boolean previous() throws SQLException {
        this.checkState();
        boolean flag = this.rs.previous();
        this.notifyCursorMoved();
        return flag;
    }

    public void refreshRow() throws SQLException {
        this.checkState();
        this.rs.refreshRow();
    }

    public boolean relative(int i) throws SQLException {
        this.checkState();
        boolean flag = this.rs.relative(i);
        this.notifyCursorMoved();
        return flag;
    }

    public boolean rowDeleted() throws SQLException {
        this.checkState();
        return this.rs.rowDeleted();
    }

    public boolean rowInserted() throws SQLException {
        this.checkState();
        return this.rs.rowInserted();
    }

    public boolean rowUpdated() throws SQLException {
        this.checkState();
        return this.rs.rowUpdated();
    }

    public void setFetchDirection(int i) throws SQLException {
        this.checkState();
        this.rs.setFetchDirection(i);
    }

    public void setFetchSize(int i) throws SQLException {
        this.checkState();
        this.rs.setFetchSize(i);
    }

    public void updateAsciiStream(int i, InputStream inputstream, int j) throws SQLException {
        this.checkState();
        this.rs.updateAsciiStream(i, inputstream, j);
    }

    public void updateAsciiStream(String s, InputStream inputstream, int i) throws SQLException {
        this.checkState();
        this.rs.updateAsciiStream(s, inputstream, i);
    }

    public void updateBigDecimal(int i, BigDecimal bigdecimal) throws SQLException {
        this.checkState();
        this.rs.updateBigDecimal(i, bigdecimal);
    }

    public void updateBigDecimal(String s, BigDecimal bigdecimal) throws SQLException {
        this.checkState();
        this.rs.updateBigDecimal(s, bigdecimal);
    }

    public void updateBinaryStream(int i, InputStream inputstream, int j) throws SQLException {
        this.checkState();
        this.rs.updateBinaryStream(i, inputstream, j);
    }

    public void updateBinaryStream(String s, InputStream inputstream, int i) throws SQLException {
        this.checkState();
        this.rs.updateBinaryStream(s, inputstream, i);
    }

    public void updateBoolean(int i, boolean flag) throws SQLException {
        this.checkState();
        this.rs.updateBoolean(i, flag);
    }

    public void updateBoolean(String s, boolean flag) throws SQLException {
        this.checkState();
        this.rs.updateBoolean(s, flag);
    }

    public void updateByte(int i, byte byte0) throws SQLException {
        this.checkState();
        this.rs.updateByte(i, byte0);
    }

    public void updateByte(String s, byte byte0) throws SQLException {
        this.checkState();
        this.rs.updateByte(s, byte0);
    }

    public void updateBytes(int i, byte[] abyte0) throws SQLException {
        this.checkState();
        this.rs.updateBytes(i, abyte0);
    }

    public void updateBytes(String s, byte[] abyte0) throws SQLException {
        this.checkState();
        this.rs.updateBytes(s, abyte0);
    }

    public void updateCharacterStream(int i, Reader reader, int j) throws SQLException {
        this.checkState();
        this.rs.updateCharacterStream(i, reader, j);
    }

    public void updateCharacterStream(String s, Reader reader, int i) throws SQLException {
        this.checkState();
        this.rs.updateCharacterStream(s, reader, i);
    }

    public void updateDate(int i, Date date) throws SQLException {
        this.checkState();
        this.rs.updateDate(i, date);
    }

    public void updateDate(String s, Date date) throws SQLException {
        this.checkState();
        this.rs.updateDate(s, date);
    }

    public void updateDouble(int i, double d) throws SQLException {
        this.checkState();
        this.rs.updateDouble(i, d);
    }

    public void updateDouble(String s, double d) throws SQLException {
        this.checkState();
        this.rs.updateDouble(s, d);
    }

    public void updateFloat(int i, float f) throws SQLException {
        this.checkState();
        this.rs.updateFloat(i, f);
    }

    public void updateFloat(String s, float f) throws SQLException {
        this.checkState();
        this.rs.updateFloat(s, f);
    }

    public void updateInt(int i, int j) throws SQLException {
        this.checkState();
        this.rs.updateInt(i, j);
    }

    public void updateInt(String s, int i) throws SQLException {
        this.checkState();
        this.rs.updateInt(s, i);
    }

    public void updateLong(int i, long l) throws SQLException {
        this.checkState();
        this.rs.updateLong(i, l);
    }

    public void updateLong(String s, long l) throws SQLException {
        this.checkState();
        this.rs.updateLong(s, l);
    }

    public void updateNull(int i) throws SQLException {
        this.checkState();
        this.rs.updateNull(i);
    }

    public void updateNull(String s) throws SQLException {
        this.checkState();
        this.rs.updateNull(s);
    }

    public void updateObject(int i, Object obj) throws SQLException {
        this.checkState();
        this.rs.updateObject(i, obj);
    }

    public void updateObject(int i, Object obj, int j) throws SQLException {
        this.checkState();
        this.rs.updateObject(i, obj, j);
    }

    public void updateObject(String s, Object obj) throws SQLException {
        this.checkState();
        this.rs.updateObject(s, obj);
    }

    public void updateObject(String s, Object obj, int i) throws SQLException {
        this.checkState();
        this.rs.updateObject(s, obj, i);
    }

    public void updateRow() throws SQLException {
        this.checkState();
        this.rs.updateRow();
        this.notifyRowChanged();
    }

    public void updateShort(int i, short word0) throws SQLException {
        this.checkState();
        this.rs.updateShort(i, word0);
    }

    public void updateShort(String s, short word0) throws SQLException {
        this.checkState();
        this.rs.updateShort(s, word0);
    }

    public void updateString(int i, String s) throws SQLException {
        this.checkState();
        this.rs.updateString(i, s);
    }

    public void updateString(String s, String s1) throws SQLException {
        this.checkState();
        this.rs.updateString(s, s1);
    }

    public void updateTime(int i, Time time) throws SQLException {
        this.checkState();
        this.rs.updateTime(i, time);
    }

    public void updateTime(String s, Time time) throws SQLException {
        this.checkState();
        this.rs.updateTime(s, time);
    }

    public void updateTimestamp(int i, Timestamp timestamp) throws SQLException {
        this.checkState();
        this.rs.updateTimestamp(i, timestamp);
    }

    public void updateTimestamp(String s, Timestamp timestamp) throws SQLException {
        this.checkState();
        this.rs.updateTimestamp(s, timestamp);
    }

    public boolean wasNull() throws SQLException {
        this.checkState();
        return this.rs.wasNull();
    }

    public URL getURL(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getURL(columnIndex);
    }

    public URL getURL(String columnName) throws SQLException {
        this.checkState();
        return this.rs.getURL(columnName);
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.checkState();
        this.rs.updateRef(columnIndex, x);
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        this.checkState();
        this.rs.updateRef(columnName, x);
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.checkState();
        this.rs.updateBlob(columnIndex, x);
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.checkState();
        this.rs.updateBlob(columnName, x);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.checkState();
        this.rs.updateClob(columnIndex, x);
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        this.checkState();
        this.rs.updateClob(columnName, x);
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.checkState();
        this.rs.updateArray(columnIndex, x);
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        this.checkState();
        this.rs.updateArray(columnName, x);
    }

    public int getHoldability() throws SQLException {
        this.checkState();
        return this.rs.getHoldability();
    }

    public boolean isClosed() throws SQLException {
        if (this.conn == null || this.ps == null || this.rs == null) {
            return true;
        }
        return this.rs.isClosed();
    }

    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.checkState();
        this.rs.updateClob(columnLabel, reader);
    }

    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.checkState();
        this.rs.updateClob(columnIndex, reader, length);
    }

    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkState();
        this.rs.updateClob(columnLabel, reader, length);
    }

    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.checkState();
        this.rs.updateNCharacterStream(columnIndex, x);
    }

    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.checkState();
        this.rs.updateNCharacterStream(columnLabel, reader);
    }

    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.checkState();
        this.rs.updateNCharacterStream(columnIndex, x, length);
    }

    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkState();
        this.rs.updateNCharacterStream(columnLabel, reader, length);
    }

    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.checkState();
        this.rs.updateNClob(columnIndex, nClob);
    }

    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.checkState();
        this.rs.updateNClob(columnLabel, nClob);
    }

    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.checkState();
        this.rs.updateNClob(columnIndex, reader);
    }

    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.checkState();
        this.rs.updateNClob(columnLabel, reader);
    }

    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.checkState();
        this.rs.updateNClob(columnIndex, reader, length);
    }

    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkState();
        this.rs.updateNClob(columnLabel, reader, length);
    }

    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.checkState();
        this.rs.updateNString(columnIndex, nString);
    }

    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.checkState();
        this.rs.updateNString(columnLabel, nString);
    }

    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.checkState();
        this.rs.updateRowId(columnIndex, x);
    }

    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.checkState();
        this.rs.updateRowId(columnLabel, x);
    }

    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.checkState();
        this.rs.updateSQLXML(columnIndex, xmlObject);
    }

    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.checkState();
        this.rs.updateSQLXML(columnLabel, xmlObject);
    }

    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.checkState();
        this.rs.updateAsciiStream(columnIndex, x);
    }

    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.checkState();
        this.rs.updateAsciiStream(columnLabel, x);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.checkState();
        this.rs.updateAsciiStream(columnIndex, x, length);
    }

    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.checkState();
        this.rs.updateAsciiStream(columnLabel, x, length);
    }

    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.checkState();
        this.rs.updateBinaryStream(columnIndex, x);
    }

    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.checkState();
        this.rs.updateBinaryStream(columnLabel, x);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.checkState();
        this.rs.updateBinaryStream(columnIndex, x, length);
    }

    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.checkState();
        this.rs.updateBinaryStream(columnLabel, x, length);
    }

    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.checkState();
        this.rs.updateBlob(columnIndex, inputStream);
    }

    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.checkState();
        this.rs.updateBlob(columnLabel, inputStream);
    }

    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.checkState();
        this.rs.updateBlob(columnIndex, inputStream, length);
    }

    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.checkState();
        this.rs.updateBlob(columnLabel, inputStream, length);
    }

    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.checkState();
        this.rs.updateCharacterStream(columnIndex, x);
    }

    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.checkState();
        this.rs.updateCharacterStream(columnLabel, reader);
    }

    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.checkState();
        this.rs.updateCharacterStream(columnIndex, x, length);
    }

    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkState();
        this.rs.updateCharacterStream(columnLabel, reader, length);
    }

    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.checkState();
        this.rs.updateClob(columnIndex, reader);
    }

    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getNCharacterStream(columnIndex);
    }

    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        this.checkState();
        return this.rs.getNCharacterStream(columnLabel);
    }

    public NClob getNClob(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getNClob(columnIndex);
    }

    public NClob getNClob(String columnLabel) throws SQLException {
        this.checkState();
        return this.rs.getNClob(columnLabel);
    }

    public String getNString(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getNString(columnIndex);
    }

    public String getNString(String columnLabel) throws SQLException {
        this.checkState();
        return this.rs.getNString(columnLabel);
    }

    public RowId getRowId(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getRowId(columnIndex);
    }

    public RowId getRowId(String columnLabel) throws SQLException {
        this.checkState();
        return this.rs.getRowId(columnLabel);
    }

    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.checkState();
        return this.rs.getSQLXML(columnIndex);
    }

    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        this.checkState();
        return this.rs.getSQLXML(columnLabel);
    }
}

