/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import java.sql.SQLException;

public class CountingSemaphore {
    private int m_count = 1;
    private Thread m_thread = null;

    public synchronized void release() {
        if (this.m_count == 0) {
            this.m_thread = null;
            this.notify();
        }
        ++this.m_count;
    }

    public synchronized void acquire() throws SQLException {
        Thread th = Thread.currentThread();
        if (th != this.m_thread) {
            while (this.m_count <= 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw SQLExceptionSapDB.generateSQLException("error.packet.threadwasinterrupted", e.toString());
                }
            }
        }
        this.m_thread = th;
        --this.m_count;
    }
}

