/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.util.DataFormat;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DataFormatFullSwap
implements DataFormat {
    public int getInt2(byte[] data, int offset) {
        int lowerByte = data[offset];
        if (lowerByte < 0) {
            lowerByte += 256;
        }
        int result = data[offset + 1] * 256 + lowerByte;
        return result;
    }

    public int getInt4(byte[] data, int offset) {
        int result = 0;
        for (int i = 3; i >= 0; --i) {
            int oneByte = data[offset + i];
            if (oneByte < 0) {
                oneByte += 256;
            }
            result = result * 256 + oneByte;
        }
        return result;
    }

    public long getInt8(byte[] data, int offset) {
        long result = 0L;
        for (int i = 7; i >= 0; --i) {
            int oneByte = data[offset + i];
            if (oneByte < 0) {
                oneByte += 256;
            }
            result = result * 256L + (long)oneByte;
        }
        return result;
    }

    public void putInt1(byte[] data, int value, int offset) {
        data[offset] = (byte)value;
    }

    public void putInt2(byte[] data, int value, int offset) {
        if (value == 0) {
            data[offset + 1] = 0;
            data[offset] = 0;
            return;
        }
        data[offset + 1] = (byte)(value >> 8 & 0xFF);
        data[offset] = (byte)(value & 0xFF);
    }

    public void putInt4(byte[] data, int value, int offset) {
        if (value == 0) {
            data[offset + 3] = 0;
            data[offset + 2] = 0;
            data[offset + 1] = 0;
            data[offset] = 0;
            return;
        }
        for (int i = 0; i <= 3; ++i) {
            data[offset + i] = (byte)(value & 0xFF);
            value >>= 8;
        }
    }

    public void putInt8(byte[] data, long value, int offset) {
        if (value == 0L) {
            data[offset + 7] = 0;
            data[offset + 6] = 0;
            data[offset + 5] = 0;
            data[offset + 4] = 0;
            data[offset + 3] = 0;
            data[offset + 2] = 0;
            data[offset + 1] = 0;
            data[offset] = 0;
            return;
        }
        for (int i = 0; i <= 7; ++i) {
            data[offset + i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
    }

    public void putDouble(byte[] data, double value, int offset) {
        long sl = Double.doubleToRawLongBits(value);
        data[offset] = (byte)(sl & 0xFFL);
        data[offset + 1] = (byte)(sl >> 8 & 0xFFL);
        data[offset + 2] = (byte)(sl >> 16 & 0xFFL);
        data[offset + 3] = (byte)(sl >> 24 & 0xFFL);
        data[offset + 4] = (byte)(sl >> 32 & 0xFFL);
        data[offset + 5] = (byte)(sl >> 40 & 0xFFL);
        data[offset + 6] = (byte)(sl >> 48 & 0xFFL);
        data[offset + 7] = (byte)(sl >> 56 & 0xFFL);
    }

    public void putBigDecimal(byte[] buf, BigDecimal d, int offset) {
        byte[] target = new byte[15];
        int scale = d.scale();
        int sign = d.signum();
        d = d.movePointRight(scale);
        d = d.abs();
        BigInteger bi = d.toBigInteger();
        BigInteger ten = null;
        while (bi.bitLength() > 113) {
            if (ten == null) {
                ten = new BigInteger("10", 10);
            }
            bi = bi.divide(ten);
            --scale;
        }
        byte[] dval = bi.toByteArray();
        int dvalSize = dval.length;
        int exp = 6176 - scale;
        byte e1 = sign < 0 ? (byte)(0xFFFFFF80 | (byte)(exp >> 7)) : (byte)(0 | (byte)(exp >> 7));
        byte e2 = (byte)(exp << 1 & 0xFE);
        for (int i = 0; i < 15; ++i) {
            target[i] = 15 > dvalSize + i ? (byte)0 : dval[(dvalSize + i) % 15];
        }
        e2 = (byte)(e2 | (byte)(target[0] & 1));
        buf[offset + 7] = target[7];
        buf[offset + 6] = target[8];
        buf[offset + 5] = target[9];
        buf[offset + 4] = target[10];
        buf[offset + 3] = target[11];
        buf[offset + 2] = target[12];
        buf[offset + 1] = target[13];
        buf[offset] = target[14];
        buf[offset + 15] = e1;
        buf[offset + 14] = e2;
        buf[offset + 13] = target[1];
        buf[offset + 12] = target[2];
        buf[offset + 11] = target[3];
        buf[offset + 10] = target[4];
        buf[offset + 9] = target[5];
        buf[offset + 8] = target[6];
    }

    public void putFloat(byte[] data, float value, int offset) {
        int si = Float.floatToRawIntBits(value);
        data[offset] = (byte)(si & 0xFF);
        data[offset + 1] = (byte)(si >> 8 & 0xFF);
        data[offset + 2] = (byte)(si >> 16 & 0xFF);
        data[offset + 3] = (byte)(si >> 24 & 0xFF);
    }

    public byte[] putString(String str) {
        byte[] destBuf;
        char c;
        char[] ca = str.toCharArray();
        int byteLen = 0;
        int len = ca.length;
        for (int i = 0; i < len; ++i) {
            c = ca[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++byteLen;
                continue;
            }
            if (c > '\u07ff') {
                byteLen += 3;
                continue;
            }
            byteLen += 2;
        }
        int count = 1;
        if (byteLen <= 245) {
            destBuf = new byte[byteLen + 2];
            this.putInt1(destBuf, byteLen, 1);
            ++count;
        } else if (byteLen <= Short.MAX_VALUE) {
            destBuf = new byte[byteLen + 4];
            this.putInt1(destBuf, 246, 1);
            this.putInt2(destBuf, byteLen, 2);
            count += 3;
        } else {
            destBuf = new byte[byteLen + 6];
            this.putInt1(destBuf, 247, 1);
            this.putInt4(destBuf, byteLen, 2);
            count += 5;
        }
        destBuf[0] = 29;
        for (int i = 0; i < len; ++i) {
            c = ca[i];
            if (c >= '\u0001' && c <= '\u007f') {
                destBuf[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                destBuf[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                destBuf[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                destBuf[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            destBuf[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            destBuf[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return destBuf;
    }

    public byte[] putBytes(byte[] val) {
        byte[] destBuf;
        int byteLen = val.length;
        int count = 1;
        if (byteLen <= 245) {
            destBuf = new byte[byteLen + 2];
            this.putInt1(destBuf, byteLen, 1);
            ++count;
        } else if (byteLen <= Short.MAX_VALUE) {
            destBuf = new byte[byteLen + 4];
            this.putInt1(destBuf, 246, 1);
            this.putInt2(destBuf, byteLen, 2);
            count += 3;
        } else {
            destBuf = new byte[byteLen + 6];
            this.putInt1(destBuf, 247, 1);
            this.putInt4(destBuf, byteLen, 2);
            count += 5;
        }
        destBuf[0] = 12;
        System.arraycopy(val, 0, destBuf, count, val.length);
        return destBuf;
    }
}

