/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.jdbc.Driver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.BitSet;
import java.util.Properties;

public class TraceConfiguration {
    private final String TRACE_ENABLED = "TRACE ENABLED";
    private final String TRACE_FOLDER = "TRACE FOLDER";
    private final String TRACE_FILE = "TRACE FILE";
    private final String TRACE_SIZE = "TRACE SIZE";
    private final String STOP_ON_ERROR = "STOP ON ERROR";
    private final String JDBC_TRACE_LEVEL_API_STR = "TRACE API";
    private final String JDBC_TRACE_LEVEL_PACKET_STR = "TRACE PACKET";
    private final String JDBC_TRACE_LEVEL_DISTRIBUTION_STR = "TRACE DISTRIBUTION";
    private static final String configFileName = "jdbctracesettings.ini";
    private static final String configSyncFileName = "jdbctrace.shm";
    private static String configPath = null;
    private MappedByteBuffer shm;
    private boolean isTraceOn;
    private String traceFolder;
    private String traceFileName;
    private long traceSize;
    private int stopOnError;
    private long traceswitchcount = 0L;
    private BitSet m_traceLevel = new BitSet();
    private boolean shmAttached = false;
    private boolean shmAttachFailed = false;
    public static final int JDBC_TRACE_LEVEL_API = 0;
    public static final int JDBC_TRACE_LEVEL_PACKET = 1;
    public static final int JDBC_TRACE_LEVEL_DISTRIBUTION = 2;

    public TraceConfiguration() {
        this.loadTraceSettings();
        this.attach();
    }

    private void attach() {
        this.shmAttachFailed = false;
        Properties sysprop = System.getProperties();
        String sapvm = sysprop.getProperty("SAPVM", "");
        String vmcontainer = sysprop.getProperty("sun.misc.product", "");
        if (sapvm.equalsIgnoreCase("TRUE") && vmcontainer.equalsIgnoreCase("VMContainer")) {
            return;
        }
        try {
            File file = new File(TraceConfiguration.getConfigPath() + configSyncFileName);
            boolean doesFileExits = file.isFile();
            FileChannel rwChannel = new RandomAccessFile(file, "rw").getChannel();
            this.shm = rwChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 4096L);
            rwChannel.close();
            this.traceswitchcount = this.shm.getLong(0);
            if (!doesFileExits) {
                this.shm.putLong(0, this.traceswitchcount);
                this.shm.force();
            }
            this.shmAttached = true;
        }
        catch (Exception e) {
            this.shm = null;
            this.shmAttachFailed = true;
        }
        catch (Error e) {
            this.shm = null;
            this.shmAttachFailed = true;
        }
    }

    public void setTraceSettingsChangeFlag() {
        if (this.shm == null) {
            return;
        }
        this.shm.putLong(0, ++this.traceswitchcount);
        this.shm.force();
    }

    public boolean hasTraceSettingsChanged() {
        if (this.shm == null) {
            return false;
        }
        long newVal = this.shm.getLong(0);
        if (this.traceswitchcount != newVal) {
            this.traceswitchcount = newVal;
            return true;
        }
        return false;
    }

    public static String getConfigPath() {
        if (configPath == null) {
            StringBuffer buf = new StringBuffer(100);
            Properties prop = System.getProperties();
            String syncfilename = prop.getProperty("com.sap.dbtech.jdbc.syncfile", null);
            if (syncfilename != null) {
                buf.append(syncfilename);
            } else {
                buf.append(System.getProperty("user.home"));
                buf.append(File.separatorChar);
                buf.append(".sdb");
                buf.append(File.separatorChar);
                if (Driver.computername != null) {
                    buf.append(Driver.computername);
                } else {
                    buf.append(System.getProperty("os.name"));
                }
                buf.append(File.separatorChar);
                buf.append(System.getProperty("user.name"));
            }
            buf.append(File.separatorChar);
            configPath = buf.toString();
            File fi = new File(configPath);
            fi.mkdirs();
        }
        return configPath;
    }

    public void setTraceSize(long len, String unit) {
        if (unit.equals("KB")) {
            len *= 1024L;
        } else if (unit.equals("MB")) {
            len = len * 1024L * 1024L;
        } else if (unit.equals("GB")) {
            len = len * 1024L * 1024L * 1024L;
        }
        if (len < 8192L) {
            len = 8192L;
        }
        this.traceSize = len;
    }

    public void loadTraceSettings() {
        File fi = new File(TraceConfiguration.getConfigPath() + configFileName);
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(fi));
            String val = prop.getProperty("TRACE ENABLED", "OFF");
            this.isTraceOn = val.equals("ON");
            this.traceFolder = prop.getProperty("TRACE FOLDER", "." + File.separatorChar);
            this.traceFileName = prop.getProperty("TRACE FILE", "jdbctrace.prt");
            this.traceSize = Long.parseLong(prop.getProperty("TRACE SIZE", String.valueOf(Long.MAX_VALUE)));
            this.stopOnError = Integer.parseInt(prop.getProperty("STOP ON ERROR", "0"));
            val = prop.getProperty("TRACE API", "1");
            if (val.equals("1")) {
                this.m_traceLevel.set(0);
            }
            if ((val = prop.getProperty("TRACE PACKET", "1")).equals("1")) {
                this.m_traceLevel.set(1);
            }
            if ((val = prop.getProperty("TRACE DISTRIBUTION", "0")).equals("1")) {
                this.m_traceLevel.set(2);
            }
        }
        catch (Exception ex) {
            this.isTraceOn = false;
            this.traceFolder = "." + File.separatorChar;
            this.traceFileName = "jdbctrace.prt";
            this.traceSize = Long.MAX_VALUE;
            this.stopOnError = 0;
            this.m_traceLevel.set(0);
            this.m_traceLevel.set(1);
        }
    }

    public void saveTraceSettings() throws FileNotFoundException, IOException {
        Properties prop = new Properties();
        prop.put("TRACE ENABLED", this.isTraceOn ? "ON" : "OFF");
        prop.put("TRACE FOLDER", this.traceFolder);
        prop.put("TRACE FILE", this.traceFileName);
        prop.put("TRACE SIZE", String.valueOf(this.traceSize));
        prop.put("STOP ON ERROR", String.valueOf(this.stopOnError));
        prop.put("TRACE API", this.m_traceLevel.get(0) ? "1" : "0");
        prop.put("TRACE PACKET", this.m_traceLevel.get(1) ? "1" : "0");
        prop.put("TRACE DISTRIBUTION", this.m_traceLevel.get(2) ? "1" : "0");
        File fi = new File(TraceConfiguration.getConfigPath() + configFileName);
        if (!fi.getParentFile().exists()) {
            fi.getParentFile().mkdirs();
        }
        prop.store(new FileOutputStream(fi), "JDBC Trace Settings");
    }

    public boolean isTraceOn() {
        return this.isTraceOn;
    }

    public void setTraceOn(boolean isTraceOn) {
        this.isTraceOn = isTraceOn;
    }

    public void setTraceLevel(int traceLevel, boolean val) {
        this.m_traceLevel.set(traceLevel, val);
    }

    public int getStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(int stopOnError) {
        this.stopOnError = stopOnError;
    }

    String getSharedMemoryName() {
        return TraceConfiguration.getConfigPath() + configSyncFileName;
    }

    public String getTraceFileName() {
        return this.traceFileName;
    }

    public void setTraceFileName(String traceFileName) {
        this.traceFileName = traceFileName;
    }

    public String getTraceFolder() {
        return this.traceFolder;
    }

    public void setTraceFolder(String traceFolder) {
        this.traceFolder = traceFolder;
    }

    public long getTraceSize() {
        return this.traceSize;
    }

    public BitSet getTraceLevel() {
        return this.m_traceLevel;
    }

    public void dumpTracesettings(PrintStream out) {
        out.print("\nConfiguration:\n  Trace              : " + (this.isTraceOn() ? "enabled" : "disabled") + "\n" + "  Trace file name    : " + this.traceFileName + "\n" + "  Trace file size    : ");
        long len = this.getTraceSize();
        if (len == Long.MAX_VALUE) {
            out.println("unlimited");
        } else {
            String unit = "Bytes";
            if (len != 0L && len % 1024L == 0L) {
                len /= 1024L;
                unit = "KBytes";
            }
            if (len != 0L && len % 1024L == 0L) {
                len /= 1024L;
                unit = "MBytes";
            }
            if (len != 0L && len % 1024L == 0L) {
                len /= 1024L;
                unit = "GBytes";
            }
            out.println("limited to " + len + " " + unit);
        }
        out.print("  TRACE API          : " + (this.m_traceLevel.get(0) ? "on" : "off") + "\n");
        out.print("  TRACE PACKET       : " + (this.m_traceLevel.get(1) ? "on" : "off") + "\n");
        out.print("  TRACE DISTRIBUTION : " + (this.m_traceLevel.get(2) ? "on" : "off") + "\n");
        out.print("  Stop on error      : " + (this.getStopOnError() == 0 ? "disabled" : String.valueOf(this.getStopOnError())) + "\n" + "  Shared memory file : " + TraceConfiguration.getConfigPath() + configSyncFileName + "\n" + "  Files will be created in path " + this.getTraceFolder() + ".\n");
    }

    public boolean isShmAttached() {
        return this.shmAttached;
    }

    public boolean isShmAttachFailed() {
        return this.shmAttachFailed;
    }
}

