/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.printf;

import com.sap.db.util.MessageTranslator;
import com.sap.db.util.printf.DataFormatter;
import com.sap.db.util.printf.FormatException;
import com.sap.db.util.printf.Formatter;
import com.sap.db.util.printf.IntegerFormatter;
import com.sap.db.util.printf.LiteralFormatter;
import com.sap.db.util.printf.OArrayEnumeration;
import com.sap.db.util.printf.PrintfArgumentMismatch;
import com.sap.db.util.printf.StringFormatter;

public class PrintfFormat {
    private Formatter[] formats;
    private int elements;

    public PrintfFormat(String formatString) throws FormatException {
        this.formats = this.parseFormatString(formatString);
    }

    private Formatter createFormatter(String format, char kind) throws FormatException {
        DataFormatter result;
        switch (kind) {
            case 's': {
                result = new StringFormatter(format);
                break;
            }
            case 'd': 
            case 'i': 
            case 'o': 
            case 'x': {
                result = new IntegerFormatter(format);
                break;
            }
            default: {
                throw new FormatException(MessageTranslator.translate("error.format.unknown", String.valueOf(kind)));
            }
        }
        return result;
    }

    public String format(Object[] objects) throws PrintfArgumentMismatch {
        OArrayEnumeration enume = new OArrayEnumeration(objects);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.elements; ++i) {
            buf.append(this.formats[i].format(enume));
        }
        if (enume.hasMoreElements()) {
            throw new PrintfArgumentMismatch(MessageTranslator.translate("error.format.toomanyargs"));
        }
        return buf.toString();
    }

    private Formatter[] parseFormatString(String formatString) throws FormatException {
        int arrayLength = 8;
        int stringPos = 0;
        int lastPos = 0;
        int endPos = formatString.length();
        Formatter[] result = new Formatter[arrayLength];
        int arrayPos = 0;
        while (stringPos < endPos && (stringPos = formatString.indexOf(37, lastPos)) != -1) {
            char current;
            if (formatString.charAt(stringPos + 1) == '%') {
                result[arrayPos] = new LiteralFormatter("%");
                ++arrayPos;
                ++stringPos;
                continue;
            }
            if (arrayPos + 3 > arrayLength) {
                Formatter[] tmp = new Formatter[arrayLength * 2];
                System.arraycopy(result, 0, tmp, 0, arrayLength);
                arrayLength *= 2;
                result = tmp;
            }
            result[arrayPos] = new LiteralFormatter(formatString.substring(lastPos, stringPos));
            ++arrayPos;
            lastPos = stringPos;
            while ('a' > (current = formatString.charAt(++stringPos)) || current > 'z' || 'A' <= current && current <= 'Z') {
            }
            result[arrayPos] = this.createFormatter(formatString.substring(lastPos, stringPos + 1), current);
            ++arrayPos;
            lastPos = stringPos + 1;
        }
        result[arrayPos] = new LiteralFormatter(formatString.substring(lastPos));
        this.elements = arrayPos + 1;
        return result;
    }
}

