/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.NameHandling;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPartAuthentication;
import com.sap.db.jdbc.packet.ReplyPacket;
import com.sap.db.jdbc.packet.RequestPacket;
import com.sap.db.rte.comm.JdbcCommunication;
import com.sap.db.rte.comm.RTEException;
import com.sap.db.util.Tracer;
import com.sap.db.util.security.AbstractAuthenticationManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;

public class NativeAuthenticationManagerImpl
extends AbstractAuthenticationManager {
    private byte[] finalValue = null;
    private Object nativeProxy = null;

    public NativeAuthenticationManagerImpl() throws SQLException {
        try {
            this.nativeProxy = Driver.loadNativeAuthentication().newInstance();
        }
        catch (InstantiationException e) {
            throw SQLExceptionSapDB.generateSQLException("error.library.notloaded", "jniauthentication", e.toString());
        }
        catch (IllegalAccessException e) {
            throw SQLExceptionSapDB.generateSQLException("error.library.notloaded", "jniauthentication", e.toString());
        }
    }

    public void authenticate(ConnectionSapDB conn, String userRaw, String password, boolean isUserPasswdAscii, JdbcCommunication session) throws SQLException {
        try {
            this.authenticateNative(conn, userRaw, password, isUserPasswdAscii, session);
        }
        catch (RTEException e) {
            throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed");
        }
    }

    public byte[] evaluateConnectReply(DataPartAuthentication input, Tracer tracer) throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void authenticateNative(Object conn, String userRaw, String password, boolean isUserPasswdAscii, JdbcCommunication session) throws SQLException, RTEException {
        try {
            String userStripped = NameHandling.stripUsername(userRaw);
            Method mt = this.nativeProxy.getClass().getMethod("init", String.class, String.class);
            Long authManager = (Long)mt.invoke(this.nativeProxy, userStripped, password);
            if (authManager == 0L) {
                throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed");
            }
            try {
                this.doAuthenticate(conn, authManager, isUserPasswdAscii, userRaw, session);
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                mt = this.nativeProxy.getClass().getMethod("release", Long.TYPE);
                mt.invoke(this.nativeProxy, authManager);
                throw throwable;
            }
            mt = this.nativeProxy.getClass().getMethod("release", Long.TYPE);
            mt.invoke(this.nativeProxy, authManager);
            {
            }
        }
        catch (SecurityException e) {
            throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed", e.toString());
        }
        catch (NoSuchMethodException e) {
            throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed", e.toString());
        }
        catch (IllegalArgumentException e) {
            throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed", e.toString());
        }
        catch (IllegalAccessException e) {
            throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed", e.toString());
        }
        catch (InvocationTargetException e) {
            throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed", e.toString());
        }
    }

    private void doAuthenticate(Object conn, Long authManager, boolean isUserPasswdAscii, String userRaw, JdbcCommunication session) throws SQLException, RTEException {
        try {
            String userEscaped = NameHandling.stripUsernameEscaped(userRaw);
            byte[] inputData = null;
            Method mt = this.nativeProxy.getClass().getMethod("evaluate", Long.TYPE, [B.class);
            Method mt_final = null;
            Method mt_getValue = null;
            boolean isFinal = false;
            do {
                Object output;
                if ((output = mt.invoke(this.nativeProxy, authManager, inputData)) == null) {
                    throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed");
                }
                if (mt_final == null || mt_getValue == null) {
                    mt_final = output.getClass().getMethod("isFinal", new Class[0]);
                    mt_getValue = output.getClass().getMethod("getValue", new Class[0]);
                }
                this.finalValue = (byte[])mt_getValue.invoke(output, new Object[0]);
                if (this.finalValue == null) {
                    throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed");
                }
                isFinal = (Boolean)mt_final.invoke(output, new Object[0]);
                if (isFinal) continue;
                inputData = this.exchangePackets(conn, userEscaped, isUserPasswdAscii, this.finalValue, session);
            } while (!isFinal);
        }
        catch (SecurityException e) {
            throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed", e.toString());
        }
        catch (NoSuchMethodException e) {
            throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed", e.toString());
        }
        catch (IllegalArgumentException e) {
            throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed", e.toString());
        }
        catch (IllegalAccessException e) {
            throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed", e.toString());
        }
        catch (InvocationTargetException e) {
            throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed", e.toString());
        }
    }

    protected byte[] exchangePackets(Object conn, String user, boolean isUserPasswdAscii, byte[] value, JdbcCommunication session) throws SQLException, RTEException {
        RequestPacket reqPckg = ((ConnectionSapDB)conn).getRequestPacket(session);
        DataPartAuthentication dpOutput = reqPckg.initAuthenticationMethodRequest();
        dpOutput.addArg(0, 0);
        dpOutput.putRawData(value, dpOutput.getCurrentOffset());
        dpOutput.close();
        ReplyPacket replPckg = ((ConnectionSapDB)conn).execute(reqPckg, this, 2, session, true);
        if (!replPckg.existsPart(33)) {
            throw SQLExceptionSapDB.generateSQLException("error.connect.nativeauthenticationfailed");
        }
        return replPckg.getRawPart();
    }

    public int getMaxPasswordLength() {
        return -1;
    }

    public void addClientProofPart(RequestPacket requestPacket, String user, String pwd, boolean isUnicode) throws SQLException {
        DataPartAuthentication dpOutput = (DataPartAuthentication)requestPacket.newAuthenticationPart();
        dpOutput.addArg(0, 0);
        dpOutput.putRawData(this.finalValue, dpOutput.getCurrentOffset());
        dpOutput.close();
    }

    public boolean supportsReconnect() {
        return true;
    }

    public String getMethodName() {
        return "NATIVE";
    }
}

