/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.tds.SybBigDecimal;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class TdsNumeric {
    private static final int[] NUME_PREC_TO_LEN = new int[]{-1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 6, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12, 12, 13, 13, 14, 14, 14, 15, 15, 16, 16, 16, 17, 17, 18, 18, 19, 19, 19, 20, 20, 21, 21, 21, 22, 22, 23, 23, 24, 24, 24, 25, 25, 26, 26, 26, 27, 27, 28, 28, 28, 29, 29, 30, 30, 31, 31, 31, 32, 32, 33, 33, 33, 34, 34, 35, 35, 36, 36, 36, 37, 37, 38, 38, 38, 39, 39, 40, 40, 41, 41, 41, 42, 42, 43, 43, 43, 44, 44, 45, 45, 46, 46, 46, 47, 47, 48, 48, 48, 49, 49, 50, 50, 50, 51, 51, 52, 52, 53, 53, 53, 54, 54};
    protected static final int NUME_MAXPREC = NUME_PREC_TO_LEN.length - 1;
    private static final int NUME_BASEBITS = 8;
    protected static final int NUME_USERPREC = 38;
    private static final int NUME_MAXLEN = 33;
    private static final int NUME_NULLSCALE = 19;
    private static final BigDecimal D_ZERO = BigDecimal.valueOf(0L, 0);
    private static final BigDecimal NEGATIVE_ONE = BigDecimal.valueOf(-1L, 0);
    private static BigDecimal MAX_NUMERIC = null;
    private static BigDecimal MIN_NUMERIC = null;

    private TdsNumeric() {
    }

    protected static BigDecimal numericValue(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            return null;
        }
        int n3 = byArray.length;
        int n4 = NUME_PREC_TO_LEN[n];
        int n5 = byArray[0] == 0 ? 1 : -1;
        byArray[0] = 0;
        byte[] byArray2 = byArray;
        if (n3 > n4) {
            if (n4 > (n3 + 1) / 2) {
                ErrorMessage.raiseIOException("JZ00B");
            }
            boolean bl = true;
            for (int i = n3 - 1; i >= n4; --i) {
                if (byArray[i] == 0) continue;
                bl = false;
                break;
            }
            if (bl) {
                byArray2 = new byte[n4];
                System.arraycopy(byArray, 0, byArray2, 0, n4);
            }
        }
        BigDecimal bigDecimal = new BigDecimal(new BigInteger(n5, byArray2), n2);
        byArray[0] = (byte)(n5 != 1 ? 1 : 0);
        return bigDecimal;
    }

    protected static byte[] tdsNumeric(BigDecimal bigDecimal, int n, int[] nArray, boolean bl) throws IOException {
        int n2;
        int n3;
        if (bigDecimal == null) {
            nArray[1] = 33;
            nArray[2] = 38;
            nArray[3] = n >= 0 ? n : 19;
            return null;
        }
        if (!(bl || MAX_NUMERIC.compareTo(bigDecimal) >= 0 && MIN_NUMERIC.compareTo(bigDecimal) <= 0)) {
            ErrorMessage.raiseIOException("JZ00B");
        }
        boolean bl2 = false;
        if (bigDecimal.compareTo(D_ZERO) < 0) {
            bl2 = true;
        }
        if ((n3 = nArray[2]) == 0) {
            n3 = -1;
        }
        if (bigDecimal instanceof SybBigDecimal) {
            n2 = ((SybBigDecimal)bigDecimal)._scale;
            n3 = ((SybBigDecimal)bigDecimal)._precision;
        } else {
            n2 = n;
        }
        nArray[3] = n2;
        BigInteger bigInteger = TdsNumeric.unscale(bigDecimal, n2);
        byte[] byArray = bigInteger.toByteArray();
        int n4 = String.valueOf(bigInteger).length();
        int n5 = 0;
        if (n3 >= n4) {
            n5 = NUME_PREC_TO_LEN[n3];
        } else if (nArray[2] > 0) {
            n5 = NUME_PREC_TO_LEN[n3];
        } else {
            n3 = n4;
            if (n3 < n2) {
                n3 = n2;
            }
            n5 = NUME_PREC_TO_LEN[n3];
        }
        byte[] byArray2 = null;
        if (nArray[2] == 0 && nArray[1] > 0) {
            byArray2 = new byte[nArray[1]];
            if (n5 != nArray[1]) {
                int n6 = byArray2.length - 1;
                for (int i = byArray.length - 1; n6 >= 0 && i >= 0; --i) {
                    if (byArray[i] == 0) continue;
                    byArray2[n6] = byArray[i];
                    --n6;
                }
            } else {
                System.arraycopy(byArray, 0, byArray2, n5 - byArray.length, byArray.length);
            }
        } else {
            byArray2 = new byte[n5];
            System.arraycopy(byArray, 0, byArray2, n5 - byArray.length, byArray.length);
            byArray2[0] = (byte)(bl2 ? 1 : 0);
        }
        nArray[2] = n3;
        nArray[1] = byArray2.length;
        return byArray2;
    }

    public static void checkRange(BigDecimal bigDecimal, int n) throws SQLException {
        BigDecimal bigDecimal2 = bigDecimal.movePointRight(n);
        if (MAX_NUMERIC.compareTo(bigDecimal2) < 0 || MIN_NUMERIC.compareTo(bigDecimal2) > 0) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    protected static BigInteger unscale(BigDecimal bigDecimal, int n) {
        if (bigDecimal.compareTo(D_ZERO) < 0) {
            bigDecimal = bigDecimal.multiply(NEGATIVE_ONE);
        }
        return bigDecimal.movePointRight(n).toBigInteger();
    }

    static {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < NUME_MAXPREC; ++i) {
            stringBuffer.append("9");
        }
        MAX_NUMERIC = new BigDecimal(stringBuffer.toString());
        MIN_NUMERIC = new BigDecimal("-" + stringBuffer.toString());
    }
}

