/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.OccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.SmartHighlightPainter;

public class XmlOccurrenceMarker
implements OccurrenceMarker {
    private static final char[] CLOSE_TAG_START = new char[]{'<', '/'};
    private static final char[] TAG_SELF_CLOSE = new char[]{'/', '>'};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void markOccurrences(RSyntaxDocument doc, Token t, RSyntaxTextAreaHighlighter h, SmartHighlightPainter p) {
        char[] lexeme = t.getLexeme().toCharArray();
        int tokenOffs = t.getOffset();
        Element root = doc.getDefaultRootElement();
        int lineCount = root.getElementCount();
        int curLine = root.getElementIndex(t.getOffset());
        boolean found = false;
        boolean forward = true;
        for (t = doc.getTokenListForLine(curLine); t != null && t.isPaintable(); t = t.getNextToken()) {
            if (t.getType() != 25) continue;
            if (t.isSingleChar('<') && t.getOffset() + 1 == tokenOffs) {
                found = true;
                break;
            }
            if (!t.is(CLOSE_TAG_START) || t.getOffset() + 2 != tokenOffs) continue;
            found = true;
            forward = false;
            break;
        }
        if (!found) {
            return;
        }
        if (forward) {
            int depth = 0;
            t = t.getNextToken().getNextToken();
            while (true) {
                if (t != null && t.isPaintable()) {
                    if (t.getType() == 25) {
                        if (t.isSingleChar('<')) {
                            ++depth;
                        } else if (t.is(TAG_SELF_CLOSE)) {
                            if (depth <= 0) return;
                            --depth;
                        } else if (t.is(CLOSE_TAG_START)) {
                            if (depth > 0) {
                                --depth;
                            } else {
                                Token match = t.getNextToken();
                                if (match == null || !match.is(lexeme)) return;
                                try {
                                    int end = match.getOffset() + match.length();
                                    h.addMarkedOccurrenceHighlight(match.getOffset(), end, p);
                                    end = tokenOffs + match.length();
                                    h.addMarkedOccurrenceHighlight(tokenOffs, end, p);
                                    return;
                                }
                                catch (BadLocationException ble) {
                                    ble.printStackTrace();
                                }
                                return;
                            }
                        }
                    }
                    t = t.getNextToken();
                    continue;
                }
                if (++curLine < lineCount) {
                    t = doc.getTokenListForLine(curLine);
                }
                if (curLine >= lineCount) return;
            }
        }
        Stack<Token> matches = new Stack<Token>();
        boolean inPossibleMatch = false;
        t = doc.getTokenListForLine(curLine);
        int endBefore = tokenOffs - 2;
        while (true) {
            if (t != null && t.getOffset() < endBefore && t.isPaintable()) {
                if (t.getType() == 25) {
                    Token next;
                    if (t.isSingleChar('<')) {
                        next = t.getNextToken();
                        if (next != null) {
                            if (next.is(lexeme)) {
                                matches.push(next);
                                inPossibleMatch = true;
                            } else {
                                inPossibleMatch = false;
                            }
                            t = next;
                        }
                    } else if (t.isSingleChar('>')) {
                        inPossibleMatch = false;
                    } else if (inPossibleMatch && t.is(TAG_SELF_CLOSE)) {
                        matches.pop();
                    } else if (t.is(CLOSE_TAG_START) && (next = t.getNextToken()) != null) {
                        if (next.is(lexeme) && !matches.isEmpty()) {
                            matches.pop();
                        }
                        t = next;
                    }
                }
                t = t.getNextToken();
                continue;
            }
            if (!matches.isEmpty()) {
                try {
                    Token match = (Token)matches.pop();
                    int end = match.getOffset() + match.length();
                    h.addMarkedOccurrenceHighlight(match.getOffset(), end, p);
                    end = tokenOffs + match.length();
                    h.addMarkedOccurrenceHighlight(tokenOffs, end, p);
                    return;
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
                return;
            }
            if (--curLine >= 0) {
                t = doc.getTokenListForLine(curLine);
            }
            if (curLine < 0) return;
        }
    }
}

