/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.AddOrChangeAbstract;
import com.sap.dbmtk.demo.ConnectionProvider;
import com.sap.dbmtk.demo.SqlPickList;
import com.sap.dbmtk.demo.SqlStatement;
import com.sap.dbmtk.demo.SqlStatementParam;
import com.sap.dbmtk.demo.SqlTraceWindow;
import com.sap.dbmtk.demo.ui.GTable;
import com.sap.dbmtk.demo.utils.DbUtils;
import com.sap.dbmtk.demo.utils.StringUtil;
import com.sap.dbmtk.demo.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class AddOrChangeOrder
extends AddOrChangeAbstract
implements ActionListener,
KeyListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "Order";
    private static final Color DEFAULT_BG_COLOR = new JTextField().getBackground();
    private int _order_id = -1;
    private JLabel _order_id_lbl = new JLabel("order_id");
    private JTextField _order_id_txt = new JTextField();
    private JLabel _store_lbl = new JLabel("Store Name");
    private JTextField _store_txt = new JTextField();
    private JButton _store_but = new JButton("...");
    private JLabel _orderdate_lbl = new JLabel("Order Date");
    private JXDatePicker _orderdate_dtp = new JXDatePicker(new Date(System.currentTimeMillis()));
    private OrderDetailsModel _orderDetails_mod = new OrderDetailsModel();
    private OrderDetailsTable _orderDetails_tab = new OrderDetailsTable(this._orderDetails_mod);
    private JLabel _title_lbl = new JLabel("Title");
    private JTextField _title_txt = new JTextField();
    private JButton _title_but = new JButton("...");
    private JLabel _isbn_lbl = new JLabel("ISBN");
    private JTextField _isbn_txt = new JTextField();
    private JButton _isbn_but = new JButton("...");
    private JLabel _quantity_lbl = new JLabel("Quantity");
    private JTextField _quantity_txt = new JTextField();
    private JLabel _discount_lbl = new JLabel("Discount");
    private JTextField _discount_txt = new JTextField();
    private JButton _od_add = new JButton("Add/Change");
    private JButton _od_remove = new JButton("Remove");
    private JLabel _od_problemDesc = new JLabel("", 4);
    private String _od_validateWarn = null;
    private static final String[] OD_TAB_HEADER = new String[]{"Title", "ISBN", "Quantity", "Discount"};
    private static final int OD_TAB_POS_TITLE = 0;
    private static final int OD_TAB_POS_ISBN = 1;
    private static final int OD_TAB_POS_QUANTITY = 2;
    private static final int OD_TAB_POS_DISCOUNT = 3;

    public AddOrChangeOrder(Window owner, ConnectionProvider connProvider, AddOrChangeAbstract.OpType opType) {
        super(NAME, owner, connProvider, opType);
        super.init();
    }

    @Override
    public JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "[][grow]"));
        if (this.isUpdate() || this.isDelete()) {
            this._order_id_txt.setEnabled(false);
            panel.add((Component)this._order_id_lbl, "");
            panel.add((Component)this._order_id_txt, "growx, pushx, wrap 20");
        }
        panel.add((Component)this._store_lbl, "");
        panel.add((Component)this._store_txt, "split, growx, pushx");
        panel.add((Component)this._store_but, "wrap");
        panel.add((Component)this._orderdate_lbl, "");
        panel.add((Component)this._orderdate_dtp, "growx, pushx, wrap 20");
        JPanel p2 = SwingUtils.createPanel("Order Details", true, (LayoutManager)new MigLayout("", "[][grow]"));
        JScrollPane scroll = new JScrollPane((Component)((Object)this._orderDetails_tab));
        scroll.setPreferredSize(new Dimension(570, 250));
        p2.add((Component)scroll, "span, split, grow, push, wrap");
        if (this.isInsert() || this.isUpdate()) {
            this._od_problemDesc.setForeground(Color.RED);
            p2.add((Component)this._title_lbl, "");
            p2.add((Component)this._title_txt, "split, growx, pushx");
            p2.add((Component)this._title_but, "wrap");
            p2.add((Component)this._isbn_lbl, "");
            p2.add((Component)this._isbn_txt, "split, growx, pushx");
            p2.add((Component)this._isbn_but, "wrap");
            p2.add((Component)this._quantity_lbl, "");
            p2.add((Component)this._quantity_txt, "growx, pushx, wrap");
            p2.add((Component)this._discount_lbl, "");
            p2.add((Component)this._discount_txt, "growx, pushx, wrap");
            p2.add((Component)this._od_problemDesc, "span, split, growx, pushx");
            p2.add((Component)this._od_add, "");
            p2.add((Component)this._od_remove, "wrap");
            this.setDefaultOrderDetails();
        }
        panel.add((Component)p2, "span, grow, push, wrap");
        if (this.isDelete() || this.isUpdate()) {
            this._store_txt.setEnabled(false);
            this._store_but.setEnabled(false);
            this._orderdate_dtp.setEnabled(false);
            if (this.isDelete()) {
                this._orderDetails_tab.setEnabled(false);
            }
        }
        this._store_txt.addActionListener(this);
        this._store_but.addActionListener(this);
        this._title_txt.addActionListener(this);
        this._title_but.addActionListener(this);
        this._isbn_txt.addActionListener(this);
        this._isbn_but.addActionListener(this);
        this._od_add.addActionListener(this);
        this._od_remove.addActionListener(this);
        this._title_txt.addKeyListener(this);
        this._isbn_txt.addKeyListener(this);
        this._quantity_txt.addKeyListener(this);
        this._discount_txt.addKeyListener(this);
        this._store_txt.addFocusListener(this);
        this._orderdate_dtp.addFocusListener((FocusListener)this);
        this._title_txt.addFocusListener(this);
        this._isbn_txt.addFocusListener(this);
        this._quantity_txt.addFocusListener(this);
        this._discount_txt.addFocusListener(this);
        this._orderDetails_tab.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int selRows = AddOrChangeOrder.this._orderDetails_tab.getSelectedRowCount();
                AddOrChangeOrder.this._od_remove.setEnabled(selRows == 1);
                if (selRows == 1) {
                    int vrow = AddOrChangeOrder.this._orderDetails_tab.getSelectedRow();
                    AddOrChangeOrder.this._title_txt.setText(AddOrChangeOrder.this._orderDetails_tab.getValueAt(vrow, 0) + "");
                    AddOrChangeOrder.this._isbn_txt.setText(AddOrChangeOrder.this._orderDetails_tab.getValueAt(vrow, 1) + "");
                    AddOrChangeOrder.this._quantity_txt.setText(AddOrChangeOrder.this._orderDetails_tab.getValueAt(vrow, 2) + "");
                    AddOrChangeOrder.this._discount_txt.setText(AddOrChangeOrder.this._orderDetails_tab.getValueAt(vrow, 3) + "");
                    AddOrChangeOrder.this.validateContent();
                }
            }
        });
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int vrow;
        Object source = e.getSource();
        if (this._store_txt.equals(source) || this._store_but.equals(source)) {
            this.showStorePickTable();
        }
        if (this._title_txt.equals(source) || this._title_but.equals(source)) {
            this.showTitlePickTable();
        }
        if (this._isbn_txt.equals(source) || this._isbn_but.equals(source)) {
            this.showTitlePickTable();
        }
        if (this._od_add.equals(source)) {
            this.addOrChangeOrderDetails();
        }
        if (this._od_remove.equals(source) && (vrow = this._orderDetails_tab.getSelectedRow()) != -1) {
            int mrow = this._orderDetails_tab.convertRowIndexToModel(vrow);
            this._orderDetails_mod.removeRow(mrow);
        }
        this.validateContent();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.validateContent();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.validateContent();
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (this._store_txt.equals(source) || this._title_txt.equals(source) || this._isbn_txt.equals(source) || this._quantity_txt.equals(source) || this._discount_txt.equals(source) || this._store_txt.equals(source)) {
            JTextField field = (JTextField)e.getSource();
            field.selectAll();
        }
    }

    private void showStorePickTable() {
        String store = this._store_txt.getText();
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call get_stores_lookup(?,?)}");
        stmnt.addParam(SqlStatementParam.createInParam("store_name", 12, store));
        stmnt.addParam(SqlStatementParam.createOracleResultSetParam("a_cursor"));
        SqlPickList pickList = new SqlPickList((Window)this, this.getConnectionProvider(), stmnt, "order-StoreName");
        boolean setValues = false;
        if (pickList.getRowCount() == 1) {
            setValues = true;
        } else {
            pickList.setVisible(true);
            if (pickList.wasOkPressed()) {
                setValues = true;
            }
        }
        if (setValues) {
            this._store_txt.setText(pickList.getSelectedValuesAsString("store_name"));
            this._title_txt.requestFocus();
        }
    }

    private void showTitlePickTable() {
        String title = this._title_txt.getText();
        String isbn = this._isbn_txt.getText();
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call ${PKG:titles_pkg}get_titles_lookup(?,?,?)}");
        stmnt.addParam(SqlStatementParam.createInParam("title", 12, title));
        stmnt.addParam(SqlStatementParam.createInParam("isbn", 12, isbn));
        stmnt.addParam(SqlStatementParam.createOracleResultSetParam("a_cursor"));
        SqlPickList pickList = new SqlPickList((Window)this, this.getConnectionProvider(), stmnt, "orderDetailes-TitlesIsbn");
        boolean setValues = false;
        if (pickList.getRowCount() == 1) {
            setValues = true;
        } else {
            pickList.setVisible(true);
            if (pickList.wasOkPressed()) {
                setValues = true;
            }
        }
        if (setValues) {
            this._title_txt.setText(pickList.getSelectedValuesAsString("title"));
            this._isbn_txt.setText(pickList.getSelectedValuesAsString("isbn"));
            this._quantity_txt.requestFocus();
        }
    }

    private void setDefaultOrderDetails() {
        this._title_txt.setText("");
        this._isbn_txt.setText("");
        this._quantity_txt.setText("1");
        this._discount_txt.setText("0");
        this._title_txt.setBackground(DEFAULT_BG_COLOR);
        this._isbn_txt.setBackground(DEFAULT_BG_COLOR);
    }

    private void addOrChangeOrderDetails() {
        String title = this._title_txt.getText();
        String isbn = this._isbn_txt.getText();
        Integer quantity = new Integer(this._quantity_txt.getText());
        BigDecimal discount = new BigDecimal(this._discount_txt.getText());
        this._od_validateWarn = this.validateOrderDetails(title, isbn, quantity, discount);
        if (StringUtil.isNullOrBlank(this._od_validateWarn)) {
            this._orderDetails_mod.addOrChangeRecord(title, isbn, quantity, discount);
            this._orderDetails_tab.packAll();
            this.setDefaultOrderDetails();
            this._title_txt.requestFocus();
        }
    }

    @Override
    public void validateContent() {
        super.validateContent();
        String problem = this.getOrderDetailsProblemText();
        if (problem == null) {
            this._od_add.setEnabled(true);
            this._od_problemDesc.setText("");
        } else {
            this._od_add.setEnabled(false);
            this._od_problemDesc.setText(problem);
        }
        if (StringUtil.hasValue(this._od_validateWarn)) {
            this._od_add.setEnabled(false);
            this._od_problemDesc.setText(this._od_validateWarn);
            this._od_validateWarn = null;
        }
    }

    public String getOrderDetailsProblemText() {
        this._title_txt.setBackground(DEFAULT_BG_COLOR);
        if (this._orderDetails_mod.existsTitle(this._title_txt.getText())) {
            this._title_txt.setBackground(Color.ORANGE);
        }
        this._isbn_txt.setBackground(DEFAULT_BG_COLOR);
        if (this._orderDetails_mod.existsIsbn(this._isbn_txt.getText())) {
            this._isbn_txt.setBackground(Color.ORANGE);
        }
        if (this._title_txt.getText().trim().length() == 0) {
            return "Title Name must be given";
        }
        try {
            new Integer(this._quantity_txt.getText());
        }
        catch (NumberFormatException nfe) {
            return "Quantity must be a Integer";
        }
        try {
            new BigDecimal(this._discount_txt.getText());
        }
        catch (NumberFormatException nfe) {
            return "Discount must be a Number";
        }
        return null;
    }

    @Override
    public String getProblemText() {
        if (this.isInsert()) {
            if (this._store_txt.getText().trim().length() == 0) {
                return "Select a Store Name";
            }
            if (this._orderDetails_tab.getRowCount() == 0) {
                return "No order details has yet been added";
            }
        }
        return null;
    }

    @Override
    public void setFields(GTable table, int vrow) {
        this._order_id = table.getValueAsInteger(vrow, "order_id", false);
        this._order_id_txt.setText("" + this._order_id);
        this._store_txt.setText(table.getValueAsString(vrow, "store_name", false));
        this._orderdate_dtp.setDate((Date)table.getValueAsTimestamp(vrow, "order_date", false));
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call get_order_details(?,?)}");
        stmnt.addParam(SqlStatementParam.createInParam("order_id_list", 12, this._order_id + ""));
        stmnt.addParam(SqlStatementParam.createOracleResultSetParam("a_cursor"));
        try {
            ResultSet rs = stmnt.executeQuery(this.getConnectionProvider());
            int rowc = 0;
            while (rs.next()) {
                ++rowc;
                String title = rs.getString(4);
                String isbn = rs.getString(5);
                Integer quantity = rs.getInt(2);
                BigDecimal discount = rs.getBigDecimal(3);
                this._orderDetails_mod.addOrChangeRecord(title, isbn, quantity, discount);
            }
            SqlTraceWindow.getInstance().addRowcount(rowc);
            SqlStatement.putWarningMessages(this.getConnectionProvider(), null, rs);
            rs.close();
            this._orderDetails_tab.packAll();
        }
        catch (SQLException e) {
            SqlStatement.showErrorMessage(e, stmnt, this, "Getting Order Information for Order ID '" + this._order_id + "' <b>failed.</b>");
        }
    }

    public String getStoreName() {
        return this.getStringValue(this._store_txt);
    }

    public Timestamp getOrderDate() {
        return this._orderdate_dtp.getDate() == null ? null : new Timestamp(this._orderdate_dtp.getDate().getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doInsert() {
        SqlStatement stmnt = null;
        Connection conn = null;
        String errAt = "start";
        try {
            int r;
            conn = this.getConnection();
            if (this.getConnectionProvider().isAutoCommitEnabledAtConnect()) {
                DbUtils.setAutoCommit(conn, null, this.getOwner(), false, "Add Order Dialog");
            }
            errAt = "insert_order";
            stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call insert_order(?, ?, ?)}");
            stmnt.addParam(SqlStatementParam.createInParam("store_name", 12, this.getStoreName()));
            stmnt.addParam(SqlStatementParam.createInParam("order_date", 93, this.getOrderDate()));
            stmnt.addParam(SqlStatementParam.createOutParam("order_id", 4));
            stmnt.executeWithGuiProgress(this.getConnectionProvider(), this.getOwner());
            Integer orderId = (Integer)stmnt.getParameterValue("order_id");
            for (r = 0; r < this._orderDetails_mod.getRowCount(); ++r) {
                String isbn = (String)this._orderDetails_mod.getValueAt(r, 1);
                Integer quantity = (Integer)this._orderDetails_mod.getValueAt(r, 2);
                BigDecimal discount = (BigDecimal)this._orderDetails_mod.getValueAt(r, 3);
                errAt = "insert_order_detail:row=" + (r + 1);
                stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call insert_order_detail(?, ?, ?, ?)}");
                stmnt.addParam(SqlStatementParam.createInParam("order_id", 4, orderId));
                stmnt.addParam(SqlStatementParam.createInParam("isbn", 12, isbn));
                stmnt.addParam(SqlStatementParam.createInParam("quantity", 4, quantity));
                stmnt.addParam(SqlStatementParam.createInParam("discount", 2, discount));
                stmnt.executeWithGuiProgress(this.getConnectionProvider(), this.getOwner());
            }
            conn.commit();
            r = 1;
            return r != 0;
        }
        catch (Throwable ex) {
            SqlStatement.showErrorMessage(ex, stmnt, this._owner, "Add Order information (at: " + errAt + ") <b>failed.</b>");
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException ex2) {
                    SqlStatement.showErrorMessage(ex2, stmnt, this._owner, "Error when rolling back the executed statements");
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null && this.getConnectionProvider().isAutoCommitEnabledAtConnect()) {
                DbUtils.setAutoCommit(conn, null, this.getOwner(), true, "Add or Change Title Dialog");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doUpdate() {
        SqlStatement stmnt = null;
        Connection conn = null;
        String errAt = "start";
        try {
            int r;
            conn = this.getConnection();
            if (this.getConnectionProvider().isAutoCommitEnabledAtConnect()) {
                DbUtils.setAutoCommit(conn, null, this.getOwner(), false, "Change Order Dialog");
            }
            errAt = "delete_order_details";
            stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call delete_order_details(?)}");
            stmnt.addParam(SqlStatementParam.createInParam("order_id", 4, this._order_id));
            stmnt.executeWithGuiProgress(this.getConnectionProvider(), this.getOwner());
            for (r = 0; r < this._orderDetails_mod.getRowCount(); ++r) {
                String isbn = (String)this._orderDetails_mod.getValueAt(r, 1);
                Integer quantity = (Integer)this._orderDetails_mod.getValueAt(r, 2);
                BigDecimal discount = (BigDecimal)this._orderDetails_mod.getValueAt(r, 3);
                errAt = "insert_order_detail:row=" + (r + 1);
                stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call insert_order_detail(?, ?, ?, ?)}");
                stmnt.addParam(SqlStatementParam.createInParam("order_id", 4, this._order_id));
                stmnt.addParam(SqlStatementParam.createInParam("isbn", 12, isbn));
                stmnt.addParam(SqlStatementParam.createInParam("quantity", 4, quantity));
                stmnt.addParam(SqlStatementParam.createInParam("discount", 2, discount));
                stmnt.executeWithGuiProgress(this.getConnectionProvider(), this.getOwner());
            }
            conn.commit();
            r = 1;
            return r != 0;
        }
        catch (Throwable ex) {
            SqlStatement.showErrorMessage(ex, stmnt, this._owner, "Add Order information (at: " + errAt + ") <b>failed.</b>");
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException ex2) {
                    SqlStatement.showErrorMessage(ex2, stmnt, this._owner, "Error when rolling back the executed statements");
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null && this.getConnectionProvider().isAutoCommitEnabledAtConnect()) {
                DbUtils.setAutoCommit(conn, null, this.getOwner(), true, "Add or Change Title Dialog");
            }
        }
    }

    @Override
    public boolean doDelete() {
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call delete_order(?)}");
        stmnt.addParam(SqlStatementParam.createInParam("order_id", 4, this._order_id));
        return stmnt.execute(this.getConnectionProvider(), this._owner, "Deleting Order information <b>failed.</b>");
    }

    private String validateOrderDetails(String title, String isbn, Integer quantity, BigDecimal discount) {
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call validate_order_detail(?, ?, ?, ?, ?)}");
        stmnt.addParam(SqlStatementParam.createInParam("title", 12, title));
        stmnt.addParam(SqlStatementParam.createInParam("isbn", 12, isbn));
        stmnt.addParam(SqlStatementParam.createInParam("quantity", 4, quantity));
        stmnt.addParam(SqlStatementParam.createInParam("discount", 2, discount));
        stmnt.addParam(SqlStatementParam.createOutParam("warning_txt", 12));
        stmnt.execute(this.getConnectionProvider(), this._owner, "Validating Order Detail information <b>failed.</b>");
        String warning = (String)stmnt.getParameterValue("warning_txt");
        if (StringUtil.isNullOrBlank(warning)) {
            warning = null;
        }
        return warning;
    }

    private class OrderDetailsModel
    extends DefaultTableModel {
        static final long serialVersionUID = 1L;

        OrderDetailsModel() {
            this.setColumnIdentifiers(OD_TAB_HEADER);
        }

        public void addOrChangeRecord(String title, String isbn, Integer quantity, BigDecimal discount) {
            int pkRow = this.getRowForPk(title, isbn);
            if (pkRow >= 0) {
                this.setValueAt(title, pkRow, 0);
                this.setValueAt(isbn, pkRow, 1);
                this.setValueAt(quantity, pkRow, 2);
                this.setValueAt(discount, pkRow, 3);
            } else {
                Vector<Object> row = new Vector<Object>(OD_TAB_HEADER.length);
                row.setSize(OD_TAB_HEADER.length);
                row.set(0, title);
                row.set(1, isbn);
                row.set(2, quantity);
                row.set(3, discount);
                this.addRow(row);
            }
        }

        public boolean existsTitle(String title) {
            for (int r = 0; r < this.getRowCount(); ++r) {
                String r_title = this.getValueAt(r, 0) + "";
                if (!title.equals(r_title)) continue;
                return true;
            }
            return false;
        }

        public boolean existsIsbn(String isbn) {
            for (int r = 0; r < this.getRowCount(); ++r) {
                String r_isbn = this.getValueAt(r, 1) + "";
                if (!isbn.equals(r_isbn)) continue;
                return true;
            }
            return false;
        }

        public int getRowForPk(String title, String isbn) {
            for (int r = 0; r < this.getRowCount(); ++r) {
                String r_title = this.getValueAt(r, 0) + "";
                String r_isbn = this.getValueAt(r, 1) + "";
                if (!title.equals(r_title) || !isbn.equals(r_isbn)) continue;
                return r;
            }
            return -1;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == 0) {
                return String.class;
            }
            if (column == 1) {
                return String.class;
            }
            if (column == 2) {
                return Number.class;
            }
            if (column == 3) {
                return Number.class;
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    private class OrderDetailsTable
    extends JXTable {
        private static final long serialVersionUID = 1L;

        OrderDetailsTable(OrderDetailsModel model) {
            if (model != null) {
                this.setModel(model);
            }
            this.setShowGrid(false);
            this.setSortable(true);
            this.setSelectionMode(0);
            this.setAutoResizeMode(0);
            this.packAll();
            this.setColumnControlVisible(true);
            this.setPreferredScrollableViewportSize(new Dimension(400, 100));
            this.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "DELETE_CURRENT_ROW");
            this.getActionMap().put("DELETE_CURRENT_ROW", new AbstractAction("DELETE_CURRENT_ROW"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddOrChangeOrder.this._od_remove.doClick();
                }
            });
        }
    }
}

