/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.ConnectionProvider;
import com.sap.dbmtk.demo.DemoApp;
import com.sap.dbmtk.demo.ResultSetTable;
import com.sap.dbmtk.demo.SqlStatement;
import com.sap.dbmtk.demo.SqlStatementParam;
import com.sap.dbmtk.demo.ui.ClickListener;
import com.sap.dbmtk.demo.ui.ResultSetTableModel;
import com.sap.dbmtk.demo.utils.Configuration;
import com.sap.dbmtk.demo.utils.DbUtils;
import com.sap.dbmtk.demo.utils.StringUtil;
import com.sap.dbmtk.demo.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.sort.RowFilters;
import org.jdesktop.swingx.table.TableColumnExt;

public abstract class DataPanelAbstract
extends JPanel
implements ActionListener {
    private static Logger _logger = Logger.getLogger(DataPanelAbstract.class);
    private static final long serialVersionUID = 1L;
    protected DemoApp _owner = null;
    protected String _panelName = "";
    protected boolean _createBorder = false;
    private boolean _firstTimeTabIsSelected = true;
    protected JLabel _filter_lbl = new JLabel("Filter: ");
    protected JTextField _filter_txt = new JTextField();
    protected JLabel _filter_cnt = new JLabel();
    protected ResultSetTable _table = null;
    protected JButton _add_but = new JButton("New");
    protected JButton _change_but = new JButton("Change");
    protected JButton _remove_but = new JButton("Remove");
    protected JButton _refresh_but = new JButton("Refresh");
    protected JCheckBox _showTableToolTip = new JCheckBox("Show Table Tooltip", true);
    protected JPanel _dbSearchPanel = new JPanel();
    protected int _dbRowCount = -1;
    protected JLabel _dbRowCount_lbl = new JLabel();
    public static final String PROPKEY_ON_REFRESH_GET_DB_COUNT = "on.refresh.get.db.count";
    public static final boolean DEFAULT_ON_REFRESH_GET_DB_COUNT = true;
    public static final String PROPKEY_DB_SEARCH_PANEL_THRESHOLD = "show.db.search.panel.threshold";
    public static final int DEFAULT_DB_SEARCH_PANEL_THRESHOLD = 100;
    public static final String PROPKEY_TABLE_TOOLTIP_IS_SELECTED = ".table.tooltip.isSelected";
    public static final boolean DEFAULT_TABLE_TOOLTIP_IS_SELECTED = true;
    private Set<DataPanelAbstract> _childSet = new HashSet<DataPanelAbstract>();

    private int getConf_dbShowSearchPanelThreshold() {
        return Configuration.getCombinedConfiguration().getIntProperty(PROPKEY_DB_SEARCH_PANEL_THRESHOLD, 100);
    }

    private boolean getConf_onRefreshGetDbCount() {
        return Configuration.getCombinedConfiguration().getBooleanProperty(PROPKEY_ON_REFRESH_GET_DB_COUNT, true);
    }

    public DataPanelAbstract(DemoApp demo, String panelName, boolean createBorder) {
        this._owner = demo;
        this._panelName = panelName;
        this._createBorder = createBorder;
        this.setName(this._panelName);
        this.pinit();
    }

    private void pinit() {
        if (this._createBorder) {
            TitledBorder border = BorderFactory.createTitledBorder(this._panelName);
            this.setBorder(border);
        }
        this._dbSearchPanel = this.createDbSearchPanel();
        this._dbSearchPanel.setVisible(false);
        this._filter_txt.setToolTipText("Client filter, that does regular expression on all table cells using this value");
        this._filter_cnt.setToolTipText("Visible rows / actual rows in the GUI Table");
        this._dbRowCount_lbl.setToolTipText("Rows braught back from server to client / actual rows in the Database Table");
        this._dbSearchPanel.setToolTipText("Restricting records fetched from the database using various where clauses.");
        this.setLayout((LayoutManager)new MigLayout("insets 5 5 0 5", "", ""));
        this.add((Component)this._filter_lbl, "split");
        this.add((Component)this._filter_txt, "growx, pushx");
        this.add((Component)this._filter_cnt, "wrap");
        this._table = this.createTable();
        JScrollPane scroll = new JScrollPane((Component)((Object)this._table));
        this.add((Component)scroll, "grow, push, wrap");
        this.add((Component)this._dbSearchPanel, "growx, pushx, hidemode 3, wrap");
        this.add((Component)this._add_but, "split, hidemode 2");
        this.add((Component)this._change_but, "hidemode 2");
        this.add((Component)this._remove_but, "hidemode 2");
        this.add((Component)this._showTableToolTip, "hidemode 2");
        this.add((Component)new JLabel(), "pushx, growx");
        this.add((Component)this._refresh_but, "wrap");
        this._add_but.setEnabled(false);
        this._change_but.setEnabled(false);
        this._remove_but.setEnabled(false);
        this._refresh_but.setEnabled(false);
        this._add_but.addActionListener(this);
        this._change_but.addActionListener(this);
        this._remove_but.addActionListener(this);
        this._refresh_but.addActionListener(this);
        this._showTableToolTip.addActionListener(this);
        this._filter_txt.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                DataPanelAbstract.this.applyFilter();
            }
        });
        this._add_but.setVisible(this.showAddButton());
        this._change_but.setVisible(this.showChangeButton());
        this._remove_but.setVisible(this.showRemoveButton());
        this._refresh_but.setVisible(this.showRefreshButton());
        this._showTableToolTip.setVisible(this.showTableToolTipCheckbox());
        this._showTableToolTip.setSelected(Configuration.getCombinedConfiguration().getBooleanProperty(this.getName() + PROPKEY_TABLE_TOOLTIP_IS_SELECTED, true));
        this.loadProps();
        this.init();
    }

    protected void init() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Configuration conf;
        Object source = e.getSource();
        try {
            if (this._add_but.equals(source)) {
                this.internalActionAdd();
            }
            if (this._change_but.equals(source)) {
                this.internalActionChange();
            }
            if (this._remove_but.equals(source)) {
                this.internalActionRemove();
            }
            if (this._refresh_but.equals(source)) {
                this.internalActionRefresh();
            }
        }
        catch (Throwable t) {
            String htmlMsg = "<html>Problem loading some field(s) from the '" + this.getName() + "' panel.<br><br><b>Exception</b>: <br>" + t + "<br></html>";
            SwingUtils.showErrorMessage(this._owner.getWindow(), "Problem", htmlMsg, t);
        }
        if (this._showTableToolTip.equals(source) && (conf = Configuration.getInstance("USER_TEMP")) != null) {
            conf.setProperty(this.getName() + PROPKEY_TABLE_TOOLTIP_IS_SELECTED, this._showTableToolTip.isSelected());
            conf.save();
        }
    }

    public boolean showAddButton() {
        return true;
    }

    public boolean showChangeButton() {
        return true;
    }

    public boolean showRemoveButton() {
        return true;
    }

    public boolean showRefreshButton() {
        return true;
    }

    public boolean showTableToolTipCheckbox() {
        return false;
    }

    public boolean isTableToolTipEnabled() {
        return this._showTableToolTip.isVisible() && this._showTableToolTip.isSelected();
    }

    public Window getOwner() {
        return this._owner.getWindow();
    }

    public ResultSetTable getTable() {
        return this._table;
    }

    public ConnectionProvider getConnectionProvider() {
        return this._owner;
    }

    public Connection getConnection() throws SQLException {
        return this._owner.getConnection();
    }

    public ResultSetTable createTable() {
        final ResultSetTable tab = new ResultSetTable(this);
        tab.setName(this.getName());
        tab.setSortable(true);
        tab.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
        tab.packAll();
        tab.setColumnControlVisible(true);
        tab.setAutoResizeMode(0);
        tab.setComponentPopupMenu(this.createDataTablePopupMenu(tab));
        int tableSelectionTimerInterval = 350;
        final Timer tableSelectionTimer = new Timer(tableSelectionTimerInterval, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                _logger.debug((Object)"rowSelectionTimer() FIRED");
                if (!DataPanelAbstract.this._owner.isConnected()) {
                    return;
                }
                DataPanelAbstract.this.internalOnTableSelection();
                boolean enable = tab.getSelectedRowCount() == 1;
                DataPanelAbstract.this._change_but.setEnabled(enable);
                DataPanelAbstract.this._remove_but.setEnabled(enable);
            }
        });
        tableSelectionTimer.setRepeats(false);
        _logger.debug((Object)("nodeSelectionTimerInterval=" + tableSelectionTimerInterval));
        tab.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                _logger.debug((Object)("selectedRow(): timer: " + (tableSelectionTimer.isRunning() ? "RESTART" : "START")));
                if (tableSelectionTimer.isRunning()) {
                    tableSelectionTimer.restart();
                } else {
                    tableSelectionTimer.start();
                }
            }
        });
        tab.addMouseListener(new ClickListener(){

            @Override
            public void doubleClick(MouseEvent e) {
                Point p;
                int vrow;
                if (DataPanelAbstract.this.showChangeButton()) {
                    DataPanelAbstract.this._change_but.setEnabled(true);
                }
                if ((vrow = tab.rowAtPoint(p = e.getPoint())) >= 0) {
                    tab.getSelectionModel().setSelectionInterval(vrow, vrow);
                    DataPanelAbstract.this._change_but.doClick();
                }
            }
        });
        return tab;
    }

    public JPopupMenu createDataTablePopupMenu(final ResultSetTable tab) {
        JMenuItem mi;
        JPopupMenu pm = new JPopupMenu();
        JMenuItem add_mi = new JMenuItem("Add...");
        final JMenuItem change_mi = new JMenuItem("Change...    <double-click>");
        final JMenuItem remove_mi = new JMenuItem("Remove...");
        JMenuItem refresh_mi = new JMenuItem("Refresh");
        if (this.showAddButton()) {
            mi = add_mi;
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataPanelAbstract.this._add_but.doClick();
                }
            });
            pm.add(mi);
        }
        if (this.showChangeButton()) {
            mi = change_mi;
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataPanelAbstract.this._change_but.doClick();
                }
            });
            pm.add(mi);
        }
        if (this.showRemoveButton()) {
            mi = remove_mi;
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataPanelAbstract.this._remove_but.doClick();
                }
            });
            pm.add(mi);
        }
        if (this.showRefreshButton()) {
            mi = refresh_mi;
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataPanelAbstract.this._refresh_but.doClick();
                }
            });
            pm.add(mi);
        }
        pm.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                boolean enable;
                boolean bl = enable = tab.getSelectedRowCount() == 1;
                if (change_mi != null) {
                    change_mi.setEnabled(enable);
                }
                if (remove_mi != null) {
                    remove_mi.setEnabled(enable);
                }
            }
        });
        return pm;
    }

    public void applyFilter() {
        String searchString = this._filter_txt.getText().trim();
        if (searchString.length() <= 0) {
            this._table.setRowFilter(null);
        } else {
            int[] mcols = new int[this._table.getColumnCount()];
            for (int i = 0; i < mcols.length; ++i) {
                mcols[i] = this._table.convertColumnIndexToModel(i);
            }
            this._table.setRowFilter(RowFilters.regexFilter((int)2, (String)(searchString + ".*"), (int[])mcols));
        }
        String rowc = this._table.getRowCount() + "/" + this._table.getModel().getRowCount();
        this._filter_cnt.setText(rowc);
        rowc = this._table.getRowCount() + "/" + this._dbRowCount;
        this._dbRowCount_lbl.setText(rowc);
    }

    private void internalOnTableSelection() {
        this.onTableSelection();
        this.fireChildTableSelection();
    }

    public void onTableSelection() {
    }

    public void onParentTableSelection(DataPanelAbstract parent) {
    }

    public void addChildTableSelectionListener(DataPanelAbstract child) {
        this._childSet.add(child);
    }

    public void removeChildTableSelectionListener(DataPanelAbstract child) {
        this._childSet.remove(child);
    }

    private void fireChildTableSelection() {
        for (DataPanelAbstract child : this._childSet) {
            _logger.debug((Object)(this.getName() + ": fireChildTableSelection on: " + child.getName()));
            child.onParentTableSelection(this);
        }
    }

    public boolean isUndocked() {
        return this._owner.isTabUnDocked(this.getName());
    }

    public void checkTransactionStatus() {
        try {
            boolean autoCommitAtConnect = this.getConnectionProvider().isAutoCommitEnabledAtConnect();
            boolean autoCommitNow = DbUtils.getAutoCommit(this.getConnection(), this._owner.getConnectedProductName());
            if (autoCommitNow != autoCommitAtConnect) {
                _logger.warn((Object)("When checking transaction status: I discovered that AutoCommit is NOW set to '" + autoCommitNow + "' while AutoCommit was to '" + autoCommitAtConnect + "' when the connection was made."));
                String htmlMsg = "<html>When checking transaction status: <br>I discovered that AutoCommit is NOW set to '<b>" + autoCommitNow + "</b>' <br>While AutoCommit was to '<b>" + autoCommitAtConnect + "</b>' when the connection was made. <br><br>I will set AutoCommit to it's original state: <b>" + autoCommitAtConnect + "</b><br><b>NOTE</b>: This is a bug in the application layer, please fix this.</html>";
                SwingUtils.showWarnMessage(this.getOwner(), "Transaction Status", htmlMsg, new Exception("Dummy exception in DataPanel named '" + this.getName() + "', this was made to get a stacktrace for easier debugging."));
                DbUtils.setAutoCommit(this.getConnection(), this._owner.getConnectedProductName(), autoCommitAtConnect, "When checking the Transaction Status after DB Operations");
            }
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems when checking internal transaction status after DB Interaction. Caught: " + e));
            SwingUtils.showWarnMessage(this.getOwner(), "Transaction Status", "Problems when checking internal transaction status after DB Interaction. Caught: " + e, e);
        }
    }

    private void internalActionAdd() {
        this.actionAdd();
        this._owner.refreshStatusBar();
        this.checkTransactionStatus();
    }

    private void internalActionChange() {
        this.actionChange();
        this._owner.refreshStatusBar();
        this.checkTransactionStatus();
    }

    private void internalActionRemove() {
        this.actionRemove();
        this._owner.refreshStatusBar();
        this.checkTransactionStatus();
    }

    private void internalActionRefresh() {
        this.saveProps();
        if (this.getConf_onRefreshGetDbCount()) {
            this.refreshDbRowCount();
        }
        this.actionRefresh();
        this._owner.refreshStatusBar();
        this.checkTransactionStatus();
    }

    public void saveProps() {
    }

    public void loadProps() {
    }

    public void actionAdd() {
    }

    public void actionChange() {
    }

    public void actionRemove() {
    }

    public void actionRefresh() {
        this.refreshTableData();
    }

    public void onConnect() {
        this._add_but.setEnabled(true);
        this._refresh_but.setEnabled(true);
    }

    public void onDisconnect() {
        this._firstTimeTabIsSelected = true;
        this.getTable().setModel(new DefaultTableModel());
        this._add_but.setEnabled(false);
        this._change_but.setEnabled(false);
        this._remove_but.setEnabled(false);
        this._refresh_but.setEnabled(false);
        this._dbRowCount = -1;
        this._dbSearchPanel.setVisible(false);
    }

    public void refreshDbRowCount() {
        this._dbRowCount = this.getDbRowCount();
        this._dbRowCount_lbl.setText(this._dbRowCount + "");
        this._dbSearchPanel.setVisible(this.isDbRowCountAboveThreshold());
    }

    public void onTabSelected() {
        if (!this.getConnectionProvider().isConnected()) {
            return;
        }
        if (this._firstTimeTabIsSelected) {
            if (!this.getConf_onRefreshGetDbCount()) {
                this.refreshDbRowCount();
            }
            this.internalActionRefresh();
            this._firstTimeTabIsSelected = false;
        }
    }

    public int getDbRowCount() {
        return -1;
    }

    public boolean isDbRowCountAboveThreshold() {
        return this._dbRowCount > this.getConf_dbShowSearchPanelThreshold();
    }

    public boolean isDbSearchPanelVisible() {
        return this._dbSearchPanel.isVisible();
    }

    public JPanel createDbSearchPanel() {
        return new JPanel();
    }

    public abstract SqlStatement getTableDataSqlStatement();

    public void refreshTableData() {
        SqlStatement sqlStmnt = this.getTableDataSqlStatement();
        try {
            boolean applyHideColumns;
            sqlStmnt.executeWithGuiProgress(this.getConnectionProvider(), this.getOwner());
            if (sqlStmnt.getResultSetCount() == 0) {
                throw new Exception("No ResultSet was produced by the SQL Statement.");
            }
            ResultSetTableModel newRstm = sqlStmnt.getResultSet(0);
            TableModel tm = this.getTable().getModel();
            if (tm instanceof ResultSetTableModel) {
                ResultSetTableModel currentRstm = (ResultSetTableModel)tm;
                currentRstm.setModelData(newRstm, false);
                applyHideColumns = false;
            } else {
                this.getTable().setModel(newRstm);
                applyHideColumns = true;
            }
            if (applyHideColumns) {
                this.getTable().packAll();
                List<String> hideColumns = this.getHiddenColumns();
                if (hideColumns != null) {
                    for (String colName : hideColumns) {
                        int vpos = this.getTable().findViewColumn(colName, false);
                        if (vpos >= 0) {
                            TableColumnExt tce = this.getTable().getColumnExt(vpos);
                            if (tce != null) {
                                tce.setVisible(false);
                            }
                            _logger.info((Object)("Hiding column '" + colName + "' in panel '" + this._panelName + "'."));
                            continue;
                        }
                        if (vpos != -1) continue;
                        _logger.info((Object)("Cant find column '" + colName + "' when trying to hide it in panel '" + this._panelName + "'."));
                    }
                }
            }
            SqlStatement.showWarningMessages(this.getConnectionProvider(), this.getOwner(), "Warning messages from db for: " + this.getName());
        }
        catch (Throwable ex) {
            SqlStatement.showErrorMessage(ex, sqlStmnt, this._owner.getWindow(), "Getting " + this.getName() + " information <b>failed.</b>");
        }
        this.applyFilter();
    }

    public List<String> getHiddenColumns() {
        return null;
    }

    public String getTableToolTipText(ResultSetTableModel rstm, int mrow, int mcol) {
        if (!this.isTableToolTipEnabled()) {
            return null;
        }
        String htmlTab = rstm.toHtmlTableString(mrow, false);
        StringBuilder sb = new StringBuilder(htmlTab.length() + 20);
        sb.append("<html>").append(htmlTab).append("</html>");
        return sb.toString();
    }

    public String getTableToolTipTextWithPicture(ResultSetTableModel rstm, int mrow, int mcol, String sqlProc, String keyCol, ImageIcon noPictureIcon, Dimension imageMaxBoundary) {
        Integer KEY_VAL;
        if (!this.isTableToolTipEnabled()) {
            return null;
        }
        String SQL_PROC = sqlProc;
        String KEY_COL = keyCol;
        ImageIcon NO_PICTURE = noPictureIcon;
        try {
            KEY_VAL = rstm.getValueAsInteger(mrow, KEY_COL, false);
            if (KEY_VAL == null) {
                return null;
            }
        }
        catch (RuntimeException rte) {
            return rte.toString();
        }
        byte[] picture = null;
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, SQL_PROC);
        stmnt.addParam(SqlStatementParam.createInParam(KEY_COL, 4, KEY_VAL));
        stmnt.addParam(SqlStatementParam.createOracleResultSetParam("a_cursor"));
        try {
            ResultSet rs = stmnt.executeQuery(this.getConnectionProvider());
            while (rs.next()) {
                picture = rs.getBytes(1);
            }
            SqlStatement.putWarningMessages(this.getConnectionProvider(), null, rs);
            rs.close();
        }
        catch (SQLException e) {
            return null;
        }
        if (picture == null && (picture = SwingUtils.toBytArray(NO_PICTURE)) == null) {
            return null;
        }
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("dbmtk_demo_image_tooltip_", ".tmp");
            tmpFile.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(tmpFile);
            fos.write(picture);
            fos.close();
        }
        catch (IOException ex) {
            return "<html>Sorry problems when creating temporary file '" + tmpFile + "'<br>Caught: " + ex + "</html>";
        }
        ImageIcon tmpImage = new ImageIcon(picture);
        int width = tmpImage.getIconWidth();
        int height = tmpImage.getIconHeight();
        Dimension originSize = new Dimension(width, height);
        Dimension boundarySize = imageMaxBoundary == null ? new Dimension(170, 220) : imageMaxBoundary;
        Dimension newSize = SwingUtils.getScaledDimension(originSize, boundarySize);
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        if (_logger.isDebugEnabled()) {
            sb.append("Picture for '").append(KEY_COL).append("': ").append(KEY_VAL).append("<br>");
            sb.append("Using temp file: <code>").append(tmpFile).append("</code><br>");
            sb.append("Width/Height: <code>").append(originSize.width).append(" x ").append(originSize.height).append("</code><br>");
            sb.append("Size:  <code>").append(StringUtil.bytesToHuman(picture.length, "#.#")).append("</code><br>");
            sb.append("<hr>");
        }
        sb.append("<table>");
        sb.append("<tr>");
        sb.append("  <td>");
        sb.append("  <img src=\"file:///").append(tmpFile).append("\" width=\"").append(newSize.width).append("\" height=\"").append(newSize.height).append("\">");
        sb.append("</td>");
        sb.append("<td>");
        sb.append(rstm.toHtmlTableString(mrow, false));
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("</html>");
        return sb.toString();
    }
}

