/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.AddOrChangeAbstract;
import com.sap.dbmtk.demo.AddOrChangeAuthor;
import com.sap.dbmtk.demo.DataPanelAbstract;
import com.sap.dbmtk.demo.DemoApp;
import com.sap.dbmtk.demo.SqlStatement;
import com.sap.dbmtk.demo.SqlStatementParam;
import com.sap.dbmtk.demo.ui.ResultSetTableModel;
import com.sap.dbmtk.demo.utils.Configuration;
import com.sap.dbmtk.demo.utils.SelectAllFocusListener;
import com.sap.dbmtk.demo.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class DataPanelAuthors
extends DataPanelAbstract {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "Author";
    private JLabel _firstName_lbl;
    private JTextField _firstName_txt;
    private JLabel _lastName_lbl;
    private JTextField _lastName_txt;
    private JComboBox _image_cbx;

    public DataPanelAuthors(DemoApp owner) {
        super(owner, NAME, true);
    }

    @Override
    public boolean showTableToolTipCheckbox() {
        return true;
    }

    @Override
    public JPanel createDbSearchPanel() {
        this._firstName_lbl = new JLabel("First Name");
        this._firstName_txt = new JTextField();
        this._lastName_lbl = new JLabel("Last Name");
        this._lastName_txt = new JTextField();
        this._image_cbx = new JComboBox<String>(new String[]{"With or Without Picture", "With Picture", "Without Picture"});
        JPanel p = SwingUtils.createPanel("DB/Server Filter", true, (LayoutManager)new MigLayout());
        p.add((Component)this._firstName_lbl, "");
        p.add((Component)this._firstName_txt, "growx, pushx");
        p.add((Component)this._lastName_lbl, "");
        p.add((Component)this._lastName_txt, "growx, pushx");
        p.add((Component)this._image_cbx, "");
        p.add((Component)this._dbRowCount_lbl, "");
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPanelAuthors.this._refresh_but.doClick();
            }
        };
        this._firstName_txt.addActionListener(al);
        this._lastName_txt.addActionListener(al);
        this._image_cbx.addActionListener(al);
        this._firstName_txt.addFocusListener(new SelectAllFocusListener());
        this._lastName_txt.addFocusListener(new SelectAllFocusListener());
        return p;
    }

    private Integer getPictureParamValue() {
        int index = this._image_cbx.getSelectedIndex();
        if (index == 0) {
            return null;
        }
        if (index == 1) {
            return 1;
        }
        if (index == 2) {
            return 0;
        }
        return null;
    }

    @Override
    public int getDbRowCount() {
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call get_authors_count(?)}");
        stmnt.addParam(SqlStatementParam.createOutParam("rcount", 4));
        stmnt.execute(this.getConnectionProvider(), this.getOwner(), "Get rowcount");
        Integer rcount = (Integer)stmnt.getParameterValue("rcount");
        return rcount == null ? -1 : rcount;
    }

    @Override
    public void saveProps() {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (conf != null) {
            conf.setProperty("Author.field.firstName", this._firstName_txt.getText());
            conf.setProperty("Author.field.lastName", this._lastName_txt.getText());
            conf.setProperty("Author.field.image", this._image_cbx.getSelectedIndex());
        }
    }

    @Override
    public void loadProps() {
        Configuration conf = Configuration.getCombinedConfiguration();
        this._firstName_txt.setText(conf.getProperty("Author.field.firstName", "a"));
        this._lastName_txt.setText(conf.getProperty("Author.field.lastName", "b"));
        this._image_cbx.setSelectedIndex(conf.getIntProperty("Author.field.image", 0));
    }

    @Override
    public void actionAdd() {
        AddOrChangeAuthor dialog = new AddOrChangeAuthor(this._owner.getWindow(), this.getConnectionProvider(), AddOrChangeAbstract.OpType.INSERT);
        if (dialog.open() == 1) {
            this.refreshDbRowCount();
            this.refreshTableData();
        }
        dialog.dispose();
    }

    @Override
    public void actionChange() {
        AddOrChangeAuthor dialog = new AddOrChangeAuthor(this._owner.getWindow(), this.getConnectionProvider(), AddOrChangeAbstract.OpType.UPDATE);
        int vrow = this.getTable().getSelectedRow();
        ((AddOrChangeAbstract)dialog).setFields(this.getTable(), vrow);
        if (dialog.open() == 1) {
            this.refreshTableData();
        }
        dialog.dispose();
    }

    @Override
    public void actionRemove() {
        AddOrChangeAuthor dialog = new AddOrChangeAuthor(this._owner.getWindow(), this.getConnectionProvider(), AddOrChangeAbstract.OpType.DELETE);
        int vrow = this.getTable().getSelectedRow();
        ((AddOrChangeAbstract)dialog).setFields(this.getTable(), vrow);
        if (dialog.open() == 1) {
            this.refreshDbRowCount();
            this.refreshTableData();
        }
        dialog.dispose();
    }

    @Override
    public SqlStatement getTableDataSqlStatement() {
        String fname = null;
        String lname = null;
        Integer pictureType = null;
        if (this.isDbSearchPanelVisible()) {
            fname = this._firstName_txt.getText();
            lname = this._lastName_txt.getText();
            pictureType = this.getPictureParamValue();
        }
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call get_authors(?,?,?,?)}");
        stmnt.addParam(SqlStatementParam.createInParam("first_name", 12, fname));
        stmnt.addParam(SqlStatementParam.createInParam("last_name", 12, lname));
        stmnt.addParam(SqlStatementParam.createInParam("has_picture", 4, pictureType));
        stmnt.addParam(SqlStatementParam.createOracleResultSetParam("a_cursor"));
        return stmnt;
    }

    @Override
    public List<String> getHiddenColumns() {
        ArrayList<String> hiddenCols = new ArrayList<String>();
        hiddenCols.add("au_id");
        return hiddenCols;
    }

    @Override
    public String getTableToolTipText(ResultSetTableModel rstm, int mrow, int mcol) {
        if (!this.isTableToolTipEnabled()) {
            return null;
        }
        return this.getTableToolTipTextWithPicture(rstm, mrow, mcol, "{call get_author_picture(?,?)}", "au_id", AddOrChangeAuthor.NO_PICTURE, new Dimension(170, 220));
    }
}

