/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.AddOrChangeAuthor;
import com.sap.dbmtk.demo.DataPanelAbstract;
import com.sap.dbmtk.demo.DemoApp;
import com.sap.dbmtk.demo.ResultSetTable;
import com.sap.dbmtk.demo.SqlStatement;
import com.sap.dbmtk.demo.SqlStatementParam;
import com.sap.dbmtk.demo.ui.ResultSetTableModel;
import com.sap.dbmtk.demo.utils.StringUtil;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class DataPanelPublisherTitles
extends DataPanelAbstract {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "Titles by Publisher(s)";
    private String[] _pub_ids = new String[0];

    public DataPanelPublisherTitles(DemoApp owner) {
        super(owner, NAME, true);
    }

    @Override
    public boolean showAddButton() {
        return false;
    }

    @Override
    public boolean showChangeButton() {
        return false;
    }

    @Override
    public boolean showRemoveButton() {
        return false;
    }

    @Override
    public boolean showTableToolTipCheckbox() {
        return true;
    }

    @Override
    public void onParentTableSelection(DataPanelAbstract parent) {
        if ("Publishers".equals(parent.getName())) {
            ResultSetTable tab = parent.getTable();
            int[] selectedRows = tab.getSelectedRows();
            this._pub_ids = new String[selectedRows.length];
            for (int r = 0; r < selectedRows.length; ++r) {
                String str = tab.getValueAsString(selectedRows[r], "pub_id", false);
                if (str == null) continue;
                this._pub_ids[r] = str;
            }
        }
        this.refreshTableData();
    }

    @Override
    public SqlStatement getTableDataSqlStatement() {
        String pub_id_values = null;
        if (this._pub_ids.length > 0) {
            pub_id_values = StringUtil.toCommaStr(this._pub_ids, ",");
        }
        if (StringUtil.isNullOrBlank(pub_id_values)) {
            pub_id_values = "-1";
        }
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call ${PKG:titles_pkg}get_titles(?, ?, ?, ?, ?)}");
        stmnt.addParam(SqlStatementParam.createInParam("au_id_list", 12, null));
        stmnt.addParam(SqlStatementParam.createInParam("pub_id_list", 12, pub_id_values));
        stmnt.addParam(SqlStatementParam.createInParam("title_name", 12, null));
        stmnt.addParam(SqlStatementParam.createInParam("has_picture", 4, null));
        stmnt.addParam(SqlStatementParam.createOracleResultSetParam("a_cursor"));
        return stmnt;
    }

    @Override
    public List<String> getHiddenColumns() {
        ArrayList<String> hiddenCols = new ArrayList<String>();
        hiddenCols.add("publisher_name");
        hiddenCols.add("title_id");
        hiddenCols.add("au_id");
        hiddenCols.add("pub_id");
        return hiddenCols;
    }

    @Override
    public String getTableToolTipText(ResultSetTableModel rstm, int mrow, int mcol) {
        if (!this.isTableToolTipEnabled()) {
            return null;
        }
        return this.getTableToolTipTextWithPicture(rstm, mrow, mcol, "{call ${PKG:titles_pkg}get_title_picture(?,?)}", "title_id", AddOrChangeAuthor.NO_PICTURE, new Dimension(300, 400));
    }
}

