/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.ConnectionProvider;
import com.sap.dbmtk.demo.DataPanelAbstract;
import com.sap.dbmtk.demo.DataPanelAuthorTitles;
import com.sap.dbmtk.demo.DataPanelAuthors;
import com.sap.dbmtk.demo.DataPanelOrderDetails;
import com.sap.dbmtk.demo.DataPanelOrders;
import com.sap.dbmtk.demo.DataPanelPublisherTitles;
import com.sap.dbmtk.demo.DataPanelPublishers;
import com.sap.dbmtk.demo.DataPanelStatistics;
import com.sap.dbmtk.demo.DataPanelStores;
import com.sap.dbmtk.demo.DataPanelTitles;
import com.sap.dbmtk.demo.DbMessage;
import com.sap.dbmtk.demo.NormalExitException;
import com.sap.dbmtk.demo.PreferencesDialog;
import com.sap.dbmtk.demo.SplitPanelAbstract;
import com.sap.dbmtk.demo.SqlStatement;
import com.sap.dbmtk.demo.SqlStatementParam;
import com.sap.dbmtk.demo.SqlTraceWindow;
import com.sap.dbmtk.demo.Version;
import com.sap.dbmtk.demo.WindowType;
import com.sap.dbmtk.demo.ui.AbstractComponentDecorator;
import com.sap.dbmtk.demo.ui.ConnectionDialog;
import com.sap.dbmtk.demo.ui.GTabbedPane;
import com.sap.dbmtk.demo.ui.MultiLineLabel;
import com.sap.dbmtk.demo.ui.StatusBar;
import com.sap.dbmtk.demo.utils.AseConnectionUtils;
import com.sap.dbmtk.demo.utils.Configuration;
import com.sap.dbmtk.demo.utils.DbUtils;
import com.sap.dbmtk.demo.utils.Logging;
import com.sap.dbmtk.demo.utils.StringUtil;
import com.sap.dbmtk.demo.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;

public class DemoApp
implements ActionListener,
ConnectionProvider {
    private static Logger _logger = Logger.getLogger(DemoApp.class);
    private static DemoApp _instance = null;
    private static final String NOT_CONNECTED_STR = "Not Connected...";
    public static final String APP_NAME = System.getProperty("APPL_NAME", "DemoClient");
    public static final String PROPKEY_APP_PREFIX = "DemoClient.";
    public static final String PROPKEY_showExtErrInfo = "DemoClient.view.show.extended.error.info";
    public static final boolean DEFAULT_showExtErrInfo = true;
    public static final String PROPKEY_enableDbmsOutput = "DemoClient.view.enable.dbms.output";
    public static final boolean DEFAULT_enableDbmsOutput = true;
    public static final String PROPKEY_connCheckTimeout = "DemoClient.connection.check.timeout";
    public static final long DEFAULT_connCheckTimeout = 2000L;
    public static final String ACTION_CONNECT = "CONNECT";
    public static final String ACTION_DISCONNECT = "DISCONNECT";
    public static final String ACTION_OPEN_SQL_TRACE = "OPEN_SQL_TRACE";
    public static final String ACTION_SAVE_PROPS = "SAVE_PROPS";
    public static final String ACTION_DBMS_OUTPUT = "DBMS_OUTPUT";
    public static final String ACTION_OPEN_PREFERENCES = "OPEN_PREFERENCES";
    public static final String ACTION_EXIT = "EXIT";
    public static final String TAB_AUTHORS = "Author";
    public static final String TAB_TITLES = "Titles";
    public static final String TAB_PUBLISHERS = "Publishers";
    public static final String TAB_STORES = "Stores";
    public static final String TAB_ORDERS = "Orders";
    public static final String TAB_STATS = "Demo Statistics";
    private Connection _conn = null;
    private int _connType = -1;
    private AseConnectionUtils.ConnectionStateInfo _aseConnectionStateInfo = null;
    private DbUtils.JdbcConnectionStateInfo _jdbcConnectionStateInfo = null;
    private JSplitPane _splitPane = new JSplitPane(1);
    private GTabbedPane _tabPane = null;
    private JPanel _mainPane = new JPanel((LayoutManager)new MigLayout("insets 0 0 0 0"));
    private JPanel _baseDemoPanel = null;
    private StatusBar _statusBar = new StatusBar();
    private JLabel _dbms_lbl = new JLabel(" DBMS: ");
    private MultiLineLabel _dbms_txt = new MultiLineLabel("Not Connected...");
    protected DataPanelAbstract _authors = null;
    protected DataPanelAbstract _authorTitles = null;
    protected SplitPanelAbstract _authorsPanel = null;
    protected DataPanelAbstract _titles = null;
    protected DataPanelAbstract _publishers = null;
    protected DataPanelAbstract _publisherTitles = null;
    protected SplitPanelAbstract _publishersPanel = null;
    protected DataPanelAbstract _stores = null;
    protected DataPanelAbstract _orders = null;
    protected DataPanelAbstract _orderDetails = null;
    protected SplitPanelAbstract _ordersPanel = null;
    protected DataPanelAbstract _statistics = null;
    private int _srvVersion = 0;
    private String _connectedDriverName = null;
    private String _connectedDriverVersion = null;
    private String _connectedToProductName = null;
    private String _connectedToProductVersion = null;
    private String _connectedToServerName = null;
    private String _connectedToSysListeners = null;
    private String _connectedSrvCharset = null;
    private String _connectedSrvSortorder = null;
    private String _connectedAsUser = null;
    private String _connectedWithUrl = null;
    private String _connectedClientCharsetId = null;
    private String _connectedClientCharsetName = null;
    private String _connectedClientCharsetDesc = null;
    private boolean _autoCommitEnabledAtConnect = true;
    private long _connCheckLastTime = 0L;
    private long _connCheckTimeout = Configuration.getCombinedConfiguration().getLongProperty("DemoClient.connection.check.timeout", 2000L);
    private Window _window = null;
    private JFrame _jframe = null;
    private JDialog _jdialog = null;
    private String _titlePrefix = null;
    private WindowType _windowType = null;
    private JButton _connect_but = SwingUtils.makeToolbarButton(Version.class, "connect_16.png", "CONNECT", this, "Connect to a DBMS", "Connect");
    private JButton _disconnect_but = SwingUtils.makeToolbarButton(Version.class, "disconnect_16.png", "DISCONNECT", this, "Close the DBMS Connection", "Disconnect");
    private JMenuBar _main_mb = new JMenuBar();
    private JToolBar _toolbar = new JToolBar();
    private JMenu _file_m = new JMenu("File");
    private JMenuItem _connect_mi = new JMenuItem("Connect...");
    private JMenuItem _disconnect_mi = new JMenuItem("Disconnect");
    private JMenuItem _exit_mi = new JMenuItem("Exit");
    private JMenu _view_m = new JMenu("View");
    private JMenuItem _sqlTrace_mi = new JMenuItem("SQL Trace...");
    private JMenuItem _preferences_mi = new JMenuItem("Preferences...");
    private JMenu _tools_m = new JMenu("Tools");
    private JMenuItem _toolDummy_mi = new JMenuItem("Dummy entry");
    private List<DbMessage> _warningMessages = new ArrayList<DbMessage>();
    private Watermark _watermark = null;

    public static DemoApp getInstance() {
        return _instance;
    }

    public static boolean hasInstance() {
        return _instance != null;
    }

    public DemoApp(CommandLine cmd) throws Exception {
        Version.setAppName(APP_NAME);
        File appStoreDir = new File(Version.APP_STORE_DIR);
        if (!appStoreDir.exists() && appStoreDir.mkdir()) {
            System.out.println("Creating directory '" + appStoreDir + "' to hold various files for " + Version.getAppName());
        }
        String CONFIG_FILE_NAME = System.getProperty("CONFIG_FILE_NAME", "dbmtkDemo.properties");
        String TMP_CONFIG_FILE_NAME = System.getProperty("TMP_CONFIG_FILE_NAME", "dbmtkDemo.save.properties");
        String APP_HOME = System.getProperty("APP_HOME");
        String defaultPropsFile = APP_HOME != null ? APP_HOME + File.separator + CONFIG_FILE_NAME : CONFIG_FILE_NAME;
        String defaultTmpPropsFile = Version.APP_STORE_DIR != null ? Version.APP_STORE_DIR + File.separator + TMP_CONFIG_FILE_NAME : TMP_CONFIG_FILE_NAME;
        String filename = Version.APP_STORE_DIR + File.separator + CONFIG_FILE_NAME;
        if (new File(filename).exists()) {
            defaultPropsFile = filename;
        }
        String propFile = cmd.getOptionValue("config", defaultPropsFile);
        String tmpPropFile = cmd.getOptionValue("tmpConfig", defaultTmpPropsFile);
        Configuration appSaveProps = new Configuration(tmpPropFile);
        Configuration.setInstance("USER_TEMP", appSaveProps);
        Configuration.setSearchOrder("USER_TEMP");
        Logging.init(null, propFile);
        _logger.info((Object)("Storage file for properties are '" + Configuration.getInstance("USER_TEMP").getFilename() + "'."));
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DemoApp demoApp = new DemoApp(WindowType.CMDLINE_JFRAME);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                _logger.debug((Object)"----Start Shutdown Hook");
                _logger.debug((Object)"----End Shutdown Hook");
            }
        });
        Thread.sleep(2500L);
        demoApp.openTheWindow();
    }

    public DemoApp(WindowType winType) {
        _instance = this;
        this._windowType = winType;
        if (winType == WindowType.CMDLINE_JFRAME) {
            this._titlePrefix = Version.getAppName();
            this._jframe = new JFrame(this._titlePrefix);
            this._jframe.setDefaultCloseOperation(3);
            this._window = this._jframe;
        }
        if (winType == WindowType.JFRAME) {
            this._titlePrefix = Version.getAppName();
            this._jframe = new JFrame(this._titlePrefix);
            this._window = this._jframe;
        }
        if (winType == WindowType.JDIALOG) {
            this._titlePrefix = Version.getAppName();
            this._jdialog = new JDialog((Dialog)null, this._titlePrefix);
            this._window = this._jdialog;
        }
        if (winType == WindowType.JDIALOG_MODAL) {
            this._titlePrefix = Version.getAppName();
            this._jdialog = new JDialog((Dialog)null, this._titlePrefix, true);
            this._window = this._jdialog;
        }
        if (this._window == null) {
            throw new RuntimeException("_window is null, this should never happen.");
        }
        this._sqlTrace_mi.setToolTipText("Open a 'trace' window where you can se what SQL Statements taht has been executed.");
        if (winType == WindowType.CMDLINE_JFRAME) {
            this._jframe.setJMenuBar(this._main_mb);
            this._main_mb.add(this._file_m);
            this._main_mb.add(this._view_m);
            this._main_mb.add(this._tools_m);
            this._file_m.add(this._connect_mi);
            this._file_m.add(this._disconnect_mi);
            this._file_m.addSeparator();
            this._file_m.add(this._exit_mi);
            this._file_m.setMnemonic(70);
            this._view_m.add(this._sqlTrace_mi);
            this._view_m.add(this._preferences_mi);
            this._tools_m.add(this._toolDummy_mi);
            this._toolDummy_mi.setVisible(false);
            this._file_m.setMnemonic(84);
            this._connect_mi.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
            this._disconnect_mi.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
            this._toolbar.setLayout((LayoutManager)new MigLayout("insets 0 0 0 3", "", ""));
            ImageIcon sap16x32 = SwingUtils.readImageIcon(DemoApp.class, "images/sap_16x32.png");
            JLabel sapIcon = new JLabel("Publications & Order Administration ", sap16x32, 2);
            sapIcon.setFont(new Font("Dialog", 1, 16));
            JLabel dbmtkIcon = new JLabel(this.createTopRightLogo());
            this._toolbar.add(this._connect_but);
            this._toolbar.add(this._disconnect_but);
            this._toolbar.add((Component)new JSeparator(1), "grow");
            this._toolbar.add((Component)sapIcon, "");
            this._toolbar.add((Component)new JLabel(), "growx, pushx");
            this._toolbar.add((Component)dbmtkIcon, "");
            this._connect_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/connect_16.png"));
            this._disconnect_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/disconnect_16.png"));
            this._exit_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/close.gif"));
            this._connect_mi.setActionCommand(ACTION_CONNECT);
            this._disconnect_mi.setActionCommand(ACTION_DISCONNECT);
            this._exit_mi.setActionCommand(ACTION_EXIT);
            this._sqlTrace_mi.setActionCommand(ACTION_OPEN_SQL_TRACE);
            this._preferences_mi.setActionCommand(ACTION_OPEN_PREFERENCES);
            this._connect_mi.addActionListener(this);
            this._disconnect_mi.addActionListener(this);
            this._exit_mi.addActionListener(this);
            this._sqlTrace_mi.addActionListener(this);
            this._preferences_mi.addActionListener(this);
        }
        ImageIcon icon16 = this.createIconWindow16();
        ImageIcon icon32 = this.createIconWindow32();
        ArrayList<Image> iconList = new ArrayList<Image>();
        if (icon16 != null) {
            iconList.add(icon16.getImage());
        }
        if (icon32 != null) {
            iconList.add(icon32.getImage());
        }
        this._window.setIconImages(iconList);
        Container contentPane = this._jframe != null ? this._jframe.getContentPane() : this._jdialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this._baseDemoPanel = this.createBaseDemoPane();
        this.setWatermarkAnchor(this._baseDemoPanel);
        this.setWatermark();
        if (winType == WindowType.CMDLINE_JFRAME) {
            contentPane.add((Component)this._toolbar, "North");
        }
        contentPane.add(this._mainPane);
        this._baseDemoPanel.setMinimumSize(new Dimension(300, 100));
        this._mainPane.add((Component)this._baseDemoPanel, "dock center");
        this._mainPane.add((Component)this._statusBar, "dock south");
        this._statusBar.setVisibleAtLineCol(false);
        this.loadProps();
        this.setComponentVisibility();
        this._window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DemoApp.this.saveProps();
                DemoApp.this.saveWinProps();
                DemoApp.this.close();
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
    }

    private ImageIcon createTopRightLogo() {
        try {
            String appDemoHome = System.getProperty("DBMTK_DEMO_HOME");
            String iconFilename = appDemoHome == null ? "./lib/dbmtk_logo_16.png" : appDemoHome + "/lib/dbmtk_logo_16.png";
            File f = new File(iconFilename);
            if (!f.exists()) {
                _logger.info((Object)("No top right corner logo will be displayed: Can't find the file '" + f + "'."));
                return null;
            }
            URL url = f.toURI().toURL();
            ImageIcon icon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(url));
            return icon;
        }
        catch (MalformedURLException e) {
            _logger.info((Object)("No top right corner logo will be displayed: Caught: " + e));
            return null;
        }
    }

    private ImageIcon createIconWindow16() {
        ImageIcon defaultIcon = SwingUtils.readImageIcon(DemoApp.class, "images/dbmtk_demo_window_16.png");
        try {
            String appDemoHome = System.getProperty("DBMTK_DEMO_HOME");
            String iconFilename = appDemoHome == null ? "./lib/dbmtk_demo_window_16.png" : appDemoHome + "/lib/dbmtk_demo_window_16.png";
            File f = new File(iconFilename);
            if (!f.exists()) {
                _logger.info((Object)("Using default window-16x16 icon. Can't find the file '" + f + "'."));
                return defaultIcon;
            }
            URL url = f.toURI().toURL();
            ImageIcon icon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(url));
            return icon;
        }
        catch (MalformedURLException e) {
            _logger.info((Object)("Using default window-16x16 icon. Caught: " + e));
            return defaultIcon;
        }
    }

    private ImageIcon createIconWindow32() {
        ImageIcon defaultIcon = SwingUtils.readImageIcon(DemoApp.class, "images/dbmtk_demo_window_32.png");
        try {
            String appDemoHome = System.getProperty("DBMTK_DEMO_HOME");
            String iconFilename = appDemoHome == null ? "./lib/dbmtk_demo_window_32.png" : appDemoHome + "/lib/dbmtk_demo_window_32.png";
            File f = new File(iconFilename);
            if (!f.exists()) {
                _logger.info((Object)("Using default window-32x32 icon. Can't find the file '" + f + "'."));
                return defaultIcon;
            }
            URL url = f.toURI().toURL();
            ImageIcon icon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(url));
            return icon;
        }
        catch (MalformedURLException e) {
            _logger.info((Object)("Using default window-32x32 icon. Caught: " + e));
            return defaultIcon;
        }
    }

    private JPanel createBaseDemoPane() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "", ""));
        this._dbms_lbl.setFont(new Font("Dialog", 1, 14));
        this._dbms_txt.setFont(new Font("Dialog", 1, 14));
        panel.add((Component)this.createTabPane(), "grow, push, wrap");
        panel.add((Component)this._dbms_lbl, "split");
        panel.add((Component)this._dbms_txt, "growx, pushx, wrap");
        return panel;
    }

    private GTabbedPane createTabPane() {
        this._tabPane = new GTabbedPane();
        ImageIcon authors_ico = SwingUtils.readImageIcon(DemoApp.class, "images/author_16.gif");
        ImageIcon titles_ico = SwingUtils.readImageIcon(DemoApp.class, "images/book_16.png");
        ImageIcon publishers_ico = SwingUtils.readImageIcon(DemoApp.class, "images/publisher_16.png");
        ImageIcon stores_ico = SwingUtils.readImageIcon(DemoApp.class, "images/store_16.png");
        ImageIcon orders_ico = SwingUtils.readImageIcon(DemoApp.class, "images/order_16.png");
        ImageIcon stats_ico = SwingUtils.readImageIcon(DemoApp.class, "images/stats_16.png");
        this._authors = new DataPanelAuthors(this);
        this._authorTitles = new DataPanelAuthorTitles(this);
        this._authorsPanel = new SplitPanelAbstract(this, TAB_AUTHORS, this._authors, this._authorTitles);
        this._titles = new DataPanelTitles(this);
        this._publishers = new DataPanelPublishers(this);
        this._publisherTitles = new DataPanelPublisherTitles(this);
        this._publishersPanel = new SplitPanelAbstract(this, TAB_PUBLISHERS, this._publishers, this._publisherTitles);
        this._stores = new DataPanelStores(this);
        this._orders = new DataPanelOrders(this);
        this._orderDetails = new DataPanelOrderDetails(this);
        this._ordersPanel = new SplitPanelAbstract(this, TAB_ORDERS, this._orders, this._orderDetails);
        this._statistics = new DataPanelStatistics(this);
        this._authors.addChildTableSelectionListener(this._titles);
        this._publishers.addChildTableSelectionListener(this._titles);
        this._tabPane.addTab(TAB_AUTHORS, authors_ico, this._authorsPanel);
        this._tabPane.addTab(TAB_TITLES, titles_ico, this._titles);
        this._tabPane.addTab(TAB_PUBLISHERS, publishers_ico, this._publishersPanel);
        this._tabPane.addTab(TAB_STORES, stores_ico, this._stores);
        this._tabPane.addTab(TAB_ORDERS, orders_ico, this._ordersPanel);
        this._tabPane.addTab(TAB_STATS, stats_ico, this._statistics);
        this._tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String tabName = DemoApp.this._tabPane.getSelectedTitle(false);
                if (DemoApp.TAB_AUTHORS.equals(tabName)) {
                    DemoApp.this._authorsPanel.onTabSelected();
                } else if (DemoApp.TAB_TITLES.equals(tabName)) {
                    DemoApp.this._titles.onTabSelected();
                } else if (DemoApp.TAB_PUBLISHERS.equals(tabName)) {
                    DemoApp.this._publishersPanel.onTabSelected();
                } else if (DemoApp.TAB_STORES.equals(tabName)) {
                    DemoApp.this._stores.onTabSelected();
                } else if (DemoApp.TAB_ORDERS.equals(tabName)) {
                    DemoApp.this._ordersPanel.onTabSelected();
                } else if (DemoApp.TAB_STATS.equals(tabName)) {
                    DemoApp.this._statistics.onTabSelected();
                }
            }
        });
        return this._tabPane;
    }

    public String getConnectedProductName() {
        return this._connectedToProductName;
    }

    public boolean isTabUnDocked(String tabTitle) {
        return this._tabPane.isTabUnDocked(tabTitle);
    }

    public boolean isTabSelected(String tabTitle) {
        return tabTitle.equals(this._tabPane.getSelectedTitle(false));
    }

    public Window getWindow() {
        return this._window;
    }

    @Override
    public boolean isConnected() {
        return this._conn != null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(false);
    }

    @Override
    public Connection getConnection(boolean forceConnectionCheck) throws SQLException {
        if (this._conn == null) {
            throw new SQLException("Not Connected!");
        }
        this._conn.isClosed();
        long lastCheckWasDone = System.currentTimeMillis() - this._connCheckLastTime;
        if (forceConnectionCheck || lastCheckWasDone > this._connCheckTimeout) {
            this.doDummySelect();
            this._connCheckLastTime = System.currentTimeMillis();
        }
        return this._conn;
    }

    @Override
    public boolean isAutoCommitEnabledAtConnect() {
        return this._autoCommitEnabledAtConnect;
    }

    @Override
    public List<DbMessage> getWarningMessages(boolean reset) {
        List<DbMessage> list = this._warningMessages;
        if (reset) {
            this._warningMessages = new ArrayList<DbMessage>();
        }
        return list;
    }

    @Override
    public void addWarningMessage(DbMessage message) {
        this._warningMessages.add(message);
    }

    private void loadProps() {
    }

    private void saveProps() {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (conf == null) {
            return;
        }
        if (this._windowType == null || this._windowType != null && this._windowType != WindowType.CMDLINE_JFRAME) {
            return;
        }
        conf.save();
    }

    public void saveWinProps() {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (conf == null) {
            return;
        }
        if (this._window == null) {
            return;
        }
        conf.setProperty("DemoClient.size.width", this._window.getSize().width);
        conf.setProperty("DemoClient.size.height", this._window.getSize().height);
        conf.setProperty("DemoClient.splitPane.location", this._splitPane.getDividerLocation());
        if (this._window.isVisible()) {
            conf.setProperty("DemoClient.size.pos.x", this._window.getLocationOnScreen().x);
            conf.setProperty("DemoClient.size.pos.y", this._window.getLocationOnScreen().y);
        }
        conf.save();
    }

    public void setSize(int width, int height) {
        this._window.setSize(width, height);
    }

    public void setLocationRelativeTo(Component comp) {
        this._window.setLocationRelativeTo(comp);
    }

    public void setVisible(boolean b) {
        this._window.setVisible(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCmd = e.getActionCommand();
        _logger.debug((Object)("ACTION '" + actionCmd + "'."));
        if (ACTION_CONNECT.equals(actionCmd)) {
            this.action_connect(e);
        }
        if (ACTION_DISCONNECT.equals(actionCmd)) {
            this.action_disconnect(e);
        }
        if (ACTION_EXIT.equals(actionCmd)) {
            this.action_exit(e);
        }
        if (ACTION_OPEN_SQL_TRACE.equals(actionCmd)) {
            this.action_sqlTrace(e);
        }
        if (ACTION_SAVE_PROPS.equals(actionCmd)) {
            this.saveProps();
        }
        if (ACTION_DBMS_OUTPUT.equals(actionCmd)) {
            this.action_dbmsOutput();
        }
        if (ACTION_OPEN_PREFERENCES.equals(actionCmd)) {
            this.action_openPreferences(e);
        }
        this.setComponentVisibility();
        this.setWatermark();
    }

    public void refreshStatusBar() {
        if (this._conn == null) {
            this.onLostConnection();
            return;
        }
        try {
            this._conn.isClosed();
            this.doDummySelect();
            if (DbUtils.isProductName(this._connectedToProductName, "Adaptive Server Enterprise", "Microsoft SQL Server")) {
                boolean getTranState = DbUtils.isProductName(this._connectedToProductName, "Adaptive Server Enterprise");
                this._aseConnectionStateInfo = AseConnectionUtils.getAseConnectionStateInfo(this._conn, getTranState);
                this._statusBar.setAseConnectionStateInfo(this._aseConnectionStateInfo);
            } else if (!DbUtils.isProductName(this._connectedToProductName, "Replication Server")) {
                this._jdbcConnectionStateInfo = DbUtils.getJdbcConnectionStateInfo(this._conn);
                this._statusBar.setJdbcConnectionStateInfo(this._jdbcConnectionStateInfo);
            }
        }
        catch (SQLException e) {
            this._conn = null;
        }
        this.setWatermark();
    }

    private void setSrvInTitle(String srvStr) {
        String title = this._titlePrefix;
        if (srvStr != null) {
            title = title + " - " + srvStr;
        }
        if (this._jframe != null) {
            this._jframe.setTitle(title);
        }
        if (this._jdialog != null) {
            this._jdialog.setTitle(title);
        }
    }

    private void action_connect(ActionEvent e) {
        this._srvVersion = 0;
        this._connectedDriverName = null;
        this._connectedDriverVersion = null;
        this._connectedToProductName = null;
        this._connectedToProductVersion = null;
        this._connectedToServerName = null;
        this._connectedSrvCharset = null;
        this._connectedSrvSortorder = null;
        this._connectedAsUser = null;
        this._connectedWithUrl = null;
        ConnectionDialog connDialog = new ConnectionDialog(this._jframe);
        connDialog.setVisible(true);
        connDialog.dispose();
        int connType = connDialog.getConnectionType();
        if (connType == 0) {
            return;
        }
        try {
            this._srvVersion = 0;
            this._connectedDriverName = connDialog.getDriverName();
            this._connectedDriverVersion = connDialog.getDriverVersion();
            this._connectedToProductName = connDialog.getDatabaseProductName();
            this._connectedToProductVersion = connDialog.getDatabaseProductVersion();
            this._connectedToServerName = connDialog.getDatabaseServerName();
            this._connectedSrvCharset = null;
            this._connectedSrvSortorder = null;
            this._connectedAsUser = connDialog.getUsername();
            this._connectedWithUrl = connDialog.getUrl();
            if (DbUtils.isProductName(this._connectedToProductName, "Adaptive Server Enterprise")) {
                this._connectedToProductVersion = AseConnectionUtils.getAseVersionStr(connDialog.getConnection());
            }
            if (DbUtils.isProductName(this._connectedToProductName, "HDB")) {
                this._connectedToProductVersion = "SAP HANA, Version: " + this._connectedToProductVersion;
            }
            String displayStr = this._connectedToProductVersion.replace("\n", " ");
            this._dbms_txt.setText(displayStr);
            _logger.info((Object)("Connected to DatabaseProductName='" + this._connectedToProductName + "', DatabaseProductVersion='" + this._connectedToProductVersion + "', DatabaseServerName='" + this._connectedToServerName + "' with Username='" + this._connectedAsUser + "', toURL='" + this._connectedWithUrl + "', using Driver='" + this._connectedDriverName + "', DriverVersion='" + this._connectedDriverVersion + "'."));
        }
        catch (Throwable ex) {
            if (_logger.isDebugEnabled()) {
                _logger.warn((Object)("Problems getting DatabaseProductName, DatabaseProductVersion, DatabaseServerName or Username. Caught: " + ex), ex);
            }
            _logger.warn((Object)("Problems getting DatabaseProductName, DatabaseProductVersion, DatabaseServerName or Username. Caught: " + ex));
        }
        this._conn = connDialog.getConnection();
        this._srvVersion = -1;
        if (connDialog.isDatabaseProduct("Adaptive Server Enterprise")) {
            this._connType = 1;
            this._srvVersion = AseConnectionUtils.getAseVersionNumber(this._conn);
            this._connectedToSysListeners = "Sorry you need 'sa_role' to query master..syslisteners";
            if (AseConnectionUtils.hasRole(this._conn, "sa_role")) {
                this._connectedToSysListeners = AseConnectionUtils.getListeners(this._conn, false, false, this._window);
            }
            this._connectedSrvCharset = AseConnectionUtils.getAseCharset(this._conn);
            this._connectedSrvSortorder = AseConnectionUtils.getAseSortorder(this._conn);
            this._connectedClientCharsetId = AseConnectionUtils.getClientCharsetId(this._conn);
            this._connectedClientCharsetName = AseConnectionUtils.getClientCharsetName(this._conn);
            this._connectedClientCharsetDesc = AseConnectionUtils.getClientCharsetDesc(this._conn);
            this._aseConnectionStateInfo = AseConnectionUtils.getAseConnectionStateInfo(this._conn, true);
            this._statusBar.setAseConnectionStateInfo(this._aseConnectionStateInfo);
            this.setWatermark();
        } else if (connDialog.isDatabaseProduct("SQL Anywhere")) {
            this._connType = 1;
            this._connectedSrvCharset = AseConnectionUtils.getAsaCharset(this._conn);
            this._connectedSrvSortorder = AseConnectionUtils.getAsaSortorder(this._conn);
            this._jdbcConnectionStateInfo = DbUtils.getJdbcConnectionStateInfo(this._conn);
            this._statusBar.setJdbcConnectionStateInfo(this._jdbcConnectionStateInfo);
            _logger.info((Object)("Connected to SQL Anywhere version '" + this._srvVersion + "'."));
        } else if (connDialog.isDatabaseProduct("Sybase IQ")) {
            this._connType = 1;
            this._connectedSrvCharset = AseConnectionUtils.getAsaCharset(this._conn);
            this._connectedSrvSortorder = AseConnectionUtils.getAsaSortorder(this._conn);
            this._jdbcConnectionStateInfo = DbUtils.getJdbcConnectionStateInfo(this._conn);
            this._statusBar.setJdbcConnectionStateInfo(this._jdbcConnectionStateInfo);
            _logger.info((Object)("Connected to Sybase IQ version '" + this._srvVersion + "'."));
        } else if (DbUtils.isProductName(this._connectedToProductName, "HDB")) {
            this._connType = 4;
            this._connectedSrvCharset = "UTF8";
            this._connectedSrvSortorder = "BINARY";
        } else if (DbUtils.isProductName(this._connectedToProductName, "Oracle")) {
            this._connType = 4;
            this._connectedSrvCharset = DbUtils.getOracleCharset(this._conn);
            this._connectedSrvSortorder = DbUtils.getOracleSortorder(this._conn);
        } else if (DbUtils.isProductName(this._connectedToProductName, "Microsoft SQL Server")) {
            this._connType = 4;
        } else if (DbUtils.isProductName(this._connectedToProductName, "DB2/Linux")) {
            this._connType = 4;
            this._connectedSrvCharset = DbUtils.getDb2Charset(this._conn);
            this._connectedSrvSortorder = DbUtils.getDb2Sortorder(this._conn);
        }
        if (DbUtils.isProductName(this._connectedToProductName, "Microsoft SQL Server")) {
            this._aseConnectionStateInfo = AseConnectionUtils.getAseConnectionStateInfo(this._conn, false);
            this._statusBar.setAseConnectionStateInfo(this._aseConnectionStateInfo);
        } else {
            this._jdbcConnectionStateInfo = DbUtils.getJdbcConnectionStateInfo(this._conn);
            this._statusBar.setJdbcConnectionStateInfo(this._jdbcConnectionStateInfo);
        }
        try {
            this._autoCommitEnabledAtConnect = DbUtils.getAutoCommit(this._conn, this._connectedToProductName);
            _logger.info((Object)("AutoCommit=" + this._autoCommitEnabledAtConnect + ". This is the initial state of AutoCommit fetched from the server."));
        }
        catch (SQLException ex) {
            _logger.warn((Object)("Problems getting AutoCommit mode. I will asume that AutoCommit=true, which is the default in JDBC. Caught: " + ex));
        }
        this.action_dbmsOutput();
        this.onConnect();
        this.setComponentVisibility();
        this.setWatermark();
    }

    private void action_dbmsOutput() {
        if (this.isConnected()) {
            try {
                boolean onOff = Configuration.getCombinedConfiguration().getBooleanProperty(PROPKEY_enableDbmsOutput, true);
                SqlStatement.dbmsOutput(this.getConnection(), onOff);
            }
            catch (SQLException e) {
                _logger.error((Object)("Enable/disabe DBMS Output: Caught: " + e));
            }
        }
        this.saveProps();
    }

    private void setComponentVisibility() {
        SwingUtils.hideMenuIfNoneIsVisible(this._view_m);
        SwingUtils.hideMenuIfNoneIsVisible(this._tools_m);
        if (!AseConnectionUtils.isConnectionOk(this._conn, false, null)) {
            this._connect_mi.setEnabled(true);
            this._connect_but.setEnabled(true);
            this._disconnect_mi.setEnabled(false);
            this._disconnect_but.setEnabled(false);
            this.setSrvInTitle(NOT_CONNECTED_STR);
            this._statusBar.setNotConnected();
            return;
        }
        this._connect_mi.setEnabled(false);
        this._connect_but.setEnabled(false);
        this._disconnect_mi.setEnabled(true);
        this._disconnect_but.setEnabled(true);
        if (this._connType == 1) {
            String srvStr = this._connectedToServerName;
            this.setSrvInTitle(srvStr);
            StatusBar.ServerInfo srvInfo = new StatusBar.ServerInfo(srvStr, this._connectedToProductName, this._connectedToProductVersion, this._connectedToServerName, this._connectedAsUser, this._connectedWithUrl, this._connectedToSysListeners, this._connectedSrvCharset, this._connectedSrvSortorder, this._connectedClientCharsetId, this._connectedClientCharsetName, this._connectedClientCharsetDesc);
            this._statusBar.setServerInfo(srvInfo);
            if (this._connectedToProductName == null || this._connectedToProductName.equals("Adaptive Server Enterprise")) {
                // empty if block
            }
        }
        if (this._connType == 4) {
            this.setSrvInTitle(this._connectedWithUrl);
            StatusBar.ServerInfo srvInfo = new StatusBar.ServerInfo(this._connectedWithUrl, this._connectedToProductName, this._connectedToProductVersion, this._connectedToServerName, this._connectedAsUser, this._connectedWithUrl, this._connectedToSysListeners, this._connectedSrvCharset, this._connectedSrvSortorder, this._connectedClientCharsetId, this._connectedClientCharsetName, this._connectedClientCharsetDesc);
            this._statusBar.setServerInfo(srvInfo);
        }
        SwingUtils.hideMenuIfNoneIsVisible(this._view_m);
        SwingUtils.hideMenuIfNoneIsVisible(this._tools_m);
    }

    private void action_disconnect(ActionEvent e) {
        this.saveWinProps();
        this._srvVersion = 0;
        this._connectedDriverName = null;
        this._connectedDriverVersion = null;
        this._connectedToProductName = null;
        this._connectedToProductVersion = null;
        this._connectedToServerName = null;
        this._connectedAsUser = null;
        this._connectedWithUrl = null;
        this._connectedToSysListeners = null;
        this._connectedSrvCharset = null;
        this._connectedSrvSortorder = null;
        this._connectedClientCharsetId = null;
        this._connectedClientCharsetName = null;
        this._connectedClientCharsetDesc = null;
        this._dbms_txt.setText(NOT_CONNECTED_STR);
        this.onDisconnect();
        if (this._conn != null) {
            try {
                this.setSrvInTitle(null);
                this._statusBar.setNotConnected();
                Connection tmpConn = this._conn;
                this._conn = null;
                this._connType = -1;
                tmpConn.close();
            }
            catch (SQLException ex) {
                _logger.error((Object)"Problems closing database connection.", (Throwable)ex);
            }
        }
    }

    private void action_exit(ActionEvent e) {
        this._jframe.dispatchEvent(new WindowEvent(this._jframe, 201));
    }

    private void action_sqlTrace(ActionEvent e) {
        SqlTraceWindow.getInstance().open();
    }

    private void action_openPreferences(ActionEvent e) {
        PreferencesDialog pref = new PreferencesDialog(this.getWindow());
        pref.setVisible(true);
        if (pref.wasOkPressed()) {
            this.action_dbmsOutput();
        }
    }

    public void openTheWindow() {
        Configuration conf = Configuration.getCombinedConfiguration();
        if (this._window == null) {
            return;
        }
        String screenResStr = SwingUtils.getScreenResulutionAsString();
        int width = 1170;
        int height = 800;
        int winPosX = -1;
        int winPosY = -1;
        int divLoc = -1;
        width = conf.getIntProperty("DemoClient.size.width", width);
        height = conf.getIntProperty("DemoClient.size.height", height);
        winPosX = conf.getIntProperty("DemoClient.size.pos.x", winPosX);
        winPosY = conf.getIntProperty("DemoClient.size.pos.y", winPosY);
        divLoc = conf.getIntProperty("DemoClient.splitPane.location", divLoc);
        width = conf.getIntProperty(PROPKEY_APP_PREFIX + screenResStr + ".size.width", width);
        height = conf.getIntProperty(PROPKEY_APP_PREFIX + screenResStr + ".size.height", height);
        winPosX = conf.getIntProperty(PROPKEY_APP_PREFIX + screenResStr + ".size.pos.x", winPosX);
        winPosY = conf.getIntProperty(PROPKEY_APP_PREFIX + screenResStr + ".size.pos.y", winPosY);
        divLoc = conf.getIntProperty(PROPKEY_APP_PREFIX + screenResStr + ".splitPane.location", divLoc);
        this.openTheWindow(width, height, winPosX, winPosY, divLoc);
    }

    public void openTheWindow(int width, int height, int winPosX, int winPosY, int dividerLocation) {
        if (width >= 0 && height >= 0) {
            this._window.setSize(width, height);
        }
        if (winPosX == -1 && winPosY == -1) {
            _logger.debug((Object)"Open window in center of screen.");
            Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            Dimension frameSize = this._window.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this._window.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        } else if (!SwingUtils.isOutOfScreen(winPosX, winPosY, width, height)) {
            _logger.debug((Object)"Open main window in last known position.");
            this._window.setLocation(winPosX, winPosY);
        }
        if (dividerLocation >= 0) {
            this._splitPane.setDividerLocation(dividerLocation);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DemoApp.this.setVisible(true);
                _logger.debug((Object)"openTheWindowAsThread() AFTER... tread is terminating...");
            }
        });
    }

    private void close() {
        if (this._conn != null) {
            try {
                this._conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this._conn = null;
    }

    protected void finalize() {
        this.close();
    }

    private void doDummySelect() throws SQLException {
        if (this._conn == null) {
            return;
        }
        String sql = "select 1";
        if (DbUtils.isProductName(this._connectedToProductName, "Oracle")) {
            sql = "select 1 from DUAL";
        } else if (DbUtils.isProductName(this._connectedToProductName, "DB2/Linux")) {
            sql = "select 1 from SYSIBM.SYSDUMMY1";
        } else if (DbUtils.isProductName(this._connectedToProductName, "HDB")) {
            sql = "select 1 from DUMMY";
        }
        try {
            Statement stmnt = this._conn.createStatement();
            ResultSet rs = stmnt.executeQuery(sql);
            while (rs.next()) {
            }
            rs.close();
            stmnt.close();
        }
        catch (SQLException ex) {
            _logger.error((Object)("Problem checking if connection is alive, SQL Statement executed '" + sql + "'. Caught: " + ex));
            throw ex;
        }
    }

    private void getServerSideConfiguration() {
        try {
            SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call get_demoapp_property(?, ?, ?)}");
            stmnt.addParam(SqlStatementParam.createInParam("propname", 12, "use_package_variables"));
            stmnt.addParam(SqlStatementParam.createOutParam("int_value", 4));
            stmnt.addParam(SqlStatementParam.createOutParam("str_value", 12));
            stmnt.execute(this, null);
            String strValue = (String)stmnt.getParameterValue("str_value");
            Integer intValue = (Integer)stmnt.getParameterValue("int_value");
            _logger.debug((Object)("getServerSideConfiguration(use_package_variables): strValue='" + strValue + "', intValue=" + intValue));
            boolean usePkgVariables = intValue == null ? true : intValue > 0;
            _logger.info((Object)("getServerSideConfiguration('use_package_variables') = " + usePkgVariables));
            SqlStatement.setUsePkgVariables(usePkgVariables);
        }
        catch (SQLException ex) {
            _logger.warn((Object)("Problems getting get_demoapp_property('use_package_variables') Setting use_package_variables to FALSE. Caught: " + ex));
            SqlStatement.setUsePkgVariables(false);
        }
    }

    private void onConnect() {
        this.getServerSideConfiguration();
        this._publishersPanel.onConnect();
        this._authorsPanel.onConnect();
        this._titles.onConnect();
        this._stores.onConnect();
        this._ordersPanel.onConnect();
        this._statistics.onConnect();
        String selectedTab = this._tabPane.getSelectedTitle(false);
        if (TAB_AUTHORS.equals(selectedTab)) {
            this._authorsPanel.onTabSelected();
        } else if (TAB_TITLES.equals(selectedTab)) {
            this._titles.onTabSelected();
        } else if (TAB_PUBLISHERS.equals(selectedTab)) {
            this._publishersPanel.onTabSelected();
        } else if (TAB_STORES.equals(selectedTab)) {
            this._stores.onTabSelected();
        } else if (TAB_ORDERS.equals(selectedTab)) {
            this._ordersPanel.onTabSelected();
        } else if (TAB_STATS.equals(selectedTab)) {
            this._statistics.onTabSelected();
        }
    }

    private void onDisconnect() {
        this._publishersPanel.onDisconnect();
        this._authorsPanel.onDisconnect();
        this._titles.onDisconnect();
        this._stores.onDisconnect();
        this._ordersPanel.onDisconnect();
        this._statistics.onDisconnect();
    }

    private void onLostConnection() {
        this.action_disconnect(null);
        this.setComponentVisibility();
        this.setWatermark();
    }

    public void setWatermark() {
        if (this._conn == null) {
            this.setWatermarkText(NOT_CONNECTED_STR);
        } else if (this._aseConnectionStateInfo != null && (this._aseConnectionStateInfo._tranCount > 0 || this._aseConnectionStateInfo.isNonNormalTranState())) {
            boolean showExtendedErrorInfo = Configuration.getCombinedConfiguration().getBooleanProperty(PROPKEY_showExtErrInfo, true);
            String str = null;
            if (showExtendedErrorInfo) {
                if (this._aseConnectionStateInfo._tranChained == 1) {
                    if (this._aseConnectionStateInfo._lockCount > 0) {
                        str = "You are in CHAINED MODE (AutoCommit=false)\nAnd you are holding " + this._aseConnectionStateInfo._lockCount + " locks in the server\nDon't forget to commit or rollback!";
                    }
                } else {
                    str = this._aseConnectionStateInfo.isTranStateUsed() ? this._aseConnectionStateInfo.getTranStateDescription() + "\n@@trancount = " + this._aseConnectionStateInfo._tranCount + ", @@tranchained = " + this._aseConnectionStateInfo._tranChained : "@@trancount = " + this._aseConnectionStateInfo._tranCount + ", @@tranchained = " + this._aseConnectionStateInfo._tranChained;
                }
            }
            this.setWatermarkText(str);
        } else {
            this.setWatermarkText(null);
        }
    }

    public void setWatermarkText(String str) {
        if (this._watermark != null) {
            this._watermark.setWatermarkText(str);
        }
    }

    public void setWatermarkAnchor(JComponent comp) {
        this._watermark = new Watermark(comp, "");
    }

    private static void printHelp(Options options, String errorStr) {
    }

    private static synchronized Options buildCommandLineOptions() {
        Options options = new Options();
        return options;
    }

    private static CommandLine parseCommandLine(String[] args, Options options) throws ParseException {
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        if (_logger.isDebugEnabled()) {
            for (Option opt : cmd) {
                _logger.debug((Object)("parseCommandLine: swith='" + opt.getOpt() + "', value='" + opt.getValue() + "'."));
            }
        }
        return cmd;
    }

    public static void main(String[] args) {
        Options options = DemoApp.buildCommandLineOptions();
        try {
            CommandLine cmd = DemoApp.parseCommandLine(args, options);
            if (cmd.hasOption("help")) {
                DemoApp.printHelp(options, "The option '--help' was passed.");
            } else if (cmd.hasOption("version")) {
                System.out.println();
                System.out.println(Version.getAppName() + " Version: " + Version.getVersionStr() + " JVM: " + System.getProperty("java.version"));
                System.out.println();
            } else if (cmd.getArgs() != null && cmd.getArgs().length > 0) {
                String error = "Unknown options: " + StringUtil.toCommaStr(cmd.getArgs());
                DemoApp.printHelp(options, error);
            } else {
                new DemoApp(cmd);
            }
        }
        catch (ParseException pe) {
            String error = "Error: " + pe.getMessage();
            DemoApp.printHelp(options, error);
        }
        catch (NormalExitException pe) {
        }
        catch (Exception e) {
            System.out.println();
            System.out.println("Error: " + e.getMessage());
            System.out.println();
            System.out.println("Printing a stacktrace, where the error occurred.");
            System.out.println("--------------------------------------------------------------------");
            e.printStackTrace();
            System.out.println("--------------------------------------------------------------------");
        }
    }

    private class Watermark
    extends AbstractComponentDecorator {
        private String[] _textBr;
        private String _textSave;
        private Graphics2D g;
        private Rectangle r;

        public Watermark(JComponent target, String text) {
            super(target);
            this._textBr = null;
            this._textSave = null;
            this.g = null;
            this.r = null;
            if (text == null) {
                text = "";
            }
            this._textSave = text;
            this._textBr = text.split("\n");
        }

        @Override
        public void paint(Graphics graphics) {
            if (this._textBr == null || this._textBr != null && this._textBr.length < 0) {
                return;
            }
            this.r = this.getDecorationBounds();
            this.g = (Graphics2D)graphics;
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font f = this.g.getFont();
            this.g.setFont(f.deriveFont(1, (float)f.getSize() * 1.5f));
            this.g.setColor(new Color(128, 128, 128, 128));
            FontMetrics fm = this.g.getFontMetrics();
            int maxStrWidth = 0;
            int maxStrHeight = fm.getHeight();
            for (int i = 0; i < this._textBr.length; ++i) {
                int CurLineStrWidth = fm.stringWidth(this._textBr[i]);
                maxStrWidth = Math.max(maxStrWidth, CurLineStrWidth);
            }
            int xPos = (this.r.width - maxStrWidth) / 2;
            int yPos = (int)((double)this.r.height - (double)((this.r.height - fm.getHeight()) / 2) * 1.3);
            for (int i = 0; i < this._textBr.length; ++i) {
                this.g.drawString(this._textBr[i], xPos, yPos + maxStrHeight * i);
            }
        }

        public void setWatermarkText(String text) {
            if (text == null) {
                text = "";
            }
            if (text.equals(this._textSave)) {
                return;
            }
            this._textSave = text;
            this._textBr = text.split("\n");
            _logger.debug((Object)("setWatermarkText: to '" + text + "'."));
            this.repaint();
        }
    }
}

