/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.DataPanelAbstract;
import com.sap.dbmtk.demo.ui.GTable;
import com.sap.dbmtk.demo.ui.ResultSetTableModel;
import com.sap.dbmtk.demo.ui.focusabletip.FocusableTip;
import com.sap.dbmtk.demo.utils.Configuration;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.swing.JComponent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.StringValue;

public class ResultSetTable
extends GTable {
    private static final long serialVersionUID = 1L;
    private boolean _tabHeader_useFocusableTips = true;
    private boolean _cellContent_useFocusableTips = true;
    private FocusableTip _focusableTip = null;
    private DataPanelAbstract _dataPanel = null;
    private static final Color NULL_VALUE_COLOR = new Color(240, 240, 240);

    public ResultSetTable(DataPanelAbstract dataPanel) {
        String timeFormat;
        String dateFormat;
        this._dataPanel = dataPanel;
        this.setDefaultRenderer(BigDecimal.class, null);
        final String timestampFormat = Configuration.getCombinedConfiguration().getProperty("ResultSetTable.cellRenderer.format.Timestamp");
        if (timestampFormat != null) {
            StringValue sv = new StringValue(){
                DateFormat df;
                {
                    this.df = new SimpleDateFormat(timestampFormat);
                }

                public String getString(Object value) {
                    return this.df.format(value);
                }
            };
            this.setDefaultRenderer(Timestamp.class, (TableCellRenderer)new DefaultTableRenderer(sv));
        }
        if ((dateFormat = Configuration.getCombinedConfiguration().getProperty("ResultSetTable.cellRenderer.format.Date")) != null) {
            StringValue sv = new StringValue(){
                DateFormat df;
                {
                    this.df = new SimpleDateFormat(dateFormat);
                }

                public String getString(Object value) {
                    return this.df.format(value);
                }
            };
            this.setDefaultRenderer(Date.class, (TableCellRenderer)new DefaultTableRenderer(sv));
        }
        if ((timeFormat = Configuration.getCombinedConfiguration().getProperty("ResultSetTable.cellRenderer.format.Time")) != null) {
            StringValue sv = new StringValue(){
                DateFormat df;
                {
                    this.df = new SimpleDateFormat(timeFormat);
                }

                public String getString(Object value) {
                    return this.df.format(value);
                }
            };
            this.setDefaultRenderer(Time.class, (TableCellRenderer)new DefaultTableRenderer(sv));
        }
        this.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                String cellValue = adapter.getString();
                if (cellValue == null || "(NULL)".equals(cellValue)) {
                    return true;
                }
                int mcol = adapter.convertColumnIndexToModel(adapter.column);
                String colName = adapter.getColumnName(mcol);
                return mcol == 0 && "row#".equals(colName);
            }
        }, NULL_VALUE_COLOR, null));
    }

    public Class<?> getColumnClass(int column) {
        if (this.getRowCount() == 0) {
            return Object.class;
        }
        Object o = this.getValueAt(0, column);
        Class clazz = o != null ? o.getClass() : Object.class;
        return clazz;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JXTableHeader(this.getColumnModel()){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.getColumnModel().getColumnIndexAtX(p.x);
                if (index < 0) {
                    return null;
                }
                TableModel tm = ResultSetTable.this.getModel();
                if (tm instanceof ResultSetTableModel) {
                    ResultSetTableModel rstm = (ResultSetTableModel)tm;
                    String tooltip = rstm.getToolTipTextForTableHeader(index);
                    if (ResultSetTable.this._tabHeader_useFocusableTips) {
                        if (tooltip != null) {
                            if (ResultSetTable.this._focusableTip == null) {
                                ResultSetTable.this._focusableTip = new FocusableTip((JComponent)((Object)this));
                            }
                            ResultSetTable.this._focusableTip.toolTipRequested(e, tooltip);
                        } else if (ResultSetTable.this._focusableTip != null) {
                            ResultSetTable.this._focusableTip.possiblyDisposeOfTipWindow();
                        }
                        return null;
                    }
                    return tooltip;
                }
                return null;
            }
        };
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String tooltip = null;
        Point p = e.getPoint();
        int vrow = this.rowAtPoint(p);
        int vcol = this.columnAtPoint(p);
        if (vrow >= 0 && vcol >= 0) {
            int mcol = super.convertColumnIndexToModel(vcol);
            int mrow = super.convertRowIndexToModel(vrow);
            TableModel tm = this.getModel();
            if (tm instanceof ResultSetTableModel) {
                ResultSetTableModel rstm = (ResultSetTableModel)tm;
                tooltip = this._dataPanel.getTableToolTipText(rstm, mrow, mcol);
                if (this._cellContent_useFocusableTips) {
                    if (tooltip != null) {
                        if (this._focusableTip == null) {
                            this._focusableTip = new FocusableTip((JComponent)((Object)this));
                        }
                        this._focusableTip.toolTipRequested(e, tooltip);
                    } else if (this._focusableTip != null) {
                        this._focusableTip.possiblyDisposeOfTipWindow();
                    }
                    return null;
                }
                return tooltip;
            }
        }
        return tooltip;
    }
}

