/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.ConnectionProvider;
import com.sap.dbmtk.demo.SqlStatement;
import com.sap.dbmtk.demo.ui.ClickListener;
import com.sap.dbmtk.demo.ui.GTable;
import com.sap.dbmtk.demo.ui.ResultSetTableModel;
import com.sap.dbmtk.demo.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SortOrder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.sort.RowFilters;

public class SqlPickList
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Window _owner = null;
    private SqlStatement _sqlStatement = null;
    private ConnectionProvider _connProvider = null;
    protected JLabel _filter_lbl = new JLabel("Filter: ");
    protected JTextField _filter_txt = new JTextField();
    protected JLabel _filter_cnt = new JLabel();
    private SqlPickListTable _tab = null;
    private ResultSetTableModel _rstm = null;
    private String _name = null;
    private JButton _ok = new JButton("OK");
    private JButton _cancel = new JButton("Cancel");
    private boolean _okWasPressed = false;

    public SqlPickList(Window owner, ConnectionProvider connProvider, SqlStatement sqlStatement, String name) {
        super(owner, "Pick List", Dialog.ModalityType.APPLICATION_MODAL);
        this._owner = owner;
        this._connProvider = connProvider;
        this._sqlStatement = sqlStatement;
        this._name = name;
        this.pinit();
        this.execute();
        this.pack();
        this.applyFilter();
        SwingUtils.installEscapeButton(this, this._cancel);
        this.setLocationRelativeTo(owner);
    }

    private void pinit() {
        this.setLayout((LayoutManager)new MigLayout());
        String desc = "<html><b>Pick a rows from the below table</b><br>Double click or press 'OK' to close the list.<br></html>";
        this._filter_txt.setToolTipText("Client filter, that does regular expression on all table cells using this value");
        this._filter_cnt.setToolTipText("Visible rows / actual rows in the GUI Table");
        this.add((Component)new JLabel(desc), "growx, pushx, wrap");
        this.add((Component)this._filter_lbl, "split");
        this.add((Component)this._filter_txt, "growx, pushx");
        this.add((Component)this._filter_cnt, "wrap");
        this.add((Component)this.createTabPanel(), "grow, push, wrap");
        this.add((Component)this.createOkCancelPanel(), "growx, pushx, tag right, wrap");
        this._filter_txt.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                SqlPickList.this.applyFilter();
            }
        });
        this._ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SqlPickList.this._okWasPressed = true;
                SqlPickList.this.setVisible(false);
            }
        });
        this._cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SqlPickList.this._okWasPressed = false;
                SqlPickList.this.setVisible(false);
            }
        });
    }

    private JPanel createOkCancelPanel() {
        JPanel p = new JPanel((LayoutManager)new MigLayout());
        p.add((Component)new JLabel(), "split, span, growx, pushx");
        p.add((Component)this._ok, "tag ok");
        p.add((Component)this._cancel, "tag cancel");
        return p;
    }

    private JPanel createTabPanel() {
        this._tab = new SqlPickListTable(this._name);
        JPanel p = new JPanel((LayoutManager)new MigLayout("insets 0 0 0 0"));
        p.add((Component)new JScrollPane((Component)((Object)this._tab)), "grow, push");
        return p;
    }

    public void applyFilter() {
        String searchString = this._filter_txt.getText().trim();
        if (searchString.length() <= 0) {
            this._tab.setRowFilter(null);
        } else {
            int[] mcols = new int[this._tab.getColumnCount()];
            for (int i = 0; i < mcols.length; ++i) {
                mcols[i] = this._tab.convertColumnIndexToModel(i);
            }
            this._tab.setRowFilter(RowFilters.regexFilter((int)2, (String)(searchString + ".*"), (int[])mcols));
        }
        String rowc = this._tab.getRowCount() + "/" + this._tab.getModel().getRowCount();
        this._filter_cnt.setText(rowc);
    }

    public int execute() {
        try {
            this._sqlStatement.executeWithGuiProgress(this._connProvider, this.getOwner());
            if (this._sqlStatement.getResultSetCount() == 0) {
                throw new Exception("No ResultSet was produced by the SQL Statement.");
            }
            this._rstm = this._sqlStatement.getResultSet(0);
            this._tab.setModel(this._rstm);
            this._tab.packAll();
            SqlStatement.showWarningMessages(this._connProvider, this._owner, "Warning messages from db for: " + this.getName());
            if (this._rstm.getRowCount() > 0) {
                this._tab.getSelectionModel().setSelectionInterval(0, 0);
            }
            return this._rstm.getRowCount();
        }
        catch (Exception ex) {
            SqlStatement.showErrorMessage(ex, this._sqlStatement, this._owner, "Getting " + this.getName() + " information <b>failed.</b>");
            return -1;
        }
    }

    public boolean wasOkPressed() {
        return this._okWasPressed;
    }

    public int getSelectedRow() {
        return this._tab.getSelectedRow();
    }

    public int getRowCount() {
        return this._tab.getRowCount();
    }

    public BigDecimal getSelectedValuesAsBigDecimal(String colName) {
        return this._tab.getSelectedValuesAsBigDecimal(colName, false);
    }

    public Integer getSelectedValuesAsInteger(String colName) {
        return this._tab.getSelectedValuesAsInteger(colName, false);
    }

    public Long getSelectedValuesAsLong(String colName) {
        return this._tab.getSelectedValuesAsLong(colName, false);
    }

    public Object getSelectedValuesAsObject(String colName) {
        return this._tab.getSelectedValuesAsObject(colName, false);
    }

    public Short getSelectedValuesAsShort(String colName) {
        return this._tab.getSelectedValuesAsShort(colName, false);
    }

    public String getSelectedValuesAsString(String colName) {
        return this._tab.getSelectedValuesAsString(colName, false);
    }

    public Timestamp getSelectedValuesAsTimestamp(String colName) {
        return this._tab.getSelectedValuesAsTimestamp(colName, false);
    }

    private class SqlPickListTable
    extends GTable {
        private static final long serialVersionUID = 1L;

        public SqlPickListTable(String name) {
            this.setDefaultRenderer(BigDecimal.class, null);
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    boolean enable = SqlPickListTable.this.getSelectedRowCount() == 1;
                    SqlPickList.this._ok.setEnabled(enable);
                    SqlPickList.this._ok.setEnabled(enable);
                }
            });
            this.addMouseListener(new ClickListener(){

                @Override
                public void doubleClick(MouseEvent e) {
                    Point p = e.getPoint();
                    int vrow = SqlPickListTable.this.rowAtPoint(p);
                    if (vrow >= 0) {
                        SqlPickList.this._ok.setEnabled(true);
                        SqlPickListTable.this.getSelectionModel().setSelectionInterval(vrow, vrow);
                        SqlPickList.this._ok.doClick();
                    }
                }
            });
            this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "SELECT_CURRENT_ROW");
            this.getActionMap().put("SELECT_CURRENT_ROW", new AbstractAction("SELECT_CURRENT_ROW"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SqlPickList.this._ok.doClick();
                }
            });
            this.setName(name);
            this.setSortable(true);
            this.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
            this.packAll();
            this.setColumnControlVisible(true);
            this.setSelectionMode(0);
            this.setAutoResizeMode(0);
        }
    }
}

