/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.ConnectionProvider;
import com.sap.dbmtk.demo.DbMessage;
import com.sap.dbmtk.demo.DbMessageAsePrint;
import com.sap.dbmtk.demo.DbMessageDbmsOutput;
import com.sap.dbmtk.demo.SqlStatementParam;
import com.sap.dbmtk.demo.SqlTraceWindow;
import com.sap.dbmtk.demo.ui.ResultSetTableModel;
import com.sap.dbmtk.demo.ui.SqlProgressDialog;
import com.sap.dbmtk.demo.utils.Configuration;
import com.sap.dbmtk.demo.utils.DbUtils;
import com.sap.dbmtk.demo.utils.SwingUtils;
import com.sybase.jdbcx.EedInfo;
import java.awt.Window;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class SqlStatement {
    private static Logger _logger = Logger.getLogger(SqlStatement.class);
    public static final String PROPKEY_EXEC_WAITFOR_POPUP_GRACETIME = "SqlStatement.exec.waitfor.popup.gracetime";
    public static final int DEFAULT_EXEC_WAITFOR_POPUP_GRACETIME = 1000;
    public static final String PROPKEY_USE_PKG_VARIABLES = "SqlStatement.usePkgVariables";
    public static final boolean DEFAULT_USE_PKG_VARIABLES = true;
    public static boolean _staticUsePkgVariables = true;
    private String _sql = null;
    private String _sqlLastUsed = null;
    private Type _type = null;
    private List<SqlStatementParam> _params = null;
    private List<ResultSetTableModel> _rstmList = new ArrayList<ResultSetTableModel>();
    private int _rowCount = 0;
    private int _execWaitforPopupGracetimeInMs = Configuration.getCombinedConfiguration().getIntProperty("SqlStatement.exec.waitfor.popup.gracetime", 1000);
    private boolean _usePkgVariables = Configuration.getCombinedConfiguration().getBooleanProperty("SqlStatement.usePkgVariables", _staticUsePkgVariables);

    public static void setUsePkgVariables(boolean toVal) {
        _staticUsePkgVariables = toVal;
    }

    public static boolean setUsePkgVariables() {
        return _staticUsePkgVariables;
    }

    public SqlStatement(Type type, String sql) {
        this(type, sql, null);
    }

    public SqlStatement(Type type, String sql, List<SqlStatementParam> params) {
        this._type = type;
        this._sql = sql;
        this._params = params;
    }

    public Type getType() {
        return this._type;
    }

    public String getSql() {
        return this._sql;
    }

    private String getSql(Connection conn) {
        String sql = this.sqlSubstitution(conn, this._sql);
        _logger.debug((Object)("getSql(conn): fixedSql=|" + sql + "|."));
        this._sqlLastUsed = sql;
        return sql;
    }

    public String getSqlLastUsed() {
        return this._sqlLastUsed;
    }

    private String sqlSubstitution(Connection conn, String inputSql) {
        String val = inputSql;
        _logger.debug((Object)("sqlSubstitution(): INPUT: inputSql='" + val + "'."));
        Pattern compiledRegex = Pattern.compile("\\$\\{.+\\}");
        while (compiledRegex.matcher(val).find()) {
            String varStr;
            String varVal = null;
            String varName = varStr = val.substring(val.indexOf("${") + 2, val.indexOf("}"));
            String varModifier = "";
            if (varStr.indexOf(58) >= 0) {
                int firstColon = varStr.indexOf(58);
                varName = varStr.substring(0, firstColon);
                varModifier = varStr.substring(firstColon + 1);
            }
            _logger.debug((Object)("sqlSubstitution(): varName='" + varName + "', varModifyer='" + varModifier + "'."));
            if ("PKG".equals(varName)) {
                varVal = "";
                if (varModifier != null) {
                    boolean isOracle = this.isOracle(conn);
                    varVal = isOracle ? varModifier + "." : varModifier + "__";
                }
                if (!this._usePkgVariables) {
                    _logger.info((Object)("Found PACKAGE variable '${" + varStr + "}' but Package Variable substritution is DISABLED, so this will simply be removed."));
                    varVal = "";
                }
            } else {
                _logger.warn((Object)("sqlSubstitution(): WARNING: Unknown variable '" + varName + "', simply removing it from the output."));
                varVal = "";
            }
            _logger.debug((Object)("sqlSubstitution(): Substituting varName '${" + varStr + "}' with value '" + varVal + "'."));
            val = val.replace("${" + varStr + "}", varVal);
        }
        _logger.debug((Object)("sqlSubstitution(): AFTER: val='" + val + "'."));
        return val;
    }

    public void addParam(SqlStatementParam val) {
        if (this._params == null) {
            this._params = new ArrayList<SqlStatementParam>();
        }
        this._params.add(val);
    }

    public List<SqlStatementParam> getParams() {
        if (this._params == null) {
            return Collections.emptyList();
        }
        return this._params;
    }

    public ResultSet executeQuery(ConnectionProvider connProvider) throws SQLException {
        Connection conn = connProvider.getConnection();
        String sql = this.getSql(conn);
        Statement stmnt = null;
        PreparedStatement pstmnt = null;
        CallableStatement cstmnt = null;
        if (Type.LANGUAGE.equals((Object)this.getType())) {
            stmnt = conn.createStatement();
        } else if (Type.PREPARED.equals((Object)this.getType())) {
            pstmnt = conn.prepareStatement(sql);
        } else if (Type.CALLABLE.equals((Object)this.getType())) {
            sql = this.fixSqlParams(this.getParams(), sql, this.isOracle(conn));
            cstmnt = conn.prepareCall(sql);
        }
        SqlTraceWindow.getInstance().addSql(sql);
        SqlTraceWindow.getInstance().startTimer();
        this.setParameters(pstmnt, cstmnt);
        SqlStatement.putWarningMessages(connProvider, this.getFirstNotNull(stmnt, pstmnt, cstmnt), null);
        ResultSet rs = null;
        if (Type.LANGUAGE.equals((Object)this.getType())) {
            rs = stmnt.executeQuery(sql);
        } else if (Type.PREPARED.equals((Object)this.getType())) {
            rs = pstmnt.executeQuery();
        } else if (Type.CALLABLE.equals((Object)this.getType())) {
            if (this.isOracle(conn)) {
                cstmnt.execute();
            } else {
                rs = cstmnt.executeQuery();
            }
        }
        SqlStatement.putWarningMessages(connProvider, this.getFirstNotNull(stmnt, pstmnt, cstmnt), null);
        int p = 0;
        for (SqlStatementParam param : this.getParams()) {
            ++p;
            if (param.isOracleRsParam()) {
                ResultSet rsParam = (ResultSet)cstmnt.getObject(p);
                if (rs == null) {
                    rs = rsParam;
                }
                param.setOutputParamValue(rsParam);
                SqlTraceWindow.getInstance().addParamAfterExec(p, param);
                continue;
            }
            if (!param.isOutput()) continue;
            param.setOutputParamValue(cstmnt.getObject(p));
            SqlTraceWindow.getInstance().addParamAfterExec(p, param);
        }
        SqlStatement.putWarningMessages(connProvider, this.getFirstNotNull(stmnt, pstmnt, cstmnt), rs);
        SqlTraceWindow.getInstance().reportTime("executeQuery() no ResultSet yet read");
        return rs;
    }

    public int executeUpdate(ConnectionProvider connProvider) throws SQLException {
        Connection conn = connProvider.getConnection();
        String sql = this.getSql(conn);
        Statement stmnt = null;
        PreparedStatement pstmnt = null;
        CallableStatement cstmnt = null;
        if (Type.LANGUAGE.equals((Object)this.getType())) {
            stmnt = conn.createStatement();
        } else if (Type.PREPARED.equals((Object)this.getType())) {
            pstmnt = conn.prepareStatement(sql);
        } else if (Type.CALLABLE.equals((Object)this.getType())) {
            sql = this.fixSqlParams(this.getParams(), sql, this.isOracle(conn));
            cstmnt = conn.prepareCall(sql);
        }
        SqlTraceWindow.getInstance().addSql(sql);
        SqlTraceWindow.getInstance().startTimer();
        this.setParameters(pstmnt, cstmnt);
        SqlStatement.putWarningMessages(connProvider, this.getFirstNotNull(stmnt, pstmnt, cstmnt), null);
        int rowc = -1;
        if (Type.LANGUAGE.equals((Object)this.getType())) {
            rowc = stmnt.executeUpdate(sql);
        } else if (Type.PREPARED.equals((Object)this.getType())) {
            rowc = pstmnt.executeUpdate();
        } else if (Type.CALLABLE.equals((Object)this.getType())) {
            rowc = cstmnt.executeUpdate();
        }
        SqlStatement.putWarningMessages(connProvider, this.getFirstNotNull(stmnt, pstmnt, cstmnt), null);
        SqlTraceWindow.getInstance().addRowcount(rowc);
        int p = 0;
        for (SqlStatementParam param : this.getParams()) {
            ++p;
            if (param.isOracleRsParam()) {
                ResultSet rsParam = (ResultSet)cstmnt.getObject(p);
                param.setOutputParamValue(rsParam);
                SqlTraceWindow.getInstance().addParamAfterExec(p, param);
                continue;
            }
            if (!param.isOutput()) continue;
            param.setOutputParamValue(cstmnt.getObject(p));
            SqlTraceWindow.getInstance().addParamAfterExec(p, param);
        }
        SqlStatement.putWarningMessages(connProvider, this.getFirstNotNull(stmnt, pstmnt, cstmnt), null);
        SqlTraceWindow.getInstance().reportTime("executeUpdate()");
        return rowc;
    }

    public boolean execute(ConnectionProvider connProvider, Window owner, String shortMessageOnErrors) {
        try {
            this.executeWithGuiProgress(connProvider, owner);
            if (!connProvider.isAutoCommitEnabledAtConnect()) {
                connProvider.getConnection().commit();
            }
            SqlStatement.putWarningMessages(connProvider, null, null);
            return true;
        }
        catch (SQLException e) {
            if (!connProvider.isAutoCommitEnabledAtConnect()) {
                try {
                    connProvider.getConnection().rollback();
                }
                catch (SQLException ex2) {
                    e.setNextException(ex2);
                }
            }
            SqlStatement.showErrorMessage(e, this, owner, shortMessageOnErrors);
            return false;
        }
    }

    public void executeWithGuiProgress(final ConnectionProvider connProvider, Window owner) throws SQLException {
        Connection conn = connProvider.getConnection();
        String sql = this.getSql(conn);
        StringBuilder sb = new StringBuilder();
        sb.append(sql).append("\n");
        List<SqlStatementParam> params = this.getParams();
        if (params != null) {
            int p = 0;
            for (SqlStatementParam param : params) {
                sb.append("-- ").append(++p).append(": ").append(param).append("\n");
            }
        }
        final SqlProgressDialog progress = new SqlProgressDialog(owner, conn, sb.toString());
        SwingWorker<String, Object> doBgThread = new SwingWorker<String, Object>(){

            @Override
            protected String doInBackground() throws Exception {
                SqlStatement.this.execute(connProvider, progress);
                return null;
            }
        };
        doBgThread.addPropertyChangeListener(progress);
        doBgThread.execute();
        progress.waitForExec(doBgThread, this._execWaitforPopupGracetimeInMs);
        try {
            doBgThread.get();
        }
        catch (Throwable originEx) {
            Throwable ex = originEx;
            if (ex instanceof ExecutionException) {
                ex = ex.getCause();
            }
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            SwingUtils.showErrorMessage(owner, "Problems when executing Statement", "<html><h2>Problems when executing Statement</h2>" + sql + "</html>", originEx);
        }
    }

    public void execute(ConnectionProvider connProvider, SqlProgressDialog progress) throws SQLException {
        Connection conn = connProvider.getConnection();
        String sql = this.getSql(conn);
        Statement stmnt = null;
        PreparedStatement pstmnt = null;
        CallableStatement cstmnt = null;
        if (Type.LANGUAGE.equals((Object)this.getType())) {
            stmnt = conn.createStatement();
        } else if (Type.PREPARED.equals((Object)this.getType())) {
            pstmnt = conn.prepareStatement(sql);
        } else if (Type.CALLABLE.equals((Object)this.getType())) {
            sql = this.fixSqlParams(this.getParams(), sql, this.isOracle(conn));
            cstmnt = conn.prepareCall(sql);
        }
        SqlTraceWindow.getInstance().addSql(sql);
        SqlTraceWindow.getInstance().startTimer();
        this.setParameters(pstmnt, cstmnt);
        if (progress != null) {
            progress.setCurrentSqlText(sql, 0, 0);
        }
        SqlStatement.putWarningMessages(connProvider, this.getFirstNotNull(stmnt, pstmnt, cstmnt), null);
        boolean hasRs = false;
        if (Type.LANGUAGE.equals((Object)this.getType())) {
            hasRs = stmnt.execute(sql);
        } else if (Type.PREPARED.equals((Object)this.getType())) {
            hasRs = pstmnt.execute();
        } else if (Type.CALLABLE.equals((Object)this.getType())) {
            hasRs = cstmnt.execute();
        }
        SqlStatement.putWarningMessages(connProvider, this.getFirstNotNull(stmnt, pstmnt, cstmnt), null);
        int rowsAffected = 0;
        do {
            if (hasRs) {
                ResultSet rs = this.getFirstNotNull(stmnt, pstmnt, cstmnt).getResultSet();
                SqlStatement.putWarningMessages(connProvider, this.getFirstNotNull(stmnt, pstmnt, cstmnt), rs);
                this.addResultSet(rs, progress);
                SqlStatement.putWarningMessages(connProvider, this.getFirstNotNull(stmnt, pstmnt, cstmnt), rs);
                rs.close();
            } else {
                rowsAffected = this.getFirstNotNull(stmnt, pstmnt, cstmnt).getUpdateCount();
                SqlStatement.putWarningMessages(connProvider, this.getFirstNotNull(stmnt, pstmnt, cstmnt), null);
                if (rowsAffected >= 0) {
                    this._rowCount += rowsAffected;
                    this.addRowCount(this._rowCount);
                }
            }
            SqlStatement.putWarningMessages(connProvider, this.getFirstNotNull(stmnt, pstmnt, cstmnt), null);
            hasRs = this.getFirstNotNull(stmnt, pstmnt, cstmnt).getMoreResults();
            SqlStatement.putWarningMessages(connProvider, this.getFirstNotNull(stmnt, pstmnt, cstmnt), null);
        } while (hasRs || rowsAffected != -1);
        int p = 0;
        for (SqlStatementParam param : this.getParams()) {
            ++p;
            if (param.isOracleRsParam()) {
                ResultSet rs = (ResultSet)cstmnt.getObject(p);
                param.setOutputParamValue(this.addResultSet(rs, progress));
                rs.close();
                SqlTraceWindow.getInstance().addParamAfterExec(p, param);
                continue;
            }
            if (!param.isOutput()) continue;
            param.setOutputParamValue(cstmnt.getObject(p));
            SqlTraceWindow.getInstance().addParamAfterExec(p, param);
        }
        this.getFirstNotNull(stmnt, pstmnt, cstmnt).close();
        SqlTraceWindow.getInstance().reportTime("execute()");
    }

    private Statement getFirstNotNull(Statement stmnt, PreparedStatement pstmnt, CallableStatement cstmnt) {
        if (stmnt != null) {
            return stmnt;
        }
        if (pstmnt != null) {
            return pstmnt;
        }
        if (cstmnt != null) {
            return cstmnt;
        }
        throw new RuntimeException("No valid statement was found");
    }

    private String fixSqlParams(List<SqlStatementParam> params, String sql, boolean isOracle) {
        if (isOracle) {
            return sql;
        }
        if (params == null) {
            return sql;
        }
        ArrayList<SqlStatementParam> removeParams = new ArrayList<SqlStatementParam>();
        for (SqlStatementParam param : params) {
            if (!param.isOracleRsParam()) continue;
            removeParams.add(param);
        }
        if (removeParams.size() > 0) {
            for (int i = 0; i < removeParams.size(); ++i) {
                String newSql = sql.replaceFirst("\\s*\\?\\s*,?\\s*", "");
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Removing Question Mark " + i + ": before='" + sql + "', after='" + newSql + "'."));
                }
                sql = newSql;
            }
            params.removeAll(removeParams);
        }
        return sql;
    }

    private void setParameters(PreparedStatement pstmnt, CallableStatement cstmnt) throws SQLException {
        List<SqlStatementParam> params = this.getParams();
        if (params != null) {
            int p = 0;
            for (SqlStatementParam param : params) {
                SqlTraceWindow.getInstance().addParam(++p, param);
                if (pstmnt != null) {
                    if (param.getValue() == null) {
                        pstmnt.setNull(p, param.getSqlType());
                    } else if (param.getSqlType() == 2004) {
                        pstmnt.setBytes(p, (byte[])param.getValue());
                    } else if (param.getSqlType() == 2005) {
                        pstmnt.setString(p, (String)param.getValue());
                    } else if (param.getSqlType() == 2) {
                        pstmnt.setBigDecimal(p, (BigDecimal)param.getValue());
                    } else {
                        pstmnt.setObject(p, param.getValue(), param.getSqlType());
                    }
                }
                if (cstmnt == null) continue;
                if (param.isInput()) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("cstmnt.setObject(): IN: p=" + p + ", value='" + param.getValue() + "', sqlType=" + ResultSetTableModel.getColumnJavaSqlTypeName(param.getSqlType())));
                    }
                    if (param.getValue() == null) {
                        cstmnt.setNull(p, param.getSqlType());
                        continue;
                    }
                    if (param.getSqlType() == 2004) {
                        cstmnt.setBytes(p, (byte[])param.getValue());
                        continue;
                    }
                    if (param.getSqlType() == 2005) {
                        cstmnt.setString(p, (String)param.getValue());
                        continue;
                    }
                    if (param.getSqlType() == 2) {
                        cstmnt.setBigDecimal(p, (BigDecimal)param.getValue());
                        continue;
                    }
                    cstmnt.setObject(p, param.getValue(), param.getSqlType());
                    continue;
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("cstmnt.registerOutParameter(): OUT: p=" + p + ", sqlType=" + ResultSetTableModel.getColumnJavaSqlTypeName(param.getSqlType())));
                }
                cstmnt.registerOutParameter(p, param.getSqlType());
            }
        }
    }

    private boolean isOracle(Connection conn) {
        try {
            DatabaseMetaData md = conn.getMetaData();
            String dbmsProductName = md.getDatabaseProductName();
            boolean isOracle = DbUtils.isProductName(dbmsProductName, "Oracle");
            SqlTraceWindow.getInstance().setDatabaseProductName(dbmsProductName);
            return isOracle;
        }
        catch (SQLException e) {
            _logger.warn((Object)"Problems checking if we are connected to Oracle or some other DBMS System");
            return false;
        }
    }

    public Object getParameterValue(String name) {
        for (SqlStatementParam p : this.getParams()) {
            if (!name.equals(p.getParamName())) continue;
            return p.getValue();
        }
        return null;
    }

    public int getRowCount() {
        int rstmRowCount = 0;
        for (ResultSetTableModel rstm : this._rstmList) {
            rstmRowCount += rstm.getRowCount();
        }
        return this._rowCount + rstmRowCount;
    }

    private void addRowCount(int rowc) {
        this._rowCount += rowc;
        SqlTraceWindow.getInstance().addRowcount(rowc);
    }

    private ResultSetTableModel addResultSet(ResultSet rs, SqlProgressDialog progress) throws SQLException {
        if (progress != null) {
            progress.setState("Reading ResultSet.");
        }
        ResultSetTableModel rstm = new ResultSetTableModel(rs, false, this.getSql(), progress);
        this._rstmList.add(rstm);
        SqlTraceWindow.getInstance().addRowcount(rstm.getRowCount());
        return rstm;
    }

    public int getResultSetCount() {
        return this._rstmList.size();
    }

    public ResultSetTableModel getResultSet(int pos) {
        return this._rstmList.get(pos);
    }

    public List<ResultSetTableModel> getResultSetList() {
        return this._rstmList;
    }

    public static void dbmsOutput(Connection conn, boolean enable) {
        CallableStatement stmt;
        String product = DbUtils.getProductName(conn);
        if (DbUtils.isProductName(product, "Oracle", "DB2/Linux")) {
            if (enable) {
                try {
                    stmt = conn.prepareCall("{call dbms_output.enable(?) }");
                    int initSize = 1000000;
                    stmt.setInt(1, initSize);
                    stmt.execute();
                    _logger.info((Object)"ENABLING Oracle/DB2 DBMS_OUTPUT, suceeded");
                }
                catch (Exception e) {
                    _logger.warn((Object)("Problem occurred while trying to enable Oracle/DB2 DBMS_OUTPUT. Caught:" + e));
                }
            } else {
                try {
                    stmt = conn.prepareCall("{call dbms_output.disable }");
                    stmt.execute();
                    _logger.info((Object)"DISABLING Oracle DBMS_OUTPUT, suceeded");
                }
                catch (Exception e) {
                    _logger.warn((Object)("Problem occurred while trying to disable Oracle DBMS_OUTPUT. Caught:" + e));
                }
            }
        }
        if (DbUtils.isProductName(product, "Adaptive Server Enterprise", "SQL Anywhere", "Sybase IQ")) {
            if (enable) {
                try {
                    stmt = conn.prepareCall("{call xp_dbmtk_enable_buffered_output}");
                    stmt.execute();
                    _logger.info((Object)"ENABLING DBMTK Runtime Component for DBMS_OUTPUT emulation, suceeded");
                }
                catch (Exception e) {
                    _logger.warn((Object)("Problem occurred while trying to enable DBMTK Runtime Component for DBMS_OUTPUT emulation. Caught:" + e));
                }
            } else {
                try {
                    stmt = conn.prepareCall("{call xp_dbmtk_disable_buffered_output}");
                    stmt.execute();
                    _logger.info((Object)"DISABLING DBMTK Runtime Component for DBMS_OUTPUT emulation, suceeded");
                }
                catch (Exception e) {
                    _logger.warn((Object)("Problem occurred while trying to disable DBMTK Runtime Component for DBMS_OUTPUT emulation. Caught:" + e));
                }
            }
        }
    }

    public static String getDbmsOutput(ConnectionProvider connProvider) {
        String msg;
        int status;
        CallableStatement stmt;
        Connection conn = null;
        try {
            conn = connProvider.getConnection();
        }
        catch (SQLException notConnected) {
            return "";
        }
        String product = DbUtils.getProductName(conn);
        String result = "";
        if (DbUtils.isProductName(product, "Oracle", "DB2/Linux")) {
            try {
                stmt = conn.prepareCall("{call dbms_output.get_line(?,?)}");
                stmt.registerOutParameter(1, 12);
                stmt.registerOutParameter(2, 2);
                status = 0;
                do {
                    stmt.execute();
                    msg = stmt.getString(1);
                    status = stmt.getInt(2);
                    _logger.debug((Object)("Oracle/DB2 DBMS_OUTPUT.GET_LINE: status=" + status + ", msg='" + msg + "'."));
                    if (msg == null) continue;
                    result = result + "<i><font color=\"blue\">DBMS_OUTPUT.GET_LINE: </font></i>" + msg + "\n";
                    connProvider.addWarningMessage(new DbMessageDbmsOutput(msg, product));
                } while (status == 0);
                _logger.debug((Object)"End of Oracle/DB2 DBMS_OUTPUT!");
                stmt.close();
            }
            catch (Exception e) {
                _logger.warn((Object)("Problem occurred during dump of Oracle DBMS_OUTPUT. Caught: " + e));
            }
        }
        if (DbUtils.isProductName(product, "Adaptive Server Enterprise", "SQL Anywhere", "Sybase IQ")) {
            try {
                stmt = conn.prepareCall("{call xp_dbmtk_get_buffered_output(?,?)}");
                stmt.registerOutParameter(1, 12);
                stmt.registerOutParameter(2, 4);
                status = 0;
                do {
                    stmt.execute();
                    msg = stmt.getString(1);
                    status = stmt.getInt(2);
                    _logger.debug((Object)("DBMTK Runtime Component for DBMS_OUTPUT emulation xp_dbmtk_get_buffered_output: status=" + status + ", msg='" + msg + "'."));
                    if (msg == null) continue;
                    result = result + "<i><font color=\"blue\">DBMTK_GET_BUFFERED_OUTPUT: </font></i>" + msg + "\n";
                    connProvider.addWarningMessage(new DbMessageDbmsOutput(msg, product));
                } while (status == 0);
                _logger.debug((Object)"End of DBMTK Runtime Component for DBMS_OUTPUT.GET_LINE emulation using xp_dbmtk_get_buffered_output!");
                stmt.close();
            }
            catch (Exception e) {
                _logger.warn((Object)("Problem occurred during dump of DBMTK Runtime Component for DBMS_OUTPUT emulation. Caught: " + e));
            }
        }
        return result;
    }

    public static String getSqlMessages(SQLException sqe, List<DbMessage> list) {
        StringBuilder sbOut = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        while (sqe != null) {
            if (sqe instanceof EedInfo) {
                EedInfo eedi = (EedInfo)sqe;
                if (eedi.getSeverity() > 10) {
                    boolean firstOnLine = true;
                    sb.append("Msg " + sqe.getErrorCode() + ", Level " + eedi.getSeverity() + ", State " + eedi.getState() + ":\n");
                    if (eedi.getServerName() != null) {
                        sb.append("Server '" + eedi.getServerName() + "'");
                        firstOnLine = false;
                    }
                    if (eedi.getProcedureName() != null) {
                        sb.append((firstOnLine ? "" : ", ") + "Procedure '" + eedi.getProcedureName() + "'");
                        firstOnLine = false;
                    }
                    sb.append((firstOnLine ? "" : ", ") + "Line " + eedi.getLineNumber() + ", Status " + eedi.getStatus() + ", TranState " + eedi.getTranState() + ":\n");
                }
                String msg = sqe.getMessage();
                sb.append(msg);
                if (!msg.endsWith("\n")) {
                    sb.append("\n");
                }
            } else {
                String msg = sqe.getMessage();
                sb.append("ErrorCode ").append(sqe.getErrorCode()).append(", SQLState ").append(sqe.getSQLState()).append(", ExceptionClass: ").append(sqe.getClass().getName()).append("\n");
                sb.append(msg);
                if (!msg.endsWith("\n")) {
                    sb.append("\n");
                }
            }
            if (list != null) {
                list.add(new DbMessageAsePrint(sb.toString()));
            }
            sbOut.append((CharSequence)sb);
            sb.setLength(0);
            sqe = sqe.getNextException();
        }
        return sbOut.toString();
    }

    public static void showErrorMessage(Throwable ex, SqlStatement sqlStmnt, Window guiOwner, String headerText) {
        SqlTraceWindow.getInstance().addException(ex);
        String msg = null;
        if (ex instanceof SQLException) {
            msg = SqlStatement.getSqlMessages((SQLException)ex, null).replace("\n", "<br>");
        }
        String definedSql = null;
        String lastUsedSql = null;
        if (sqlStmnt != null) {
            definedSql = sqlStmnt.getSql();
            lastUsedSql = sqlStmnt.getSqlLastUsed();
        }
        if (definedSql == null) {
            String string = definedSql = sqlStmnt == null ? "SqlStmnt was NULL" : "null";
        }
        if (lastUsedSql == null) {
            lastUsedSql = sqlStmnt == null ? "SqlStmnt was NULL" : "null";
        }
        boolean showExtendedErrorInfo = Configuration.getCombinedConfiguration().getBooleanProperty("DemoClient.view.show.extended.error.info", true);
        String extendedErrorMsg = "";
        if (showExtendedErrorInfo) {
            extendedErrorMsg = definedSql.equals(lastUsedSql) ? (msg == null ? "" : "<br><b>Decoded SQL Message</b>: <br>" + msg) + "<br><b>SQL Statement executed</b>:<pre>" + lastUsedSql + "</pre>" : (msg == null ? "" : "<br><b>Decoded SQL Message</b>: <br>" + msg) + "<br><b>Defined SQL Statement</b>:<pre>" + definedSql + "</pre><br><b>SQL Statement executed</b>:<pre>" + lastUsedSql + "</pre>";
        }
        String htmlMsg = "<html>" + headerText + "<br><br><b>Exception</b>: <br>" + ex + "<br>" + extendedErrorMsg + "</html>";
        SwingUtils.showErrorMessage(guiOwner, "Problem", htmlMsg, ex);
        if (definedSql.equals(lastUsedSql)) {
            _logger.info((Object)("Problem when executing sql: " + definedSql));
        } else {
            _logger.info((Object)("Problem when executing sql: definedSql='" + definedSql + "', executedSql='" + lastUsedSql + "'."));
        }
    }

    public static void putWarningMessages(ConnectionProvider connProvider, Statement stmnt, ResultSet rs) {
        boolean showExtendedErrorInfo = Configuration.getCombinedConfiguration().getBooleanProperty("DemoClient.view.show.extended.error.info", true);
        if (!showExtendedErrorInfo) {
            return;
        }
        try {
            Connection conn = connProvider.getConnection();
            SqlStatement.getSqlMessages(conn.getWarnings(), connProvider.getWarningMessages(false));
            conn.clearWarnings();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (stmnt != null) {
            try {
                SqlStatement.getSqlMessages(stmnt.getWarnings(), connProvider.getWarningMessages(false));
                stmnt.clearWarnings();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (rs != null) {
            try {
                SqlStatement.getSqlMessages(rs.getWarnings(), connProvider.getWarningMessages(false));
                rs.clearWarnings();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void showWarningMessages(ConnectionProvider connProvider, Window guiOwner, String headerText) {
        List<DbMessage> warnList;
        StringBuilder sb = new StringBuilder();
        boolean showExtendedErrorInfo = Configuration.getCombinedConfiguration().getBooleanProperty("DemoClient.view.show.extended.error.info", true);
        if (!showExtendedErrorInfo) {
            return;
        }
        boolean dbmsOutputIsEnabled = Configuration.getCombinedConfiguration().getBooleanProperty("DemoClient.view.enable.dbms.output", true);
        if (dbmsOutputIsEnabled) {
            SqlStatement.getDbmsOutput(connProvider);
        }
        if ((warnList = connProvider.getWarningMessages(true)).isEmpty()) {
            return;
        }
        sb.append("<html>");
        sb.append(headerText).append("<br>");
        sb.append("<br>");
        sb.append("<b>Messages</b>: <br>");
        for (DbMessage dbm : warnList) {
            sb.append(dbm.toHtml());
            sb.append("<br>");
        }
        sb.append("</html>");
        SwingUtils.showInfoMessage(guiOwner, "Warning/Information messages", sb.toString());
    }

    public static enum Type {
        LANGUAGE,
        PREPARED,
        CALLABLE;

    }
}

