/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.DemoApp;
import com.sap.dbmtk.demo.SqlStatement;
import com.sap.dbmtk.demo.SqlStatementParam;
import com.sap.dbmtk.demo.utils.SwingUtils;
import com.sap.dbmtk.demo.utils.TimeUtils;
import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import net.miginfocom.swing.MigLayout;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class SqlTraceWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static SqlTraceWindow _instance = null;
    private RSyntaxTextArea _log_txt = new RSyntaxTextArea(50, 100);
    private RTextScrollPane _log_sp = new RTextScrollPane((Component)this._log_txt);
    private JCheckBox _moveToEnd_chk = new JCheckBox("Move To End", true);
    private JButton _close_but = new JButton("Close");
    private String _dbmsProductName = "UNKNWON";
    private long _execStartTime = 0L;
    private SimpleDateFormat _sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public SqlTraceWindow() {
        this.init();
        this.pack();
    }

    private void init() {
        ImageIcon icon16 = SwingUtils.readImageIcon(DemoApp.class, "images/sql_16.png");
        ImageIcon icon32 = SwingUtils.readImageIcon(DemoApp.class, "images/sql_32.png");
        ArrayList<Image> iconList = new ArrayList<Image>();
        if (icon16 != null) {
            iconList.add(icon16.getImage());
        }
        if (icon32 != null) {
            iconList.add(icon32.getImage());
        }
        this.setIconImages(iconList);
        this._log_txt.setSyntaxEditingStyle("text/sql");
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0"));
        this.add((Component)this._log_sp, "grow, push, wrap 20");
        this.add((Component)this._moveToEnd_chk, "split");
        this.add((Component)this._close_but, "tag ok, wrap");
        this._close_but.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                _instance.setVisible(false);
            }
        });
    }

    public void open() {
        _instance.setVisible(true);
    }

    public static SqlTraceWindow getInstance() {
        if (_instance == null) {
            _instance = new SqlTraceWindow();
        }
        return _instance;
    }

    public static boolean hasInstance() {
        return _instance != null;
    }

    public static void setInstance(SqlTraceWindow inst) {
        _instance = inst;
    }

    public void setDatabaseProductName(String dbmsProductName) {
        this._dbmsProductName = dbmsProductName;
    }

    public void addSql(String sql) {
        StringBuilder sb = new StringBuilder();
        String timeNow = this._sdf.format(new Date(System.currentTimeMillis()));
        sb.append("\n");
        sb.append("\n");
        sb.append("/*========================================================================================*\n");
        sb.append(" * Time: ").append(timeNow).append("\n");
        sb.append(" * DBMS: ").append(this._dbmsProductName).append("\n");
        sb.append(" *========================================================================================*/\n");
        sb.append(sql);
        if (!sql.endsWith("\n")) {
            sb.append("\n");
        }
        this.append(sb.toString());
    }

    public void addException(Throwable ex) {
        StringBuilder sb = new StringBuilder();
        String msg = "" + ex;
        if (ex instanceof SQLException) {
            msg = SqlStatement.getSqlMessages((SQLException)ex, null);
        }
        sb.append("------------------------------------------------------\n");
        sb.append("-- Exception -----------------------------------------\n");
        sb.append("------------------------------------------------------\n");
        sb.append(ex);
        sb.append("Decoded message: \n").append(msg);
        sb.append("\n");
        this.append(sb.toString());
    }

    public void addRowcount(int rowCount) {
        StringBuilder sb = new StringBuilder();
        sb.append("-- >>>>> ROWS Affected = ").append(rowCount).append(" <<<<< --\n");
        this.append(sb.toString());
    }

    public void addParam(int p, SqlStatementParam param) {
        StringBuilder sb = new StringBuilder();
        sb.append("-- ").append(p).append(": ").append(param).append("\n");
        this.append(sb.toString());
    }

    public void addParamAfterExec(int p, SqlStatementParam param) {
        StringBuilder sb = new StringBuilder();
        sb.append("-- OUTPUT VALUE: ").append(p).append(": ").append(param).append("\n");
        this.append(sb.toString());
    }

    public void addExecTime(long execTime, String labelText) {
        StringBuilder sb = new StringBuilder();
        sb.append("-- EXEC TIME: ").append(TimeUtils.msToTimeStr("%SS.%ms", execTime)).append("   label='").append(labelText).append("'.\n");
        this.append(sb.toString());
    }

    public void startTimer() {
        this._execStartTime = System.currentTimeMillis();
    }

    public long reportTime(String labelText) {
        long execTime = System.currentTimeMillis() - this._execStartTime;
        this.addExecTime(execTime, labelText);
        return execTime;
    }

    private void append(String txt) {
        this._log_txt.append(txt);
        if (this._moveToEnd_chk.isSelected()) {
            this._log_txt.setCaretPosition(this._log_txt.getDocument().getLength());
        }
    }
}

