/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui;

import com.sap.dbmtk.demo.Version;
import com.sap.dbmtk.demo.ui.JdbcDriverHelper;
import com.sap.dbmtk.demo.ui.JdbcOptionsDialog;
import com.sap.dbmtk.demo.ui.WaitForExecDialog;
import com.sap.dbmtk.demo.utils.AseConnectionUtils;
import com.sap.dbmtk.demo.utils.Configuration;
import com.sap.dbmtk.demo.utils.DbUtils;
import com.sap.dbmtk.demo.utils.StringUtil;
import com.sap.dbmtk.demo.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;

public class ConnectionDialog
extends JDialog
implements ActionListener,
KeyListener,
TableModelListener,
ChangeListener,
FocusListener {
    private static Logger _logger = Logger.getLogger(ConnectionDialog.class);
    private static final long serialVersionUID = 1L;
    public static final int CANCEL = 0;
    public static final int TDS_CONN = 1;
    public static final int OFFLINE_CONN = 2;
    public static final int JDBC_CONN = 4;
    private int _connectionType = 0;
    private Connection _jdbcConn = null;
    private String _desiredProductName = null;
    public static final String ACTION_OK = "OK";
    public static final String ACTION_CANCEL = "CANCEL";
    private static final String NO_PROFILE_IS_SELECTED = "<choose a profile>";
    private Frame _owner = null;
    private JPanel _okCancelPanel;
    private JPanel _jdbcPanel = null;
    private ImageIcon _jdbcImageIcon = SwingUtils.readImageIcon(Version.class, "images/jdbc_connect_32.png");
    private JLabel _jdbcIcon = new JLabel(this._jdbcImageIcon);
    private JLabel _jdbcHelp = new JLabel();
    private JLabel _jdbcProfile_lbl = new JLabel("Use Profile");
    private ProfileComboBoxModel _jdbcProfile_mod = new ProfileComboBoxModel();
    private JComboBox _jdbcProfile_cbx = new JComboBox(this._jdbcProfile_mod);
    private JButton _jdbcProfileActions_but = new JButton("Profile Actions...");
    private JLabel _jdbcDriver_lbl = new JLabel("JDBC Driver");
    private JComboBox _jdbcDriver_cbx = new JComboBox();
    private JLabel _jdbcUrl_lbl = new JLabel("JDBC Url");
    private JComboBox _jdbcUrl_cbx = new JComboBox();
    private JButton _jdbcUrl_but = new JButton("...");
    private JLabel _jdbcUsername_lbl = new JLabel("Username");
    private JTextField _jdbcUsername_txt = new JTextField("sa");
    private JLabel _jdbcPassword_lbl = new JLabel("Password");
    private JTextField _jdbcPassword_txt = new JPasswordField();
    private JCheckBox _jdbcAutoCommit_chk = new JCheckBox("Auto-commit", true);
    private JCheckBox _jdbcAutoCommit2_chk = new JCheckBox("<html>Do <b>not</b> set AutoCommit when connecting, <b>trust</b> JDBC/Server</html>", true);
    private JCheckBox _jdbcSavePassword_chk = new JCheckBox("Save password", true);
    private JButton _jdbcTestConn_but = new JButton("Test Connection");
    private JLabel _jdbcSqlInit_lbl = new JLabel("SQL Init");
    private JTextField _jdbcSqlInit_txt = new JTextField("");
    private JLabel _jdbcUrlOptions_lbl = new JLabel("URL Options");
    private JTextField _jdbcUrlOptions_txt = new JTextField("");
    private JButton _jdbcUrlOptions_but = new JButton("...");
    private JLabel _ok_lbl = new JLabel("");
    private JButton _ok = new JButton("OK");
    private JButton _cancel = new JButton("Cancel");
    private boolean _inLoadProfile = false;

    public ConnectionDialog(Frame owner) {
        super((Window)owner, "Connect", Dialog.ModalityType.DOCUMENT_MODAL);
        this._owner = owner;
        this.initComponents();
        this.pack();
        Dimension size = this.getPreferredSize();
        size.width = 530;
        this.setSize(size);
        this.setLocationRelativeTo(owner);
        this.getSavedWindowProps();
        this.setFocus();
    }

    public void setDesiredProductName(String productName) {
        this._desiredProductName = productName;
    }

    public String getDatabaseProductName() throws SQLException {
        Connection conn = this._jdbcConn;
        return ConnectionDialog.getDatabaseProductName(conn);
    }

    public static String getDatabaseProductName(Connection conn) throws SQLException {
        if (conn == null) {
            return null;
        }
        try {
            String str = conn.getMetaData().getDatabaseProductName();
            _logger.debug((Object)("getDatabaseProductName() returns: '" + str + "'."));
            return str;
        }
        catch (SQLException e) {
            if ("JZ0SJ".equals(e.getSQLState())) {
                try {
                    String str1 = "";
                    String str2 = "";
                    Statement stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery("admin rssd_name");
                    while (rs.next()) {
                        str1 = rs.getString(1);
                        str2 = rs.getString(2);
                    }
                    rs.close();
                    stmt.close();
                    _logger.info((Object)("Replication Server with RSSD at '" + str1 + "." + str2 + "'."));
                    return "Replication Server";
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            _logger.debug((Object)("getDatabaseProductName() Caught: " + e), (Throwable)e);
            throw e;
        }
    }

    public String getDatabaseProductVersion() throws SQLException {
        Connection conn = this._jdbcConn;
        return ConnectionDialog.getDatabaseProductVersion(conn);
    }

    public static String getDatabaseProductVersion(Connection conn) throws SQLException {
        if (conn == null) {
            return null;
        }
        try {
            String str = conn.getMetaData().getDatabaseProductVersion();
            _logger.debug((Object)("getDatabaseProductVersion() returns: '" + str + "'."));
            return str;
        }
        catch (SQLException e) {
            if ("JZ0SJ".equals(e.getSQLState())) {
                try {
                    String str = "";
                    Statement stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery("admin version");
                    while (rs.next()) {
                        str = rs.getString(1);
                    }
                    rs.close();
                    stmt.close();
                    _logger.info((Object)("Replication Server with Version string '" + str + "'."));
                    return str;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            _logger.debug((Object)("getDatabaseProductVersion() Caught: " + e), (Throwable)e);
            throw e;
        }
    }

    public boolean isDatabaseProduct(String str) {
        if (str == null) {
            return false;
        }
        try {
            String currentDbProductName = this.getDatabaseProductName();
            return str.equals(currentDbProductName);
        }
        catch (SQLException e) {
            _logger.debug((Object)("isDatabaseProduct() Caught: " + e), (Throwable)e);
            return false;
        }
    }

    public String getDatabaseServerName() throws SQLException {
        Connection conn = this._jdbcConn;
        return ConnectionDialog.getDatabaseServerName(conn);
    }

    public static String getDatabaseServerName(Connection conn) throws SQLException {
        if (conn == null) {
            return null;
        }
        String serverName = "";
        String currentDbProductName = ConnectionDialog.getDatabaseProductName(conn);
        if ("Adaptive Server Enterprise".equals(currentDbProductName)) {
            serverName = AseConnectionUtils.getAseServername(conn);
        } else if ("SQL Anywhere".equals(currentDbProductName)) {
            serverName = AseConnectionUtils.getAseServername(conn);
        } else if ("Sybase IQ".equals(currentDbProductName)) {
            serverName = AseConnectionUtils.getAseServername(conn);
        } else if (!"H2".equals(currentDbProductName)) {
            if ("HDB".equals(currentDbProductName)) {
                serverName = DbUtils.getHanaServername(conn);
            } else if ("SAP DB".equals(currentDbProductName)) {
                serverName = DbUtils.getMaxDbServername(conn);
            } else if ("Oracle".equals(currentDbProductName)) {
                serverName = DbUtils.getOracleServername(conn);
            } else if ("Microsoft SQL Server".equals(currentDbProductName)) {
                serverName = AseConnectionUtils.getAseServername(conn);
            } else if (DbUtils.isProductName(currentDbProductName, "DB2/Linux")) {
                serverName = DbUtils.getDb2Servername(conn);
            }
        }
        return serverName;
    }

    public String getDriverName() throws SQLException {
        Connection conn = this._jdbcConn;
        return ConnectionDialog.getDriverName(conn);
    }

    public static String getDriverName(Connection conn) throws SQLException {
        if (conn == null) {
            return null;
        }
        try {
            String str = conn.getMetaData().getDriverName();
            _logger.debug((Object)("getDriverName() returns: '" + str + "'."));
            return str;
        }
        catch (SQLException e) {
            if ("JZ0SJ".equals(e.getSQLState())) {
                try {
                    String str = "";
                    Statement stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery("admin version");
                    while (rs.next()) {
                        str = rs.getString(1);
                        _logger.debug((Object)("getDriverName(): RepServer check, using version " + str));
                    }
                    rs.close();
                    stmt.close();
                    return "jConnect (TM) for JDBC (TM)";
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            _logger.debug((Object)("getDriverName() Caught: " + e), (Throwable)e);
            throw e;
        }
    }

    public String getDriverVersion() throws SQLException {
        Connection conn = this._jdbcConn;
        return ConnectionDialog.getDriverVersion(conn);
    }

    public static String getDriverVersion(Connection conn) throws SQLException {
        if (conn == null) {
            return null;
        }
        try {
            String str = conn.getMetaData().getDriverVersion();
            _logger.debug((Object)("getDriverVersion() returns: '" + str + "'."));
            return str;
        }
        catch (SQLException e) {
            if ("JZ0SJ".equals(e.getSQLState())) {
                try {
                    String str = "";
                    Statement stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery("admin version");
                    while (rs.next()) {
                        str = rs.getString(1);
                        _logger.debug((Object)("getDriverVersion(): RepServer check, using version " + str));
                    }
                    rs.close();
                    stmt.close();
                    return "jConnect (TM) for JDBC(TM)/unknown/getDriverVersion()/getSQLState()=JZ0SJ: Metadata accessor information was not found on this database";
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            _logger.debug((Object)("getDriverVersion() Caught: " + e), (Throwable)e);
            throw e;
        }
    }

    public int getConnectionType() {
        return this._connectionType;
    }

    public Connection getConnection() {
        return this._jdbcConn;
    }

    public String getUsername() {
        return this._jdbcUsername_txt.getText();
    }

    public String getUrl() {
        return StringUtil.getSelectedItemString(this._jdbcUrl_cbx);
    }

    public String getJdbcDriver() {
        return this._jdbcDriver_cbx.getEditor().getItem().toString();
    }

    public String getJdbcUrl() {
        return this._jdbcUrl_cbx.getEditor().getItem().toString();
    }

    public String getJdbcUser() {
        return this._jdbcUsername_txt.getText();
    }

    public String getJdbcPasswd() {
        return this._jdbcPassword_txt.getText();
    }

    public void setJdbcDriver(String driver) {
        this.addAndSelectItem(this._jdbcDriver_cbx, driver);
    }

    public void setJdbcUrl(String url) {
        this.addAndSelectItem(this._jdbcUrl_cbx, url);
    }

    public void setJdbcUsername(String username) {
        this._jdbcUsername_txt.setText(username);
    }

    public void setJdbcPassword(String password) {
        this._jdbcPassword_txt.setText(password);
    }

    private void addAndSelectItem(JComboBox cbx, String item) {
        boolean exists = false;
        for (int i = 0; i < cbx.getItemCount(); ++i) {
            Object obj = cbx.getItemAt(i);
            if (!obj.equals(item)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            cbx.addItem(item);
        }
        cbx.setSelectedItem(item);
    }

    protected void initComponents() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0, wrap 1", "", ""));
        this._jdbcPanel = this.createJdbcPanel();
        this._okCancelPanel = this.createOkCancelPanel();
        panel.add((Component)this._jdbcPanel, "grow, push, wrap");
        panel.add((Component)this._okCancelPanel, "pushx, growx, bottom, right");
        this.loadProps();
        this.setContentPane(panel);
        this.validateContents();
    }

    private JPanel createJdbcPanel() {
        JPanel panel = SwingUtils.createPanel("JDBC Connection Information", true);
        panel.setLayout((LayoutManager)new MigLayout("", "", ""));
        this._jdbcPanel = panel;
        this._jdbcHelp.setText("<html>Connect to any JDBC datasource<br><br>Note: The JDBC Driver needs to be in the classpath</html>");
        this._jdbcProfile_lbl.setToolTipText("<html>Choose an earlier sessions that was saved.<br><br>Set to '<b>&lt;choose a profile&gt;</b>' if you want to save current settings as a <i>new profile</i>.<br> Then Press 'Save Profile...' or 'OK' to connect... Then you will be prompted for a profile name.</html>");
        this._jdbcProfile_cbx.setToolTipText(this._jdbcProfile_lbl.getToolTipText());
        this._jdbcDriver_lbl.setToolTipText("JDBC drivername to be used when creating the connection");
        this._jdbcDriver_cbx.setToolTipText("JDBC drivername to be used when creating the connection");
        this._jdbcUrl_lbl.setToolTipText("URL for the above JDBC drivername to connect to a datastore, a couple of template URL for H2 and Sybase JDBC driver");
        this._jdbcUrl_cbx.setToolTipText("URL for the above JDBC drivername to connect to a datastore, a couple of template URL for H2 and Sybase JDBC driver");
        this._jdbcUrl_but.setToolTipText("Open a File chooser dialog to get a filename, for some templates values are replaced");
        this._jdbcUsername_lbl.setToolTipText("User name to be used when creating the connection");
        this._jdbcUsername_txt.setToolTipText("User name to be used when creating the connection");
        this._jdbcPassword_lbl.setToolTipText("Password to be used when creating the connection");
        this._jdbcPassword_txt.setToolTipText("Password to be used when creating the connection");
        this._jdbcSqlInit_lbl.setToolTipText("<html>Send this SQL Statement after the connection has been established.<br>If you want to send several statements, use ';' as a teminator for each statement.</html>");
        this._jdbcSqlInit_txt.setToolTipText("<html>Send this SQL Statement after the connection has been established.<br>If you want to send several statements, use ';' as a teminator for each statement.</html>");
        this._jdbcUrlOptions_lbl.setToolTipText("<html>If the current Driver supports <code>driver.getPropertyInfo()</code>, show available Options.</html>");
        this._jdbcUrlOptions_txt.setToolTipText("<html>If the current Driver supports <code>driver.getPropertyInfo()</code>, show available Options.</html>");
        this._jdbcUrlOptions_but.setToolTipText("<html>If the current Driver supports <code>driver.getPropertyInfo()</code>, show available Options.</html>");
        this._jdbcTestConn_but.setToolTipText("Make a test connection to the above JDBC datastore");
        this._jdbcAutoCommit_chk.setToolTipText("<html>JDBC setAutoCommit(<b>true</b>|false) when connection to the server. The default mode in JDBC is AutoCommit=<b>true</b><br><br>For ASE AutoCommit means the following<ul>  <li><b>true </b> (<code>set chained off</code>): The default mode, called <b>unchained</b> mode or Transact-SQL mode, requires explicit <b>begin transaction</b> statements paired with <b>commit transaction</b> or <b>rollback transaction</b> statements to complete the transaction.</li>  <li><b>false</b> (<code>set chained on</code>):  <b>chained</b> mode implicitly begins a transaction before any data-retrieval or modification statement: <b>delete</b>, <b>insert</b>, <b>open</b>, <b>fetch</b>, <b>select</b>, and <b>update</b>. You must still explicitly end the transaction with <b>commit transaction</b> or <b>rollback transaction</b></li></ul></html>");
        this._jdbcAutoCommit2_chk.setToolTipText("<html>If the Option is Enabled, just use the JDBC Default value<br> or let the server you connect to choose in what mode you want to have.<br></html>");
        try {
            this._jdbcProfileActions_but = this.createProfileActionsButton(null);
        }
        catch (Throwable ex) {
            _logger.error((Object)"Problems creating the 'Application Options' button.", ex);
        }
        panel.add((Component)this._jdbcIcon, "");
        panel.add((Component)this._jdbcHelp, "wmin 100, pushx, growx, wrap 15");
        panel.add((Component)this._jdbcProfile_lbl, "");
        panel.add((Component)this._jdbcProfile_cbx, "pushx, growx, split");
        panel.add((Component)this._jdbcProfileActions_but, "wrap");
        panel.add((Component)this._jdbcDriver_lbl, "");
        panel.add((Component)this._jdbcDriver_cbx, "pushx, growx, wrap");
        panel.add((Component)this._jdbcUrl_lbl, "");
        panel.add((Component)this._jdbcUrl_cbx, "pushx, growx, split");
        panel.add((Component)this._jdbcUrl_but, "wrap");
        panel.add((Component)this._jdbcUsername_lbl, "");
        panel.add((Component)this._jdbcUsername_txt, "pushx, growx, wrap");
        panel.add((Component)this._jdbcPassword_lbl, "");
        panel.add((Component)this._jdbcPassword_txt, "pushx, growx, wrap");
        panel.add((Component)this._jdbcAutoCommit_chk, "skip, split, growx, pushx, ");
        panel.add((Component)this._jdbcAutoCommit2_chk, "wrap");
        panel.add((Component)this._jdbcSqlInit_lbl, "");
        panel.add((Component)this._jdbcSqlInit_txt, "pushx, growx, wrap");
        panel.add((Component)this._jdbcUrlOptions_lbl, "");
        panel.add((Component)this._jdbcUrlOptions_txt, "pushx, growx, split");
        panel.add((Component)this._jdbcUrlOptions_but, "wrap");
        panel.add((Component)this._jdbcSavePassword_chk, "skip, split, growx, pushx");
        panel.add((Component)this._jdbcTestConn_but, "wrap");
        this._jdbcProfile_cbx.setEditable(false);
        this._jdbcDriver_cbx.setEditable(true);
        this._jdbcUrl_cbx.setEditable(true);
        ArrayList<String> driversList = new ArrayList<String>();
        driversList.add("com.sybase.jdbc4.jdbc.SybDriver");
        driversList.add("oracle.jdbc.OracleDriver");
        driversList.add("com.sap.db.jdbc.Driver");
        if (driversList.size() > 0) {
            for (String str : driversList) {
                this._jdbcDriver_cbx.addItem(str);
            }
        } else {
            this._jdbcDriver_cbx.addItem("org.h2.Driver");
            this._jdbcDriver_cbx.addItem("com.sybase.jdbc3.jdbc.SybDriver");
            this._jdbcDriver_cbx.addItem("com.sybase.jdbc4.jdbc.SybDriver");
            this._jdbcDriver_cbx.addItem("com.sap.db.jdbc.Driver");
        }
        this._jdbcUrl_cbx.addItem("jdbc:sybase:Tds:<host>:<port>");
        this._jdbcUrl_cbx.addItem("jdbc:sybase:Tds:<host>:<port>[/<dbname>]");
        this._jdbcUrl_cbx.addItem("jdbc:oracle:thin:@//[HOST][:PORT]/SERVICE");
        this._jdbcProfile_cbx.addActionListener(this);
        this._jdbcDriver_cbx.addActionListener(this);
        this._jdbcTestConn_but.addActionListener(this);
        this._jdbcUrl_cbx.getEditor().getEditorComponent().addKeyListener(this);
        this._jdbcUrl_cbx.addActionListener(this);
        this._jdbcPassword_txt.addActionListener(this);
        this._jdbcUrl_but.addActionListener(this);
        this._jdbcUrlOptions_but.addActionListener(this);
        this._jdbcAutoCommit2_chk.addActionListener(this);
        return panel;
    }

    private JPanel createOkCancelPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "", ""));
        this._ok_lbl.setForeground(Color.RED);
        this._ok_lbl.setFont(this._ok_lbl.getFont().deriveFont(1));
        this._ok_lbl.setText("");
        panel.add((Component)new JLabel(), "pushx, growx");
        panel.add((Component)this._ok_lbl, "");
        panel.add((Component)this._ok, "tag ok, right");
        panel.add((Component)this._cancel, "tag cancel");
        this._ok.addActionListener(this);
        this._cancel.addActionListener(this);
        return panel;
    }

    private void validateContents() {
        String aseProblem = "";
        String offlineProblem = "";
        String jdbcProblem = "";
        String pcsProblem = "";
        String hostmonProblem = "";
        String otherProblem = "";
        String url = this._jdbcUrl_cbx.getEditor().getItem().toString();
        if (url.matches(".*<.*>.*")) {
            jdbcProblem = "Replace the <template> with something.";
        }
        if (url.matches(".*\\[.*\\].*")) {
            jdbcProblem = "Replace the [template] with something or delete it.";
        }
        String sumProblem = otherProblem + aseProblem + offlineProblem + jdbcProblem + pcsProblem + hostmonProblem;
        this._ok_lbl.setText(sumProblem);
        if (sumProblem.equals("")) {
            this._ok.setEnabled(true);
            this._jdbcTestConn_but.setEnabled(true);
        } else {
            this._ok.setEnabled(false);
            this._jdbcTestConn_but.setEnabled(false);
        }
        this._jdbcAutoCommit_chk.setEnabled(!this._jdbcAutoCommit2_chk.isSelected());
    }

    private void setFocus() {
        Runnable deferredAction = new Runnable(){

            @Override
            public void run() {
                if (ConnectionDialog.this._jdbcUsername_txt.getText().trim().equals("")) {
                    ConnectionDialog.this._jdbcUsername_txt.requestFocus();
                    return;
                }
                if (ConnectionDialog.this._jdbcPassword_txt.getText().trim().equals("")) {
                    ConnectionDialog.this._jdbcPassword_txt.requestFocus();
                    return;
                }
                ConnectionDialog.this._ok.requestFocus();
                ConnectionDialog.this.validateContents();
            }
        };
        SwingUtilities.invokeLater(deferredAction);
    }

    private boolean jdbcConnect() {
        String jdbcDriver = StringUtil.getSelectedItemString(this._jdbcDriver_cbx);
        String jdbcUrl = StringUtil.getSelectedItemString(this._jdbcUrl_cbx);
        String jdbcUser = this._jdbcUsername_txt.getText();
        String jdbcPasswd = this._jdbcPassword_txt.getText();
        Boolean jdbcAutoCommit = this._jdbcAutoCommit_chk.isSelected();
        String sqlInit = this._jdbcSqlInit_txt.getText();
        String jdbcUrlOptions = this._jdbcUrlOptions_txt.getText();
        if (!this._jdbcAutoCommit_chk.isVisible() || this._jdbcAutoCommit2_chk.isSelected()) {
            jdbcAutoCommit = null;
        }
        this._jdbcConn = this.jdbcConnect(Version.getAppName(), jdbcDriver, jdbcUrl, jdbcUser, jdbcPasswd, jdbcUrlOptions, sqlInit, jdbcAutoCommit);
        return this._jdbcConn != null;
    }

    private Connection jdbcConnect(String appname, final String driver, final String url, final String user, final String passwd, final String urlOptions, final String sqlInit, final Boolean autoCommit) {
        final Properties props2 = new Properties();
        WaitForExecDialog wait = new WaitForExecDialog((Window)this, "JDBC Connect...");
        WaitForExecDialog.BgExecutor doWork = new WaitForExecDialog.BgExecutor(wait){

            @Override
            public Object doWork() {
                try {
                    try {
                        Driver jdbcDriver = DriverManager.getDriver(url);
                        if (jdbcDriver == null) {
                            Class.forName(driver).newInstance();
                        }
                    }
                    catch (Exception ex) {
                        _logger.warn((Object)("Can't load JDBC driver for URL='" + url + "' using 'old way od doing it' using: DriverManager.getDriver(url); Lets continue and try just to use DriverManager.getConnection(url, props); which is the 'new' way of doing it. Caught=" + ex));
                        _logger.debug((Object)("Can't load JDBC driver for URL='" + url + "' using 'old way od doing it' using: DriverManager.getDriver(url); Lets continue and try just to use DriverManager.getConnection(url, props); which is the 'new' way of doing it. Caught=" + ex), (Throwable)ex);
                    }
                    Properties props = new Properties();
                    props.put("user", user);
                    props.put("password", passwd);
                    if (StringUtil.hasValue(urlOptions)) {
                        Map<String, String> urlMap = StringUtil.parseCommaStrToMap(urlOptions);
                        for (String key : urlMap.keySet()) {
                            String val = urlMap.get(key);
                            props.put(key, val);
                            props2.put(key, val);
                        }
                    }
                    if (url.startsWith("jdbc:sybase:Tds:") && !props.containsKey("IS_CLOSED_TEST")) {
                        props.put("IS_CLOSED_TEST", "INTERNAL");
                        props2.put("IS_CLOSED_TEST", "INTERNAL");
                    }
                    if (url.startsWith("jdbc:db2:") && !props.containsKey("retrieveMessagesFromServerOnGetMessage")) {
                        props.put("retrieveMessagesFromServerOnGetMessage", "true");
                        props2.put("retrieveMessagesFromServerOnGetMessage", "true");
                    }
                    _logger.debug((Object)("getConnection to driver='" + driver + "', url='" + url + "', user='" + user + "'."));
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html>");
                    sb.append("<table border=0 cellspacing=1 cellpadding=1>");
                    sb.append("<tr> <td nowrap><b>User:  </b></td> <td nowrap>").append(user).append("</td> </tr>");
                    sb.append("<tr> <td nowrap><b>Url:   </b></td> <td nowrap>").append(url).append("</td> </tr>");
                    if (props2.size() > 0) {
                        sb.append("<tr> <td nowrap><b>Url Options: </b></td> <td nowrap>").append(StringUtil.toCommaStr(props2)).append("</td> </tr>");
                    }
                    sb.append("<tr> <td nowrap><b>Driver:</b></td> <td nowrap>").append(driver).append("</td> </tr>");
                    sb.append("</table>");
                    sb.append("</html>");
                    this.getWaitDialog().setState(sb.toString());
                    SwingUtils.setWindowMinSize(this.getWaitDialog());
                    Connection conn = DriverManager.getConnection(url, props);
                    if (StringUtil.hasValue(sqlInit)) {
                        try {
                            String[] sa;
                            for (String sql : sa = sqlInit.split(";")) {
                                if ("".equals(sql = sql.trim())) continue;
                                this.getWaitDialog().setState("<html>SQL Init: " + sql + "<br></html>");
                                DbUtils.exec(conn, sql);
                            }
                        }
                        catch (SQLException ex) {
                            SwingUtils.showErrorMessage(ConnectionDialog.this, "SQL Initialization Failed", "<html><h2>SQL Initialization Failed</h2>Full SQL Init String '" + sqlInit + "'<br><br><b>SQL State:     </b>" + ex.getSQLState() + "<br><b>Error number:  </b>" + ex.getErrorCode() + "<br><b>Error Message: </b>" + ex.getMessage() + "<br></html>", ex);
                            throw ex;
                        }
                    }
                    if (autoCommit != null) {
                        _logger.info((Object)("Setting JDBC AutoCommit to '" + autoCommit + "', as the last thing when connected to the server."));
                        DbUtils.setAutoCommit(conn, null, autoCommit, "The request to change AutoCommit was made during the <b>Login</b> sequence.<br>Possible a login profile/trigger or simular that did <i>something</i>.");
                    }
                    return conn;
                }
                catch (SQLException ex) {
                    StringBuffer sb = new StringBuffer();
                    for (SQLException eTmp = ex; eTmp != null; eTmp = eTmp.getNextException()) {
                        sb.append("\n");
                        sb.append("ex.toString='").append(ex.toString()).append("', ");
                        sb.append("Driver='").append(driver).append("', ");
                        sb.append("URL='").append(url).append("', ");
                        sb.append("User='").append(user).append("', ");
                        sb.append("SQLState='").append(eTmp.getSQLState()).append("', ");
                        sb.append("ErrorCode=").append(eTmp.getErrorCode()).append(", ");
                        sb.append("Message='").append(eTmp.getMessage()).append("', ");
                        sb.append("classpath='").append(System.getProperty("java.class.path")).append("'.");
                    }
                    _logger.info((Object)(Version.getAppName() + " - JDBC connect FAILED (catch SQLException) Caught: " + sb.toString()));
                    this.setException(ex);
                }
                catch (Exception ex) {
                    _logger.info((Object)(Version.getAppName() + " - JDBC connect FAILED (catch Exception) Caught: " + ex));
                    this.setException(ex);
                }
                return null;
            }
        };
        Connection conn = (Connection)wait.execAndWait(doWork, 100);
        if (doWork.hasException()) {
            Throwable t = doWork.getException();
            if (t instanceof SQLException) {
                SQLException e;
                StringBuffer sb = new StringBuffer();
                sb.append("<html>");
                sb.append("<h2>Problems During Connect (SQLException)</h2>");
                sb.append("<hr>");
                boolean loadDriverProblem = false;
                for (e = (SQLException)t; e != null; e = e.getNextException()) {
                    if (e.getMessage().indexOf("No suitable driver") >= 0) {
                        loadDriverProblem = true;
                    }
                    sb.append("<table border=0 cellspacing=1 cellpadding=1>");
                    sb.append("<tr> <td nowrap><b>Message    </b></td> <td nowrap>").append(e.getMessage()).append("</td> </tr>");
                    sb.append("<tr> <td nowrap><b>SQLState   </b></td> <td nowrap>").append(e.getSQLState()).append("</td> </tr>");
                    sb.append("<tr> <td nowrap><b>ErrorCode  </b></td> <td nowrap>").append(e.getErrorCode()).append("</td> </tr>");
                    sb.append("<tr> <td nowrap><b>Driver     </b></td> <td nowrap>").append(driver).append("</td> </tr>");
                    sb.append("<tr> <td nowrap><b>URL        </b></td> <td nowrap>").append(url).append("</td> </tr>");
                    if (props2.size() > 0) {
                        sb.append("<tr> <td nowrap><b>Url Options: </b></td> <td nowrap>").append(StringUtil.toCommaStr(props2)).append("</td> </tr>");
                    }
                    sb.append("<tr> <td nowrap><b>User       </b></td> <td nowrap>").append(user).append("</td> </tr>");
                    sb.append("<tr> <td nowrap><b>classpath  </b></td> <td nowrap>").append(System.getProperty("java.class.path")).append("</td> </tr>");
                    sb.append("</table>");
                    sb.append("<hr>");
                }
                if (loadDriverProblem) {
                    sb.append("<h2>An error occurred while establishing the connection: </h2>");
                    sb.append("The selected Driver cannot handle the specified Database URL. <br>");
                    sb.append("The most common reason for this error is that the database <b>URL contains a syntax error</b> preventing the driver from accepting it. <br>");
                    sb.append("The error also occurs when trying to connect to a database with the wrong driver. Correct this and try again.");
                }
                sb.append("</html>");
                SwingUtils.showErrorMessage(Version.getAppName() + " - jdbc connect", sb.toString(), e);
            } else if (t instanceof Exception) {
                SwingUtils.showErrorMessage(Version.getAppName() + " - jdbc connect", "Connection (Exception) FAILED.\n\n" + t.toString(), t);
            } else {
                SwingUtils.showErrorMessage(Version.getAppName() + " - jdbc connect", "Connection (other) FAILED.\n\n" + t.toString(), t);
            }
        }
        return conn;
    }

    private boolean testJdbcConnection(String appname, String driver, String url, String user, String passwd) {
        try {
            Class.forName(driver).newInstance();
            Properties props = new Properties();
            props.put("user", user);
            props.put("password", passwd);
            _logger.debug((Object)("Try getConnection to driver='" + driver + "', url='" + url + "', user='" + user + "'."));
            Connection conn = DriverManager.getConnection(url, props);
            conn.close();
            JOptionPane.showMessageDialog(this, "Connection succeeded.", Version.getAppName() + " - connect check", 1);
            return true;
        }
        catch (SQLException e) {
            StringBuffer sb = new StringBuffer();
            while (e != null) {
                sb.append("\n");
                sb.append(e.getMessage());
                e = e.getNextException();
            }
            SwingUtils.showErrorMessage(Version.getAppName() + " - connect check", "Connection FAILED.\n\n" + sb.toString(), e);
        }
        catch (Exception e) {
            SwingUtils.showErrorMessage(Version.getAppName() + " - connect check", "Connection FAILED.\n\n" + e.toString(), e);
        }
        return false;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.validateContents();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String jdbcDriver;
        List<String> urlTemplates;
        String profile;
        Object source = e.getSource();
        String action = e.getActionCommand();
        if (this._inLoadProfile) {
            return;
        }
        if (this._jdbcProfile_cbx.equals(source) && StringUtil.hasValue(profile = this._jdbcProfile_mod.getSelectedProfile())) {
            this.loadProfile(profile);
        }
        if (this._jdbcDriver_cbx.equals(source) && (urlTemplates = JdbcDriverHelper.getUrlTemplateList(jdbcDriver = StringUtil.getSelectedItemString(this._jdbcDriver_cbx))) != null && urlTemplates.size() > 0) {
            this._jdbcUrl_cbx.removeAllItems();
            for (String template : urlTemplates) {
                this._jdbcUrl_cbx.addItem(template);
            }
        }
        if (this._jdbcUrl_but.equals(source)) {
            String url = this._jdbcUrl_cbx.getEditor().getItem().toString();
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                String newFile = fc.getSelectedFile().getAbsolutePath().replace('\\', '/');
                String newUrl = this._jdbcUrl_cbx.getEditor().getItem() + newFile;
                this._jdbcUrl_cbx.getEditor().setItem(newUrl);
            }
        }
        if (this._jdbcPassword_txt.equals(source)) {
            if (this._jdbcUsername_txt.getText().trim().equals("")) {
                this.setFocus();
            } else {
                this._ok.doClick();
            }
        }
        if (this._jdbcTestConn_but.equals(source)) {
            this.testJdbcConnection("testConnect", this._jdbcDriver_cbx.getEditor().getItem().toString(), this._jdbcUrl_cbx.getEditor().getItem().toString(), this._jdbcUsername_txt.getText(), this._jdbcPassword_txt.getText());
        }
        if (this._jdbcUrlOptions_but.equals(source)) {
            Map<String, String> sendOpt = StringUtil.parseCommaStrToMap(this._jdbcUrlOptions_txt.getText());
            Map<String, String> outOpt = JdbcOptionsDialog.showDialog(this, StringUtil.getSelectedItemString(this._jdbcDriver_cbx), StringUtil.getSelectedItemString(this._jdbcUrl_cbx), sendOpt);
            if (outOpt != null) {
                this._jdbcUrlOptions_txt.setText(StringUtil.toCommaStr(outOpt));
            }
        }
        if (this._cancel.equals(source) || ACTION_CANCEL.equals(action)) {
            if (this._jdbcConn != null) {
                try {
                    this._jdbcConn.close();
                }
                catch (SQLException sendOpt) {
                    // empty catch block
                }
            }
            this._connectionType = 0;
            this.setVisible(false);
        }
        if (this._ok.equals(source) || ACTION_OK.equals(action)) {
            this.action_profile(ProfileActions.SAVE, this._jdbcProfile_mod.getSelectedProfile());
            if (this.isVisible()) {
                this.saveProps();
            }
            int connType = -1;
            connType = 4;
            this.action_connect(connType);
        }
        this.validateContents();
    }

    private boolean saveChangesDialog(String name, String changesTable, JDialog owner) {
        String htmlMsg = "<html><h3>Connection Attributes has been changed</h3>Profile Name '<b>" + name + "</b>'.<br>You have changed some Attributes since the last time you connected with this profile.<br><br>Below is the changes made:<br>" + changesTable + "<br>Do you want to change the stored profile to reflect your changes?<br></html>";
        String SAVE_THIS = "Save Changes";
        String SAVE_AS = "Save As New Profile";
        String NOT_THIS_TIME = "Not this time";
        Object[] options = new String[]{"Save Changes", "Save As New Profile", "Not this time"};
        int result = JOptionPane.showOptionDialog(owner, htmlMsg, "Save Changes", 1, 3, null, options, 0);
        Object choice = options[result];
        if ("Save Changes".equals(choice)) {
            return true;
        }
        if ("Save As New Profile".equals(choice)) {
            this.action_profile(ProfileActions.SAVE_AS, name);
            return false;
        }
        if ("Not this time".equals(choice)) {
            return false;
        }
        return false;
    }

    private static StringBuilder htmlTabRowIfChangedPwd(StringBuilder sb, String key, Object oldValue, Object newValue) {
        return ConnectionDialog.htmlTabRowIfChanged(sb, key, Configuration.encryptPropertyValue(key, oldValue + ""), Configuration.encryptPropertyValue(key, newValue + ""));
    }

    private static StringBuilder htmlTabRowIfChanged(StringBuilder sb, String key, Object oldValue, Object newValue) {
        boolean changed = false;
        if (oldValue == null) {
            oldValue = "";
        }
        if (newValue == null) {
            newValue = "";
        }
        boolean bl = changed = !oldValue.equals(newValue);
        if (changed) {
            sb.append("<tr> <td><b>").append(key).append("</b></td> <td nowrap>").append(newValue).append("</td> <td nowrap>").append(oldValue).append("</td> </tr>");
        }
        return sb;
    }

    private String getChangeTable(String name) {
        Configuration conf = Configuration.getCombinedConfiguration();
        StringBuilder sb = new StringBuilder();
        ConnectionDialog.htmlTabRowIfChanged(sb, "Driver", this._jdbcDriver_cbx.getSelectedItem(), conf.getProperty("profile." + name + ".jdbc.jdbcDriver", ""));
        ConnectionDialog.htmlTabRowIfChanged(sb, "URL", this._jdbcUrl_cbx.getSelectedItem(), conf.getProperty("profile." + name + ".jdbc.jdbcUrl", ""));
        ConnectionDialog.htmlTabRowIfChanged(sb, "User", this._jdbcUsername_txt.getText(), conf.getProperty("profile." + name + ".jdbc.jdbcUser", ""));
        if (this._jdbcSavePassword_chk.isSelected()) {
            ConnectionDialog.htmlTabRowIfChangedPwd(sb, "Password", this._jdbcPassword_txt.getText(), conf.getProperty("profile." + name + ".jdbc.jdbcPasswd", ""));
        }
        ConnectionDialog.htmlTabRowIfChanged(sb, "Auto-commit", this._jdbcAutoCommit_chk.isSelected(), conf.getBooleanProperty("profile." + name + ".jdbc.jdbcAutoCommit", true));
        ConnectionDialog.htmlTabRowIfChanged(sb, "Auto-commit Trust Server", this._jdbcAutoCommit2_chk.isSelected(), conf.getBooleanProperty("profile." + name + ".jdbc.jdbcAutoCommit.atConnect", true));
        ConnectionDialog.htmlTabRowIfChanged(sb, "SQL Init", this._jdbcSqlInit_txt.getText(), conf.getProperty("profile." + name + ".jdbc.login.sql.init", ""));
        ConnectionDialog.htmlTabRowIfChanged(sb, "URL Options", this._jdbcUrlOptions_txt.getText(), conf.getProperty("profile." + name + ".jdbc.login.url.options", ""));
        if (sb.length() > 0) {
            sb.insert(0, "<tr> <td nowrap bgcolor=\"#848484\"><font color=\"white\"><b>Attribute</b></font></td> <td nowrap bgcolor=\"#848484\"><font color=\"white\"><b>New Value</b></font></td> <td nowrap bgcolor=\"#848484\"><font color=\"white\"><b>Old Value</b></font></td> </tr>");
            sb.insert(0, "<table border=1 cellspacing=0 cellpadding=1>");
            sb.append("</table>");
            return sb.toString();
        }
        return null;
    }

    private void action_profile(ProfileActions action, String name) {
        if (ProfileActions.SAVE.equals((Object)action)) {
            if (StringUtil.isNullOrBlank(name)) {
                this.action_profile(ProfileActions.SAVE_AS, name);
            } else {
                boolean saveThis = true;
                String changesTable = this.getChangeTable(name);
                if (changesTable != null) {
                    saveThis = this.saveChangesDialog(name, changesTable, this);
                }
                if (saveThis) {
                    this.saveProfile(name);
                }
            }
        } else if (ProfileActions.SAVE_AS.equals((Object)action)) {
            String suggestion = this._jdbcProfile_mod.getSelectedProfile();
            if (StringUtil.isNullOrBlank(suggestion)) {
                suggestion = this._jdbcUrl_cbx.getSelectedItem() + " - " + (StringUtil.hasValue(this._jdbcUsername_txt.getText()) ? this._jdbcUsername_txt.getText() : "username");
            }
            RenameOrAddDialog dialog = new RenameOrAddDialog(this, suggestion, "<html><b>Save As a new Connection Profile</b></html>");
            dialog.setVisible(true);
            if (dialog.pressedOk() && StringUtil.hasValue(name = dialog.getName())) {
                this.saveProfile(name);
                this._jdbcProfile_cbx.setSelectedItem(name);
            }
        } else if (ProfileActions.RENAME.equals((Object)action)) {
            RenameOrAddDialog dialog = new RenameOrAddDialog(this, name, "<html><b>Rename a Connection Profile</b></html>");
            dialog.setVisible(true);
            if (dialog.pressedOk()) {
                String oldName = name;
                name = dialog.getName();
                if (StringUtil.hasValue(name)) {
                    this.saveProfile(name);
                    this.removeProfile(oldName);
                    this._jdbcProfile_cbx.setSelectedItem(name);
                }
            }
        } else if (ProfileActions.REMOVE.equals((Object)action)) {
            this.removeProfile(name);
        }
    }

    private void action_connect(int connType) {
        if (this.isVisible()) {
            this.saveProps();
        }
        if (4 == connType) {
            if (this._jdbcConn == null && !this.jdbcConnect()) {
                return;
            }
            this._connectionType = 4;
            this.setVisible(false);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyevent) {
    }

    @Override
    public void keyTyped(KeyEvent keyevent) {
        Object source = keyevent.getSource();
    }

    @Override
    public void keyReleased(KeyEvent keyevent) {
        this.validateContents();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setFocus();
        this.validateContents();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.validateContents();
    }

    private void saveProps() {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (conf == null) {
            _logger.warn((Object)"Getting Configuration for TEMP failed, probably not initialized");
            return;
        }
        String profile = this._jdbcProfile_mod.getSelectedProfile();
        if (StringUtil.hasValue(profile)) {
            conf.setProperty("profile.last", profile);
        }
        conf.setProperty("conn.dialog.window.width", this.getSize().width);
        conf.setProperty("conn.dialog.window.height", this.getSize().height);
        conf.setProperty("conn.dialog.window.pos.x", this.getLocationOnScreen().x);
        conf.setProperty("conn.dialog.window.pos.y", this.getLocationOnScreen().y);
        conf.save();
    }

    private void loadProps() {
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf == null) {
            _logger.warn((Object)"Getting Configuration for TEMP failed, probably not initialized");
            return;
        }
        Object str = null;
        boolean bol = false;
        String profile = conf.getProperty("profile.last");
        if (StringUtil.hasValue(profile)) {
            this._jdbcProfile_cbx.setSelectedItem(profile);
        }
    }

    private static Set<String> getProfileNames() {
        Configuration conf = Configuration.getCombinedConfiguration();
        HashSet<String> profiles = new HashSet<String>();
        for (String key : conf.getKeys("profile.")) {
            String[] sa = key.split("\\.");
            String name = null;
            if (sa.length >= 2) {
                name = sa[1];
            }
            if (name != null && name.equals("last")) continue;
            profiles.add(name);
        }
        ArrayList sortedList = new ArrayList(profiles);
        Collections.sort(sortedList);
        profiles = new LinkedHashSet(sortedList);
        return profiles;
    }

    private void removeProfile(String name) {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (conf == null) {
            _logger.warn((Object)"Getting Configuration for TEMP failed, probably not initialized");
            return;
        }
        conf.removeAll("profile." + name);
        conf.save();
        this._jdbcProfile_mod.refresh();
    }

    private void loadProfile(String name) {
        Configuration conf = Configuration.getCombinedConfiguration();
        this._jdbcDriver_cbx.setSelectedItem(conf.getProperty("profile." + name + ".jdbc.jdbcDriver", ""));
        this._jdbcUrl_cbx.setSelectedItem(conf.getProperty("profile." + name + ".jdbc.jdbcUrl", ""));
        this._jdbcUsername_txt.setText(conf.getProperty("profile." + name + ".jdbc.jdbcUser", ""));
        this._jdbcPassword_txt.setText(conf.getProperty("profile." + name + ".jdbc.jdbcPasswd", ""));
        this._jdbcAutoCommit_chk.setSelected(conf.getBooleanProperty("profile." + name + ".jdbc.jdbcAutoCommit", true));
        this._jdbcAutoCommit2_chk.setSelected(conf.getBooleanProperty("profile." + name + ".jdbc.jdbcAutoCommit.atConnect", true));
        this._jdbcSqlInit_txt.setText(conf.getProperty("profile." + name + ".jdbc.login.sql.init", ""));
        this._jdbcUrlOptions_txt.setText(conf.getProperty("profile." + name + ".jdbc.login.url.options", ""));
    }

    private void saveProfile(String name) {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (conf == null) {
            _logger.warn((Object)"Getting Configuration for TEMP failed, probably not initialized");
            return;
        }
        conf.setProperty("profile." + name + ".jdbc.jdbcDriver", this._jdbcDriver_cbx.getEditor().getItem().toString());
        conf.setProperty("profile." + name + ".jdbc.jdbcUrl", this._jdbcUrl_cbx.getEditor().getItem().toString());
        conf.setProperty("profile." + name + ".jdbc.jdbcUser", this._jdbcUsername_txt.getText());
        conf.setProperty("profile." + name + ".jdbc.jdbcPasswd", this._jdbcPassword_txt.getText(), true);
        conf.setProperty("profile." + name + ".jdbc.jdbcAutoCommit", this._jdbcAutoCommit_chk.isSelected());
        conf.setProperty("profile." + name + ".jdbc.jdbcAutoCommit.atConnect", this._jdbcAutoCommit2_chk.isSelected());
        conf.setProperty("profile." + name + ".jdbc.login.sql.init", this._jdbcSqlInit_txt.getText());
        conf.setProperty("profile." + name + ".jdbc.login.url.options", this._jdbcUrlOptions_txt.getText());
        conf.save();
        this._jdbcProfile_mod.refresh();
    }

    private void getSavedWindowProps() {
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf == null) {
            _logger.warn((Object)"Getting Configuration for TEMP failed, probably not initialized");
            return;
        }
        int width = conf.getIntProperty("conn.dialog.window.width", -1);
        int height = conf.getIntProperty("conn.dialog.window.height", -1);
        int x = conf.getIntProperty("conn.dialog.window.pos.x", -1);
        int y = conf.getIntProperty("conn.dialog.window.pos.y", -1);
        if (width != -1 && height != -1) {
            this.setSize(width, height);
        }
        if (x != -1 && y != -1 && !SwingUtils.isOutOfScreen(x, y, width, height)) {
            this.setLocation(x, y);
        }
        SwingUtils.setWindowMinSize(this);
    }

    private JPopupMenu createProfileActionsPopupMenu() {
        final JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                popupMenu.removeAll();
                final String currentProfile = ConnectionDialog.this._jdbcProfile_mod.getSelectedProfile();
                JMenuItem save_mi = new JMenuItem("Save");
                save_mi.setToolTipText("Save currently selected profile");
                save_mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ConnectionDialog.this.action_profile(ProfileActions.SAVE, currentProfile);
                    }
                });
                JMenuItem saveAs_mi = new JMenuItem("Save As...");
                saveAs_mi.setToolTipText("Save currently selected profile, as a new name");
                saveAs_mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ConnectionDialog.this.action_profile(ProfileActions.SAVE_AS, currentProfile);
                    }
                });
                JMenuItem rename_mi = new JMenuItem("Rename...");
                rename_mi.setToolTipText("Rename currently selected profile, as a new name");
                rename_mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ConnectionDialog.this.action_profile(ProfileActions.RENAME, currentProfile);
                    }
                });
                JMenuItem remove_mi = new JMenuItem("Remove");
                remove_mi.setText("Remove");
                remove_mi.setToolTipText("Remove the current selected profile.");
                remove_mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ConnectionDialog.this.action_profile(ProfileActions.REMOVE, currentProfile);
                    }
                });
                if (StringUtil.hasValue(currentProfile)) {
                    save_mi.setEnabled(true);
                    saveAs_mi.setEnabled(true);
                    rename_mi.setEnabled(true);
                    remove_mi.setEnabled(true);
                } else {
                    save_mi.setEnabled(false);
                    saveAs_mi.setEnabled(true);
                    rename_mi.setEnabled(false);
                    remove_mi.setEnabled(false);
                }
                popupMenu.add(save_mi);
                popupMenu.add(saveAs_mi);
                popupMenu.add(rename_mi);
                popupMenu.add(remove_mi);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        return popupMenu;
    }

    private JButton createProfileActionsButton(JButton button) {
        if (button == null) {
            button = new JButton();
        }
        button.setToolTipText("<html>Various Profile Actions that can be made.</html>");
        button.setText("Profile Actions...");
        JPopupMenu popupMenu = this.createProfileActionsPopupMenu();
        button.setComponentPopupMenu(popupMenu);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source instanceof JButton) {
                    JButton but = (JButton)source;
                    JPopupMenu pm = but.getComponentPopupMenu();
                    pm.show(but, 14, 14);
                    pm.setLocation(MouseInfo.getPointerInfo().getLocation());
                }
            }
        });
        return button;
    }

    private class RenameOrAddDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private String _oldName;
        private String _newName;
        private boolean _pressedOk;
        private String _htmlMsg;
        private JLabel _name_head;
        private JLabel _name_lbl;
        private JTextField _name_txt;
        private JLabel _name_bussy;
        private JButton _ok_but;
        private JButton _cancel_but;

        public RenameOrAddDialog(JDialog owner, String oldName, String htmlMsg) {
            super(owner, oldName != null ? "Rename" : "Add", true);
            this._oldName = null;
            this._newName = null;
            this._pressedOk = false;
            this._htmlMsg = "";
            this._name_head = new JLabel();
            this._name_lbl = new JLabel("Name");
            this._name_txt = new JTextField(30);
            this._name_bussy = new JLabel("The Name already exists, choose another one.");
            this._ok_but = new JButton(ConnectionDialog.ACTION_OK);
            this._cancel_but = new JButton("Cancel");
            this._oldName = oldName;
            this._newName = null;
            this._pressedOk = false;
            this._htmlMsg = htmlMsg;
            if (this._htmlMsg == null) {
                this._htmlMsg = "";
            }
            this.init();
            this.pack();
            this.setLocationRelativeTo(owner);
            this.validateCompenents();
            SwingUtils.installEscapeButton(this, this._cancel_but);
            SwingUtils.setFocus(this._name_txt);
        }

        public boolean pressedOk() {
            return this._pressedOk;
        }

        @Override
        public String getName() {
            return this._newName;
        }

        private void init() {
            this._name_bussy.setForeground(Color.RED);
            this._name_txt.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    RenameOrAddDialog.this.validateCompenents();
                }
            });
            this._name_head.setText(this._htmlMsg);
            if (this._oldName != null) {
                this._name_txt.setText(this._oldName);
            }
            this.setLayout((LayoutManager)new MigLayout());
            JPanel panel = new JPanel((LayoutManager)new MigLayout());
            panel.add((Component)this._name_head, "span, wrap 20");
            panel.add((Component)this._name_lbl, "");
            panel.add((Component)this._name_txt, "pushx, growx, wrap");
            panel.add((Component)this._name_bussy, "skip, pushx, growx, hidemode 3, wrap");
            this.add((Component)panel, "push, grow, wrap");
            this.add((Component)this._ok_but, "split, tag ok");
            this.add((Component)this._cancel_but, "tag cancel");
            this._name_txt.addActionListener(this);
            this._ok_but.addActionListener(this);
            this._cancel_but.addActionListener(this);
            this.validateCompenents();
        }

        private void validateCompenents() {
            boolean enableOk = true;
            String currentItem = this._name_txt.getText();
            boolean bussy = ConnectionDialog.this._jdbcProfile_mod.exists(currentItem);
            this._name_bussy.setVisible(bussy);
            if (bussy) {
                enableOk = false;
            }
            this._ok_but.setEnabled(enableOk);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (this._name_txt.equals(source)) {
                this._ok_but.doClick();
            }
            if (this._ok_but.equals(source)) {
                this._pressedOk = true;
                this._newName = this._name_txt.getText();
                this.setVisible(false);
            }
            if (this._cancel_but.equals(source)) {
                this._pressedOk = false;
                this._newName = null;
                this.setVisible(false);
            }
        }
    }

    protected static class ProfileComboBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = 1L;

        public ProfileComboBoxModel() {
            this.refresh();
        }

        public void refresh() {
            String currentSelected = null;
            JComboBox cbxOwner = null;
            ListDataListener[] la = this.getListDataListeners();
            for (int i = 0; i < la.length; ++i) {
                if (!(la[i] instanceof JComboBox)) continue;
                cbxOwner = (JComboBox)la[i];
                currentSelected = ProfileComboBoxModel.notSelectedValueToNull(StringUtil.getSelectedItemString(cbxOwner));
            }
            Set names = ConnectionDialog.getProfileNames();
            this.removeAllElements();
            this.addElement(ConnectionDialog.NO_PROFILE_IS_SELECTED);
            for (String name : names) {
                this.addElement(name);
            }
            if (cbxOwner != null && currentSelected != null) {
                cbxOwner.setSelectedItem(currentSelected);
            }
        }

        public static String notSelectedValueToNull(String value) {
            if (ConnectionDialog.NO_PROFILE_IS_SELECTED.equals(value)) {
                return null;
            }
            return value;
        }

        public boolean exists(String name) {
            if (ConnectionDialog.NO_PROFILE_IS_SELECTED.equals(name)) {
                return true;
            }
            for (int i = 0; i < this.getSize(); ++i) {
                String entry = this.getElementAt(i) + "";
                if (!entry.equals(name)) continue;
                return true;
            }
            return false;
        }

        public String getSelectedProfile() {
            Object o = this.getSelectedItem();
            if (o == null) {
                return null;
            }
            return ProfileComboBoxModel.notSelectedValueToNull(o.toString());
        }
    }

    public static enum ProfileActions {
        SAVE,
        SAVE_AS,
        REMOVE,
        RENAME;

    }
}

