/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui;

import com.sap.dbmtk.demo.ui.GTabbedPane;
import com.sap.dbmtk.demo.ui.MultiLineLabel;
import com.sap.dbmtk.demo.utils.StringUtil;
import com.sap.dbmtk.demo.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class GTabbedPaneViewDialog
extends JDialog
implements ActionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    private ImageIcon _iconTab = new ImageIcon(GTabbedPaneViewDialog.class.getResource("images/tab.gif"));
    private ImageIcon _iconUp = new ImageIcon(GTabbedPaneViewDialog.class.getResource("images/up.png"));
    private ImageIcon _iconDown = new ImageIcon(GTabbedPaneViewDialog.class.getResource("images/down.png"));
    private MultiLineLabel _description1 = new MultiLineLabel("Choose in what order the Tabs 'Title names' will be arranged on the Tab Pane.");
    private MultiLineLabel _description2 = new MultiLineLabel("You can also hide some Tabs, which you think you may never use.");
    private JButton _up = new JButton();
    private JButton _down = new JButton();
    private JButton _toStartOrder = new JButton("To Start Order");
    private JButton _toOriginOrder = new JButton("To Original Order");
    private JButton _rmTabOrderVis = new JButton("Clear saved info");
    private DefaultTableModel _tableModel = null;
    private JXTable _table = null;
    private GTabbedPane _gTabbedPane = null;
    private List<String> _modelOrder = new ArrayList<String>();
    private List<String> _orderAtStart = new ArrayList<String>();
    private DefaultTableModel _tableModelAtStart = null;
    private JButton _ok = new JButton("OK");
    private JButton _cancel = new JButton("Cancel");
    private JButton _apply = new JButton("Apply");
    private int _dialogReturnSt = 2;
    private boolean _hasGroups = false;

    private GTabbedPaneViewDialog(Frame owner, GTabbedPane gTabbedPane) {
        super(owner, "Change Tabs Order and Visibility", true);
        this._gTabbedPane = gTabbedPane;
        this._modelOrder = gTabbedPane.getModelTabOrder();
        this._orderAtStart = gTabbedPane.getTabOrder(true);
        this.initComponents();
        this._tableModelAtStart = SwingUtils.copyTableModel(this._tableModel);
        this.pack();
        Dimension size = this.getSize();
        size.height += (this._table.getRowCount() - 6) * 18;
        size.width = Math.min(size.width, 700);
        this.setSize(size);
    }

    public static int showDialog(Frame owner, GTabbedPane gTabbedPane) {
        GTabbedPaneViewDialog dialog = new GTabbedPaneViewDialog(owner, gTabbedPane);
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
        dialog.dispose();
        return dialog._dialogReturnSt;
    }

    protected void initComponents() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout());
        panel.add((Component)this._description1, "grow, wrap");
        panel.add((Component)this._description2, "grow, wrap 10");
        this._table = this.createTable();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView((Component)this._table);
        panel.add((Component)jScrollPane, "span, grow, height 100%, push, wrap");
        panel.add((Component)this._up, "tag left, span, split");
        panel.add((Component)this._down, "tag left");
        panel.add((Component)this._toStartOrder, "tag left");
        panel.add((Component)this._toOriginOrder, "tag left");
        panel.add((Component)this._rmTabOrderVis, "tag right, wrap push");
        panel.add((Component)this.createOkPanel(), "gap top 20, right");
        this._apply.setEnabled(false);
        this.setContentPane(panel);
        this._up.addActionListener(this);
        this._down.addActionListener(this);
        this._toStartOrder.addActionListener(this);
        this._toOriginOrder.addActionListener(this);
        this._rmTabOrderVis.addActionListener(this);
        this._up.setToolTipText("Move the tab up (or to left in the TabbedPane)");
        this._down.setToolTipText("Move the tab down (or to right in the TabbedPane)");
        this._toStartOrder.setToolTipText("Restore the tabs to the order it had when this dialog was opened.");
        this._toOriginOrder.setToolTipText("Restore the tabs to the order it originally was when TabbedPane was created.");
        this._rmTabOrderVis.setToolTipText("<html>Remove/clear the persisted values for TabTitles order and the visibility.<br>This is usually stored in the configuration or properties file.</html>");
        this._up.setIcon(this._iconUp);
        this._down.setIcon(this._iconDown);
        if (this._iconTab != null) {
            this.setIconImage(this._iconTab.getImage());
        }
        if (this._up.getIcon() == null) {
            this._up.setText("Move Up");
        }
        if (this._down.getIcon() == null) {
            this._down.setText("Move Down");
        }
        this.pack();
    }

    JPanel createOkPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 0 0", "", ""));
        panel.add((Component)this._ok, "tag ok");
        panel.add((Component)this._cancel, "tag cancel");
        panel.add((Component)this._apply, "tag apply");
        this._ok.addActionListener(this);
        this._cancel.addActionListener(this);
        this._apply.addActionListener(this);
        return panel;
    }

    private void apply() {
        this._table.clearSelection();
        ArrayList<String> newTabOrder = new ArrayList<String>();
        TableModel tm = this._table.getModel();
        for (int r = 0; r < tm.getRowCount(); ++r) {
            String groupName = (String)tm.getValueAt(r, TabPos.GroupName.ordinal());
            String tabName = (String)tm.getValueAt(r, TabPos.TabName.ordinal());
            Boolean visible = (Boolean)tm.getValueAt(r, TabPos.TabVisible.ordinal());
            this._gTabbedPane.setVisibleAtModel(groupName, tabName, visible);
            String addStr = tabName;
            if (!StringUtil.isNullOrBlank(groupName)) {
                addStr = groupName + ":" + tabName;
            }
            if (!visible.booleanValue()) continue;
            newTabOrder.add(addStr);
        }
        this._gTabbedPane.setTabOrder(newTabOrder);
        this._gTabbedPane.saveTabOrderAndVisibility();
        this._apply.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String toGroupName;
        String atGroupName;
        DefaultTableModel dtm;
        int toRow;
        int row;
        Object source = e.getSource();
        if (this._up.equals(source)) {
            row = this._table.getSelectedRow();
            if (row < 0) {
                SwingUtils.showInfoMessage(this, "Select a row", "No row in the table is selected.");
                return;
            }
            toRow = row - 1;
            dtm = (DefaultTableModel)this._table.getModel();
            if (toRow >= 0) {
                atGroupName = dtm.getValueAt(row, TabPos.GroupName.ordinal()) + "";
                if (atGroupName.equals(toGroupName = dtm.getValueAt(toRow, TabPos.GroupName.ordinal()) + "")) {
                    dtm.moveRow(row, row, toRow);
                    this._table.getSelectionModel().setSelectionInterval(toRow, toRow);
                } else {
                    SwingUtils.showInfoMessage(this, "Can't move to another group", "<html>Trying to move into a new group<br>This is not supported for the moment<br><br>From group: <b>" + atGroupName + "</b><br>To group: <b>" + toGroupName + "</b><br></html>");
                    return;
                }
            }
        }
        if (this._down.equals(source)) {
            row = this._table.getSelectedRow();
            if (row < 0) {
                SwingUtils.showInfoMessage(this, "Select a row", "No row in the table is selected.");
                return;
            }
            toRow = row + 1;
            dtm = (DefaultTableModel)this._table.getModel();
            if (toRow < dtm.getRowCount()) {
                atGroupName = dtm.getValueAt(row, TabPos.GroupName.ordinal()) + "";
                if (atGroupName.equals(toGroupName = dtm.getValueAt(toRow, TabPos.GroupName.ordinal()) + "")) {
                    dtm.moveRow(row, row, toRow);
                    this._table.getSelectionModel().setSelectionInterval(toRow, toRow);
                } else {
                    SwingUtils.showInfoMessage(this, "Can't move to another group", "<html>Trying to move into a new group<br>This is not supported for the moment<br><br>From group: <b>" + atGroupName + "</b><br>To group: <b>" + toGroupName + "</b><br></html>");
                    return;
                }
            }
        }
        if (this._toStartOrder.equals(source)) {
            this.toTabOrder(this._tableModel, this._orderAtStart);
        }
        if (this._toOriginOrder.equals(source)) {
            this.toTabOrder(this._tableModel, this._modelOrder);
        }
        if (this._rmTabOrderVis.equals(source)) {
            this._gTabbedPane.removeTabOrderAndVisibility();
        }
        if (this._ok.equals(source)) {
            this.apply();
            this._dialogReturnSt = 0;
            this.setVisible(false);
        }
        if (this._cancel.equals(source)) {
            this._dialogReturnSt = 2;
            this.setVisible(false);
        }
        if (this._apply.equals(source)) {
            this.apply();
        }
    }

    private void toTabOrder(DefaultTableModel tm, List<String> tabOrder) {
        for (int oi = 0; oi < tabOrder.size(); ++oi) {
            String entry = tabOrder.get(oi);
            String[] sa = entry.split(":");
            String groupName = "";
            String tabName = entry;
            if (sa.length > 1) {
                groupName = sa[sa.length - 2];
                tabName = sa[sa.length - 1];
            }
            int moveRow = -1;
            for (int tr = 0; tr < tm.getRowCount(); ++tr) {
                Object rowTabName = tm.getValueAt(tr, TabPos.TabName.ordinal());
                Object rowGroupName = tm.getValueAt(tr, TabPos.GroupName.ordinal());
                if (rowGroupName == null) {
                    rowGroupName = "";
                }
                if (!tabName.equals(rowTabName) || !groupName.equals(rowGroupName)) continue;
                moveRow = tr;
                break;
            }
            if (moveRow < 0 || oi == moveRow) continue;
            tm.moveRow(moveRow, moveRow, oi);
        }
    }

    private void checkForChanges() {
        boolean enabled = false;
        TableModel tm = this._table.getModel();
        for (int r = 0; r < tm.getRowCount(); ++r) {
            String rowTabName = (String)tm.getValueAt(r, TabPos.TabName.ordinal());
            Boolean rowVisible = (Boolean)tm.getValueAt(r, TabPos.TabVisible.ordinal());
            String startTabName = (String)this._tableModelAtStart.getValueAt(r, TabPos.TabName.ordinal());
            Boolean startVisible = (Boolean)this._tableModelAtStart.getValueAt(r, TabPos.TabVisible.ordinal());
            if (!rowTabName.equals(startTabName)) {
                enabled = true;
            }
            if (!rowVisible.equals(startVisible)) {
                enabled = true;
            }
            if (enabled) break;
        }
        this._apply.setEnabled(enabled);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.checkForChanges();
    }

    public JXTable createTable() {
        Vector<String> tabHead = new Vector<String>();
        tabHead.setSize(TabPos.values().length);
        tabHead.set(TabPos.GroupIcon.ordinal(), "Group");
        tabHead.set(TabPos.GroupName.ordinal(), "GroupName");
        tabHead.set(TabPos.TabIcon.ordinal(), "Icon");
        tabHead.set(TabPos.TabVisible.ordinal(), "Visible");
        tabHead.set(TabPos.TabName.ordinal(), "Name");
        tabHead.set(TabPos.TabDescription.ordinal(), "Description");
        Vector<Vector<Object>> tabData = this.populateTable();
        this._tableModel = new DefaultTableModel(tabData, tabHead){
            private static final long serialVersionUID = 1L;

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == TabPos.GroupIcon.ordinal()) {
                    return Icon.class;
                }
                if (column == TabPos.TabIcon.ordinal()) {
                    return Icon.class;
                }
                if (column == TabPos.TabVisible.ordinal()) {
                    return Boolean.class;
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == TabPos.TabVisible.ordinal();
            }
        };
        this.toTabOrder(this._tableModel, this._orderAtStart);
        this._tableModel.addTableModelListener(this);
        JXTable table = new JXTable((TableModel)this._tableModel);
        table.setSortable(false);
        table.setAutoResizeMode(0);
        table.setShowGrid(false);
        table.setSelectionMode(0);
        if (!this._hasGroups) {
            TableColumnModelExt tcmx = (TableColumnModelExt)table.getColumnModel();
            tcmx.getColumnExt((Object)"Group").setVisible(false);
            tcmx.getColumnExt((Object)"GroupName").setVisible(false);
        }
        SwingUtils.calcColumnWidths((JTable)table);
        return table;
    }

    private Vector<Vector<Object>> populateTable() {
        Vector<Vector<Object>> tab = new Vector<Vector<Object>>();
        this.populateTable(null, 0, this._gTabbedPane, tab);
        return tab;
    }

    private void populateTable(GTabbedPane parentTabPane, int parentPos, GTabbedPane tabPane, Vector<Vector<Object>> table) {
        for (int t = 0; t < tabPane.getModelTabCount(); ++t) {
            Component comp = tabPane.getComponentAt(t);
            if (comp instanceof GTabbedPane) {
                this.populateTable(tabPane, t, (GTabbedPane)comp, table);
                continue;
            }
            Vector<Object> row = new Vector<Object>();
            row = new Vector();
            row.setSize(TabPos.values().length);
            if (parentTabPane != null) {
                row.set(TabPos.GroupIcon.ordinal(), parentTabPane.getIconAtModel(parentPos));
                row.set(TabPos.GroupName.ordinal(), parentTabPane.getTitleAtModel(parentPos));
                this._hasGroups = true;
            }
            row.set(TabPos.TabIcon.ordinal(), tabPane.getIconAtModel(t));
            row.set(TabPos.TabVisible.ordinal(), tabPane.isVisibleAtModel(t));
            row.set(TabPos.TabName.ordinal(), tabPane.getTitleAtModel(t));
            row.set(TabPos.TabDescription.ordinal(), StringUtil.stripHtml(tabPane.getToolTipTextAtModel(t)));
            table.add(row);
        }
    }

    private static enum TabPos {
        GroupIcon,
        GroupName,
        TabIcon,
        TabVisible,
        TabName,
        TabDescription;

    }
}

