/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui;

import com.sap.dbmtk.demo.Version;
import com.sap.dbmtk.demo.utils.StringUtil;
import com.sap.dbmtk.demo.utils.SwingUtils;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JdbcDriverHelper {
    private static org.apache.log4j.Logger _logger = org.apache.log4j.Logger.getLogger(JdbcDriverHelper.class);
    public static final String DEFAULT_DriversFileName = Version.APP_STORE_DIR + File.separator + "JdbcDrivers.xml";
    public static final String JDBC_DRIVER_DOWNLOAD_URL = "http://www.asetune.com/jdbc_drivers_download.php";
    private static JdbcDriverTableModel _jdbcDriverModel = null;
    private static String _filename = DEFAULT_DriversFileName;
    private static final String XML_TAG_DRIVERS_LIST = "DriversList";
    private static final String XML_BEGIN_TAG_DRIVERS_LIST = "<DriversList>";
    private static final String XML_END___TAG_DRIVERS_LIST = "</DriversList>";
    private static final String XML_TAG_DRIVER_ENTRY = "DriverEntry";
    private static final String XML_BEGIN_TAG_DRIVER_ENTRY = "<DriverEntry>";
    private static final String XML_END___TAG_DRIVER_ENTRY = "</DriverEntry>";
    private static final String XML_SUBTAG_CLASSNAME = "ClassName";
    private static final String XML_BEGIN_SUBTAG_CLASSNAME = "<ClassName>";
    private static final String XML_END___SUBTAG_CLASSNAME = "</ClassName>";
    private static final String XML_SUBTAG_DESCRIPTION = "Description";
    private static final String XML_BEGIN_SUBTAG_DESCRIPTION = "<Description>";
    private static final String XML_END___SUBTAG_DESCRIPTION = "</Description>";
    private static final String XML_SUBTAG_HOME_PAGE = "HomePage";
    private static final String XML_BEGIN_SUBTAG_HOME_PAGE = "<HomePage>";
    private static final String XML_END___SUBTAG_HOME_PAGE = "</HomePage>";
    private static final String XML_SUBTAG_JAR_FILE = "JarFile";
    private static final String XML_BEGIN_SUBTAG_JAR_FILE = "<JarFile>";
    private static final String XML_END___SUBTAG_JAR_FILE = "</JarFile>";
    private static final String XML_SUBTAG_URL_TEMPLATE = "UrlTemplate";
    private static final String XML_BEGIN_SUBTAG_URL_TEMPLATE = "<UrlTemplate>";
    private static final String XML_END___SUBTAG_URL_TEMPLATE = "</UrlTemplate>";

    public static JdbcDriverTableModel getModel() {
        if (_jdbcDriverModel == null) {
            _jdbcDriverModel = new JdbcDriverTableModel();
        }
        return _jdbcDriverModel;
    }

    public static List<String> getAvailableDriverList() {
        ArrayList<String> list = new ArrayList<String>();
        JdbcDriverTableModel model = JdbcDriverHelper.getModel();
        for (DriverInfoEntry e : model.getEntries(true)) {
            list.add(e.getClassName());
        }
        return list;
    }

    public static List<String> getUrlTemplateList(String driverName) {
        JdbcDriverTableModel model = JdbcDriverHelper.getModel();
        DriverInfoEntry entry = model.getEntry(driverName);
        if (entry != null) {
            return entry.getUrlTemplateList();
        }
        return JdbcDriverHelper.getDefaultUrlTemplateList(driverName);
    }

    public static List<String> getDefaultUrlTemplateList(String driverName) {
        ArrayList<String> templates = new ArrayList<String>();
        if ("sun.jdbc.odbc.JdbcOdbcDriver".equals(driverName)) {
            templates.add("jdbc:odbc:DSN");
        } else if ("com.sybase.jdbc3.jdbc.SybDriver".equals(driverName) || "com.sybase.jdbc4.jdbc.SybDriver".equals(driverName)) {
            templates.add("jdbc:sybase:Tds:<host>:<port>");
            templates.add("jdbc:sybase:Tds:<host>:<port>[/<dbname>]");
            templates.add("jdbc:sybase:Tds:<host>:<port>?OPT1=val&OPT2=val");
        } else if ("net.sourceforge.jtds.jdbc.Driver".equals(driverName)) {
            templates.add("jdbc:jtds:<server_type>://<host>[:<port>][/<db>][;<prop>=<val>[;...]]");
            templates.add("jdbc:jtds:sybase://<host>[:<port>][/<db>][;<prop>=<val>[;...]]");
            templates.add("jdbc:jtds:sqlserver://<host>[:<port>][/<db>][;<prop>=<val>[;...]]");
        } else if ("org.h2.Driver".equals(driverName)) {
            templates.add("jdbc:h2:file:[<path>]<dbname>");
            templates.add("jdbc:h2:file:[<path>]<dbname>;IFEXISTS=TRUE");
            templates.add("jdbc:h2:file:[<path>]<dbname>;AUTO_SERVER=TRUE");
            templates.add("jdbc:h2:file:${ASETUNE_SAVE_DIR}/${SERVERNAME}_${DATE}");
            templates.add("jdbc:h2:file:${ASETUNE_SAVE_DIR}/${ASEHOSTNAME}_${DATE}");
            templates.add("jdbc:h2:tcp://<host>[:<port>]/<dbname>");
            templates.add("jdbc:h2:ssl://<host>[:<port>]/<dbname>");
            templates.add("jdbc:h2:zip:<zipFileName>!/<dbname>");
        } else if ("com.sap.db.jdbc.Driver".equals(driverName)) {
            templates.add("jdbc:sap://<host>:<port>");
            templates.add("jdbc:sap://<host>:3##15");
            templates.add("jdbc:sap://<host>:3##15 (replace## with instance_number)");
            templates.add("jdbc:sap://<host>:30015");
        } else if ("com.sap.dbtech.jdbc.DriverSapDB".equals(driverName)) {
            templates.add("jdbc:sapdb://<host>/<database_name>");
            templates.add("jdbc:sapdb://<host>[:<port>]/<database_name>[?<opt1>[&<opt>]...]");
        } else if ("oracle.jdbc.OracleDriver".equals(driverName)) {
            templates.add("jdbc:oracle:thin:@//[HOST][:PORT]/SERVICE");
            templates.add("jdbc:oracle:thin:@[HOST][:PORT]:SID");
        } else if ("com.microsoft.jdbc.sqlserver.SQLServerDriver".equals(driverName)) {
            templates.add("jdbc:microsoft:sqlserver://<host>:<port> ");
            templates.add("jdbc:microsoft:sqlserver://<host>:<port>;databasename=name");
        } else if ("com.microsoft.sqlserver.jdbc.SQLServerDriver".equals(driverName)) {
            templates.add("jdbc:sqlserver://<host>:<port> ");
        } else if ("com.ibm.db2.jcc.DB2Driver".equals(driverName)) {
            templates.add("jdbc:db2://<host>:<port>/<dbname>");
            templates.add("jdbc:db2://<host>:50000");
        } else if ("org.postgresql.Driver".equals(driverName)) {
            templates.add("jdbc:postgresql:database");
            templates.add("jdbc:postgresql://host/database");
            templates.add("jdbc:postgresql://host:port/database");
            templates.add("jdbc:postgresql://host:port/database?user=userName&password=pass");
            templates.add("jdbc:postgresql://host:port/database?charSet=LATIN1&compatible=7.2");
        } else if ("com.mysql.jdbc.Driver".equals(driverName)) {
            templates.add("jdbc:mysql://[host][:port]/[database][?p1=v1]...");
            templates.add("jdbc:mysql://[host][,failoverhost...][:port]/[database]");
            templates.add("jdbc:mysql://[host][,failoverhost...][:port]/[database][?propertyName1][=propertyValue1][&propertyName2][=propertyValue2]...");
        } else if ("org.apache.derby.jdbc.EmbeddedDriver".equals(driverName)) {
            templates.add("jdbc:derby://host/database");
        } else if ("org.apache.derby.jdbc.ClientDriver".equals(driverName)) {
            templates.add("jdbc:derby://host/database");
        }
        return templates;
    }

    public static String getDescription(String driverName) {
        JdbcDriverTableModel model = JdbcDriverHelper.getModel();
        DriverInfoEntry entry = model.getEntry(driverName);
        if (entry != null) {
            return entry.getDescription();
        }
        return JdbcDriverHelper.getDefaultDescription(driverName);
    }

    public static String getDefaultDescription(String driverName) {
        if ("sun.jdbc.odbc.JdbcOdbcDriver".equals(driverName)) {
            return "JDBC - ODBC Bridge";
        }
        if ("com.sybase.jdbc3.jdbc.SybDriver".equals(driverName)) {
            return "Sybase JDBC 3.0 Driver";
        }
        if ("com.sybase.jdbc4.jdbc.SybDriver".equals(driverName)) {
            return "Sybase JDBC 4.0 Driver";
        }
        if ("net.sourceforge.jtds.jdbc.Driver".equals(driverName)) {
            return "jTDS JDBC Driver";
        }
        if ("org.h2.Driver".equals(driverName)) {
            return "H2 JDBC Driver";
        }
        if ("com.sap.db.jdbc.Driver".equals(driverName)) {
            return "SAP HANA JDBC Driver";
        }
        if ("com.sap.dbtech.jdbc.DriverSapDB".equals(driverName)) {
            return "SAP MaxDB JDBC Driver";
        }
        if ("oracle.jdbc.OracleDriver".equals(driverName)) {
            return "Oracle JDBC Driver";
        }
        if ("com.microsoft.jdbc.sqlserver.SQLServerDriver".equals(driverName)) {
            return "Microsoft SQL Server JDBC Driver";
        }
        if ("com.microsoft.sqlserver.jdbc.SQLServerDriver".equals(driverName)) {
            return "Microsoft SQL Server 2005 JDBC Driver";
        }
        if ("com.ibm.db2.jcc.DB2Driver".equals(driverName)) {
            return "IBM DB2 Driver";
        }
        if ("org.postgresql.Driver".equals(driverName)) {
            return "Postgres JDBC Driver";
        }
        if ("com.mysql.jdbc.Driver".equals(driverName)) {
            return "MySQL JDBC Driver";
        }
        if ("org.apache.derby.jdbc.EmbeddedDriver".equals(driverName)) {
            return "Derby Embedded JDBC Driver";
        }
        if ("org.apache.derby.jdbc.ClientDriver".equals(driverName)) {
            return "Derby Client JDBC Driver";
        }
        return "";
    }

    public static String getHomePage(String driverName) {
        JdbcDriverTableModel model = JdbcDriverHelper.getModel();
        DriverInfoEntry entry = model.getEntry(driverName);
        if (entry != null) {
            return entry.getHomePage();
        }
        return JdbcDriverHelper.getDefaultHomePage(driverName);
    }

    public static String getDefaultHomePage(String driverName) {
        if ("sun.jdbc.odbc.JdbcOdbcDriver".equals(driverName)) {
            return "en.wikipedia.org/wiki/JDBC_driver";
        }
        if ("com.sybase.jdbc3.jdbc.SybDriver".equals(driverName)) {
            return "www.sybase.com/jconnect";
        }
        if ("com.sybase.jdbc4.jdbc.SybDriver".equals(driverName)) {
            return "www.sybase.com/jconnect";
        }
        if ("net.sourceforge.jtds.jdbc.Driver".equals(driverName)) {
            return "jtds.sourceforge.net";
        }
        if ("org.h2.Driver".equals(driverName)) {
            return "www.h2database.com";
        }
        if ("com.sap.db.jdbc.Driver".equals(driverName)) {
            return "www.sap.com/HANA";
        }
        if ("com.sap.dbtech.jdbc.DriverSapDB".equals(driverName)) {
            return "maxdb.sap.com";
        }
        if ("oracle.jdbc.OracleDriver".equals(driverName)) {
            return "www.oracle.com/technetwork/database/features/jdbc";
        }
        if ("com.microsoft.jdbc.sqlserver.SQLServerDriver".equals(driverName)) {
            return "msdn.microsoft.com/en-US/sqlserver/aa937724";
        }
        if ("com.microsoft.sqlserver.jdbc.SQLServerDriver".equals(driverName)) {
            return "msdn.microsoft.com/en-US/sqlserver/aa937724";
        }
        if ("org.postgresql.Driver".equals(driverName)) {
            return "jdbc.postgresql.org";
        }
        if ("com.ibm.db2.jcc.DB2Driver".equals(driverName)) {
            return "www.ibm.com/software/data/db2";
        }
        if ("com.mysql.jdbc.Driver".equals(driverName)) {
            return "www.mysql.com/products/connector";
        }
        if ("org.apache.derby.jdbc.EmbeddedDriver".equals(driverName)) {
            return "db.apache.org/derby";
        }
        if ("org.apache.derby.jdbc.ClientDriver".equals(driverName)) {
            return "db.apache.org/derby";
        }
        return "";
    }

    public static String getDefaultClassNameForJarFile(String jarName) {
        if (jarName == null) {
            return "";
        }
        if (jarName.equals("jconn3.jar")) {
            return "com.sybase.jdbc3.jdbc.SybDriver";
        }
        if (jarName.equals("jconn4.jar")) {
            return "com.sybase.jdbc4.jdbc.SybDriver";
        }
        if (jarName.matches("jtds-.*\\.jar")) {
            return "net.sourceforge.jtds.jdbc.Driver";
        }
        if (jarName.matches("h2-.*\\.jar")) {
            return "org.h2.Driver";
        }
        if (jarName.equals("ngdbc.jar")) {
            return "com.sap.db.jdbc.Driver";
        }
        if (jarName.equals("sapdbc.jar.jar")) {
            return "com.sap.dbtech.jdbc.DriverSapDB";
        }
        if (jarName.matches("ojdbc.*\\.jar")) {
            return "oracle.jdbc.OracleDriver";
        }
        if (jarName.matches("sqljdbc.*\\.jar")) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        if (jarName.matches("db2jcc.*\\.jar")) {
            return "com.ibm.db2.jcc.DB2Driver";
        }
        if (jarName.matches("postgresql.*\\.jar")) {
            return "org.postgresql.Driver";
        }
        if (jarName.equals("mysql.jar")) {
            return "com.mysql.jdbc.Driver";
        }
        if (jarName.equals("derby.jar")) {
            return "org.apache.derby.jdbc.EmbeddedDriver";
        }
        if (jarName.equals("derbyclient.jar")) {
            return "org.apache.derby.jdbc.ClientDriver";
        }
        return "";
    }

    public static String guessDriverForUrl(String jdbcUrl) {
        if (StringUtil.isNullOrBlank(jdbcUrl)) {
            return "";
        }
        if (jdbcUrl.startsWith("jdbc:odbc:")) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        if (jdbcUrl.startsWith("jdbc:sybase:Tds:")) {
            return "com.sybase.jdbc4.jdbc.SybDriver";
        }
        if (jdbcUrl.startsWith("jdbc:jtds:")) {
            return "net.sourceforge.jtds.jdbc.Driver";
        }
        if (jdbcUrl.startsWith("jdbc:h2:")) {
            return "org.h2.Driver";
        }
        if (jdbcUrl.startsWith("jdbc:sap:")) {
            return "com.sap.db.jdbc.Driver";
        }
        if (jdbcUrl.startsWith("jdbc:sapdb:")) {
            return "com.sap.dbtech.jdbc.DriverSapDB";
        }
        if (jdbcUrl.startsWith("jdbc:oracle:thin:")) {
            return "oracle.jdbc.OracleDriver";
        }
        if (jdbcUrl.startsWith("jdbc:microsoft:sqlserver:")) {
            return "com.microsoft.jdbc.sqlserver.SQLServerDriver";
        }
        if (jdbcUrl.startsWith("jdbc:sqlserver:")) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        if (jdbcUrl.startsWith("jdbc:db2:")) {
            return "com.ibm.db2.jcc.DB2Driver";
        }
        if (jdbcUrl.startsWith("jdbc:postgresql:")) {
            return "org.postgresql.Driver";
        }
        if (jdbcUrl.startsWith("jdbc:mysql:")) {
            return "com.mysql.jdbc.Driver";
        }
        if (jdbcUrl.startsWith("jdbc:derby:")) {
            return "org.apache.derby.jdbc.ClientDriver";
        }
        if (jdbcUrl.startsWith("jdbc:derby:")) {
            return "org.apache.derby.jdbc.EmbeddedDriver";
        }
        return "";
    }

    public static List<String> getDriverList() {
        ArrayList<String> driverList = new ArrayList<String>();
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (drivers instanceof DriverWrapper) {
                driverList.add(((DriverWrapper)driver).getClassName());
                continue;
            }
            driverList.add(driver.getClass().getName());
        }
        return driverList;
    }

    public static String getFileName() {
        return _filename;
    }

    public static void setFileName(String filename) {
        _filename = filename;
    }

    private static void saveFile(boolean showGuiOnError) {
        block2: {
            try {
                JdbcDriverHelper.saveFile(JdbcDriverHelper.getFileName(), JdbcDriverHelper.getModel().getEntries(false));
            }
            catch (IOException ex) {
                if (!showGuiOnError) break block2;
                SwingUtils.showErrorMessage("writing to JDBC Driver File", "Problems writing to JDBC Driver File '" + JdbcDriverHelper.getFileName() + "'.", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveFile(String fileName, ArrayList<DriverInfoEntry> list) throws IOException {
        if (StringUtil.isNullOrBlank(fileName)) {
            fileName = JdbcDriverHelper.getFileName();
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(fileName, "rw");
            try (FileChannel channel = raf.getChannel();){
                FileLock lock = channel.lock();
                try {
                    channel.truncate(0L);
                    StringBuilder sb = new StringBuilder();
                    sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
                    sb.append("\n");
                    sb.append("<!-- \n");
                    sb.append("    BEGIN: Example of how a entry looks like \n");
                    DriverInfoEntry dummyExample = new DriverInfoEntry();
                    dummyExample.setClassName("com.provider.jdbc.class.name.Driver");
                    dummyExample.setDescription("Short Description of the JDBC Driver Provider");
                    dummyExample.setHomePage("www.somewhere.com/we/can/find/more/info");
                    dummyExample.setJarFile("c:/location/where/the/diver/is/located/name.jar");
                    dummyExample.addUrlTemplate("jdbc:xxx:<host>:<port>");
                    dummyExample.addUrlTemplate("jdbc:xxx:another_template");
                    dummyExample.addUrlTemplate("jdbc:xxx:some_other_template");
                    sb.append(dummyExample.toXml());
                    sb.append("    \n");
                    sb.append("    END: Example of how a entry looks like\n");
                    sb.append("-->\n");
                    sb.append("\n");
                    sb.append(XML_BEGIN_TAG_DRIVERS_LIST).append("\n");
                    sb.append("\n");
                    ByteBuffer byteBuffer = ByteBuffer.wrap(sb.toString().getBytes(Charset.forName("UTF-8")));
                    channel.write(byteBuffer);
                    for (DriverInfoEntry entry : list) {
                        if (entry.getInSystemPath()) continue;
                        sb.setLength(0);
                        sb.append(entry.toXml());
                        byteBuffer = ByteBuffer.wrap(sb.toString().getBytes(Charset.forName("UTF-8")));
                        channel.write(byteBuffer);
                    }
                    sb.setLength(0);
                    sb.append("\n");
                    sb.append(XML_END___TAG_DRIVERS_LIST).append("\n");
                    byteBuffer = ByteBuffer.wrap(sb.toString().getBytes(Charset.forName("UTF-8")));
                    channel.write(byteBuffer);
                    channel.force(true);
                }
                finally {
                    lock.release();
                }
            }
        }
        catch (IOException e) {
            _logger.warn((Object)("Problems writing to JDBC Driver File '" + fileName + "'. Caught: " + e));
            throw e;
        }
    }

    private static class JdbcDriverFileXmlParser
    extends DefaultHandler {
        private SAXParserFactory _saxFactory = SAXParserFactory.newInstance();
        private SAXParser _saxParser = null;
        private StringBuilder _xmlTagBuffer = new StringBuilder();
        private DriverInfoEntry _lastEntry = new DriverInfoEntry();
        private ArrayList<DriverInfoEntry> _entryList = new ArrayList();

        private JdbcDriverFileXmlParser() {
            try {
                this._saxParser = this._saxFactory.newSAXParser();
            }
            catch (SAXException e) {
                _logger.warn((Object)("Problems Creating JDBC Driver File XML Parser '" + JdbcDriverHelper.getFileName() + "'. Caught: " + e), (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                _logger.warn((Object)("Problems Creating JDBC Driver File XML Parser '" + JdbcDriverHelper.getFileName() + "'. Caught: " + e), (Throwable)e);
            }
        }

        public ArrayList<DriverInfoEntry> parseFile(String fileName) {
            this._lastEntry = new DriverInfoEntry();
            this._entryList = new ArrayList();
            try {
                this._saxParser.parse(new File(fileName), (DefaultHandler)this);
            }
            catch (SAXException e) {
                _logger.warn((Object)("Problems Parsing JDBC Driver File File '" + fileName + "'. Caught: " + e), (Throwable)e);
            }
            catch (FileNotFoundException e) {
                _logger.info((Object)("The JDBC Driver File '" + fileName + "' wasn't found. Caught: " + e));
            }
            catch (IOException e) {
                _logger.warn((Object)("Problems Parsing JDBC Driver File '" + fileName + "'. Caught: " + e), (Throwable)e);
            }
            return this._entryList;
        }

        @Override
        public void characters(char[] buffer, int start, int length) {
            this._xmlTagBuffer.append(buffer, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this._xmlTagBuffer.setLength(0);
            if (JdbcDriverHelper.XML_TAG_DRIVER_ENTRY.equals(qName)) {
                this._lastEntry = new DriverInfoEntry();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (JdbcDriverHelper.XML_TAG_DRIVER_ENTRY.equals(qName)) {
                if (this._entryList == null) {
                    this._entryList = new ArrayList();
                }
                this._entryList.add(this._lastEntry);
            } else if (JdbcDriverHelper.XML_SUBTAG_CLASSNAME.equals(qName)) {
                this._lastEntry.setClassName(this._xmlTagBuffer.toString().trim());
            } else if (JdbcDriverHelper.XML_SUBTAG_DESCRIPTION.equals(qName)) {
                this._lastEntry.setDescription(this._xmlTagBuffer.toString().trim());
            } else if (JdbcDriverHelper.XML_SUBTAG_HOME_PAGE.equals(qName)) {
                this._lastEntry.setHomePage(this._xmlTagBuffer.toString().trim());
            } else if (JdbcDriverHelper.XML_SUBTAG_JAR_FILE.equals(qName)) {
                this._lastEntry.setJarFile(this._xmlTagBuffer.toString().trim());
            } else if (JdbcDriverHelper.XML_SUBTAG_URL_TEMPLATE.equals(qName)) {
                this._lastEntry.addUrlTemplate(this._xmlTagBuffer.toString().trim());
            }
            this._xmlTagBuffer.setLength(0);
        }
    }

    private static class AddOrChangeEntryDialog
    extends JDialog
    implements ActionListener,
    FocusListener {
        private static final long serialVersionUID = 1L;
        public int _dialogType = -1;
        public static int ADD_DIALOG = 1;
        public static int CHANGE_DIALOG = 2;
        private JButton _ok = new JButton("OK");
        private JButton _cancel = new JButton("Cancel");
        private DriverInfoEntry _return = null;
        private DriverInfoEntry _entry = null;
        private JLabel _className_lbl = new JLabel("Classname");
        private JTextField _className_txt = new JTextField();
        private JLabel _description_lbl = new JLabel("Description");
        private JTextField _description_txt = new JTextField();
        private JLabel _homePage_lbl = new JLabel("Home Page");
        private JTextField _homePage_txt = new JTextField();
        private JLabel _jarFile_lbl = new JLabel("JAR File");
        private JTextField _jarFile_txt = new JTextField();
        private JButton _jarFile_but = new JButton("...");
        private JLabel _urlTemplateLst_lbl = new JLabel("URL Template List");
        private DefaultListModel _urlTemplateLst_dlm = new DefaultListModel();
        private JList _urlTemplateLst_lst = new JList(this._urlTemplateLst_dlm);
        private JLabel _urlTemplate_lbl = new JLabel("URL Template");
        private JTextField _urlTemplate_txt = new JTextField();
        private JButton _urlTemplateAdd_but = new JButton("Add");
        private JButton _urlTemplateRemove_but = new JButton("Remove");

        private AddOrChangeEntryDialog(JDialog owner, DriverInfoEntry entry) {
            super(owner, "", true);
            this._dialogType = entry == null ? ADD_DIALOG : CHANGE_DIALOG;
            this._entry = entry;
            if (this._entry == null) {
                this._entry = new DriverInfoEntry();
            }
            this.initComponents();
            this.pack();
        }

        public static DriverInfoEntry showDialog(JDialog owner, DriverInfoEntry entry) {
            AddOrChangeEntryDialog dialog = new AddOrChangeEntryDialog(owner, entry);
            dialog.setLocationRelativeTo(owner);
            dialog.setFocus();
            dialog.setVisible(true);
            dialog.dispose();
            return dialog._return;
        }

        protected void initComponents() {
            JPanel panel = new JPanel();
            panel.setLayout((LayoutManager)new MigLayout("insets 20 20"));
            if (this._dialogType == ADD_DIALOG) {
                this.setTitle("New JDBC Driver");
            } else if (this._dialogType == CHANGE_DIALOG) {
                this.setTitle("Change JDBC Driver");
            } else {
                throw new RuntimeException("Unknown Dialog Type");
            }
            this._className_lbl.setToolTipText("<html>Classname of the JDBC Driver, for example <i>com.sybase.jdbc4.jdbc.SybDriver</i>.</html>");
            this._className_txt.setToolTipText(this._className_lbl.getToolTipText());
            this._description_lbl.setToolTipText("<html><i><b>Optional</b></i> A Text description of what this this JDBC Driver is. (from what company etc...)</html>");
            this._description_txt.setToolTipText(this._description_lbl.getToolTipText());
            this._homePage_lbl.setToolTipText("<html><i><b>Optional</b></i> A web page where you can find some info about the Driver</html>");
            this._homePage_txt.setToolTipText(this._homePage_lbl.getToolTipText());
            this._jarFile_lbl.setToolTipText("<html>Name of the JAR file the Driver (above Classname) is located in.</html>");
            this._jarFile_txt.setToolTipText(this._jarFile_lbl.getToolTipText());
            this._jarFile_but.setToolTipText("<html>Open a File Dialog where you can choose a JAR File.</html>");
            this._urlTemplateLst_lbl.setToolTipText("<html>List of Examples/Templates that could be used when connecting using this Driver.</html>");
            this._urlTemplateLst_lst.setToolTipText(this._urlTemplateLst_lst.getToolTipText());
            this._urlTemplate_lbl.setToolTipText("<html><i><b>Optional</b></i> A Template which can be used when connecting using this JDBC Driver.<br>Multiple Templates can be added.</html>");
            this._urlTemplate_txt.setToolTipText(this._urlTemplate_lbl.getToolTipText());
            this._urlTemplateAdd_but.setToolTipText("<html>Add <b>this</b> entry to the list of URL Templates for this Driver.</html>");
            this._urlTemplateRemove_but.setToolTipText("<html>Remove <b>this/selected</b> entry to the list of URL Templates for this Driver.</html>");
            panel.add((Component)this._className_lbl, "");
            panel.add((Component)this._className_txt, "pushx, growx, wrap");
            panel.add((Component)this._description_lbl, "");
            panel.add((Component)this._description_txt, "pushx, growx, wrap");
            panel.add((Component)this._homePage_lbl, "");
            panel.add((Component)this._homePage_txt, "pushx, growx, wrap");
            panel.add((Component)this._jarFile_lbl, "");
            panel.add((Component)this._jarFile_txt, "split, span 2, pushx, growx");
            panel.add((Component)this._jarFile_but, "wrap 15");
            JScrollPane scroll = new JScrollPane();
            scroll.setViewportView(this._urlTemplateLst_lst);
            panel.add((Component)this._urlTemplateLst_lbl, "");
            panel.add((Component)scroll, "push, grow, wrap");
            panel.add((Component)this._urlTemplate_lbl, "");
            panel.add((Component)this._urlTemplate_txt, "split, span 3, pushx, growx");
            panel.add((Component)this._urlTemplateAdd_but, "");
            panel.add((Component)this._urlTemplateRemove_but, "wrap 15");
            panel.add((Component)this._ok, "tag ok,     gap top 20, skip, split, bottom, right, pushx");
            panel.add((Component)this._cancel, "tag cancel,                   split, bottom");
            this.setContentPane(panel);
            this._className_txt.setText(this._entry.getClassName());
            this._description_txt.setText(this._entry.getDescription());
            this._homePage_txt.setText(this._entry.getHomePage());
            this._jarFile_txt.setText(this._entry.getJarFile());
            for (String urlTemplate : this._entry.getUrlTemplateList()) {
                this._urlTemplateLst_dlm.addElement(urlTemplate);
            }
            this._jarFile_but.addActionListener(this);
            this._urlTemplate_txt.addActionListener(this);
            this._urlTemplateAdd_but.addActionListener(this);
            this._urlTemplateRemove_but.addActionListener(this);
            this._ok.addActionListener(this);
            this._cancel.addActionListener(this);
            this._className_txt.addFocusListener(this);
            this._description_txt.addFocusListener(this);
            this._homePage_txt.addFocusListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String dir;
            JFileChooser fc;
            int returnVal;
            Object source = e.getSource();
            if (this._ok.equals(source)) {
                this._entry.setClassName(this._className_txt.getText());
                this._entry.setDescription(this._description_txt.getText());
                this._entry.setHomePage(this._homePage_txt.getText());
                this._entry.setJarFile(this._jarFile_txt.getText());
                ArrayList<String> urlTemplates = new ArrayList<String>();
                for (int i = 0; i < this._urlTemplateLst_dlm.size(); ++i) {
                    urlTemplates.add(this._urlTemplateLst_dlm.getElementAt(i) + "");
                }
                this._entry.setUrlTemplateList(urlTemplates);
                this._return = this._entry;
                this.setVisible(false);
            }
            if (this._cancel.equals(source)) {
                this._return = null;
                this.setVisible(false);
            }
            if (this._jarFile_but.equals(source) && (returnVal = (fc = new JFileChooser(dir = this._jarFile_txt.getText())).showOpenDialog(this)) == 0) {
                File retFile = fc.getSelectedFile();
                this._jarFile_txt.setText(retFile.getAbsolutePath());
                String filename = retFile.getName();
                String className = JdbcDriverHelper.getDefaultClassNameForJarFile(filename);
                this._className_txt.setText(className);
                this.focusLost(null);
            }
            if (this._urlTemplateAdd_but.equals(source) || this._urlTemplate_txt.equals(source)) {
                String template = this._urlTemplate_txt.getText();
                this._urlTemplateLst_dlm.addElement(template);
            }
            if (this._urlTemplateRemove_but.equals(source)) {
                int index = this._urlTemplateLst_lst.getSelectedIndex();
                if (index >= 0) {
                    this._urlTemplateLst_dlm.remove(index);
                } else {
                    SwingUtils.showInfoMessage(this, "Select a row", "Please select a row you want to delete");
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object source = null;
            if (e != null) {
                source = e.getSource();
            }
            if (this._className_txt.equals(source) || source == null) {
                String className = this._className_txt.getText().trim();
                if (this._urlTemplateLst_dlm.size() == 0) {
                    List<String> urlTemplates = JdbcDriverHelper.getDefaultUrlTemplateList(className);
                    for (String template : urlTemplates) {
                        this._urlTemplateLst_dlm.addElement(template);
                    }
                }
                if (this._description_txt.getText().trim().equals("")) {
                    this._description_txt.setText(JdbcDriverHelper.getDefaultDescription(className));
                }
                if (this._homePage_txt.getText().trim().equals("")) {
                    this._homePage_txt.setText(JdbcDriverHelper.getDefaultHomePage(className));
                }
            }
            if (this._description_txt.equals(source)) {
                // empty if block
            }
            if (this._homePage_txt.equals(source)) {
                // empty if block
            }
        }

        private void setFocus() {
            Runnable deferredAction = new Runnable(){

                @Override
                public void run() {
                    _className_txt.requestFocus();
                }
            };
            SwingUtilities.invokeLater(deferredAction);
        }
    }

    public static class JdbcDriverTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private static final String[] TAB_HEADER = new String[]{"System", "Class", "Description", "Home Page", "Jar File", "toString", "Version"};
        private static final int TAB_POS_SYSTEM = 0;
        private static final int TAB_POS_CLASS = 1;
        private static final int TAB_POS_DESC = 2;
        private static final int TAB_POS_HOME_PAGE = 3;
        private static final int TAB_POS_JAR_FILE = 4;
        private static final int TAB_POS_TO_STRING = 5;
        private static final int TAB_POS_VERSION = 6;
        private ArrayList<DriverInfoEntry> _rows = new ArrayList();
        private boolean _hasChanged = false;

        public JdbcDriverTableModel() {
            this.loadModel(true);
        }

        public boolean isChanged() {
            return this._hasChanged;
        }

        public void setChanged(boolean changed) {
            this._hasChanged = changed;
        }

        public void clear(boolean fireChange) {
            this._rows.clear();
            this.setChanged(true);
            if (fireChange) {
                this.fireTableDataChanged();
            }
        }

        public void reload() {
            this.clear(false);
            this.loadModel(true);
        }

        public DriverInfoEntry getEntry(String driver) {
            for (DriverInfoEntry entry : this._rows) {
                if (!entry.getClassName().equals(driver)) continue;
                return entry;
            }
            return null;
        }

        public DriverInfoEntry getEntry(int mrow) {
            return this._rows.get(mrow);
        }

        public ArrayList<DriverInfoEntry> getEntries(boolean includeSystemPath) {
            ArrayList<DriverInfoEntry> retRows = new ArrayList<DriverInfoEntry>();
            for (DriverInfoEntry entry : this._rows) {
                if (includeSystemPath && entry.getInSystemPath()) {
                    retRows.add(entry);
                    continue;
                }
                retRows.add(entry);
            }
            return retRows;
        }

        public void deleteEntry(int mrow, boolean deRegisterInDriverManager) {
            DriverInfoEntry entry;
            if (deRegisterInDriverManager && (entry = this.getEntry(mrow)) != null) {
                DriverWrapper.deregisterDriver(entry.getClassName());
            }
            this._rows.remove(mrow);
            this.setChanged(true);
            this.fireTableDataChanged();
        }

        public void setEntries(ArrayList<DriverInfoEntry> entries, boolean fireChange) {
            this._rows = entries;
            this.setChanged(true);
            if (fireChange) {
                this.fireTableDataChanged();
            }
        }

        public void addEntry(DriverInfoEntry entry) {
            this._rows.add(entry);
            this.setChanged(true);
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return TAB_HEADER.length;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return TAB_HEADER[0];
                }
                case 1: {
                    return TAB_HEADER[1];
                }
                case 2: {
                    return TAB_HEADER[2];
                }
                case 3: {
                    return TAB_HEADER[3];
                }
                case 4: {
                    return TAB_HEADER[4];
                }
                case 5: {
                    return TAB_HEADER[5];
                }
                case 6: {
                    return TAB_HEADER[6];
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column != 0;
        }

        @Override
        public int getRowCount() {
            return this._rows.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            DriverInfoEntry entry = this._rows.get(row);
            switch (column) {
                case 0: {
                    return entry.getInSystemPath();
                }
                case 1: {
                    return entry.getClassName();
                }
                case 2: {
                    return entry.getDescription();
                }
                case 3: {
                    return entry.getHomePage();
                }
                case 4: {
                    return entry.getJarFile();
                }
                case 5: {
                    return entry.getToString();
                }
                case 6: {
                    return entry.getVersion();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(column);
        }

        private void loadModel(boolean parseXmlFile) {
            if (parseXmlFile) {
                File checkFile = new File(JdbcDriverHelper.getFileName());
                if (!checkFile.exists()) {
                    _logger.info((Object)("User Defined JDBC Drivers file '" + JdbcDriverHelper.getFileName() + "', doesn't exist, try to create an empty."));
                    ArrayList empty = new ArrayList();
                    try {
                        JdbcDriverHelper.saveFile(JdbcDriverHelper.getFileName(), empty);
                    }
                    catch (IOException ex) {
                        _logger.warn((Object)("Problems creating: User Defined JDBC Drivers file '" + JdbcDriverHelper.getFileName() + "'. Disregarding this. Caught: " + ex));
                    }
                }
                JdbcDriverFileXmlParser parser = new JdbcDriverFileXmlParser();
                ArrayList<DriverInfoEntry> parsedEntries = parser.parseFile(JdbcDriverHelper.getFileName());
                _logger.info((Object)("Get User Defined JDBC Drivers by parsing the file '" + JdbcDriverHelper.getFileName() + "', which contained " + parsedEntries.size() + " entries."));
                for (DriverInfoEntry entry : parsedEntries) {
                    try {
                        DriverWrapper.install(entry.getClassName(), entry.getJarFile(), entry.getHomePage(), entry.getDescription(), entry.getUrlTemplateList());
                    }
                    catch (Exception ex) {
                        _logger.warn((Object)("Problems installing JDBC Driver='" + entry.getClassName() + "', JarFile='" + entry.getJarFile() + "'. This one will simply not be available. Caught: " + ex));
                    }
                }
            }
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            while (drivers.hasMoreElements()) {
                CodeSource src;
                boolean inSystemPath = true;
                Driver driver = drivers.nextElement();
                String className = driver.getClass().getName();
                String jarFile = "<in system classpath>";
                String desc = "";
                String homePage = "";
                String version = "";
                ArrayList<String> templates = new ArrayList();
                _logger.debug((Object)("DriverManager-Entry: classname='" + className + "', driver='" + driver + "'."));
                if (driver instanceof DriverWrapper) {
                    DriverWrapper w = (DriverWrapper)driver;
                    inSystemPath = false;
                    className = w.getClassName();
                    jarFile = w.getJarFile();
                    desc = w.getDecription();
                    homePage = w.getHomePage();
                    templates = w.getUrlTemplateList();
                    driver = w.getDriver();
                    _logger.debug((Object)("DRIVER IS A WRAPPER. classname='" + className + "', jarFile='" + jarFile + "'."));
                } else {
                    inSystemPath = true;
                    desc = JdbcDriverHelper.getDefaultDescription(className);
                    homePage = JdbcDriverHelper.getDefaultHomePage(className);
                    templates = JdbcDriverHelper.getDefaultUrlTemplateList(className);
                }
                ProtectionDomain protDom = driver.getClass().getProtectionDomain();
                if (protDom != null && (src = protDom.getCodeSource()) != null) {
                    URL jar = src.getLocation();
                    jarFile = jar + "";
                    _logger.debug((Object)("DriverManager-Entry: classname='" + className + "', driver='" + driver + "' can be located in JAR File '" + jarFile + "'."));
                }
                try {
                    DriverPropertyInfo[] dpi = driver.getPropertyInfo("", null);
                    if (dpi != null) {
                        for (int i = 0; i < dpi.length; ++i) {
                            String dpiName = dpi[i].name;
                            String dpiValue = dpi[i].value;
                            if (dpiName == null || !dpiName.toLowerCase().startsWith("version") || (version = dpiValue) == null || version.indexOf(10) < 0) continue;
                            version = version.substring(0, version.indexOf(10));
                        }
                    }
                }
                catch (Throwable dpi) {
                    // empty catch block
                }
                DriverInfoEntry entry = new DriverInfoEntry();
                entry.setInSystemPath(inSystemPath);
                entry.setClassName(className);
                entry.setDescription(desc);
                entry.setHomePage(homePage);
                entry.setVersion(version);
                entry.setJarFile(jarFile);
                entry.setToString(driver.toString());
                entry.setUrlTemplateList(templates);
                this.addEntry(entry);
            }
        }
    }

    public static class DriverInfoEntry {
        private boolean _inSystemPath = false;
        private String _className = null;
        private String _description = null;
        private String _homePage = null;
        private String _version = null;
        private String _jarFile = null;
        private String _toString = null;
        private List<String> _urlTemplateList = new ArrayList<String>();

        public static DriverInfoEntry cloneEntry(DriverInfoEntry entry) {
            DriverInfoEntry cloned = new DriverInfoEntry();
            cloned.setInSystemPath(false);
            cloned.setClassName("Cloned: " + entry.getClassName());
            cloned.setDescription("Cloned: " + entry.getDescription());
            cloned.setHomePage("Cloned: " + entry.getHomePage());
            cloned.setVersion(entry.getVersion());
            cloned.setJarFile(entry.getJarFile().replace("file:/", ""));
            cloned.setUrlTemplateList(entry.getUrlTemplateList());
            return cloned;
        }

        public boolean getInSystemPath() {
            return this._inSystemPath;
        }

        public String getClassName() {
            return this._className;
        }

        public String getDescription() {
            return this._description;
        }

        public String getHomePage() {
            return this._homePage;
        }

        public String getVersion() {
            return this._version;
        }

        public String getJarFile() {
            return this._jarFile;
        }

        public String getToString() {
            return this._toString;
        }

        public List<String> getUrlTemplateList() {
            return this._urlTemplateList;
        }

        public void setInSystemPath(boolean inSystemPath) {
            this._inSystemPath = inSystemPath;
        }

        public void setClassName(String className) {
            if (className == null) {
                className = "";
            }
            this._className = className;
        }

        public void setDescription(String description) {
            if (description == null) {
                description = "";
            }
            this._description = description;
        }

        public void setHomePage(String homePage) {
            if (homePage == null) {
                homePage = "";
            }
            this._homePage = homePage;
        }

        public void setVersion(String version) {
            if (version == null) {
                version = "";
            }
            this._version = version;
        }

        public void setJarFile(String jarFile) {
            if (jarFile == null) {
                jarFile = "";
            }
            if (jarFile.startsWith("file:/")) {
                jarFile = jarFile.substring("file:/".length());
            }
            if (jarFile.startsWith("jar:file:")) {
                jarFile = jarFile.substring("jar:file:".length());
            }
            if (jarFile.endsWith("!/")) {
                jarFile = jarFile.substring(0, jarFile.length() - "!/".length());
            }
            this._jarFile = jarFile;
        }

        public void setToString(String toString) {
            if (toString == null) {
                toString = "";
            }
            this._toString = toString;
        }

        public void setUrlTemplateList(List<String> urlTemplates) {
            if (urlTemplates == null) {
                urlTemplates = new ArrayList<String>();
            }
            this._urlTemplateList = urlTemplates;
        }

        public void addUrlTemplate(String urlTemplate) {
            if (urlTemplate == null) {
                urlTemplate = "";
            }
            this._urlTemplateList.add(urlTemplate);
        }

        public String toXml() {
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append("    ").append(JdbcDriverHelper.XML_BEGIN_TAG_DRIVER_ENTRY).append("\n");
            sb.append("        ").append(JdbcDriverHelper.XML_BEGIN_SUBTAG_CLASSNAME).append(StringUtil.xmlSafe(this.getClassName())).append(JdbcDriverHelper.XML_END___SUBTAG_CLASSNAME).append("\n");
            sb.append("        ").append(JdbcDriverHelper.XML_BEGIN_SUBTAG_DESCRIPTION).append(StringUtil.xmlSafe(this.getDescription())).append(JdbcDriverHelper.XML_END___SUBTAG_DESCRIPTION).append("\n");
            sb.append("        ").append(JdbcDriverHelper.XML_BEGIN_SUBTAG_HOME_PAGE).append(StringUtil.xmlSafe(this.getHomePage())).append(JdbcDriverHelper.XML_END___SUBTAG_HOME_PAGE).append("\n");
            sb.append("        ").append(JdbcDriverHelper.XML_BEGIN_SUBTAG_JAR_FILE).append(StringUtil.xmlSafe(this.getJarFile())).append(JdbcDriverHelper.XML_END___SUBTAG_JAR_FILE).append("\n");
            for (String urlTemplate : this.getUrlTemplateList()) {
                sb.append("        ").append(JdbcDriverHelper.XML_BEGIN_SUBTAG_URL_TEMPLATE).append(StringUtil.xmlSafe(urlTemplate)).append(JdbcDriverHelper.XML_END___SUBTAG_URL_TEMPLATE).append("\n");
            }
            sb.append("    ").append(JdbcDriverHelper.XML_END___TAG_DRIVER_ENTRY).append("\n");
            return sb.toString();
        }
    }

    public static class JdbcDriverInfoPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JXTable _table = new JXTable();
        private JdbcDriverTableModel _tm = null;
        private JTextArea _xmlFile = new JTextArea(JdbcDriverHelper.getFileName());
        private JButton _reload_but = new JButton("Reload");
        private JButton _download_but = new JButton("Download");
        private JButton _addDriver_but = new JButton("Add/Change Driver");
        private JButton _delDriver_but = new JButton("Delete Driver");

        public JdbcDriverInfoPanel() {
            this.init();
        }

        private String getDriversPath() {
            File driversDir = new File(Version.APP_STORE_DIR + File.separator + "jdbc_drivers");
            if (!driversDir.exists() && driversDir.mkdir()) {
                _logger.info((Object)("Creating directory '" + driversDir + "' to hold JDBC Driver files for " + Version.getAppName()));
            }
            return driversDir.toString();
        }

        private void init() {
            String driversDir = this.getDriversPath();
            this._xmlFile.setToolTipText("This is where JDBC Drivers not included in the classpath will be described.");
            this._reload_but.setToolTipText("Reload JDBC Drivers from the above XML file");
            this._download_but.setToolTipText("<html>Download various JDBC drivers<br>" + Version.getAppName() + " can't distribute a lot of JDBC Drivers, so you need to download them yourself.<br><br>This will just open a web page that has a collection of various JDBC Drivers that can be downloaded.<br>Put them in the directory <code>" + driversDir + "</code> and restart " + Version.getAppName() + ".</html>");
            this._addDriver_but.setToolTipText("Open a Dialog to add a JDBC Driver");
            this._delDriver_but.setToolTipText("Delete the selected Driver in the list");
            JLabel dummy = new JLabel("dummy");
            this._xmlFile.setEditable(false);
            this._xmlFile.setBackground(dummy.getBackground());
            this._xmlFile.setFont(dummy.getFont());
            JScrollPane scroll = new JScrollPane();
            scroll.setViewportView((Component)this._table);
            this._tm = JdbcDriverHelper.getModel();
            this._table.setModel((TableModel)this._tm);
            this._table.setSortable(true);
            this._table.setAutoResizeMode(0);
            this._table.setColumnControlVisible(true);
            this._table.packAll();
            this._table.setPreferredScrollableViewportSize(new Dimension(400, 100));
            this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0"));
            this.add((Component)scroll, "span, push, grow, wrap");
            this.add((Component)this._xmlFile, "span, pushx, growx, wrap");
            this.add((Component)this._reload_but, "");
            this.add((Component)new JLabel(), "span, split, growx, pushx");
            this.add((Component)this._download_but, "");
            this.add((Component)this._addDriver_but, "");
            this.add((Component)this._delDriver_but, "wrap");
            this._reload_but.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    _tm.reload();
                    _table.packAll();
                }
            });
            this._download_but.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Desktop desktop;
                    if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                        _logger.info((Object)"You clicked on Download Drivers 'http://www.asetune.com/jdbc_drivers_download.php'. Browser will be opened.");
                        try {
                            desktop.browse(new URI("http://www.asetune.com/jdbc_drivers_download.php?toLocation=" + URLEncoder.encode(this.getDriversPath(), "UTF-8")));
                        }
                        catch (Exception ex) {
                            _logger.error((Object)("Problems when open the URL 'http://www.asetune.com/jdbc_drivers_download.php'. Caught: " + ex));
                        }
                    }
                }
            });
            this._addDriver_but.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int vrow = _table.getSelectedRow();
                    if (vrow >= 0) {
                        int mrow = _table.convertRowIndexToModel(vrow);
                        DriverInfoEntry entry = _tm.getEntry(mrow);
                        if (entry.getInSystemPath()) {
                            SwingUtils.showInfoMessage("In System Class Path", "<html>Can't change properties for a JDBC Driver in the System Class Path<br>So the entry was <b>cloned</b> with a new name</html>");
                            DriverInfoEntry cloneEntry = DriverInfoEntry.cloneEntry(entry);
                            DriverInfoEntry retEntry = AddOrChangeEntryDialog.showDialog(null, cloneEntry);
                            if (retEntry != null) {
                                _tm.addEntry(retEntry);
                            }
                            JdbcDriverHelper.saveFile(true);
                        } else {
                            DriverInfoEntry retEntry = AddOrChangeEntryDialog.showDialog(null, entry);
                            if (retEntry != null) {
                                _tm.fireTableDataChanged();
                            }
                            JdbcDriverHelper.saveFile(true);
                        }
                    } else {
                        DriverInfoEntry retEntry = AddOrChangeEntryDialog.showDialog(null, null);
                        if (retEntry != null) {
                            _tm.addEntry(retEntry);
                        }
                        JdbcDriverHelper.saveFile(true);
                    }
                    _reload_but.doClick();
                }
            });
            this._delDriver_but.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int vrow = _table.getSelectedRow();
                    if (vrow >= 0) {
                        int mrow = _table.convertRowIndexToModel(vrow);
                        DriverInfoEntry entry = _tm.getEntry(mrow);
                        if (entry.getInSystemPath()) {
                            SwingUtils.showInfoMessage("In System Class Path", "Sorry Can't delete a JDBC Driver in the System Class Path");
                        } else {
                            _tm.deleteEntry(mrow, true);
                            JdbcDriverHelper.saveFile(true);
                        }
                    } else {
                        SwingUtils.showInfoMessage(null, "Select a row", "Please select a row you want to delete");
                    }
                    _reload_but.doClick();
                }
            });
        }
    }

    private static class ParentLastURLClassLoader
    extends ClassLoader {
        private ChildURLClassLoader childClassLoader;

        public ParentLastURLClassLoader(List<URL> classpath) {
            super(Thread.currentThread().getContextClassLoader());
            URL[] urls = classpath.toArray(new URL[classpath.size()]);
            this.childClassLoader = new ChildURLClassLoader(urls, new FindClassClassLoader(this.getParent()));
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                return this.childClassLoader.findClass(name);
            }
            catch (ClassNotFoundException e) {
                return super.loadClass(name, resolve);
            }
        }

        private static class ChildURLClassLoader
        extends URLClassLoader {
            private FindClassClassLoader realParent;

            public ChildURLClassLoader(URL[] urls, FindClassClassLoader realParent) {
                super(urls, (ClassLoader)null);
                this.realParent = realParent;
            }

            @Override
            public Class<?> findClass(String name) throws ClassNotFoundException {
                try {
                    return super.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    return this.realParent.loadClass(name);
                }
            }
        }

        private static class FindClassClassLoader
        extends ClassLoader {
            public FindClassClassLoader(ClassLoader parent) {
                super(parent);
            }

            @Override
            public Class<?> findClass(String name) throws ClassNotFoundException {
                return super.findClass(name);
            }
        }
    }

    private static class DriverWrapper
    implements Driver {
        private Driver _driver;
        private String _jarFile;
        private String _homePage;
        private String _desc;
        private List<String> _urlTemplateList;

        DriverWrapper(Driver driver) {
            this._driver = driver;
        }

        public static void install(String className, String jarFile, String homePage, String desc, List<String> urlTemplateList) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException, MalformedURLException {
            URL url = new URL("jar:file:" + jarFile + "!/");
            ArrayList<URL> urlList = new ArrayList<URL>();
            urlList.add(url);
            ParentLastURLClassLoader cl = new ParentLastURLClassLoader(urlList);
            Driver driver = (Driver)Class.forName(className, true, cl).newInstance();
            DriverWrapper driverWrapper = new DriverWrapper(driver);
            DriverWrapper.deregisterDriver(className);
            DriverManager.registerDriver(driverWrapper);
            driverWrapper._driver = driver;
            driverWrapper._jarFile = jarFile;
            driverWrapper._homePage = homePage;
            driverWrapper._desc = desc;
            driverWrapper._urlTemplateList = urlTemplateList != null ? urlTemplateList : new ArrayList();
        }

        public static void deregisterDriver(String className) {
            Enumeration<Driver> driversEnum = DriverManager.getDrivers();
            while (driversEnum.hasMoreElements()) {
                Driver dmDriver = driversEnum.nextElement();
                String dmClassName = dmDriver.getClass().getName();
                if (dmDriver instanceof DriverWrapper) {
                    dmClassName = ((DriverWrapper)dmDriver).getClassName();
                }
                if (!dmClassName.equals(className)) continue;
                try {
                    DriverManager.deregisterDriver(dmDriver);
                }
                catch (SQLException ex) {
                    _logger.warn((Object)("Problems de-register driver='" + dmDriver + "'. Caught: " + ex));
                }
            }
        }

        @Override
        public boolean acceptsURL(String u) throws SQLException {
            return this._driver.acceptsURL(u);
        }

        @Override
        public Connection connect(String u, Properties p) throws SQLException {
            return this._driver.connect(u, p);
        }

        @Override
        public int getMajorVersion() {
            return this._driver.getMajorVersion();
        }

        @Override
        public int getMinorVersion() {
            return this._driver.getMinorVersion();
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String u, Properties p) throws SQLException {
            return this._driver.getPropertyInfo(u, p);
        }

        @Override
        public boolean jdbcCompliant() {
            return this._driver.jdbcCompliant();
        }

        public String toString() {
            return this._driver.toString();
        }

        public Driver getDriver() {
            return this._driver;
        }

        public String getClassName() {
            return this._driver.getClass().getName();
        }

        public String getJarFile() {
            return this._jarFile;
        }

        public String getDecription() {
            return this._desc;
        }

        public String getHomePage() {
            return this._homePage;
        }

        public List<String> getUrlTemplateList() {
            return this._urlTemplateList;
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return null;
        }
    }
}

