/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui;

import com.sap.dbmtk.demo.Version;
import com.sap.dbmtk.demo.utils.Configuration;
import com.sap.dbmtk.demo.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.sort.RowFilters;
import org.jdesktop.swingx.table.TableColumnExt;

public class JdbcOptionsDialog
extends JDialog
implements ActionListener,
TableModelListener {
    private static Logger _logger = Logger.getLogger(JdbcOptionsDialog.class);
    private static final long serialVersionUID = 1L;
    private LocalTable _table = null;
    private JButton _ok = new JButton("OK");
    private JButton _cancel = new JButton("Cancel");
    private String _driverClassName = null;
    private String _urlTemplate = null;
    private Map<String, String> _inValues = null;
    private Map<String, String> _outValues = null;
    private JLabel _optionsFilter_lbl = new JLabel("Filter");
    private JTextField _optionsFilter_txt = new JTextField();
    private static final String DIALOG_TITLE = "Options for the JDBC Driver";
    private static final String[] TAB_HEADER = new String[]{"Use", "Non System", "Required", "Option Name", "Value", "Description"};
    private static final int TAB_POS_USE = 0;
    private static final int TAB_POS_USER_DEFINED = 1;
    private static final int TAB_POS_OPT_REQUIRED = 2;
    private static final int TAB_POS_OPT_NAME = 3;
    private static final int TAB_POS_OPT_VALUE = 4;
    private static final int TAB_POS_OPT_DESC = 5;

    private JdbcOptionsDialog(Dialog owner, String driverClassName, String urlTemplate, Map<String, String> inValues) {
        super(owner, "Options for the JDBC Driver '" + driverClassName + "'", true);
        this._driverClassName = driverClassName;
        this._urlTemplate = urlTemplate;
        this._inValues = inValues;
        if (this._inValues == null) {
            this._inValues = new HashMap<String, String>();
        }
        this.initComponents();
    }

    public static Map<String, String> showDialog(Dialog owner, String driverClassName, String urlTemplate, Map<String, String> inValues) {
        JdbcOptionsDialog options = new JdbcOptionsDialog(owner, driverClassName, urlTemplate, inValues);
        options.setLocationRelativeTo(owner);
        options.setVisible(true);
        options.dispose();
        return options._outValues;
    }

    protected void initComponents() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 0, wrap 1", "", ""));
        panel.add((Component)this.createTopPanel(), "growx, pushx");
        panel.add((Component)this.createTablePanel(), "grow, push, height 100%");
        panel.add((Component)this.createOkCancelPanel(), "bottom, right, pushx");
        this.loadProps();
        this.setContentPane(panel);
        this.initComponentActions();
    }

    private JPanel createTopPanel() {
        JPanel panel = SwingUtils.createPanel("Filter", false);
        panel.setLayout((LayoutManager)new MigLayout("", "", ""));
        panel.add((Component)this._optionsFilter_lbl, "");
        panel.add((Component)this._optionsFilter_txt, "pushx, growx");
        this._optionsFilter_txt.addActionListener(this);
        this._optionsFilter_txt.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                JdbcOptionsDialog.this.applyOptionFilter();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        return panel;
    }

    private JPanel createOkCancelPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "", ""));
        panel.add((Component)this._ok, "tag ok, right");
        panel.add((Component)this._cancel, "tag cancel");
        this._ok.addActionListener(this);
        this._cancel.addActionListener(this);
        return panel;
    }

    private JPanel createTablePanel() {
        JPanel panel = SwingUtils.createPanel("Actual Data Table", false);
        panel.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "", ""));
        this._table = new LocalTable();
        this._table.getModel().addTableModelListener(this);
        JScrollPane scroll = new JScrollPane((Component)((Object)this._table));
        panel.add((Component)scroll, "push, grow, height 100%, wrap");
        return panel;
    }

    private void initComponentActions() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JdbcOptionsDialog.this.saveProps();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this._cancel.equals(source)) {
            this._outValues = null;
            this.setVisible(false);
        }
        if (this._ok.equals(source)) {
            this.doApply();
            this.saveProps();
            this.setVisible(false);
        }
        if (this._optionsFilter_txt.equals(source)) {
            this.applyOptionFilter();
        }
    }

    private void applyOptionFilter() {
        String searchString = this._optionsFilter_txt.getText().trim();
        if (searchString.length() > 0) {
            this._table.setRowFilter(RowFilters.regexFilter((int)2, (String)searchString, (int[])new int[0]));
        } else {
            this._table.setRowFilter(null);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0 && e.getColumn() == 4 && e.getFirstRow() != -1) {
            this._table.getModel().setValueAt(new Boolean(true), e.getFirstRow(), 0);
        }
    }

    private void doApply() {
        this._outValues = new LinkedHashMap<String, String>();
        TableModel tm = this._table.getModel();
        for (int r = 0; r < tm.getRowCount(); ++r) {
            String val;
            String key;
            String oldVal;
            boolean add = (Boolean)tm.getValueAt(r, 0);
            if (!add || (oldVal = this._outValues.put(key = (String)tm.getValueAt(r, 3), val = (String)tm.getValueAt(r, 4))) == null) continue;
            _logger.warn((Object)("Found an already existing value for the key '" + key + "'. The existing value '" + oldVal + "' is replaced with the new value '" + val + "'."));
        }
        this._table.resetCellChanges();
    }

    private void saveProps() {
        Configuration tmpConf = Configuration.getInstance("USER_TEMP");
        String base = "jdbcOptionsDialog.";
        if (tmpConf != null) {
            tmpConf.setProperty(base + "window.width", this.getSize().width);
            tmpConf.setProperty(base + "window.height", this.getSize().height);
            tmpConf.setProperty(base + "window.pos.x", this.getLocationOnScreen().x);
            tmpConf.setProperty(base + "window.pos.y", this.getLocationOnScreen().y);
            tmpConf.save();
        }
    }

    private void loadProps() {
        int width = 1024;
        int height = 630;
        int x = -1;
        int y = -1;
        Configuration tmpConf = Configuration.getCombinedConfiguration();
        String base = "jdbcOptionsDialog.";
        this.setSize(width, height);
        if (tmpConf == null) {
            return;
        }
        width = tmpConf.getIntProperty(base + "window.width", width);
        height = tmpConf.getIntProperty(base + "window.height", height);
        x = tmpConf.getIntProperty(base + "window.pos.x", -1);
        y = tmpConf.getIntProperty(base + "window.pos.y", -1);
        if (width != -1 && height != -1) {
            this.setSize(width, height);
        }
        if (x != -1 && y != -1) {
            if (!SwingUtils.isOutOfScreen(x, y, width, height)) {
                this.setLocation(x, y);
            }
        } else {
            SwingUtils.centerWindow(this);
        }
    }

    private class LocalTable
    extends JXTable {
        private static final long serialVersionUID = 0L;
        protected int _lastTableHeaderColumn = -1;
        private JPopupMenu _popupMenu = null;
        private JPopupMenu _headerPopupMenu = null;

        LocalTable() {
            this.setModel(new LocalTableModel());
            this.setShowGrid(false);
            this.setSortable(true);
            this.setSelectionMode(0);
            this.setAutoResizeMode(0);
            this.packAll();
            this.setColumnControlVisible(true);
            this._popupMenu = this.createDataTablePopupMenu();
            this.setComponentPopupMenu(this.getDataTablePopupMenu());
            this._headerPopupMenu = this.createDataTableHeaderPopupMenu();
            this.getTableHeader().setComponentPopupMenu(this.getDataTableHeaderPopupMenu());
            this.refreshTable();
        }

        public int getLastTableHeaderColumn() {
            return this._lastTableHeaderColumn;
        }

        protected JTableHeader createDefaultTableHeader() {
            JXTableHeader tabHeader = new JXTableHeader(this.getColumnModel()){
                private static final long serialVersionUID = 0L;

                public String getToolTipText(MouseEvent e) {
                    String tip = null;
                    int col = this.getColumnModel().getColumnIndexAtX(e.getPoint().x);
                    if (col < 0) {
                        return null;
                    }
                    switch (col) {
                        case 0: {
                            tip = "Check the box if you want to select this option.";
                            break;
                        }
                        case 1: {
                            tip = "Indicates that this is a input parameter, which is't recognized by the JDBC Driver.";
                            break;
                        }
                        case 2: {
                            tip = "Is this option required when you do connect.";
                            break;
                        }
                        case 3: {
                            tip = "Name of the JDBC option from the driver.";
                            break;
                        }
                        case 4: {
                            tip = "Value of this option.";
                            break;
                        }
                        case 5: {
                            tip = "The Desction from the JDBC Driver";
                        }
                    }
                    if (tip == null) {
                        return null;
                    }
                    return "<html>" + tip + "</html>";
                }
            };
            tabHeader.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    LocalTable.this._lastTableHeaderColumn = LocalTable.this.getColumnModel().getColumnIndexAtX(e.getX());
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }
            });
            return tabHeader;
        }

        public String getToolTipText(MouseEvent e) {
            String tip = null;
            Point p = e.getPoint();
            int row = super.convertRowIndexToModel(this.rowAtPoint(p) < 0 ? 0 : this.rowAtPoint(p));
            int col = super.convertColumnIndexToModel(this.columnAtPoint(p));
            if (col > 0) {
                // empty if block
            }
            if (row >= 0) {
                // empty if block
            }
            if (col >= 0 && row >= 0) {
                tip = (String)super.getModel().getValueAt(row, 3) + ": " + (String)super.getModel().getValueAt(row, 5);
            }
            if (tip == null) {
                return null;
            }
            return "<html>" + tip + "</html>";
        }

        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            return c;
        }

        protected void refreshTable() {
            Vector<Object> row = new Vector<Object>();
            DefaultTableModel tm = (DefaultTableModel)this.getModel();
            Driver driver = null;
            DriverPropertyInfo[] attributes = null;
            try {
                Class.forName(JdbcOptionsDialog.this._driverClassName);
                Properties info = new Properties();
                driver = DriverManager.getDriver(JdbcOptionsDialog.this._urlTemplate);
                attributes = driver.getPropertyInfo(JdbcOptionsDialog.this._urlTemplate, info);
            }
            catch (Exception e) {
                String extraInfo = "";
                if (e.getMessage().indexOf("No suitable driver") >= 0) {
                    extraInfo = extraInfo + "<br>";
                    extraInfo = extraInfo + "<hr>";
                    extraInfo = extraInfo + "<b>Tip:</b> No suitable driver<br>";
                    extraInfo = extraInfo + "The selected Driver cannot handle the specified Database URL. <br>";
                    extraInfo = extraInfo + "The most common reason for this error is that the database <b>URL contains a syntax error</b> preventing the driver from accepting it. <br>";
                    extraInfo = extraInfo + "The error also occurs when trying to connect to a database with the wrong driver. Correct this and try again.";
                }
                SwingUtils.showErrorMessage(JdbcOptionsDialog.this, "Problems getting Connection Properties", "<html><h2>Some problem when getting Connection Properties</h2><b>Driver</b>: " + JdbcOptionsDialog.this._driverClassName + "<br><b>URL</b>: " + JdbcOptionsDialog.this._urlTemplate + "<br><br><b>Message</b>: " + e.getMessage() + "<br>" + extraInfo + "</html>", e);
                _logger.warn((Object)("Problems getting Connection Properties for driver='" + JdbcOptionsDialog.this._driverClassName + "', URL='" + JdbcOptionsDialog.this._urlTemplate + "'."), (Throwable)e);
                return;
            }
            _logger.debug((Object)("Resolving properties for: " + driver.getClass().getName()));
            LinkedHashMap inValuesCopy = new LinkedHashMap(JdbcOptionsDialog.this._inValues);
            boolean addedAnyRequired = false;
            for (int i = 0; i < attributes.length; ++i) {
                String name = attributes[i].name;
                String[] stringArray = attributes[i].choices;
                boolean required = attributes[i].required;
                String description = attributes[i].description;
                String value = attributes[i].value;
                String choises = "";
                if (stringArray != null && stringArray.length > 0) {
                    choises = "";
                    for (int j = 0; j < stringArray.length; ++j) {
                        choises = choises + "<" + stringArray[j] + ">, ";
                    }
                    if (choises.endsWith(", ")) {
                        choises = choises.substring(0, choises.length() - 2);
                    }
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)"\n-----------------------------------------------------------");
                    _logger.debug((Object)(" Name:        " + (String)name));
                    _logger.debug((Object)(" Required:    " + required));
                    _logger.debug((Object)(" Value:       " + value));
                    _logger.debug((Object)(" Choices are: " + choises));
                    _logger.debug((Object)(" Description: " + description));
                }
                if (value == null) {
                    value = "";
                }
                if ((value = value.trim()).length() > 80 && value.indexOf("\n", 20) != -1) {
                    value = value.substring(0, value.indexOf("\n", 20));
                }
                if (name.equalsIgnoreCase("USER") || name.equalsIgnoreCase("PASSWORD")) continue;
                if (value.equalsIgnoreCase("null")) {
                    value = "";
                }
                if (name.equalsIgnoreCase("APPLICATIONNAME") && value.equals("")) {
                    value = Version.getAppName();
                }
                if (required) {
                    addedAnyRequired = true;
                }
                row = new Vector();
                row.setSize(TAB_HEADER.length);
                row.set(0, new Boolean(false));
                row.set(1, new Boolean(false));
                row.set(2, new Boolean(required));
                row.set(3, name);
                row.set(4, value + choises);
                row.set(5, description);
                if (inValuesCopy.containsKey(name)) {
                    String inStr = (String)inValuesCopy.get(name);
                    row.set(0, new Boolean(true));
                    row.set(4, inStr);
                    inValuesCopy.remove(name);
                }
                tm.addRow(row);
            }
            int insertPos = 0;
            for (Map.Entry entry : inValuesCopy.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                row = new Vector();
                row.setSize(TAB_HEADER.length);
                row.set(0, new Boolean(true));
                row.set(1, new Boolean(true));
                row.set(2, new Boolean(false));
                row.set(3, key);
                row.set(4, val);
                row.set(5, "");
                tm.insertRow(insertPos++, row);
            }
            this.resetCellChanges();
            this.packAll();
            TableColumnExt tcx = this.getColumnExt(2);
            if (tcx != null) {
                tcx.setVisible(addedAnyRequired);
            }
        }

        public boolean isCellChanged(int row, int col) {
            int mrow = super.convertRowIndexToModel(row);
            int mcol = super.convertColumnIndexToModel(col);
            LocalTableModel tm = (LocalTableModel)this.getModel();
            return tm.isCellChanged(mrow, mcol);
        }

        public void resetCellChanges() {
            LocalTableModel tm = (LocalTableModel)this.getModel();
            tm.resetCellChanges();
            this.repaint();
        }

        public JPopupMenu getDataTablePopupMenu() {
            return this._popupMenu;
        }

        public JPopupMenu createDataTablePopupMenu() {
            return null;
        }

        public JPopupMenu getDataTableHeaderPopupMenu() {
            return this._headerPopupMenu;
        }

        public JPopupMenu createDataTableHeaderPopupMenu() {
            return null;
        }
    }

    private static class LocalTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;
        private Vector<Vector<Boolean>> _changeIndicator = new Vector();

        LocalTableModel() {
            this.setColumnIdentifiers(TAB_HEADER);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            Boolean changed;
            Vector<Boolean> changeRowIndicator;
            super.setValueAt(value, row, column);
            if (this._changeIndicator.size() < this.getRowCount()) {
                this._changeIndicator.setSize(this.getRowCount());
            }
            if ((changeRowIndicator = this._changeIndicator.get(row)) == null) {
                changeRowIndicator = new Vector(this.getColumnCount());
                this._changeIndicator.set(row, changeRowIndicator);
            }
            if (changeRowIndicator.size() < this.getColumnCount()) {
                changeRowIndicator.setSize(this.getColumnCount());
            }
            if ((changed = changeRowIndicator.get(column)) == null) {
                changeRowIndicator.set(column, new Boolean(true));
            } else if (!changed.booleanValue()) {
                changeRowIndicator.set(column, new Boolean(true));
            }
        }

        public boolean isCellChanged(int row, int col) {
            Vector<Boolean> changeRowIndicator = this._changeIndicator.get(row);
            if (changeRowIndicator == null) {
                return false;
            }
            Boolean changed = changeRowIndicator.get(col);
            if (changed == null) {
                return false;
            }
            return changed;
        }

        public void resetCellChanges() {
            this._changeIndicator = new Vector(this.getRowCount());
            this._changeIndicator.setSize(this.getRowCount());
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return Boolean.class;
                }
                case 2: {
                    return Boolean.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return String.class;
                }
                case 5: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return true;
                }
                case 5: {
                    return false;
                }
            }
            return false;
        }
    }
}

