/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui;

import javax.swing.JLabel;

public class MultiLineLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private boolean _internalHtmlTran = false;

    public MultiLineLabel() {
    }

    public MultiLineLabel(String s) {
        super(s);
        this.setText(s);
    }

    @Override
    public void setText(String text) {
        this._internalHtmlTran = false;
        if (text == null) {
            text = "";
        }
        if (text.trim().startsWith("<html>")) {
            super.setText(text);
            return;
        }
        this._internalHtmlTran = true;
        if (text.indexOf("\n") < 0) {
            super.setText("<html>" + text + "</html>");
            return;
        }
        String[] textBr = text.split("\n");
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        for (int i = 0; i < textBr.length; ++i) {
            sb.append(textBr[i]);
            sb.append("<br>");
        }
        sb.append("</html>");
        super.setText(sb.toString());
    }

    public String getTextStripHtml() {
        if (!this._internalHtmlTran) {
            return super.getText();
        }
        String text = super.getText();
        if (text == null) {
            return null;
        }
        text = text.replaceAll("\\<br\\>", "\n");
        text = text.replaceAll("\\<html\\>", "");
        text = text.replaceAll("\\</html\\>", "");
        return text;
    }
}

